/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.comcamvacuum.ui.jas;

import javax.swing.JComponent;
import javax.swing.JPanel;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.comcamvacuum.data.ComCamVacuumAgentProperties;
import org.lsst.ccs.subsystem.comcamvacuum.data.VacSysState;
import org.lsst.ccs.subsystem.comcamvacuum.ui.ComCamVacControlPanel;
import org.lsst.ccs.subsystem.comcamvacuum.ui.ComCamVacuumPage;
import org.lsst.ccs.subsystem.common.ui.jas.ControlPanel;
import org.lsst.ccs.subsystem.common.ui.jas.MonOptionalPage;

@Plugin(name="Vacuum Control Plugin", description="Vacuum Control Plugin")
public class ComCamVacControlPlugin
extends ConsolePlugin {
    public void initialize() {
        OptionalPage.getService().add((OptionalPage)new MonOptionalPage(ComCamVacuumAgentProperties.COMCAMVACUUM_TYPE_AGENT_PROPERTY, ComCamVacControl.class, "Control", true, new String[0]));
        OptionalPage.getService().add((OptionalPage)new VacImageOptionalPage());
    }

    static class VacImageOptionalPage
    implements OptionalPage {
        private ComCamVacuumPage vacuumPage;

        VacImageOptionalPage() {
        }

        public boolean isAutoOpen() {
            return false;
        }

        public String getPage(AgentInfo agent) {
            return agent != null && agent.hasAgentProperty(ComCamVacuumAgentProperties.COMCAMVACUUM_TYPE_AGENT_PROPERTY) ? "CCS Subsystems/" + agent.getName() + "/Schematic" : null;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            this.vacuumPage = new ComCamVacuumPage(agent);
            JComponent panel = this.vacuumPage.getView().getPanel();
            panel.setName(agent.getName() + " Schematic");
            return panel;
        }

        public void opened(String page) {
            this.vacuumPage.getView().install();
        }

        public void closed(String page) {
            this.vacuumPage.getView().uninstall();
            this.vacuumPage = null;
        }
    }

    public static class ComCamVacControl
    extends ControlPanel
    implements StatusMessageListener {
        private ComCamVacControlPanel ctrlPanel;

        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals("ComCamVacuumState")) {
                    this.updateControlPanel(sd.getSubsystemData().getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException embeddedObjectDeserializationException) {
                // empty catch block
            }
        }

        public JPanel getControlPanel(String agent) {
            this.ctrlPanel = new ComCamVacControlPanel(agent);
            return this.ctrlPanel;
        }

        public void initControlPanel() {
            this.ctrlPanel.initPanel();
        }

        public void updateControlPanel(Object obj) {
            this.ctrlPanel.updatePanel((VacSysState)obj);
        }

        public void disableControlPanel() {
            this.ctrlPanel.disablePanel();
        }

        public StatusMessageListener getListener() {
            return this;
        }
    }
}

