/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.tree;

import javax.swing.tree.TreePath;
import org.freehep.jas.plugin.tree.DefaultJTree;
import org.freehep.jas.plugin.tree.FTreeNode;
import org.freehep.jas.plugin.tree.FTreeNodeSelectionNotification;
import org.freehep.jas.plugin.tree.FTreeUtils;

class FTreeSelectionManager {
    private DefaultJTree jTree;

    FTreeSelectionManager(DefaultJTree jTree) {
        this.jTree = jTree;
    }

    FTreeNode[] selectedNodes() {
        return this.jTree.selectedNodes();
    }

    public void selectionChange(FTreeNodeSelectionNotification event) {
        TreePath path = FTreeUtils.treePathForNode(this.jTree.model().findNode(event.nodePath()));
        switch (event.state()) {
            case 1: {
                this.jTree.getSelectionModel().removeSelectionPath(path);
                break;
            }
            case 0: {
                this.jTree.getSelectionModel().addSelectionPath(path);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown state " + event.state());
            }
        }
    }
}

