/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.power.constants.PathFinderQuadBoxSwitches;
import org.lsst.ccs.subsystem.power.constants.SwitchState;
import org.lsst.ccs.subsystem.power.data.PathFinderQuadBoxState;

public class PathFinderQuadBoxControlPanel
extends JPanel
implements UiUtilities.ActionHandler,
CommandSender.ReplyHandler {
    private static final String[] panelNames = new String[6];
    private static final Map<Integer, String> switchNames;
    private static final int[] nameWidths;
    private static final Map<Integer, Integer> bfrSwitchMap;
    private static final Map<Integer, Integer> mainSwitchMap;
    private static final int statusLabelWidth;
    private final CommandSender sender;
    private final UiUtilities uiUtils;
    private SystemStatusPanel statusPanel;
    private final JPanel topPanel = new JPanel();
    private final JPanel statePanel = new JPanel();
    private final JLabel stateLabel = new JLabel("System State: ");
    private final JLabel stateStatus = new JLabel("....");
    private final JPanel periodPanel = new JPanel();
    private final JLabel periodLabel = new JLabel("Update Period: ");
    private final JTextField periodTextField = new JTextField("...");
    private final JLabel periodUnitsLabel = new JLabel("sec");
    private final JPanel[] switchPanel = new JPanel[6];
    private final JLabel[][] switchLabel = new JLabel[6][];
    private final JLabel[][] switchStatus = new JLabel[6][];
    private final ButtonGroup[][] switchBG = new ButtonGroup[6][];
    private final JRadioButton[][] switchOffRB = new JRadioButton[6][];
    private final JRadioButton[][] switchOnRB = new JRadioButton[6][];
    private final Map<Integer, Integer> switchLines = new HashMap<Integer, Integer>();
    private double powerPeriod = 5.0;
    private static final long serialVersionUID = 1L;

    public PathFinderQuadBoxControlPanel(String agent) {
        this.sender = new CommandSender(agent, (CommandSender.ReplyHandler)this);
        this.uiUtils = new UiUtilities((UiUtilities.ActionHandler)this);
        this.initComponents();
        new DisablePanel().run();
    }

    private void initComponents() {
        int dvc;
        this.statusPanel = new SystemStatusPanel(this.sender);
        Dimension d = this.stateStatus.getPreferredSize();
        d.width = 70;
        this.stateStatus.setPreferredSize(d);
        this.stateStatus.setMinimumSize(d);
        d = this.periodTextField.getPreferredSize();
        d.width = 50;
        this.periodTextField.setPreferredSize(d);
        this.periodTextField.setMinimumSize(d);
        this.periodTextField.setHorizontalAlignment(0);
        this.periodTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathFinderQuadBoxControlPanel.this.setUpdatePeriod();
            }
        });
        for (int dvc2 = 0; dvc2 < 6; ++dvc2) {
            int nSwitch = PathFinderQuadBoxSwitches.NUM_SWITCHES[dvc2];
            this.switchLabel[dvc2] = new JLabel[nSwitch + 1];
            this.switchStatus[dvc2] = new JLabel[nSwitch + 1];
            this.switchBG[dvc2] = new ButtonGroup[nSwitch + 1];
            this.switchOnRB[dvc2] = new JRadioButton[nSwitch + 1];
            this.switchOffRB[dvc2] = new JRadioButton[nSwitch + 1];
        }
        int[] lines = new int[6];
        for (int swId : switchNames.keySet()) {
            int line;
            int n = dvc = swId >> 8;
            lines[n] = lines[n] + 1;
            this.switchLines.put(swId, line);
            this.switchLabel[dvc][line] = UiUtilities.newLabel((String)(switchNames.get(swId) + ": "), (int)0);
            this.switchStatus[dvc][line] = UiUtilities.newLabel((String)"X", (int)statusLabelWidth);
            JRadioButton jRadioButton = this.uiUtils.newRadioButton("On", "N" + Integer.toString(swId));
            this.switchOnRB[dvc][line] = jRadioButton;
            JRadioButton on = jRadioButton;
            JRadioButton jRadioButton2 = this.uiUtils.newRadioButton("Off", "F" + Integer.toString(swId));
            this.switchOffRB[dvc][line] = jRadioButton2;
            JRadioButton off = jRadioButton2;
            ButtonGroup buttonGroup = new ButtonGroup();
            this.switchBG[dvc][line] = buttonGroup;
            ButtonGroup bg = buttonGroup;
            bg.add(on);
            bg.add(off);
        }
        this.statePanel.add(this.stateLabel);
        this.statePanel.add(this.stateStatus);
        this.periodPanel.add(this.periodLabel);
        this.periodPanel.add(this.periodTextField);
        this.periodPanel.add(this.periodUnitsLabel);
        GridBagConstraints gbt = new GridBagConstraints();
        this.topPanel.setLayout(new GridBagLayout());
        gbt.gridx = 0;
        gbt.gridy = 0;
        this.topPanel.add((Component)this.statusPanel, gbt);
        GridBagConstraints gbs = new GridBagConstraints();
        for (dvc = 0; dvc < 6; ++dvc) {
            JPanel panel = this.switchPanel[dvc] = new JPanel();
            TitledBorder border = new TitledBorder(new LineBorder(Color.BLACK), panelNames[dvc]);
            border.setTitleColor(UiConstants.BLUE);
            panel.setBorder(border);
            panel.setLayout(new GridBagLayout());
            gbs.gridy = 0;
            gbs.insets.top = 0;
            for (int line = 0; line < this.switchLabel[dvc].length; ++line) {
                if (this.switchLabel[dvc][line] == null) continue;
                gbs.gridx = 0;
                gbs.insets.left = 4;
                gbs.insets.right = 0;
                panel.add((Component)this.switchLabel[dvc][line], gbs);
                ++gbs.gridx;
                gbs.insets.left = 0;
                panel.add((Component)this.switchStatus[dvc][line], gbs);
                ++gbs.gridx;
                gbs.insets.right = 4;
                panel.add((Component)this.switchOffRB[dvc][line], gbs);
                ++gbs.gridx;
                panel.add((Component)this.switchOnRB[dvc][line], gbs);
                ++gbs.gridy;
                gbs.insets.top = -4;
            }
            panel.setMinimumSize(panel.getPreferredSize());
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        this.add((Component)this.topPanel, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        this.add((Component)this.switchPanel[0], gbc);
        ++gbc.gridx;
        this.add((Component)this.switchPanel[1], gbc);
        ++gbc.gridx;
        this.add((Component)this.switchPanel[2], gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.add((Component)this.switchPanel[3], gbc);
        ++gbc.gridx;
        this.add((Component)this.switchPanel[4], gbc);
    }

    private void setUpdatePeriod() {
        try {
            double value = Double.valueOf(this.periodTextField.getText());
            this.sender.sendCommand(null, "setUpdatePeriod", new Object[]{(int)(1000.0 * value)});
            this.periodTextField.setEnabled(false);
        }
        catch (NumberFormatException nfe) {
            this.periodTextField.setText(String.valueOf(this.powerPeriod));
        }
    }

    private void setSwitchOn(int swId, boolean on) {
        this.sender.sendCommand(null, "setNamedSwitchOn", new Object[]{PathFinderQuadBoxSwitches.switchIdToName.get(swId), on});
    }

    public void updateControlPanel(PathFinderQuadBoxState rs) {
        SwingUtilities.invokeLater(new UpdatePowerStatus(rs));
    }

    public void initPanel() {
        this.sender.sendCommand(true, null, "getFullState", new Object[0]);
    }

    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        this.updatePanel((PathFinderQuadBoxState)reply);
    }

    public void updatePanel(PathFinderQuadBoxState rs) {
        SwingUtilities.invokeLater(new UpdatePowerStatus(rs));
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    public void handleRadioButton(String name) {
        boolean on = name.charAt(0) == 'N';
        int swId = Integer.valueOf(name.substring(1));
        this.sender.sendCommand(null, "setNamedSwitchOn", new Object[]{PathFinderQuadBoxSwitches.switchIdToName.get(swId), on});
    }

    static {
        PathFinderQuadBoxControlPanel.panelNames[0] = "BFR";
        PathFinderQuadBoxControlPanel.panelNames[1] = "5V Clean PDU";
        PathFinderQuadBoxControlPanel.panelNames[2] = "24V Clean PDU";
        PathFinderQuadBoxControlPanel.panelNames[3] = "24V Dirty PDU";
        PathFinderQuadBoxControlPanel.panelNames[4] = "48V Dirty PDU";
        switchNames = new LinkedHashMap<Integer, String>();
        switchNames.put(11, "5V Clean PDU");
        switchNames.put(10, "24V Clean PDU");
        switchNames.put(8, "24V Dirty PDU");
        switchNames.put(7, "48V Dirty PDU");
        switchNames.put(0, "Heater 1");
        switchNames.put(1, "Heater 2");
        switchNames.put(767, "Main");
        switchNames.put(512, "Ion pumps");
        switchNames.put(522, "FES Encoder");
        switchNames.put(523, "FES/Shutter HCUs");
        switchNames.put(519, "RFG/UTC/BPU MAQ20s");
        switchNames.put(517, "VALVES/PTH MAQ20");
        switchNames.put(518, "Gauges");
        switchNames.put(1023, "Main");
        switchNames.put(772, "PF turbo");
        switchNames.put(774, "PF scroll");
        switchNames.put(776, "PF turbo heater");
        switchNames.put(1279, "Main");
        switchNames.put(1029, "Purge fan");
        nameWidths = new int[6];
        PathFinderQuadBoxControlPanel.nameWidths[0] = 110;
        PathFinderQuadBoxControlPanel.nameWidths[1] = 70;
        PathFinderQuadBoxControlPanel.nameWidths[2] = 130;
        PathFinderQuadBoxControlPanel.nameWidths[3] = 105;
        PathFinderQuadBoxControlPanel.nameWidths[4] = 105;
        bfrSwitchMap = new HashMap<Integer, Integer>();
        bfrSwitchMap.put(1, 11);
        bfrSwitchMap.put(2, 10);
        bfrSwitchMap.put(3, 8);
        bfrSwitchMap.put(4, 7);
        mainSwitchMap = new HashMap<Integer, Integer>();
        mainSwitchMap.put(2, 767);
        mainSwitchMap.put(3, 1023);
        mainSwitchMap.put(4, 1279);
        statusLabelWidth = UiUtilities.maxEnumLabelWidth(SwitchState.class);
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
            PathFinderQuadBoxControlPanel.this.statusPanel.disablePanel();
            Iterator iterator = switchNames.keySet().iterator();
            while (iterator.hasNext()) {
                int swId = (Integer)iterator.next();
                int dvc = swId >> 8;
                int line = (Integer)PathFinderQuadBoxControlPanel.this.switchLines.get(swId);
                PathFinderQuadBoxControlPanel.this.switchStatus[dvc][line].setEnabled(false);
                PathFinderQuadBoxControlPanel.this.switchOffRB[dvc][line].setEnabled(false);
                PathFinderQuadBoxControlPanel.this.switchOnRB[dvc][line].setEnabled(false);
            }
            PathFinderQuadBoxControlPanel.this.repaint();
        }
    }

    class UpdatePowerStatus
    implements Runnable {
        private final PathFinderQuadBoxState qs;

        UpdatePowerStatus(PathFinderQuadBoxState qs) {
            this.qs = qs;
        }

        @Override
        public void run() {
            PathFinderQuadBoxControlPanel.this.statusPanel.updatePanel(this.qs.getTickMillis());
            PathFinderQuadBoxControlPanel.this.stateStatus.setText("RUNNING");
            PathFinderQuadBoxControlPanel.this.stateStatus.setForeground(UiConstants.GREEN);
            PathFinderQuadBoxControlPanel.this.periodTextField.setEnabled(true);
            PathFinderQuadBoxControlPanel.this.powerPeriod = (double)this.qs.getTickMillis() / 1000.0;
            PathFinderQuadBoxControlPanel.this.periodTextField.setText(String.valueOf(PathFinderQuadBoxControlPanel.this.powerPeriod));
            Iterator iterator = switchNames.keySet().iterator();
            while (iterator.hasNext()) {
                int swId = (Integer)iterator.next();
                int devc = swId >> 8;
                int line = (Integer)PathFinderQuadBoxControlPanel.this.switchLines.get(swId);
                SwitchState st = this.qs.getSwitchState(swId);
                st = st == null ? SwitchState.OFFLINE : st;
                JLabel label = PathFinderQuadBoxControlPanel.this.switchStatus[devc][line];
                label.setText(st.toString());
                label.setForeground(st == SwitchState.ON ? UiConstants.GREEN : (st == SwitchState.OFF ? Color.BLACK : UiConstants.BLUE));
                if (st != SwitchState.OFFLINE) {
                    JRadioButton selButton = st == SwitchState.ON ? PathFinderQuadBoxControlPanel.this.switchOnRB[devc][line] : PathFinderQuadBoxControlPanel.this.switchOffRB[devc][line];
                    selButton.setSelected(true);
                }
                PathFinderQuadBoxControlPanel.this.switchStatus[devc][line].setEnabled(true);
                PathFinderQuadBoxControlPanel.this.switchOffRB[devc][line].setEnabled(true);
                PathFinderQuadBoxControlPanel.this.switchOnRB[devc][line].setEnabled(true);
            }
            iterator = bfrSwitchMap.keySet().iterator();
            while (iterator.hasNext()) {
                String suffix;
                SwitchState mainSwSt;
                int devc = (Integer)iterator.next();
                SwitchState bfrSwSt = this.qs.getSwitchState((Integer)bfrSwitchMap.get(devc));
                Integer mainSwId = (Integer)mainSwitchMap.get(devc);
                SwitchState switchState = mainSwSt = mainSwId == null ? SwitchState.ON : this.qs.getSwitchState(mainSwId);
                String string = bfrSwSt != SwitchState.ON ? " (BFR off)" : (suffix = mainSwSt != SwitchState.ON ? " (Main off)" : "");
                Color color = bfrSwSt != SwitchState.ON ? UiConstants.RED : (mainSwSt != SwitchState.ON ? UiConstants.PURPLE : UiConstants.BLUE);
                JPanel panel = PathFinderQuadBoxControlPanel.this.switchPanel[devc];
                TitledBorder border = (TitledBorder)panel.getBorder();
                border.setTitle(panelNames[devc] + suffix);
                border.setTitleColor(color);
            }
            PathFinderQuadBoxControlPanel.this.repaint();
        }
    }
}

