/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims.channel;

import java.io.IOException;
import org.lsst.ccs.daq.ims.channel.FilterReadableIntChannel;
import org.lsst.ccs.daq.ims.channel.ReadableIntChannel;

public class Compress18BitChannel
extends FilterReadableIntChannel {
    private int bitsAvailable = 0;
    private long dataAvailable = 0L;

    Compress18BitChannel(ReadableIntChannel input) {
        super(input);
    }

    @Override
    public int read() throws IOException {
        while (this.bitsAvailable < 32) {
            long in = (long)this.input.read() & 0xFFFFFFFFL;
            this.dataAvailable |= in << this.bitsAvailable;
            this.bitsAvailable += 18;
        }
        int result = (int)this.dataAvailable;
        this.bitsAvailable -= 32;
        this.dataAvailable >>>= 32;
        return result;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
        if (this.bitsAvailable != 0) {
            throw new IOException("Unused data remaining on close");
        }
    }
}

