/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import nom.tam.fits.FitsDate;
import nom.tam.fits.FitsException;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

public class MetaDataSet {
    private final Map<String, List<Map<String, Object>>> metaDataMaps = new HashMap<String, List<Map<String, Object>>>();

    public void addProperties(String name, Properties props) {
        this.addMetaDataMap(name, this.convertToMetaData(props));
    }

    public void addMetaData(String name, String key, Object value) {
        List<Map<String, Object>> meta = this.findOrCreateMetaData(name);
        meta.add(0, Collections.singletonMap(key, value));
    }

    public void addMetaDataMap(String name, Map<String, Object> data) {
        if (data == null) {
            return;
        }
        List<Map<String, Object>> meta = this.findOrCreateMetaData(name);
        meta.add(0, data);
    }

    public void addMetaDataSet(MetaDataSet metaDataSet) {
        if (metaDataSet == null) {
            return;
        }
        for (Map.Entry<String, List<Map<String, Object>>> entry : metaDataSet.metaDataMaps.entrySet()) {
            for (Map<String, Object> metaData : entry.getValue()) {
                this.addMetaDataMap(entry.getKey(), metaData);
            }
        }
    }

    public Properties convertToProperties() {
        throw new UnsupportedOperationException("convertToProperties");
    }

    public Object getValue(String name) {
        return this.getValue(null, name);
    }

    public Object getValue(String map, String name) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        Object obj = null;
        for (Map.Entry<String, List<Map<String, Object>>> metaDataEntry : this.metaDataMaps.entrySet()) {
            for (Map<String, Object> metaData : metaDataEntry.getValue()) {
                Object result;
                if (map != null && !map.equals(metaDataEntry.getKey()) || (result = metaData.get(name)) == null) continue;
                results.put(metaDataEntry.getKey(), result);
                obj = result;
            }
        }
        if (results.size() <= 1) {
            return obj;
        }
        throw new RuntimeException("More than one map defines a value for " + name + " (" + results + ")");
    }

    private List<Map<String, Object>> findOrCreateMetaData(String name) {
        List<Map<String, Object>> result = this.metaDataMaps.get(name);
        if (result == null) {
            result = new LinkedList<Map<String, Object>>();
            this.metaDataMaps.put(name, result);
        }
        return result;
    }

    private Map<String, Object> convertToMetaData(Properties props) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Object n : BootstrapResourceUtils.getAllKeysInProperties((Properties)props)) {
            String name = (String)n;
            String value = props.getProperty(name);
            result.put(name, this.convertToMetaData(value));
        }
        return result;
    }

    private Object convertToMetaData(String value) {
        try {
            return Integer.decode(value);
        }
        catch (NumberFormatException x) {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException xx) {
                try {
                    return new FitsDate(value).toDate();
                }
                catch (FitsException xxx) {
                    if ("true".equalsIgnoreCase(value)) {
                        return Boolean.TRUE;
                    }
                    if ("false".equalsIgnoreCase(value)) {
                        return Boolean.FALSE;
                    }
                    return value;
                }
            }
        }
    }
}

