/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.extension.aida.function;

import hep.aida.IFunction;
import hep.aida.ref.function.BaseModelFunction;
import hep.aida.ref.function.FunctionCore;
import hep.aida.ref.function.PolynomialCoreNotNorm;
import hep.aida.ref.plotter.adapter.AIDAFunctionAdapter;
import jas.hist.Basic1DFunction;
import jas.hist.FunctionFactoryError;
import jas.hist.InvalidFunctionParameter;
import jas.hist.JASHist;
import org.freehep.jas.extension.aida.function.AbstractFunctionFactory;

public class LineFunctionFactory
extends AbstractFunctionFactory {
    public LineFunctionFactory() {
        super("1st order polynomial");
    }

    public Basic1DFunction createFunction(JASHist h) throws FunctionFactoryError {
        double xMin = h.getXAxis().getMin();
        double xMax = h.getXAxis().getMax();
        double yMin = h.getYAxis().getMin();
        double yMax = h.getYAxis().getMax();
        LineFunction c = new LineFunction(xMin, xMax, yMin, yMax);
        this.chooseName(c, h);
        return c;
    }

    private class LineFunction
    extends AIDAFunctionAdapter {
        public LineFunction(double xMin, double xMax, double yMin, double yMax) {
            super((IFunction)new BaseModelFunction("p1", "", (FunctionCore)new PolynomialCoreNotNorm(1, 2), null));
            try {
                double a = yMin + (yMax - yMin) * 0.8;
                double b = xMin + (xMax - xMin) * 0.8;
                this.setParameter(0, (yMin * xMin - a * b) / (xMin - b));
                this.setParameter(1, (a - yMin) / (xMin - b));
            }
            catch (InvalidFunctionParameter ifp) {
                throw new RuntimeException("Invalid parameter");
            }
        }
    }
}

