/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.jgroups.tester;

import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.stack.AddressGenerator;
import org.jgroups.stack.Protocol;
import org.jgroups.tests.Probe;
import org.lsst.ccs.messaging.jgroups.CCSAddress;
import org.lsst.ccs.messaging.jgroups.JGroupsBusMessagingLayer;

public class Tester {
    private static final AtomicInteger ID = new AtomicInteger();
    private static final String CLUSTER_NAME = "TEST";
    private String name;
    private int rank;
    private String config;
    private final boolean showGUI;
    private JChannel channel;
    private JFrame frame;
    private int level = Level.INFO.intValue();

    public Tester(String name, int rank, String config, boolean showGUI) {
        this.name = name == null ? "Node_" + Integer.toString(ID.getAndIncrement()) : name;
        this.rank = rank;
        this.config = config;
        this.showGUI = showGUI;
    }

    public Tester() {
        this(null, 0, null, false);
    }

    public Tester(boolean showGUI) {
        this(null, 0, null, showGUI);
    }

    public Tester(String name, boolean showGUI) {
        this(null, 0, null, showGUI);
    }

    private void start() {
        if (this.showGUI) {
            SwingUtilities.invokeLater(this::makeGUI);
        }
    }

    private void stop() {
        if (this.frame != null) {
            this.frame.dispose();
        }
        this.channel.close();
    }

    private void makeGUI() {
        this.frame = new JFrame(this.name);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                Tester.this.stop();
            }
        });
        Box root = Box.createVerticalBox();
        this.frame.add(new JScrollPane(root));
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("Output level: "));
        box.add(Box.createRigidArea(new Dimension(5, 5)));
        Level[] levels = new Level[]{Level.SEVERE, Level.WARNING, Level.INFO, Level.FINE, Level.FINER, Level.FINEST};
        JComboBox<Level> combo = new JComboBox<Level>(levels);
        combo.setSelectedItem(Level.INFO);
        combo.addActionListener(e -> {
            JComboBox c = (JComboBox)e.getSource();
            this.level = ((Level)c.getSelectedItem()).intValue();
        });
        box.add(combo);
        box.add(Box.createRigidArea(new Dimension(5, 5)));
        box.add(Box.createHorizontalGlue());
        root.add(box);
        root.add(Box.createRigidArea(new Dimension(5, 5)));
        box = Box.createHorizontalBox();
        JButton b = new JButton("Create channel");
        b.addActionListener(e -> {
            ((JButton)e.getSource()).setEnabled(false);
            this.createChannel();
        });
        box.add(b);
        box.add(Box.createRigidArea(new Dimension(5, 5)));
        b = new JButton("Connect");
        b.addActionListener(e -> {
            if (e.getActionCommand().equals("Connect")) {
                ((JButton)e.getSource()).setText("Disconnect");
                this.connectChannel(null);
            } else {
                ((JButton)e.getSource()).setText("Connect");
                this.disconnectChannel();
            }
        });
        box.add(b);
        box.add(Box.createRigidArea(new Dimension(5, 5)));
        box.add(Box.createHorizontalGlue());
        root.add(box);
        root.add(Box.createRigidArea(new Dimension(5, 5)));
        box = Box.createHorizontalBox();
        b = new JButton("Send");
        b.addActionListener(e -> this.sendMessage());
        box.add(b);
        box.add(Box.createRigidArea(new Dimension(5, 5)));
        b = new JButton("View");
        b.addActionListener(e -> this.logView());
        box.add(b);
        box.add(Box.createRigidArea(new Dimension(5, 5)));
        box.add(Box.createHorizontalGlue());
        root.add(box);
        root.add(Box.createRigidArea(new Dimension(5, 5)));
        box = Box.createHorizontalBox();
        box.add(new JLabel("Probe"));
        box.add(Box.createRigidArea(new Dimension(5, 5)));
        JTextField f = new JTextField();
        f.addActionListener(e -> this.probe(e.getActionCommand()));
        box.add(f);
        box.add(Box.createRigidArea(new Dimension(5, 5)));
        box.add(Box.createHorizontalGlue());
        root.add(box);
        root.add(Box.createRigidArea(new Dimension(5, 5)));
        root.add(Box.createVerticalGlue());
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private String setName(String name) {
        if (this.channel != null) {
            return "Too late, the channel has already been created.";
        }
        this.name = name == null ? "Node_" + Integer.toString(ID.getAndIncrement()) : name;
        return "Changed name to " + this.name;
    }

    private String setRank(int rank) {
        if (this.channel != null) {
            return "Too late, the channel has already been created.";
        }
        if (rank < 0 || rank > 15) {
            return "Rank should be between 0 and 15";
        }
        this.rank = rank;
        return "Changed rank to " + this.rank;
    }

    private String setConfig(String config) {
        if (this.channel != null) {
            return "Too late, the channel has already been created.";
        }
        this.config = config;
        return "Changed config to " + this.config;
    }

    private String setLogLevel(String level, String protocol) {
        if (this.channel == null) {
            return "Channel does not exist.";
        }
        if (protocol == null) {
            this.channel.stack().setLevel(level);
            return "Stack level: " + this.channel.stack().getLevel();
        }
        Protocol prot = this.channel.stack().findProtocol(protocol);
        if (prot == null) {
            return "No such protocol: " + protocol;
        }
        prot.setLevel(level);
        return prot.getName() + " level: " + prot.getLevel();
    }

    private String createChannel() {
        if (this.channel != null) {
            return "Too late, the channel has already been created.";
        }
        try {
            if (this.config == null) {
                InputStream xml = this.getClass().getResourceAsStream("udp_test.xml");
                this.channel = new JChannel(xml);
            } else {
                if (!this.config.startsWith("/") && !this.config.startsWith("c:")) {
                    this.config = System.getProperty("user.home") + "/" + this.config;
                }
                this.channel = new JChannel(this.config);
            }
            this.channel.addAddressGenerator((AddressGenerator)new CCSAddress.Generator(this.rank));
            this.channel.setName(this.name);
            String text = "Channel configuration:\n" + this.channel.getProperties();
            this.log(text, Level.FINE);
            this.channel.setReceiver((Receiver)new MessageReceiver());
            return "Created channel " + this.name + " with rank " + this.rank;
        }
        catch (Exception x) {
            return "Error creating channel" + x;
        }
    }

    private String connectChannel(String clusterName) {
        if (this.channel == null) {
            return "Channel does not exist.";
        }
        if (this.channel.isConnected()) {
            return "Channel is already connected.";
        }
        if (this.channel.isConnecting()) {
            return "Channel is already connecting.";
        }
        if (clusterName == null) {
            clusterName = CLUSTER_NAME;
        }
        try {
            this.channel.connect(clusterName);
            return "Connected to cluster " + clusterName;
        }
        catch (Exception x) {
            return "Error connecting channel. " + x;
        }
    }

    private String disconnectChannel() {
        if (this.channel == null) {
            return "Channel does not exist.";
        }
        if (!this.channel.isConnected()) {
            return "Channel is not connected.";
        }
        try {
            String cluster = this.channel.clusterName();
            this.channel.disconnect();
            return "Disconnected " + this.name + " from cluster " + cluster;
        }
        catch (Exception x) {
            return "Error disconnecting channel. " + x;
        }
    }

    private String sendMessage() {
        if (this.channel == null) {
            return "Channel does not exist.";
        }
        if (!this.channel.isConnected()) {
            return "Channel is not connected.";
        }
        try {
            this.channel.send(null, (Object)"default payload");
            return "Sent from " + this.name + " to " + this.channel.clusterName();
        }
        catch (Exception x) {
            return "Error sending message. " + x;
        }
    }

    private String invokeOnChannel(String method) {
        if (this.channel == null) {
            return "Channel does not exist.";
        }
        try {
            return JChannel.class.getMethod(method, new Class[0]).invoke((Object)this.channel, new Object[0]).toString();
        }
        catch (NoSuchMethodException x) {
            return "No such method: " + method;
        }
        catch (IllegalAccessException x) {
            return "IllegalAccessException";
        }
        catch (InvocationTargetException x) {
            return "InvocationTargetException: " + x;
        }
    }

    private void logView() {
        this.log(this.channel.getViewAsString(), Level.OFF);
    }

    private String view() {
        try {
            return this.channel.getViewAsString();
        }
        catch (Exception x) {
            return "Error: " + x;
        }
    }

    private void probe(String text) {
        Object[] ss = text.split("\\s");
        this.log(Arrays.toString(ss), Level.FINE);
        try {
            Probe.main((String[])ss);
        }
        catch (Exception x) {
            this.log(x, Level.WARNING);
        }
    }

    private void log(Object what, Level level) {
        JGroupsBusMessagingLayer.getLogger().fatal(what);
    }

    private String processCommand(String s) {
        try {
            String[] ss = s.split("\\s+");
            if (ss.length == 0) {
                return null;
            }
            switch (ss[0]) {
                case "setName": {
                    return this.setName(ss[1]);
                }
                case "setRank": {
                    return this.setRank(Integer.parseInt(ss[1]));
                }
                case "setConfig": {
                    return this.setConfig(ss[1]);
                }
                case "setLevel": {
                    switch (ss.length) {
                        case 2: {
                            return this.setLogLevel(ss[1], null);
                        }
                        case 3: {
                            return this.setLogLevel(ss[1], ss[2]);
                        }
                    }
                    return "Wrong number of arguments, should be (level, protocol)";
                }
                case "create": {
                    return this.createChannel();
                }
                case "connect": {
                    return this.connectChannel(ss.length == 1 ? null : ss[1]);
                }
                case "disconnect": {
                    return this.disconnectChannel();
                }
                case "view": {
                    return this.view();
                }
                case "send": {
                    return this.sendMessage();
                }
                case "invoke": {
                    return this.invokeOnChannel(ss[1]);
                }
            }
            return "   Commands:\nsetName name\nsetRank int\nsetConfig location\nsetLevel level protocol (fatal, error, warn, info, debug, trace (capitalization not relevant))\ncreate\nconnect clusterName\ndisconnect\nview\nsend\ninvoke method\n";
        }
        catch (Exception x) {
            return "Error: " + x;
        }
    }

    public static void main(String ... args) throws Exception {
        if (args.length == 0) {
            Tester node = new Tester(true);
            node.start();
            node = new Tester(true);
            node.start();
            node = new Tester(true);
            node.start();
        } else {
            Tester.console(args);
        }
        System.exit(0);
    }

    public static void console(String ... args) throws Exception {
        String command;
        JGroupsBusMessagingLayer.getLogger().severe((Object)"Starting JGroups tester");
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        Tester tester = new Tester();
        while (!"exit".equalsIgnoreCase(command = reader.readLine())) {
            String response = tester.processCommand(command);
            if (response == null) continue;
            JGroupsBusMessagingLayer.getLogger().severe((Object)response);
        }
    }

    private class MessageReceiver
    extends ReceiverAdapter {
        private MessageReceiver() {
        }

        public void unblock() {
            Tester.this.log("unblock()", Level.FINEST);
        }

        public void block() {
            Tester.this.log("block()", Level.FINEST);
        }

        public void suspect(Address mbr) {
            Tester.this.log("suspect() " + mbr, Level.FINEST);
        }

        public void viewAccepted(View view) {
            Tester.this.log("viewAccepted() " + view, Level.FINEST);
        }

        public void setState(InputStream input) throws Exception {
            super.setState(input);
        }

        public void getState(OutputStream output) throws Exception {
            super.getState(output);
        }

        public void receive(Message msg) {
            Tester.this.log("receive() " + msg.getSrc(), Level.FINEST);
        }
    }
}

