/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims.channel;

import java.io.File;
import java.io.IOException;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.TruncatedFileException;
import nom.tam.fits.header.Standard;
import nom.tam.util.BufferedFile;
import org.lsst.ccs.daq.ims.channel.Compress18BitChannel;
import org.lsst.ccs.daq.ims.channel.IntFileChannelReader;
import org.lsst.ccs.daq.ims.channel.MultiplexingIntChannel;
import org.lsst.ccs.daq.ims.channel.ReadableIntChannel;
import org.lsst.ccs.daq.ims.channel.XORReadableIntChannel;

public class FitsIntReader
implements ReadableIntChannel {
    private final Compress18BitChannel input;
    private final List<Segment> segments = new ArrayList<Segment>();

    public FitsIntReader(File ... files) throws IOException, TruncatedFileException {
        for (File file : files) {
            FitsIntReader.openFITSFile(this.segments, file);
        }
        ReadableIntChannel[] inputs = new ReadableIntChannel[this.segments.size()];
        int j = 0;
        for (Segment segment : this.segments) {
            FileChannel channel = segment.getChannel();
            inputs[j++] = new IntFileChannelReader(channel, segment.getSeekPosition(), segment.getDataSize());
        }
        MultiplexingIntChannel multiplex = new MultiplexingIntChannel(inputs);
        XORReadableIntChannel xor = new XORReadableIntChannel(multiplex, 131071);
        this.input = new Compress18BitChannel(xor);
    }

    @Override
    public void close() throws IOException {
        this.input.close();
        for (Segment segment : this.segments) {
            segment.close();
        }
    }

    private static void openFITSFile(List<Segment> segments, File file) throws IOException, TruncatedFileException {
        BufferedFile bf = new BufferedFile(file, "r");
        for (int i = 0; i < 17; ++i) {
            Header header = new Header(bf);
            String ccdSlot = null;
            if (i == 0) {
                ccdSlot = header.getStringValue("CCDSLOT");
            }
            if (i <= 0) continue;
            Segment segment = new Segment(header, bf, bf.getFilePointer(), ccdSlot);
            int dataSize = segment.getDataSize();
            int pad = FitsUtil.padding(dataSize);
            bf.skip(dataSize + pad);
            segments.add(segment);
        }
    }

    @Override
    public int read() throws IOException {
        return this.input.read();
    }

    @Override
    public int read(IntBuffer buffer) throws IOException {
        return this.input.read(buffer);
    }

    @Override
    public boolean isOpen() {
        return this.input.isOpen();
    }

    static {
        FitsFactory.setUseHierarch(true);
    }

    private static class Segment {
        private final Header header;
        private final BufferedFile bf;
        private final long filePointer;
        private final String ccdSlot;
        private final int nAxis1;
        private final int nAxis2;
        private final FileChannel channel;

        public Segment(Header header, BufferedFile bf, long filePointer, String ccdSlot) {
            this.header = header;
            this.bf = bf;
            this.channel = bf.getChannel();
            this.filePointer = filePointer;
            this.ccdSlot = ccdSlot;
            this.nAxis1 = header.getIntValue(Standard.NAXIS1);
            this.nAxis2 = header.getIntValue(Standard.NAXIS2);
        }

        private int getDataSize() {
            return this.nAxis1 * this.nAxis2 * 4;
        }

        private FileChannel getChannel() {
            return this.channel;
        }

        private long getSeekPosition() {
            return this.filePointer;
        }

        private void close() throws IOException {
            this.channel.close();
        }
    }
}

