/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.drivers.thorlabs.ThorlabsFW;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.HasDataProviderInfos;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.teststand.ThorlabsSC10Device;
import org.lsst.ccs.subsystem.teststand.states.ThorlabsFWState;

public class ThorlabsFWDevice
extends Device
implements HasDataProviderInfos {
    private final ThorlabsFW fwheel = new ThorlabsFW();
    private final int maxTime = 11;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected AgentStateService stateService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    private static final Logger LOG = Logger.getLogger(ThorlabsSC10Device.class.getName());
    private Map<Integer, String> chanMap = new HashMap<Integer, String>();
    private Integer chanKey;
    @ConfigurationParameter(isFinal=true, description="port Id")
    protected volatile String devcId;
    @ConfigurationParameter(isFinal=true, description="6 or 12 for filter-wheel size")
    protected volatile Integer fwsize;
    @ConfigurationParameter(isFinal=true, maxLength=12, description="List of filter names")
    protected volatile List<String> filterNames;
    @ConfigurationParameter(description="<false|true> for <low|high> speed of motion")
    protected volatile Boolean speedMode;
    @ConfigurationParameter(description="<false|true> for sensors <inactive|active> when wheel idle")
    protected volatile Boolean sensorMode;
    private final int trigModeVal = 1;

    protected void initDevice() {
        this.stateService.registerState(ThorlabsFWState.class, "Filter Wheel State", (Object)this);
        this.chanKey = 0;
        if (this.devcId == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"devcId", (String)"is missing");
        }
        this.fullName = "ThorlabsFW " + this.name + " (" + this.devcId + ")";
        if (this.fwsize == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"fwsize", (String)"is missing");
        }
        if (this.filterNames == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"filterNames", (String)"is missing");
        }
        if (this.filterNames.size() != this.fwsize.intValue()) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"filterNames", (String)("has size " + this.filterNames.size() + ", != fwsize " + this.fwsize));
        }
        if (this.speedMode == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"speedMode", (String)"is missing");
        }
        if (this.sensorMode == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"sensorMode", (String)"is missing");
        }
    }

    protected void initialize() {
        try {
            this.fwheel.open(this.devcId);
            int speedModeVal = this.speedMode != false ? 1 : 0;
            int sensorModeVal = this.sensorMode != false ? 1 : 0;
            this.fwheel.setFW(ThorlabsFW.CmndFW.POSITION_COUNT, this.fwsize.intValue());
            this.fwheel.setFW(ThorlabsFW.CmndFW.SPEED_MODE, speedModeVal);
            this.fwheel.setFW(ThorlabsFW.CmndFW.SENSOR_MODE, sensorModeVal);
            this.fwheel.setFW(ThorlabsFW.CmndFW.TRIGGER_MODE, 1);
            int fwpos = Integer.parseInt(this.fwheel.queryFW(ThorlabsFW.CmndFW.POSITION));
            this.publishPosition(fwpos);
            this.initSensors();
            LOG.info("\n Connected to " + this.fullName);
            LOG.info("Starting filter wheel position for ThorlabsFW " + this.name + " = " + fwpos + " of " + this.fwsize);
            this.setOnline(true);
        }
        catch (DriverException e) {
            if (!this.inited) {
                LOG.severe("Error connecting to or initializing " + this.fullName + ": " + e);
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.fwheel.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    public List<DataProviderInfo> getDataProviderInfos() {
        ArrayList<DataProviderInfo> data = new ArrayList<DataProviderInfo>();
        String path = this.name + "/filterName";
        HashMap<DataProviderInfo.Attribute, String> attributes = new HashMap<DataProviderInfo.Attribute, String>();
        attributes.put(DataProviderInfo.Attribute.UNITS, "unitless");
        DataProviderInfo dataProviderInfo = new DataProviderInfo(path, DataProviderInfo.Type.TRENDING, path, attributes);
        data.add(dataProviderInfo);
        return data;
    }

    public void publishDataProviderCurrentData(AgentInfo ... agents) {
        try {
            int currentPosition = this.getPosition();
            this.publishPosition(currentPosition);
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ConfigurationParameterChanger(propertyName="speedMode")
    public void setSpeedMode(Boolean mode) throws DriverException {
        if (this.isOnline()) {
            if (mode == null) throw new IllegalArgumentException(this.name + ": improper value for speedMode, not changed");
            LOG.info(this.name + "config. change request: set SPEED_MODE = " + mode);
            int speedModeVal = mode != false ? 1 : 0;
            this.fwheel.setFW(ThorlabsFW.CmndFW.SPEED_MODE, speedModeVal);
            this.speedMode = mode;
            return;
        } else {
            if (mode == null) return;
            this.speedMode = mode;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ConfigurationParameterChanger(propertyName="sensorMode")
    public void setSensorMode(Boolean mode) throws DriverException {
        if (this.isOnline()) {
            if (mode == null) throw new IllegalArgumentException(this.name + ": improper value for sensorMode, not changed");
            LOG.info(this.name + "config. change request: set SENSOR_MODE = " + mode);
            int sensorModeVal = mode != false ? 1 : 0;
            this.fwheel.setFW(ThorlabsFW.CmndFW.SENSOR_MODE, sensorModeVal);
            this.sensorMode = mode;
            return;
        } else {
            if (mode == null) return;
            this.sensorMode = mode;
        }
    }

    @Command(type=Command.CommandType.QUERY, name="listFilters", description="List filter names by position")
    public String listFilters() {
        String flist = this.name + " contains " + this.fwsize + " filters.  Names:";
        for (int i = 0; i < Math.max(this.filterNames.size(), this.fwsize); ++i) {
            flist = flist + String.format("\n  %2d  ", i + 1) + this.filterNames.get(i);
        }
        return flist;
    }

    @Command(type=Command.CommandType.ACTION, name="setPosition", description="Set filter wheel position", timeout=11)
    public void setPosition(@Argument(name="<int>", description="New position, 1 to maximum") int value) throws DriverException {
        this.fwheel.setFW(ThorlabsFW.CmndFW.POSITION, value);
        this.publishPosition(value);
    }

    @Command(type=Command.CommandType.ACTION, name="setNamedPosition", description="Set filter wheel to named position", timeout=11)
    public void setNamedPosition(@Argument(name="<String>", description="Name of new position") String posName) throws DriverException {
        int fwpos = this.filterNames.indexOf(posName) + 1;
        LOG.info(this.name + "Position requested " + posName + " (" + fwpos + ")");
        if (fwpos <= 0) {
            LOG.severe(this.name + ":  " + posName + " not a valid filter name");
            throw new IllegalArgumentException(this.name + ":  " + posName + " not a valid filter name");
        }
        this.setPosition(fwpos);
    }

    private void publishPosition(int fwpos) {
        this.stateService.updateAgentComponentState((Object)this, new Enum[]{ThorlabsFWState.getEnum((int)fwpos)});
        String fname = this.filterNames.get(fwpos - 1);
        KeyValueData kvd = new KeyValueData(this.name + "/filterName", (Serializable)((Object)fname));
        this.agent.publishSubsystemDataOnStatusBus(kvd);
        LOG.info(this.name + " position set to filter " + fwpos + " (" + fname + ")");
    }

    protected int[] checkChannel(String chName, int hwChan, String type, String subtype) throws Exception {
        try {
            ThorlabsFW.CmndFW.valueOf((String)type);
        }
        catch (IllegalArgumentException e) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)chName, (String)"type", (Object)type);
        }
        Integer n = this.chanKey;
        this.chanKey = this.chanKey + 1;
        this.chanMap.put(this.chanKey, type);
        return new int[]{this.chanKey, 0};
    }

    protected double readChannel(int hwChan, int type) {
        double value = super.readChannel(hwChan, type);
        String chanName = this.chanMap.get(type);
        try {
            value = Integer.parseInt(this.fwheel.queryFW(ThorlabsFW.CmndFW.valueOf((String)chanName)));
        }
        catch (DriverTimeoutException et) {
            LOG.severe(this.name + " timeout reading " + chanName + ": " + et);
            this.setOnline(false);
        }
        catch (DriverException e) {
            LOG.severe(this.name + " exception reading data " + chanName + ": " + e);
        }
        return value;
    }

    @Command(type=Command.CommandType.QUERY, name="getPosition", description="Read filter wheel position")
    public int getPosition() throws DriverException {
        return Integer.parseInt(this.fwheel.queryFW(ThorlabsFW.CmndFW.POSITION));
    }

    @Command(type=Command.CommandType.QUERY, name="getNamedPosition", description="Get name of current filter")
    public String getNamedPosition() throws DriverException {
        return this.filterNames.get(this.getPosition() - 1);
    }

    @Command(type=Command.CommandType.QUERY, name="readAll", description="Read all filter-wheel controller settings and data")
    public String readAll() {
        Object table = "Read all filter wheel settings and data\n\n";
        ThorlabsFW.CmndFW[] cmndN = ThorlabsFW.CmndFW.values();
        int nN = cmndN.length;
        for (int i = 0; i < nN; ++i) {
            table = (String)table + String.format("\n   %-22s", cmndN[i]);
            try {
                String respN = this.fwheel.queryFW(cmndN[i]);
                table = (String)table + respN;
                continue;
            }
            catch (DriverException ex) {
                table = (String)table + ex.getMessage();
            }
        }
        table = (String)table + "\n";
        return table;
    }
}

