/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverLockedException;
import org.lsst.ccs.drivers.cornerstone.C260;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.teststand.MonochromatorDevice;
import org.lsst.ccs.utilities.logging.Logger;

public class Cornerstone260Device
extends Device
implements MonochromatorDevice {
    protected C260 md = null;
    private double runWave = 0.0;
    @ConfigurationParameter(maxLength=6, description="filter labels")
    private volatile String[] filter_label = new String[]{"", "", "", "", "", ""};
    @ConfigurationParameter(maxLength=6, description="filter lower edges", units="nm")
    private volatile double[] filter_edges = new double[6];
    @ConfigurationParameter(isFinal=true, description="serial devcName")
    private volatile String host = null;
    @ConfigurationParameter(isFinal=true, description="connection type, serial")
    private volatile String connType = "serial";
    @ConfigurationParameter(isFinal=true, description="baud rate")
    private volatile int baud = 9600;
    private int waitForLock = -123456789;
    private static final int NOT_DEFINED = -123456789;
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    long[] prevTime = new long[10];
    private double lastwl;
    private double lastband;
    private int lastfltpos;
    private int lastshut;
    private int lastslit1;
    private int lastslit2;
    private int lastgrat;
    private int laststep;
    @LookupField(strategy=LookupField.Strategy.TOP)
    Subsystem subsys;

    @Override
    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="host", description="Host name") String host) throws DriverException {
        this.md.open(host);
        this.log.debug((Object)"Opened connection to Cornerstone 260 device.");
    }

    public void close() {
        if (this.md != null) {
            try {
                this.md.close();
            }
            catch (DriverException e) {
                this.log.error((Object)"Failed to close connection to Cornerstone device.");
            }
        }
        this.log.debug((Object)"Closed connection to Cornerstone 260 device.");
    }

    protected void initialize() {
        try {
            this.log.info((Object)"Try to open connection to Cornerstone260!");
            this.log.info((Object)("Using host = (" + this.host + ") and baud = (" + this.baud + ") connection type: " + this.connType));
            this.md = this.waitForLock != -123456789 ? new C260(this.waitForLock) : new C260();
            this.md.open(this.host, this.baud);
            this.log.info((Object)"Succeeded in opening connection to C260 monochromator.");
            this.setOnline(true);
        }
        catch (DriverException f) {
            this.log.severe((Object)"Failed to open connection to Cornerstone260 device!", (Throwable)f);
            this.md = null;
        }
    }

    @Override
    @Command(name="abort", description="")
    public void abort() throws DriverException {
        if (this.md != null) {
            this.md.abort();
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="getBandpass", description="")
    public double getBandpass() throws DriverException {
        if (this.md != null) {
            double gbp = this.md.getBandpass();
            return gbp;
        }
        return -999.0;
    }

    @Override
    @Command(name="setBandpass", description="")
    public void setBandpass(double bandpass) throws DriverException {
        if (this.md != null) {
            this.md.setBandpass(bandpass);
        }
    }

    @Override
    @Command(name="setCalibrate", description="")
    public void setCalibrate(double val) throws DriverException {
        if (this.md != null) {
            // empty if block
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="getError", description="")
    public String getError() throws DriverException {
        C260.storedError err = new C260.storedError(this.md);
        int errCode = this.md.getFullError(err);
        this.md.clearErrors();
        if (errCode == -1) {
            return "No Error";
        }
        return err.getStr();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="getFilter", description="")
    public int getFilter() throws DriverException {
        if (this.md != null) {
            int fln = this.md.getFilter();
            return fln;
        }
        return -1;
    }

    @Override
    @Command(name="setFilter", description="")
    public void setFilter(int pos) throws DriverException {
        if (this.isOnline() && this.md != null) {
            this.md.setFilter(pos);
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="getFilterLabel", description="")
    public String getFilterLabel(int filter) {
        String label = null;
        label = this.filter_label[filter - 1];
        return label;
    }

    @Override
    public void setFilterLabel(int filter, String label) {
        this.filter_label[filter] = label;
    }

    @Override
    @ConfigurationParameterChanger(propertyName="filter_labels")
    public void setFilterLabels(String[] labels) {
        if (labels == null || labels.length != this.filter_label.length) {
            throw new IllegalArgumentException("Invalid labels array, should have 6 elements");
        }
        this.filter_label = labels;
    }

    @Override
    @ConfigurationParameterChanger(propertyName="filter_edges")
    public void setFilterEdges(double[] edges) {
        if (edges == null || edges.length != this.filter_edges.length) {
            throw new IllegalArgumentException("Invalid edges array, should have 6 elements");
        }
        this.filter_edges = edges;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="getGrating", description="")
    public String getGrating() throws DriverException {
        if (this.md != null) {
            return this.md.getGrating();
        }
        return null;
    }

    @Override
    @Command(name="setGrating", description="")
    public void setGrating(int param) throws DriverException {
        if (this.md != null) {
            this.md.setGrating(param);
        }
    }

    @Override
    @Command(name="getGratingLabel", description="")
    public String getGratingLabel(int grat) throws DriverException {
        if (this.md != null) {
            return this.md.getGratingLabel(grat);
        }
        return null;
    }

    @Override
    @Command(name="setGratingLabel", description="")
    public void setGratingLabel(int param, String label) throws DriverException {
        if (this.md != null) {
            this.md.setGratingLabel(param, label);
        }
    }

    @Override
    @Command(name="getGratingLines", description="")
    public int getGratingLines(int grat) throws DriverException {
        if (this.md != null) {
            return this.getGratingLines(grat);
        }
        return 0;
    }

    @Override
    @Command(name="setGratingLines", description="")
    public void setGratingLines(int grat, int param) throws DriverException {
    }

    @Override
    @Command(name="getGratingFactor", description="")
    public double getGratingFactor(int grat) throws DriverException {
        if (this.md != null) {
            return this.md.getGratingFactor(grat);
        }
        return 0.0;
    }

    @Override
    @Command(name="setGratingFactor", description="")
    public void setGratingFactor(int grat, double param) throws DriverException {
    }

    @Override
    @Command(name="getGratingOffset", description="")
    public double getGratingOffset(int grat) throws DriverException {
        return 0.0;
    }

    @Override
    @Command(name="setGratingOffset", description="")
    public void setGratingOffset(int grat, double param) throws DriverException {
    }

    @Override
    @Command(name="getHandshake", description="")
    public String getHandshake() throws DriverException {
        if (this.md != null) {
            boolean flag = this.md.getHandshake();
            if (flag) {
                return "true";
            }
            return "false";
        }
        return null;
    }

    @Override
    @Command(name="setHandshake", description="")
    public void setHandshake(int flag) throws DriverException {
        if (this.md != null) {
            this.md.setHandshake(flag);
        }
    }

    @Override
    @Command(name="getInfo", description="return information about the C260")
    public String getInfo() throws DriverException {
        String info = "";
        if (this.md != null) {
            info = this.md.getInfo();
        }
        return info;
    }

    @Override
    @Command(name="setOutport", description="")
    public void setOutport(int num) throws DriverException {
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="getShutter", description="")
    public String getShutter() throws DriverException {
        if (this.md != null) {
            return this.md.getShutter();
        }
        return null;
    }

    @Override
    @Command(name="openShutter", description="")
    public void openShutter() throws DriverException {
        if (this.md != null) {
            this.md.openShutter();
        }
    }

    @Override
    @Command(name="closeShutter", description="")
    public void closeShutter() throws DriverException {
        if (this.isOnline() && this.md != null) {
            this.md.closeShutter();
        }
    }

    @Override
    @Command(name="isShutterOpen", description="")
    public boolean isShutterOpen() throws DriverException {
        boolean is = false;
        if (this.isOnline()) {
            is = this.md.isShutterOpen();
        }
        return is;
    }

    @Override
    @Command(name="setShutter", description="")
    public void setShutter(String param) throws DriverException {
        if (this.isOnline() && this.md != null) {
            this.md.setShutter(param);
        }
    }

    @Override
    @Command(name="setSlitSize", description="")
    public void setSlitSize(int slit, int microns) throws DriverException {
        if (this.md != null) {
            this.md.setSlitSize(slit, microns);
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="getSlitSize", description="")
    public int getSlitSize(int slit) throws DriverException {
        int slitsize = 0;
        if (this.md != null) {
            slitsize = this.md.getSlitSize(slit);
        }
        return slitsize;
    }

    @Override
    public double getLastwl() {
        return this.lastwl;
    }

    public double getLastband() {
        return this.lastband;
    }

    @Override
    public int getLastfltpos() {
        return this.lastfltpos;
    }

    @Override
    public int getLastshut() {
        return this.lastshut;
    }

    @Override
    public int getLastSW1() {
        return this.lastslit1;
    }

    @Override
    public int getLastSW2() {
        return this.lastslit2;
    }

    public int getLastgrat() {
        return this.lastgrat;
    }

    public int getLaststep() {
        return this.laststep;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="getErrorCondition", description="")
    public int getErrorCondition() throws DriverException {
        C260.storedError err = new C260.storedError(this.md);
        int errNum = this.md.getFullError(err);
        return errNum;
    }

    @Override
    @Command(name="getStep", description="")
    public int getStep() throws DriverException {
        if (this.md != null) {
            return this.md.getStep();
        }
        return 0;
    }

    @Override
    @Command(name="advanceSteps", description="")
    public void advanceSteps(int param) throws DriverException {
        if (this.md != null) {
            this.md.advanceSteps(param);
        }
    }

    @Override
    @Command(name="getUnits", description="")
    public String getUnits() throws DriverException {
        if (this.md != null) {
            return this.md.getUnits();
        }
        return null;
    }

    @Override
    @Command(name="setUnits", description="")
    public void setUnits(String param) throws DriverException {
        if (this.md != null) {
            this.md.setUnits(param);
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="getWave", description="")
    public double getWave() throws DriverException {
        if (this.md != null) {
            this.lastwl = this.md.getWave();
            return this.lastwl;
        }
        return -1.0;
    }

    @Override
    @Command(name="setWave", description="")
    public void setWave(double wv) throws DriverException {
        if (this.isOnline() && this.md != null) {
            this.md.setWave(wv);
        }
    }

    @Command(name="setTimeout", description="set the read timeout")
    public void setTimeout(double tko) throws DriverException {
        if (this.isOnline() && this.md != null) {
            this.md.setTimeout(tko);
        }
    }

    @Override
    @Command(name="setWaveAndFilter", description="sets wavelength and the corresponding appropriate filter")
    public double setWaveAndFilter(double wv) throws DriverException {
        int ifilt = 0;
        double rwl = -1.0;
        if (this.isOnline() && this.md != null) {
            this.log.info((Object)("Setting wavelength to " + wv));
            this.md.setWave(wv);
            for (int i = 0; i < this.filter_edges.length; ++i) {
                if (!(this.filter_edges[i] > 0.0) || !(wv > this.filter_edges[i])) continue;
                ifilt = i + 1;
            }
            this.log.info((Object)("Setting filter wheel position to " + ifilt + " for wl = " + wv + " nm"));
            this.md.setFilter(ifilt);
            try {
                Thread.sleep(4000L);
                try {
                    rwl = this.md.getWave();
                }
                catch (Exception e) {
                    this.log.error((Object)("Failed to retrieve new wavelength setting. Trying again." + e));
                    Thread.sleep(10000L);
                    try {
                        rwl = this.md.getWave();
                    }
                    catch (Exception ee) {
                        this.log.error((Object)("Failed again to retrieve new wavelength setting. Trying again." + ee));
                        Thread.sleep(10000L);
                        this.md.setWave(wv + 200.0);
                        Thread.sleep(10000L);
                        this.md.setWave(wv);
                    }
                }
            }
            catch (InterruptedException f) {
                this.log.error((Object)"sleep interrupted!");
            }
        }
        KeyValueData data = new KeyValueData(this.getName() + "/filterId", (Serializable)Integer.valueOf(ifilt));
        this.subsys.publishSubsystemDataOnStatusBus(data);
        return rwl;
    }

    @Override
    @Command(name="setrunwave", description="Sets the wl value for acquisition")
    public void setRunWave(double runWave) {
        this.runWave = runWave;
    }

    @Override
    @Command(name="getrunwave", description="Returns the wl value for acquisition")
    public double getRunWave() {
        return this.runWave;
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer iType = typeMap.get(type.toUpperCase());
        if (iType == null) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"type", (Object)type);
        } else if (iType != -1) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"Wrong channel type specified! type = ", (Object)type);
        }
        return new int[]{iType, 0};
    }

    protected void initChannel(int chan, int type, int subtype) {
    }

    protected double readChannel(int chan, int type) {
        double value = 0.0;
        try {
            switch (chan) {
                case 0: {
                    this.lastwl = value = this.getWave();
                    break;
                }
                case -1: {
                    value = this.getRunWave();
                    break;
                }
                case 1: {
                    value = this.isShutterOpen() ? 1.0 : 0.0;
                    this.lastshut = (int)value;
                    break;
                }
                case 2: {
                    value = this.getFilter();
                    this.log.info((Object)("filter number is" + value));
                    this.lastfltpos = (int)value;
                    break;
                }
                case 3: {
                    value = this.getSlitSize(1);
                    this.lastslit1 = (int)value;
                    break;
                }
                case 4: {
                    value = this.getSlitSize(2);
                    this.lastslit2 = (int)value;
                    break;
                }
                case 5: {
                    value = Integer.valueOf(this.getGrating().split(",")[0]).intValue();
                    this.lastgrat = (int)value;
                    break;
                }
                case 6: {
                    this.lastband = value = this.getBandpass();
                    break;
                }
                case 7: {
                    value = Integer.valueOf(this.getGrating().split(",")[1]).intValue();
                    this.laststep = (int)value;
                }
            }
        }
        catch (DriverLockedException f) {
            System.out.print("M");
        }
        catch (DriverException e) {
            this.log.error((Object)("Error reading channel type " + chan + ": " + e));
        }
        return value;
    }

    static {
        typeMap.put("WAVELENGTH", -1);
        typeMap.put("PA", -1);
        typeMap.put("UNKNOWN", -1);
    }
}

