/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j;

public class INDIDate {
    private int years;
    private int months;
    private int days;
    private int hours;
    private int minutes;
    private double seconds;
    private static final int JANUARY = 1;
    private static final int FEBRUARY = 2;
    private static final int MARCH = 3;
    private static final int APRIL = 4;
    private static final int MAY = 5;
    private static final int JUNE = 6;
    private static final int JULY = 7;
    private static final int AUGUST = 8;
    private static final int SEPTEMBER = 9;
    private static final int OCTOBER = 10;
    private static final int NOVEMBER = 11;
    private static final int DECEMBER = 12;
    private static final int DAYS_LONG_MONTH = 31;
    private static final int DAYS_SHORT_MONTH = 30;
    private static final int DAYS_FEBRUARY = 28;
    private static final int DAYS_FEBRUARY_LEAP_YEAR = 29;
    private static final int YEARS_FOR_LEAP_YEAR = 4;
    private static final int HOURS_PER_DAY = 24;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int SECONDS_PER_MINUTE = 60;

    public INDIDate() {
        this.initializeComponents();
    }

    public INDIDate(int years, int months, int days) {
        this.initializeComponents();
        this.setYears(years);
        this.setMonths(months);
        this.setDays(days);
    }

    public INDIDate(int years, int months, int days, int hours, int minutes, double seconds) {
        this.initializeComponents();
        this.setYears(years);
        this.setMonths(months);
        this.setDays(days);
        this.setHours(hours);
        this.setMinutes(minutes);
        this.setSeconds(seconds);
    }

    private void initializeComponents() {
        this.years = 0;
        this.months = 1;
        this.days = 1;
        this.hours = 0;
        this.minutes = 0;
        this.seconds = 0.0;
    }

    public final int getYears() {
        return this.years;
    }

    public final void setYears(int years) {
        this.years = years;
    }

    public final int getMonths() {
        return this.months;
    }

    public final void setMonths(int months) {
        if (months >= 1 && months <= 12) {
            this.months = months;
        }
    }

    public final int getDays() {
        return this.days;
    }

    public final void setDays(int days) {
        if (days < 1) {
            return;
        }
        if (days <= 28) {
            this.days = days;
        } else if ((this.months == 1 || this.months == 3 || this.months == 5 || this.months == 7 || this.months == 8 || this.months == 10 || this.months == 12) && days <= 31) {
            this.days = days;
        } else if ((this.months == 4 || this.months == 6 || this.months == 9 || this.months == 11) && days <= 30) {
            this.days = days;
        } else if (this.months == 2 && this.years % 4 == 0 && days <= 29) {
            this.days = days;
        }
    }

    public final int getHours() {
        return this.hours;
    }

    public final void setHours(int hours) {
        if (hours >= 0 && hours < 24) {
            this.hours = hours;
        }
    }

    public final int getMinutes() {
        return this.minutes;
    }

    public final void setMinutes(int minutes) {
        if (minutes >= 0 && minutes < 60) {
            this.minutes = minutes;
        }
    }

    public final double getSeconds() {
        return this.seconds;
    }

    public final void setSeconds(double seconds) {
        if (seconds >= 0.0 && seconds < 60.0) {
            this.seconds = seconds;
        }
    }

    public final String toString() {
        return this.years + "/" + this.months + "/" + this.days + " " + this.hours + ":" + this.minutes + ":" + this.seconds;
    }
}

