/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j.client;

import java.util.Formatter;
import java.util.Locale;
import org.indilib.i4j.INDIException;
import org.indilib.i4j.INDISexagesimalFormatter;
import org.indilib.i4j.client.INDIElement;
import org.indilib.i4j.client.INDIElementListener;
import org.indilib.i4j.client.INDINumberProperty;
import org.indilib.i4j.client.INDIValueException;
import org.indilib.i4j.client.INDIViewCreator;
import org.indilib.i4j.protocol.DefElement;
import org.indilib.i4j.protocol.DefNumber;
import org.indilib.i4j.protocol.OneElement;
import org.indilib.i4j.protocol.OneNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class INDINumberElement
extends INDIElement {
    private static final Logger LOG = LoggerFactory.getLogger(INDINumberElement.class);
    private double value;
    private Double desiredValue = null;
    private String numberFormat;
    private double min;
    private double max;
    private double step;
    private INDISexagesimalFormatter sFormatter;
    private INDIElementListener uiComponent;

    protected INDINumberElement(DefNumber xml, INDINumberProperty property) {
        super((DefElement<?>)xml, property);
        this.setNumberFormat(xml.getFormat());
        this.setMin(xml.getMin());
        this.setMax(xml.getMax());
        this.setStep(xml.getStep());
        this.setValue(xml.getTextContent());
    }

    private void setNumberFormat(String newNumberFormat) {
        if (!newNumberFormat.startsWith("%")) {
            throw new IllegalArgumentException("Number format not starting with %\n");
        }
        if (!(newNumberFormat.endsWith("f") || newNumberFormat.endsWith("e") || newNumberFormat.endsWith("E") || newNumberFormat.endsWith("g") || newNumberFormat.endsWith("G") || newNumberFormat.endsWith("m"))) {
            throw new IllegalArgumentException("Number format not recognized%\n");
        }
        if (newNumberFormat.endsWith("m")) {
            this.sFormatter = new INDISexagesimalFormatter(newNumberFormat);
        }
        if (newNumberFormat.equals("%0.f")) {
            newNumberFormat = "%.0f";
        }
        this.numberFormat = newNumberFormat;
    }

    public double getMax() {
        return this.max;
    }

    public String getMaxAsString() {
        return this.getNumberAsString(this.getMax());
    }

    public double getMin() {
        return this.min;
    }

    public String getMinAsString() {
        return this.getNumberAsString(this.getMin());
    }

    public String getNumberFormat() {
        return this.numberFormat;
    }

    public double getStep() {
        return this.step;
    }

    public String getStepAsString() {
        return this.getNumberAsString(this.getStep());
    }

    @Override
    public String getValueAsString() {
        return this.getNumberAsString(this.getValue());
    }

    private String getNumberAsString(double number) {
        String aux;
        if (this.numberFormat.endsWith("m")) {
            aux = this.sFormatter.format(Double.valueOf(number));
        } else {
            Formatter formatter = new Formatter(Locale.US);
            aux = formatter.format(this.getNumberFormat(), number).toString();
            formatter.close();
        }
        return aux;
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    protected void setValue(OneElement<?> xml) {
        this.setValue(xml.getTextContent());
        this.notifyListeners();
    }

    private void setMax(String maxS) {
        this.max = this.parseNumber(maxS);
    }

    private void setMin(String minS) {
        this.min = this.parseNumber(minS);
    }

    private void setStep(String stepS) {
        this.step = this.parseNumber(stepS);
    }

    private void setValue(String valueS) {
        this.value = this.parseNumber(valueS);
        if (this.value < this.min || this.value > this.max) {
            String message = this.getProperty().getName() + " ; " + this.getName() + " ; Number (" + valueS + ") not in range [" + this.min + ", " + this.max + "]";
            LOG.error(message);
        }
    }

    private double parseNumber(String number) {
        double res;
        if (this.numberFormat.endsWith("m")) {
            res = this.sFormatter.parseSexagesimal(number);
        } else {
            try {
                res = Double.parseDouble(number);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Number value not correct");
            }
        }
        return res;
    }

    @Override
    public INDIElementListener getDefaultUIComponent() throws INDIException {
        if (this.uiComponent != null) {
            this.removeINDIElementListener(this.uiComponent);
        }
        this.uiComponent = INDIViewCreator.getDefault().createNumberElementView(this, this.getProperty().getPermission());
        this.addINDIElementListener(this.uiComponent);
        return this.uiComponent;
    }

    @Override
    public boolean checkCorrectValue(Object valueToCheck) throws INDIValueException {
        double d;
        if (valueToCheck == null) {
            throw new INDIValueException(this, "null value");
        }
        if (valueToCheck instanceof Double) {
            d = (Double)valueToCheck;
        } else if (valueToCheck instanceof String) {
            String val = (String)valueToCheck;
            try {
                d = this.parseNumber(val);
            }
            catch (IllegalArgumentException e) {
                throw new INDIValueException(this, e.getMessage());
            }
        } else {
            throw new INDIValueException(this, "The number value is not correct (not Double nor String)");
        }
        if (d < this.min) {
            throw new INDIValueException(this, "Number less than minimum (" + this.getMinAsString() + ")");
        }
        if (d > this.max) {
            throw new INDIValueException(this, "Number greater than maximum (" + this.getMaxAsString() + ")");
        }
        return true;
    }

    @Override
    public String getNameAndValueAsString() {
        return this.getName() + " - " + this.getValueAsString();
    }

    @Override
    public Double getDesiredValue() {
        return this.desiredValue;
    }

    @Override
    public void setDesiredValue(Object desiredValue) throws INDIValueException {
        if (desiredValue instanceof String) {
            this.setDesiredValueAsString((String)desiredValue);
        } else if (desiredValue instanceof Double) {
            this.setDesiredValueAsdouble((Double)desiredValue);
        } else {
            throw new INDIValueException(this, "Value for a Number Element must be a String or a Double");
        }
    }

    private void setDesiredValueAsString(String newDesiredValue) throws INDIValueException {
        double dd = this.parseNumber(newDesiredValue);
        if (dd < this.min || dd > this.max) {
            throw new INDIValueException(this, this.getName() + " ; Number (" + newDesiredValue + ") not in range [" + this.min + ", " + this.max + "]");
        }
        this.desiredValue = new Double(dd);
    }

    private void setDesiredValueAsdouble(double newDesiredValue) throws INDIValueException {
        double dd = newDesiredValue;
        if (dd < this.min || dd > this.max) {
            throw new INDIValueException(this, this.getName() + " ; Number (" + this.value + ") not in range [" + this.min + ", " + this.max + "]");
        }
        this.desiredValue = new Double(dd);
    }

    @Override
    public boolean isChanged() {
        return this.desiredValue != null;
    }

    protected OneNumber getXMLOneElementNewValue() {
        OneNumber xml = (OneNumber)((OneNumber)new OneNumber().setName(this.getName())).setTextContent(Double.toString(this.desiredValue));
        this.desiredValue = null;
        return xml;
    }

    public String toString() {
        return this.getNumberAsString(this.value).trim();
    }
}

