/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j.protocol.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.indilib.i4j.protocol.INDIProtocol;
import org.indilib.i4j.protocol.api.INDIInputStream;
import org.indilib.i4j.protocol.url.INDIURLStreamHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class INDIInputStreamImpl
extends InputStream
implements INDIInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(INDIInputStreamImpl.class);
    private final ObjectInputStream in;

    protected INDIInputStreamImpl(ObjectInputStream in) throws IOException {
        this.in = in;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int read() throws IOException {
        throw new IOException("not supported method");
    }

    @Override
    public INDIProtocol<?> readObject() throws IOException {
        try {
            INDIProtocol readObject = (INDIProtocol)this.in.readObject();
            readObject.trim();
            if (LOG.isTraceEnabled()) {
                LOG.trace("received indi object " + readObject);
            }
            return readObject;
        }
        catch (EOFException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("could not deserialize xml", e);
        }
    }

    static {
        INDIURLStreamHandlerFactory.init();
    }
}

