/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.ImageMetaData;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.focalplane.CCSPlayList;
import org.lsst.ccs.subsystem.focalplane.FirmwareVersion;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneSubsystem;
import org.lsst.ccs.subsystem.focalplane.IdleClear;
import org.lsst.ccs.subsystem.focalplane.IdleClearSupport;
import org.lsst.ccs.subsystem.focalplane.LSE71Commands;
import org.lsst.ccs.subsystem.focalplane.RebDevices;
import org.lsst.ccs.subsystem.focalplane.SequencerConfig;
import org.lsst.ccs.subsystem.focalplane.data.ImageReadoutParametersEvent;
import org.lsst.ccs.subsystem.focalplane.data.SequencerInfo;
import org.lsst.ccs.subsystem.focalplane.data.SequencerType;
import org.lsst.ccs.subsystem.focalplane.states.FocalPlaneState;
import org.lsst.ccs.subsystem.focalplane.states.SequencerState;
import org.lsst.ccs.subsystem.rafts.AutoCloseableReentrantLock;
import org.lsst.ccs.subsystem.rafts.SequencerProc;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2Model;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2ModelBuilder;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.LocationSet;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class Sequencers
implements IdleClearSupport {
    private static final Logger LOG = Logger.getLogger(Sequencers.class.getName());
    private final Lock sequencerLock = new ReentrantLock();
    private volatile Condition sequencerFinished;
    private final Map<Reb, SequencerProc> REBs = new LinkedHashMap<Reb, SequencerProc>();
    private final Map<Location, Reb> locationMap = new LinkedHashMap<Location, Reb>();
    private final Map<Location, Map<String, Integer>> sequencerParameterCache = new LinkedHashMap<Location, Map<String, Integer>>();
    private ImageName imageName;
    private final FocalPlaneSubsystem subsys;
    private final SequencerConfig sequencerConfig;
    private Map<SequencerType, ModelAndName> models;
    private Map<String, Integer> opcodeMap;
    private Integer currentOpcode;
    private Boolean supportsMultiMains;
    private Map<Reb.RebType, int[]> registerMap;
    private KeyValueDataList sequencerKeyValueData;
    private String annotation;
    private LocationSet locations;
    private final LocationSet configuredLocations = new LocationSet();
    private final RebDevices devices;
    private final ExecutorService executor;
    private final IdleClear idleClear;

    Sequencers(FocalPlaneSubsystem subsys, SequencerConfig sequencer, ExecutorService executor) {
        this.subsys = subsys;
        this.sequencerConfig = sequencer;
        this.executor = executor;
        this.devices = new RebDevices(executor, sequencer, this.configuredLocations);
        this.idleClear = new IdleClear(this.sequencerConfig, subsys, this);
    }

    void add(Reb reb, SequencerProc seq) {
        this.REBs.put(reb, seq);
        Location location = reb.getLocation();
        this.configuredLocations.add(location);
        this.locationMap.put(location, reb);
        if (this.subsys != null && this.subsys.dataProviderDictionaryService != null) {
            this.subsys.dataProviderDictionaryService.registerClass(SequencerInfo.class, reb.getFullName());
            this.subsys.dataProviderDictionaryService.registerClass(ImageReadoutParametersEvent.class, ImageReadoutParametersEvent.EVENT_KEY);
        }
    }

    public void clear(int nClears) throws REBException, RaftException, DAQException {
        this.clear(nClears, () -> this.setState(new Enum[]{FocalPlaneState.QUIESCENT, SequencerState.IDLE}));
    }

    public void clear(int nClears, Runnable runAfterClear) throws REBException, RaftException, DAQException {
        this.setMain(this.sequencerConfig.getClearMain());
        this.setParameter(this.sequencerConfig.getClearCountParameter(), nClears);
        this.sequencerFinished = this.scheduleEmulatedSequencer(Duration.ofMillis(nClears * 100));
        this.runSequencers(false, FocalPlaneState.CLEARING, SequencerState.RUNNING, runAfterClear);
    }

    public void startIntegration(ImageName imageName, String annotation, LocationSet locations) throws REBException, RaftException, DAQException {
        if (!this.sequencerConfig.isRealDAQ()) {
            CCSPlayList playList = this.sequencerConfig.getCurrentPlaylist();
            if (playList == null) {
                throw new RaftException("Using emulated DAQ but no playlist defined");
            }
            if (!playList.hasNextImage()) {
                throw new RaftException("No images left in playlist " + playList.getName());
            }
        }
        this.imageName = imageName;
        this.annotation = annotation;
        this.locations = locations;
        this.setMain(this.sequencerConfig.getIntegrateMain());
        if (this.sequencerConfig.hasEmulatedDAQ()) {
            this.sequencerFinished = this.sequencerLock.newCondition();
        }
        this.runSequencers(false, FocalPlaneState.INTEGRATING, SequencerState.RUNNING, (Runnable)null);
    }

    public void rowShift(int nRows) throws REBException, RaftException, DAQException {
        if (nRows == 0) {
            return;
        }
        if (this.sequencerConfig.hasEmulatedDAQ()) {
            throw new RaftException("rowShift not suported with emulatedDAQ");
        }
        this.stop();
        this.waitForStop(Duration.ofSeconds(1L));
        if (nRows > 0) {
            this.setMain(this.sequencerConfig.getRowShiftForwardMain());
        } else {
            this.setMain(this.sequencerConfig.getRowShiftReverseMain());
        }
        this.setParameter(this.sequencerConfig.getShiftCountParameter(), Math.abs(nRows));
        this.sequencerFinished = null;
        this.runSequencers(false, FocalPlaneState.ROW_SHIFT, SequencerState.RUNNING, () -> {
            try {
                this.setMain(this.sequencerConfig.getIntegrateMain());
                if (this.sequencerConfig.hasEmulatedDAQ()) {
                    this.sequencerFinished = this.sequencerLock.newCondition();
                }
                this.runSequencers(false, FocalPlaneState.INTEGRATING, SequencerState.RUNNING, (Runnable)null);
            }
            catch (DAQException | REBException | RaftException x) {
                LOG.log(Level.SEVERE, "Error restarting INTEGRATE after rowShift", x);
                this.setState(new Enum[]{SequencerState.IDLE});
            }
        });
    }

    public void stop() throws DAQException, REBException {
        if (this.sequencerConfig.hasEmulatedDAQ()) {
            Condition condition = this.sequencerFinished;
            if (condition != null) {
                this.sequencerLock.lock();
                try {
                    condition.signalAll();
                }
                finally {
                    this.sequencerLock.unlock();
                }
            }
        } else if (Objects.equals(Boolean.TRUE, this.supportsMultiMains) && this.subsys != null) {
            this.sequencerConfig.getCamera().startSequencer(31);
        } else {
            for (Map.Entry<Reb, SequencerProc> entry : this.REBs.entrySet()) {
                if (!this.isRebOnlineAndValid(entry.getKey())) continue;
                entry.getValue().sendStop();
            }
        }
    }

    public Image endIntegration(LSE71Commands.ReadoutMode readout, Runnable runAtEndReadout) throws REBException, RaftException, DAQException, IOException, CCSPlayList.PlayListException {
        LocationSet effectiveLocations = this.getEffectiveLocations();
        this.stop();
        this.waitForStop(Duration.ofSeconds(1L));
        switch (readout) {
            case TRUE: {
                this.setMain(this.sequencerConfig.getReadMain());
                if (!this.sequencerConfig.isRealDAQ()) {
                    CCSPlayList playList = this.sequencerConfig.getCurrentPlaylist();
                    playList.playNextImage(this.imageName.toString(), effectiveLocations, this.currentOpcode, this.annotation);
                }
                this.sequencerFinished = this.scheduleEmulatedSequencer(Duration.ofSeconds(2L));
                try {
                    return this.runSequencers(true, FocalPlaneState.READING_OUT, SequencerState.RUNNING, () -> {
                        if (this.subsys != null) {
                            this.subsys.getImageCoordinatorService().sequencersFinished();
                        }
                        this.setState(new Enum[]{SequencerState.IDLE});
                        if (runAtEndReadout != null) {
                            runAtEndReadout.run();
                        }
                    });
                }
                catch (DAQException x) {
                    LOG.log(Level.WARNING, "DAQ Exception during trigger, attempting to leave in clean state");
                    this.sequencerFinished = null;
                    this.setState(new Enum[]{SequencerState.IDLE, FocalPlaneState.QUIESCENT});
                    if (runAtEndReadout != null) {
                        runAtEndReadout.run();
                    }
                    throw x;
                }
            }
            case PSEUDO: {
                this.setMain(this.sequencerConfig.getPseudoReadMain());
                this.sequencerFinished = this.scheduleEmulatedSequencer(Duration.ofSeconds(2L));
                this.runSequencers(false, FocalPlaneState.READING_OUT, SequencerState.RUNNING, FocalPlaneState.QUIESCENT);
                return null;
            }
        }
        this.sequencerFinished = null;
        this.setState(new Enum[]{SequencerState.IDLE, FocalPlaneState.QUIESCENT});
        return null;
    }

    private Condition scheduleEmulatedSequencer(Duration when) {
        if (this.sequencerConfig.hasEmulatedDAQ()) {
            Condition condition = this.sequencerLock.newCondition();
            this.subsys.getScheduler().schedule(() -> {
                this.sequencerLock.lock();
                try {
                    condition.signalAll();
                }
                finally {
                    this.sequencerLock.unlock();
                }
            }, when.toMillis(), TimeUnit.MILLISECONDS);
            return condition;
        }
        return null;
    }

    @Override
    public void prepareForIdleClear() throws REBException, RaftException, DAQException {
        this.setState(new Enum[]{FocalPlaneState.IDLE_CLEAR});
    }

    @Override
    public void doIdleClear() throws REBException, RaftException, DAQException {
        if (this.sequencerConfig.hasEmulatedDAQ()) {
            this.sequencerFinished = this.scheduleEmulatedSequencer(Duration.ofMillis(100L));
        }
        this.setMain(this.sequencerConfig.getIdleClearMain());
        if (this.sequencerConfig.getIdleClearRows() != null) {
            this.setParameter(this.sequencerConfig.getClearRowsParameter(), this.sequencerConfig.getIdleClearRows());
        }
        this.runSequencers(false, () -> this.setState(new Enum[]{SequencerState.IDLE_CLEAR}), () -> this.setState(new Enum[]{SequencerState.IDLE}));
    }

    @Override
    public void terminateIdleClear(FocalPlaneState stateOnFinish) throws REBException, RaftException, DAQException {
        this.waitForStop(this.sequencerConfig.getIdleClearPeriod());
        if (stateOnFinish != null) {
            this.setState(new Enum[]{stateOnFinish, SequencerState.IDLE});
        }
    }

    private void setMain(String mainName) throws REBException, RaftException {
        if (this.opcodeMap != null) {
            this.currentOpcode = this.opcodeMap.get(mainName);
            if (this.currentOpcode == null) {
                throw new RaftException("Invalid main: " + mainName);
            }
            if (!Objects.equals(Boolean.TRUE, this.supportsMultiMains) || this.subsys == null) {
                for (Map.Entry<Reb, SequencerProc> entry : this.REBs.entrySet()) {
                    if (!this.isRebOnlineAndValid(entry.getKey())) continue;
                    entry.getValue().setStart(mainName);
                }
            }
        } else {
            this.currentOpcode = null;
        }
    }

    public void setSubroutinePointer(String pointerName, String subroutineName) throws REBException, RaftException {
        for (Map.Entry<Reb, SequencerProc> entry : this.REBs.entrySet()) {
            if (!this.isRebOnlineAndValid(entry.getKey())) continue;
            SequencerProc sequenceProc = entry.getValue();
            Integer subroutineAddress = (Integer)sequenceProc.getSubroutineMap().get(subroutineName);
            if (subroutineAddress == null) {
                throw new RaftException("Subroutine " + subroutineName + " not found");
            }
            sequenceProc.setParameter(pointerName, subroutineAddress.intValue());
        }
    }

    private void setParameter(String parameter, int value) throws REBException, RaftException {
        for (Map.Entry<Reb, SequencerProc> entry : this.REBs.entrySet()) {
            if (!this.isRebOnlineAndValid(entry.getKey())) continue;
            entry.getValue().setParameter(parameter, value);
        }
    }

    private Image runSequencers(boolean acquire, FocalPlaneState stateWhileRunning) throws REBException, RaftException, DAQException {
        return this.runSequencers(acquire, stateWhileRunning, SequencerState.RUNNING);
    }

    private Image runSequencers(boolean acquire, FocalPlaneState stateWhileRunning, SequencerState sequencerStateWhileRunning) throws REBException, RaftException, DAQException {
        return this.runSequencers(acquire, stateWhileRunning, sequencerStateWhileRunning, (FocalPlaneState)null);
    }

    private Image runSequencers(boolean acquire, Runnable runOnStart) throws REBException, RaftException, DAQException {
        return this.runSequencers(acquire, runOnStart, null);
    }

    private Image runSequencers(boolean acquire, FocalPlaneState stateWhileRunning, SequencerState sequencerStateWhileRunning, FocalPlaneState stateOnCompletion) throws REBException, RaftException, DAQException {
        return this.runSequencers(acquire, stateWhileRunning, sequencerStateWhileRunning, stateOnCompletion == null ? null : () -> this.setState(new Enum[]{stateOnCompletion, SequencerState.IDLE}));
    }

    private Image runSequencers(boolean acquire, FocalPlaneState stateWhileRunning, SequencerState sequencerStateWhileRunning, Runnable runOnFinish) throws REBException, RaftException, DAQException {
        return this.runSequencers(acquire, () -> this.setState(new Enum[]{stateWhileRunning, sequencerStateWhileRunning}), runOnFinish);
    }

    private Image runSequencers(boolean acquire, Runnable runOnStart, Runnable runOnFinish) throws REBException, RaftException, DAQException {
        LocationSet effectiveLocations = this.getEffectiveLocations();
        Image image = null;
        CCSTimeStamp ts = CCSTimeStamp.currentTime();
        if (Objects.equals(Boolean.TRUE, this.supportsMultiMains) && this.subsys != null) {
            if (this.currentOpcode == null) {
                throw new REBException("opcode not set");
            }
            LOG.log(this.getLevelForSequencerLogMessage(), "Starting sequencers with opcode={0}", this.currentOpcode);
            if (acquire) {
                ImageMetaData imd = new ImageMetaData(this.imageName.toString(), this.sequencerConfig.getDAQFolder(), this.annotation, this.currentOpcode.intValue(), (Set)effectiveLocations);
                if (this.getNRebs() > 0) {
                    image = this.sequencerConfig.getCamera().triggerImage(imd);
                    Duration delta = Duration.between(ts.getTAIInstant(), image.getMetaData().getTimestamp());
                    LOG.log(this.getLevelForSequencerLogMessage(), "Delta time between CCS and DAQ={0}", delta);
                }
                this.sendImageReadoutParametersEvent(effectiveLocations);
            } else {
                Instant daqTime = this.sequencerConfig.getCamera().startSequencer(this.currentOpcode.intValue());
                Duration delta = Duration.between(ts.getTAIInstant(), daqTime);
                LOG.log(this.getLevelForSequencerLogMessage(), "Delta time between CCS and DAQ={0}", delta);
            }
        } else if (this.subsys != null) {
            int oldOpcode = 1;
            if (acquire) {
                ImageMetaData imd = new ImageMetaData(this.imageName.toString(), this.sequencerConfig.getDAQFolder(), this.annotation, oldOpcode, (Set)effectiveLocations);
                image = this.sequencerConfig.getCamera().triggerImage(imd);
                this.sendImageReadoutParametersEvent(effectiveLocations);
            } else {
                this.sequencerConfig.getCamera().startSequencer(oldOpcode);
            }
        } else {
            for (Map.Entry<Reb, SequencerProc> entry : this.REBs.entrySet()) {
                if (!this.isRebOnlineAndValid(entry.getKey())) continue;
                entry.getValue().startSequencer();
            }
            if (acquire) {
                this.sendImageReadoutParametersEvent(effectiveLocations);
            }
        }
        runOnStart.run();
        if (runOnFinish != null) {
            if (this.sequencerConfig.useParallelRegisters()) {
                this.devices.whenSequencersStopped(() -> {
                    LOG.log(this.getLevelForSequencerLogMessage(), "Sequencers finished");
                    runOnFinish.run();
                });
            } else {
                this.doInBackground(() -> {
                    try {
                        this.waitForStop(Duration.ofMillis(1000000000L));
                        LOG.log(this.getLevelForSequencerLogMessage(), "Sequencers finished");
                        runOnFinish.run();
                    }
                    catch (REBException ex) {
                        LOG.log(Level.SEVERE, "Error waiting for REBs", ex);
                    }
                });
            }
        }
        return image;
    }

    private Level getLevelForSequencerLogMessage() {
        return this.idleClear.isIdleClearActive() ? Level.FINE : Level.INFO;
    }

    private void sendImageReadoutParametersEvent(LocationSet effectiveLocations) throws RaftException, REBException {
        ImageReadoutParametersEvent irpe = new ImageReadoutParametersEvent(this.imageName, this.annotation, effectiveLocations, this.currentOpcode.intValue(), this.sequencerConfig.getDAQFolder());
        for (Location location : effectiveLocations) {
            Reb reb = this.locationMap.get(location);
            Map<String, Integer> cache = this.sequencerParameterCache.get(location);
            int preCols = cache.get("PreCols");
            int underCols = cache.get("UnderCols");
            int readCols = cache.get("ReadCols");
            int postCols = cache.get("PostCols");
            int readCols2 = cache.get("ReadCols2");
            int overCols = cache.get("OverCols");
            int preRows = cache.get("PreRows");
            int readRows = cache.get("ReadRows");
            int postRows = cache.get("PostRows");
            int overRows = cache.get("OverRows");
            irpe.setParameters(location, reb.getCCDType(), preCols, underCols, readCols, postCols, readCols2, overCols, preRows, readRows, postRows, overRows);
        }
        if (this.subsys != null) {
            this.subsys.sendEvent(ImageReadoutParametersEvent.EVENT_KEY, (Serializable)irpe);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void waitForStop(Duration timeout) throws REBException {
        if (this.sequencerConfig.hasEmulatedDAQ()) {
            try {
                Condition condition = this.sequencerFinished;
                if (condition == null) return;
                this.sequencerLock.lock();
                try {
                    condition.await((int)timeout.toMillis(), TimeUnit.MILLISECONDS);
                    return;
                }
                finally {
                    this.sequencerLock.unlock();
                }
            }
            catch (InterruptedException ex) {
                throw new REBException("Interrupt while waiting for sequencer");
            }
        } else {
            long start = System.nanoTime();
            if (this.sequencerConfig.useParallelRegisters()) {
                this.devices.waitSequencersStopped(timeout);
                LOG.log(this.getLevelForSequencerLogMessage(), () -> String.format("Waiting for sequencers took %,dns (timeout %s)", System.nanoTime() - start, timeout));
                return;
            } else {
                HashSet<String> alreadyChecked = new HashSet<String>();
                for (Map.Entry<Reb, SequencerProc> entry : this.REBs.entrySet()) {
                    ModelAndName modelAndNameForREB = Sequencers.getModelAndNameForREB(this.models, entry.getKey());
                    if (alreadyChecked.contains(modelAndNameForREB.getName()) && this.subsys != null && !this.subsys.isSimulationMode() || !this.isRebOnlineAndValid(entry.getKey())) continue;
                    SequencerProc seq = entry.getValue();
                    seq.waitDone((int)timeout.toMillis());
                    int errorAddr = seq.getErrorAddr();
                    if (errorAddr != -1) {
                        LOG.log(Level.SEVERE, "REB error register set to {0} for {1}", new Object[]{errorAddr, entry.getKey()});
                    }
                    alreadyChecked.add(modelAndNameForREB.getName());
                }
                LOG.log(this.getLevelForSequencerLogMessage(), () -> String.format("Waiting for %d/%d sequencers took %,dns (timeout %s)", alreadyChecked.size(), this.REBs.size(), System.nanoTime() - start, timeout));
            }
        }
    }

    private static void sanityCheck(List<String> requiredMains, List<String> requiredParameters, FPGA2Model model) throws RaftException, REBException {
        Map mainMap = model.getMainAddresses();
        for (String main : requiredMains) {
            if (mainMap.get(main) != null) continue;
            throw new RaftException("Sequencer failed sanity check, missing main " + main);
        }
        List pointers = model.getPointers();
        for (String parameter : requiredParameters) {
            boolean found = false;
            for (FPGA2Model.PointerInfo pointer : pointers) {
                if (!pointer.getName().equals(parameter)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new RaftException("Sequencer failed sanity check, missing parameter " + parameter);
        }
    }

    static int[] computeMetaDataRegisters(String[] metaDataNames, FPGA2Model model) throws RaftException {
        int[] registers = new int[metaDataNames.length];
        Map pointerMap = model.getPointerMap();
        int k = 0;
        block4: for (String metaName : metaDataNames) {
            FPGA2Model.PointerInfo pi = (FPGA2Model.PointerInfo)pointerMap.get(metaName);
            if (pi != null) {
                switch (pi.getKind()) {
                    case REPEAT_FUNCTION: {
                        registers[k++] = pi.getAddress();
                        continue block4;
                    }
                    case REPEAT_SUBROUTINE: {
                        registers[k++] = pi.getAddress();
                        continue block4;
                    }
                    default: {
                        throw new RaftException("Parameter: " + metaName + " is of unsupported type " + pi.getKind());
                    }
                }
            }
            throw new RaftException("Required parameter not defined " + metaName);
        }
        LOG.log(Level.INFO, "Meta-data registers set {0}", Arrays.toString(registers));
        return registers;
    }

    static FPGA2Model validate(List<String> requiredMains, List<String> requiredParameters, String sequencerFile) throws RaftException, REBException, IOException {
        InputStream input = BootstrapResourceUtils.getBootstrapResource((String)sequencerFile);
        if (input == null) {
            throw new IOException("Invalid sequencer file name " + sequencerFile);
        }
        FPGA2ModelBuilder builder = new FPGA2ModelBuilder();
        FPGA2Model compiledModel = builder.compileFile(input);
        Sequencers.sanityCheck(requiredMains, requiredParameters, compiledModel);
        return compiledModel;
    }

    void load() throws RaftException, REBException, DAQException {
        LinkedHashMap<SequencerType, ModelAndName> localModels = new LinkedHashMap<SequencerType, ModelAndName>();
        LinkedHashMap<Reb.RebType, int[]> localRegisterMap = new LinkedHashMap<Reb.RebType, int[]>();
        this.opcodeMap = null;
        Map<SequencerType, String> sequencers = this.sequencerConfig.getSequencers();
        for (Map.Entry<SequencerType, String> sequencer : sequencers.entrySet()) {
            try {
                FPGA2Model fPGA2Model = Sequencers.validate(this.sequencerConfig.getRequiredMains(), this.sequencerConfig.getRequiredParameters(), sequencer.getValue());
                localModels.put(sequencer.getKey(), new ModelAndName(fPGA2Model, sequencer.getValue()));
            }
            catch (IOException iOException) {
                throw new RaftException("Error reading sequencer " + sequencer.getValue(), (Throwable)iOException);
            }
        }
        this.sequencerKeyValueData = new KeyValueDataList();
        for (Map.Entry<Reb, SequencerProc> entry : this.REBs.entrySet()) {
            Reb reb = entry.getKey();
            SequencerProc seq = entry.getValue();
            ModelAndName modelAndName = Sequencers.getModelAndNameForREB(localModels, reb);
            int[] registers = Sequencers.computeMetaDataRegisters(this.sequencerConfig.getMetaDataRegisters(), modelAndName.getModel());
            if (localRegisterMap.get(reb.getRebType()) == null) {
                localRegisterMap.put(reb.getRebType(), registers);
            } else if (!Arrays.equals((int[])localRegisterMap.get(reb.getRebType()), registers)) {
                throw new RaftException("Sequencers have inconsistent meta-data register sets for type " + reb.getRebType());
            }
            if (this.opcodeMap == null) {
                this.opcodeMap = modelAndName.getModel().getMainOpcodes();
            } else if (!this.opcodeMap.equals(modelAndName.getModel().getMainOpcodes())) {
                throw new RaftException("Sequencers have inconsistent main opcodes\n" + this.opcodeMap + "\n" + modelAndName.getModel().getMainOpcodes());
            }
            if (this.isRebOnlineAndValid(reb)) {
                try {
                    FirmwareVersion version = this.getFirmwareVersionForReb(reb);
                    this.checkAndLoadSequencer(seq, reb, modelAndName, version);
                }
                catch (REBException | RaftException x) {
                    LOG.log(Level.SEVERE, "Error stopping or loading sequencer " + modelAndName.getName() + " into " + reb.getFullName(), x);
                }
            }
            SequencerInfo data = new SequencerInfo(modelAndName.getName(), String.valueOf(modelAndName.getModel().computeCheckSum()));
            this.sequencerKeyValueData.addData(reb.getFullName(), (Serializable)data);
        }
        this.models = localModels;
        this.registerMap = localRegisterMap;
        if (this.subsys != null) {
            for (Map.Entry<Object, Object> entry : localRegisterMap.entrySet()) {
                this.sequencerConfig.getCamera().setRegisterList(((Reb.RebType)entry.getKey()).getLocationType(), (int[])entry.getValue());
            }
            this.subsys.publishSubsystemDataOnStatusBus((KeyValueData)this.sequencerKeyValueData);
        }
    }

    private void checkAndLoadSequencer(SequencerProc seq, Reb reb, ModelAndName modelAndName, FirmwareVersion version) throws REBException, RaftException {
        try (AutoCloseableReentrantLock lock = SequencerProc.lockSequencer((long)1L, (TimeUnit)TimeUnit.SECONDS);){
            if (seq.isRunning()) {
                LOG.log(Level.INFO, "Sequencer {0} running, attempting to stop", reb.getFullName());
                seq.sendStop();
                seq.waitDone(2000);
            }
            boolean rebSupportsMultiMains = version.supportsMultiMains();
            if (this.supportsMultiMains == null) {
                this.supportsMultiMains = rebSupportsMultiMains;
            } else if (this.supportsMultiMains != rebSupportsMultiMains) {
                LOG.log(Level.SEVERE, "Inconsistent firmware version {0} for REB {1}", new Object[]{version, reb.getFullName()});
            }
            LOG.log(Level.INFO, "Loading sequencer {0} into {1}", new Object[]{modelAndName.getName(), reb.getFullName()});
            seq.loadSequencer(modelAndName.getModel());
            this.sequencerParameterCache.put(reb.getLocation(), this.loadSequencerParameters(seq, reb, modelAndName.getModel()));
        }
        catch (AutoCloseableReentrantLock.AutoCloseableReentrantLockException e) {
            LOG.log(Level.SEVERE, "Could not obtain lock to invoke checkAndLoadSequencer", e);
        }
    }

    private void doInBackground(Runnable run) {
        this.executor.submit(run);
    }

    private void setState(Enum ... states) {
        this.setState(CCSTimeStamp.currentTime(), states);
    }

    private void setState(CCSTimeStamp ts, Enum ... states) {
        if (this.subsys != null) {
            this.subsys.setState(ts, states);
        }
    }

    Map<SequencerType, ModelAndName> getModels() {
        return this.models;
    }

    Map<Reb.RebType, int[]> getRegisterMap() {
        return this.registerMap;
    }

    KeyValueDataList getSequencerKeyValueData() {
        return this.sequencerKeyValueData;
    }

    IdleClear getIdleClear() {
        return this.idleClear;
    }

    Map<SequencerType, String> getSequencerPaths() {
        HashMap<SequencerType, String> sequencerPaths = new HashMap<SequencerType, String>();
        for (Map.Entry<SequencerType, ModelAndName> e : this.models.entrySet()) {
            sequencerPaths.put(e.getKey(), this.subsys.getAgentInfo().getAgentProperty("org.lsst.ccs.agent.hostname") + ":" + BootstrapResourceUtils.getPathOfResourceInUserResourceDirectories((String)e.getValue().getName()));
        }
        return sequencerPaths;
    }

    void load(Reb reb, FirmwareVersion version) {
        if (this.models != null) {
            SequencerProc seq = this.REBs.get(reb);
            if (seq != null) {
                ModelAndName modelAndName = Sequencers.getModelAndNameForREB(this.models, reb);
                try {
                    this.checkAndLoadSequencer(seq, reb, modelAndName, version);
                }
                catch (REBException | RaftException ex) {
                    LOG.log(Level.SEVERE, "Unable to load sequencer into " + reb.getFullName(), ex);
                }
            } else {
                LOG.log(Level.WARNING, "Reb sequencer not loaded since SequencerProc is null (guider?) {0}", reb.getFullName());
            }
        }
    }

    private boolean isRebOnlineAndValid(Reb reb) {
        if (this.subsys == null) {
            return true;
        }
        return this.subsys.isRebOnlineAndValid(reb);
    }

    private FirmwareVersion getFirmwareVersionForReb(Reb reb) {
        if (this.subsys == null) {
            return new FirmwareVersion(825774084);
        }
        return this.subsys.getFirmwareVersionForReb(reb);
    }

    private static ModelAndName getModelAndNameForREB(Map<SequencerType, ModelAndName> models, Reb reb) {
        String rebTypeString;
        switch (rebTypeString = reb.getRebType() + "-" + reb.getCCDType().getName().toUpperCase()) {
            case "SCIENCE-E2V": {
                ModelAndName result = models.get(SequencerType.SCIENCE_E2V);
                if (result == null) {
                    result = models.get(SequencerType.E2V);
                }
                return result;
            }
            case "SCIENCE-ITL": 
            case "WAVEFRONT-ITL": {
                ModelAndName result = models.get(SequencerType.SCIENCE_ITL);
                if (result == null) {
                    result = models.get(SequencerType.ITL);
                }
                return result;
            }
            case "WAVEFRONT-WF": {
                ModelAndName result = models.get(SequencerType.WAVEFRONT);
                if (result == null) {
                    result = models.get(SequencerType.ITL);
                }
                return result;
            }
            case "GUIDER-ITL": {
                ModelAndName result = models.get(SequencerType.GUIDER);
                if (result == null) {
                    result = models.get(SequencerType.ITL);
                }
                return result;
            }
        }
        throw new IllegalArgumentException("Unknown sequencer type: " + rebTypeString);
    }

    void loadSequencerParameters() {
        this.REBs.forEach((reb, seq) -> {
            ModelAndName modelAndNameForREB = Sequencers.getModelAndNameForREB(this.models, reb);
            try {
                this.sequencerParameterCache.put(reb.getLocation(), this.loadSequencerParameters((SequencerProc)seq, (Reb)reb, modelAndNameForREB.getModel()));
            }
            catch (REBException | RaftException ex) {
                LOG.log(Level.SEVERE, "Failed to set sequencer parameter for " + reb.getFullName(), ex);
            }
        });
        this.sequencerConfig.commitBulkChange();
    }

    Map<String, Integer> loadSequencerParameters(SequencerProc seq, Reb reb, FPGA2Model model) throws REBException, RaftException {
        if (this.isRebOnlineAndValid(reb)) {
            Map<String, Integer> result = this.sequencerConfig.loadParameters(model, seq);
            if (this.sequencerConfig.getTranparentMode() != null && this.subsys != null) {
                this.subsys.setTransparentMode(reb, this.sequencerConfig.getTranparentMode());
            }
            return result;
        }
        return Collections.EMPTY_MAP;
    }

    LocationSet getConfiguredLocations() {
        return this.configuredLocations;
    }

    LocationSet getEffectiveLocations() {
        return this.locations == null || this.locations.isEmpty() ? this.configuredLocations : this.locations;
    }

    int getNRebs() {
        return this.REBs.size();
    }

    private static class ModelAndName {
        private final FPGA2Model model;
        private final String name;

        public ModelAndName(FPGA2Model model, String name) {
            this.model = model;
            this.name = name;
        }

        public FPGA2Model getModel() {
            return this.model;
        }

        public String getName() {
            return this.name;
        }
    }
}

