/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.io.Serializable;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public interface EPOSControllerWithBrake
extends EPOSController {
    public boolean isBrakeActivatedPub();

    public void setBrakeActivatedPub(boolean var1);

    @Command(type=Command.CommandType.ACTION, level=1, description="Activate brake to prevent motion and disable controller.")
    default public void activateBrakeAndDisable() {
        this.activateBrake();
        FcsUtils.sleep(20, this.getName());
        this.goToSwitchOnDisabled();
    }

    default public void doReleaseBrake() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("doReleaseBrake-EPOS");){
            int val = (int)this.readParameter(EPOSEnumerations.EposParameter.DigitalOutputFonctionnalityState);
            this.writeParameter(EPOSEnumerations.EposParameter.DigitalOutputFonctionnalityState, FcsUtils.force2one(val, 15));
            this.checkBrakeReleased();
            this.publishData();
            FCSLOG.info(this.getName() + ": brake released.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Enable and release brake to permit motion. Not allowed in MASTER_ENCODER mode.")
    default public void enableAndReleaseBrake() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("enableAndReleaseBrake-EPOS");){
            if (this.isInMode(EPOSEnumerations.EposMode.MASTER_ENCODER)) {
                throw new RejectedCommandException(this.getName() + " brake can't be released when in mode MASTER_ENCODER");
            }
            this.goToOperationEnable();
            this.doReleaseBrake();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Activate brake to prevent motion and check that brake is activated within a timeout of 500ms.")
    default public void activateBrake() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("activateBrake-EPOS");){
            int val = (int)this.readParameter(EPOSEnumerations.EposParameter.DigitalOutputFonctionnalityState);
            this.writeParameter(EPOSEnumerations.EposParameter.DigitalOutputFonctionnalityState, FcsUtils.force2zero(val, 15));
            this.checkBrakeActivated();
            this.publishData();
            FCSLOG.info(this.getName() + ": brake activated.");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="return true if brake if activated.")
    default public boolean isBrakeActivated() {
        int digitalOutput = (int)this.readParameter(EPOSEnumerations.EposParameter.DigitalOutputFonctionnalityState);
        return (digitalOutput >> 15 & 1) == 0;
    }

    default public void checkBrakes(boolean activated) {
        boolean statusOK;
        long timeoutMillis = 500L;
        long timeStart = System.currentTimeMillis();
        long duration = 0L;
        boolean bl = statusOK = activated == this.isBrakeActivated();
        while (!statusOK && duration <= timeoutMillis) {
            duration = System.currentTimeMillis() - timeStart;
            FcsUtils.sleep(5, this.getName());
            statusOK = activated == this.isBrakeActivated();
        }
        if (!statusOK) {
            String msg = this.getName() + String.format(" couldn't activate brake during time allocated of %d ms", timeoutMillis);
            FCSLOG.severe(msg);
            this.setBrakeActivatedPub(!activated);
            throw new FcsHardwareException(msg);
        }
        FCSLOG.info(this.getName() + String.format(" brake activation duration = %d", duration));
        this.setBrakeActivatedPub(activated);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check that controller brake is activated. If brake is not activated within a timeout of 500ms, throw an Exception.")
    default public void checkBrakeActivated() {
        this.checkBrakes(true);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check that controller brake is released. If brake is not released within a timeout of 500ms, throw an Exception.")
    default public void checkBrakeReleased() {
        this.checkBrakes(false);
    }

    @Override
    default public StatusDataPublishedByEPOSController createStatusDataPublishedByEPOSController() {
        StatusDataPublishedByEPOSController status = new StatusDataPublishedByEPOSController(this.isBooted(), this.isInitialized(), this.isInError(), this.getErrorRegister(), this.getErrorHistoryNB(), this.getLastErrorCode(), this.getLastErrorName());
        status.setMode(this.getMode());
        status.setState(this.getEposState());
        status.setCurrent(this.getCurrent());
        status.setPosition(this.getPosition());
        status.setVelocity(this.getVelocity());
        status.setProfileAcceleration(this.getProfileAcceleration());
        status.setProfileDeceleration(this.getProfileDeceleration());
        status.setProfileVelocity(this.getProfileVelocity());
        status.setAverageCurrent(this.getAverageCurrent());
        status.setFollowingError(this.getFollowingError());
        status.setControllerWithBrake(true);
        status.setBrakeActivated(this.isBrakeActivatedPub());
        return status;
    }

    @Override
    default public void publishData() {
        StatusDataPublishedByEPOSController status = this.createStatusDataPublishedByEPOSController();
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData(this.getName(), (Serializable)status));
    }
}

