/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.gpio;

import com.sun.jna.LastErrorException;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.PointerType;
import com.sun.jna.Structure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.gpio.GPIODriver;

public class GPIODriverLibgpiod
extends GPIODriver {
    private final List<GPIOChipLibgpiod> GPIOChipsByIndex = new ArrayList<GPIOChipLibgpiod>();
    private final List<GPIOChannelLibgpiod> GPIOChannelsByIndex = new ArrayList<GPIOChannelLibgpiod>();
    private final Set<Integer> GPIOExportedChannels = new HashSet<Integer>();

    public GPIODriverLibgpiod() throws DriverException {
        gpiod.gpiod_chip_ptr chip;
        int chipNum = 0;
        int channelNum = 0;
        gpiod.gpiod_chip_iter_ptr chipIter = gpiod.INSTANCE.gpiod_chip_iter_new();
        while ((chip = gpiod.INSTANCE.gpiod_chip_iter_next(chipIter)) != null) {
            gpiod.gpiod_line_ptr line;
            this.GPIOChipsByIndex.add(new GPIOChipLibgpiod(chip, channelNum));
            gpiod.gpiod_line_iter_ptr lineIter = gpiod.INSTANCE.gpiod_line_iter_new(chip);
            while ((line = gpiod.INSTANCE.gpiod_line_iter_next(lineIter)) != null) {
                this.GPIOChannelsByIndex.add(new GPIOChannelLibgpiod(line, chipNum, channelNum));
                ++channelNum;
            }
            ++chipNum;
            gpiod.INSTANCE.gpiod_line_iter_free(lineIter);
        }
        gpiod.INSTANCE.gpiod_chip_iter_free(chipIter);
    }

    @Override
    public List<? extends GPIODriver.GPIOChip> enumerateChips() throws DriverException {
        return this.GPIOChipsByIndex;
    }

    @Override
    public List<? extends GPIODriver.GPIOChannel> enumerateExportedChannels() throws DriverException {
        return this.GPIOExportedChannels.stream().map(this.GPIOChannelsByIndex::get).collect(Collectors.toList());
    }

    @Override
    public GPIOChannelLibgpiod getChannel(int channel) throws DriverException {
        if (channel < 0 || channel >= this.GPIOChannelsByIndex.size()) {
            throw new DriverException("Invalid channel " + channel);
        }
        return this.GPIOChannelsByIndex.get(channel);
    }

    @Override
    public boolean isExported(int channel) {
        return this.GPIOExportedChannels.contains(channel);
    }

    @Override
    public GPIOChannelLibgpiod export(int channel) throws DriverException {
        GPIOChannelLibgpiod chan = this.getChannel(channel);
        chan.export();
        this.GPIOExportedChannels.add(channel);
        return chan;
    }

    @Override
    public List<? extends GPIODriver.GPIOChannel> exportRange(int base, int ngpio) throws DriverException {
        ArrayList<GPIOChannelLibgpiod> result = new ArrayList<GPIOChannelLibgpiod>();
        for (int channel = base; channel < base + ngpio; ++channel) {
            if (!this.isExported(channel)) {
                result.add(this.export(channel));
                continue;
            }
            result.add(this.getChannel(channel));
        }
        return result;
    }

    @Override
    public void unexport(int channel) throws DriverException {
        this.getChannel(channel).unexport();
        this.GPIOExportedChannels.remove(channel);
    }

    @Override
    public void unexportRange(int base, int ngpio) throws DriverException {
        for (int channel = base; channel < base + ngpio; ++channel) {
            if (!this.isExported(channel)) continue;
            this.unexport(channel);
        }
    }

    private static interface gpiod
    extends Library {
        public static final gpiod INSTANCE = (gpiod)Native.load((String)"gpiod", gpiod.class);
        public static final int LINE_DIRECTION_INPUT = 1;
        public static final int LINE_DIRECTION_OUTPUT = 2;
        public static final int GPIOD_LINE_REQUEST_DIRECTION_AS_IS = 1;
        public static final int GPIOD_LINE_REQUEST_DIRECTION_INPUT = 2;
        public static final int GPIOD_LINE_REQUEST_DIRECTION_OUTPUT = 3;

        public gpiod_chip_iter_ptr gpiod_chip_iter_new() throws LastErrorException;

        public gpiod_chip_ptr gpiod_chip_iter_next(gpiod_chip_iter_ptr var1);

        public void gpiod_chip_iter_free(gpiod_chip_iter_ptr var1);

        public gpiod_chip_ptr gpiod_chip_open_by_number(int var1);

        public String gpiod_chip_name(gpiod_chip_ptr var1);

        public String gpiod_chip_label(gpiod_chip_ptr var1);

        public int gpiod_chip_num_lines(gpiod_chip_ptr var1);

        public gpiod_line_ptr gpiod_chip_get_line(gpiod_chip_ptr var1, int var2);

        public gpiod_line_iter_ptr gpiod_line_iter_new(gpiod_chip_ptr var1) throws LastErrorException;

        public gpiod_line_ptr gpiod_line_iter_next(gpiod_line_iter_ptr var1);

        public void gpiod_line_iter_free(gpiod_line_iter_ptr var1);

        public String gpiod_line_name(gpiod_line_ptr var1);

        public int gpiod_line_offset(gpiod_line_ptr var1);

        public int gpiod_line_direction(gpiod_line_ptr var1);

        public int gpiod_line_request(gpiod_line_ptr var1, gpiod_line_request_config_ptr var2, int var3) throws LastErrorException;

        public void gpiod_line_release(gpiod_line_ptr var1);

        public int gpiod_line_get_value(gpiod_line_ptr var1);

        public void gpiod_line_set_value(gpiod_line_ptr var1, int var2);

        public void gpiod_line_close_chip(gpiod_line_ptr var1);

        public static class gpiod_line_request_config_ptr
        extends gpiod_line_request_config
        implements Structure.ByReference {
        }

        public static class gpiod_line_request_config
        extends Structure {
            public String consumer;
            public int request_type;
            public int flags;

            protected List<String> getFieldOrder() {
                return Arrays.asList("consumer", "request_type", "flags");
            }
        }

        public static final class gpiod_line_iter_ptr
        extends PointerType {
        }

        public static final class gpiod_line_ptr
        extends PointerType {
        }

        public static final class gpiod_chip_iter_ptr
        extends PointerType {
        }

        public static final class gpiod_chip_ptr
        extends PointerType {
        }
    }

    public final class GPIOChipLibgpiod
    extends GPIODriver.GPIOChip {
        private GPIOChipLibgpiod(gpiod.gpiod_chip_ptr chip, int base) throws DriverException {
            super(base, gpiod.INSTANCE.gpiod_chip_num_lines(chip), gpiod.INSTANCE.gpiod_chip_name(chip), gpiod.INSTANCE.gpiod_chip_label(chip));
        }
    }

    public static final class GPIOChannelLibgpiod
    extends GPIODriver.GPIOChannel {
        private gpiod.gpiod_line_ptr line = null;

        private GPIOChannelLibgpiod(gpiod.gpiod_line_ptr line, int chip, int channel) {
            super(chip, channel, gpiod.INSTANCE.gpiod_line_name(line), gpiod.INSTANCE.gpiod_line_offset(line));
        }

        private void assertExported() throws DriverException {
            if (this.line == null) {
                throw new DriverException("Invalid operation on unexported channel");
            }
        }

        private void export() throws DriverException {
            if (this.line == null) {
                gpiod.gpiod_chip_ptr chipPtr = gpiod.INSTANCE.gpiod_chip_open_by_number(this.chip);
                this.line = gpiod.INSTANCE.gpiod_chip_get_line(chipPtr, this.offset);
                gpiod.gpiod_line_request_config_ptr config = new gpiod.gpiod_line_request_config_ptr();
                config.consumer = gpiod.INSTANCE.toString();
                config.request_type = 1;
                config.flags = 0;
                gpiod.INSTANCE.gpiod_line_request(this.line, config, 0);
            }
        }

        private void unexport() throws DriverException {
            if (this.line != null) {
                gpiod.INSTANCE.gpiod_line_release(this.line);
                gpiod.INSTANCE.gpiod_line_close_chip(this.line);
                this.line = null;
            }
        }

        @Override
        public GPIODriver.GPIOChannel.Direction getDirection() throws DriverException {
            this.assertExported();
            int dir = gpiod.INSTANCE.gpiod_line_direction(this.line);
            switch (dir) {
                case 1: {
                    return GPIODriver.GPIOChannel.Direction.IN;
                }
                case 2: {
                    return GPIODriver.GPIOChannel.Direction.OUT;
                }
            }
            throw new DriverException("Invalid direction " + dir);
        }

        @Override
        public void setDirection(GPIODriver.GPIOChannel.Direction dir) throws DriverException {
            this.assertExported();
            gpiod.INSTANCE.gpiod_line_release(this.line);
            gpiod.gpiod_line_request_config_ptr config = new gpiod.gpiod_line_request_config_ptr();
            config.consumer = gpiod.INSTANCE.toString();
            config.flags = 0;
            switch (dir) {
                case IN: {
                    config.request_type = 2;
                    gpiod.INSTANCE.gpiod_line_request(this.line, config, 0);
                    break;
                }
                case OUT: {
                    config.request_type = 3;
                    gpiod.INSTANCE.gpiod_line_request(this.line, config, 0);
                }
            }
        }

        @Override
        public void set() throws DriverException {
            this.assertExported();
            gpiod.INSTANCE.gpiod_line_set_value(this.line, 1);
        }

        @Override
        public void clear() throws DriverException {
            this.assertExported();
            gpiod.INSTANCE.gpiod_line_set_value(this.line, 0);
        }

        @Override
        public boolean read() throws DriverException {
            this.assertExported();
            return gpiod.INSTANCE.gpiod_line_get_value(this.line) == 1;
        }

        @Override
        public void write(boolean value) throws DriverException {
            this.assertExported();
            gpiod.INSTANCE.gpiod_line_set_value(this.line, value ? 1 : 0);
        }

        @Override
        public void lock() throws DriverException {
        }

        @Override
        public void unlock() throws DriverException {
        }
    }
}

