/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.teststand.Cornerstone260Device;
import org.lsst.ccs.subsystem.teststand.MonochromatorDevice;

public class Cornerstone260SimDevice
extends Cornerstone260Device
implements MonochromatorDevice {
    int simfln = 1;
    double simwv = 225.0;
    private boolean openclose = false;
    private String host = null;
    private String connType = "serial";
    private int baud = 9600;
    private String[] filter_label = new String[]{"", "", "", "", "", ""};
    private double[] filter_edges = new double[6];

    public Cornerstone260SimDevice(String host, int baud) throws DriverException {
        this.md = null;
    }

    public Cornerstone260SimDevice() throws DriverException {
        this.md = null;
    }

    @Override
    protected void initialize() {
        this.log.info((Object)"Try to open connection to Cornerstone260 simulated device!");
        this.log.info((Object)("Using host = (" + this.host + ") and baud = (" + this.baud + ") connection type: " + this.connType));
        this.log.info((Object)"Succeeded in opening connection to Simulated C260 monochromator.");
        this.setOnline(true);
    }

    @Override
    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="host", description="Host name") String host) throws DriverException {
        this.log.debug((Object)"Opened connection to Cornerstone 260 device.");
    }

    @Override
    @Command(name="getFilter", description="")
    public int getFilter() throws DriverException {
        return this.simfln;
    }

    @Override
    @Command(name="setFilter", description="")
    public void setFilter(int pos) throws DriverException {
        this.simfln = pos;
    }

    @Override
    @Command(name="getShutter", description="")
    public String getShutter() throws DriverException {
        String gs = "shutter";
        return gs;
    }

    @Override
    @Command(name="openShutter", description="")
    public void openShutter() throws DriverException {
        this.openclose = true;
    }

    @Override
    @Command(name="closeShutter", description="")
    public void closeShutter() throws DriverException {
        this.openclose = false;
    }

    @Override
    @Command(name="isShutterOpen", description="")
    public boolean isShutterOpen() throws DriverException {
        boolean is = false;
        return this.openclose;
    }

    @Override
    @Command(name="setShutter", description="")
    public void setShutter(String param) throws DriverException {
    }

    @Override
    @Command(name="getWave", description="")
    public double getWave() throws DriverException {
        return this.simwv;
    }

    @Override
    @Command(name="setWave", description="")
    public void setWave(double wv) throws DriverException {
        this.simwv = wv;
    }
}

