/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j.protocol.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import org.indilib.i4j.protocol.api.INDIConnection;
import org.indilib.i4j.protocol.api.INDIInputStream;
import org.indilib.i4j.protocol.api.INDIOutputStream;
import org.indilib.i4j.protocol.io.INDIProtocolFactory;
import org.indilib.i4j.protocol.url.INDIURLStreamHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class INDISocketConnection
implements INDIConnection {
    private static final Logger LOG;
    private static final int CONNECT_TIMEOUT = 20000;
    private INDIInputStream inputStream;
    private INDIOutputStream ouputStream;
    private final Socket socket;

    public INDISocketConnection(Socket socket) {
        this.socket = socket;
    }

    public INDISocketConnection(String host, int port) throws IOException {
        this(new Socket());
        this.socket.connect(new InetSocketAddress(host, port), 20000);
    }

    @Override
    public INDIInputStream getINDIInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = INDIProtocolFactory.createINDIInputStream(this.wrap(this.socket.getInputStream()));
        }
        return this.inputStream;
    }

    protected InputStream wrap(InputStream coreInputStream) {
        return coreInputStream;
    }

    protected OutputStream wrap(OutputStream coreOutputStream) {
        return coreOutputStream;
    }

    @Override
    public INDIOutputStream getINDIOutputStream() throws IOException {
        if (this.ouputStream == null) {
            this.ouputStream = INDIProtocolFactory.createINDIOutputStream(this.wrap(this.socket.getOutputStream()));
        }
        return this.ouputStream;
    }

    @Override
    public void close() throws IOException {
        this.socket.shutdownInput();
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (Exception e) {
            LOG.warn("inputStream close problem", (Throwable)e);
        }
        try {
            if (this.ouputStream != null) {
                this.ouputStream.close();
            }
        }
        catch (Exception e) {
            LOG.warn("ouputStream close problem", (Throwable)e);
        }
        try {
            if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            }
        }
        catch (Exception e) {
            LOG.warn("socket close problem", (Throwable)e);
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.getURL().toString() + ")";
    }

    @Override
    public URL getURL() {
        try {
            return new URL(this.getProtocol(), this.socket.getInetAddress().getHostAddress(), this.socket.getPort(), "/");
        }
        catch (MalformedURLException e) {
            LOG.error("illegal std url, should never happen!", (Throwable)e);
            return null;
        }
    }

    protected String getProtocol() {
        return "indi";
    }

    static {
        INDIURLStreamHandlerFactory.init();
        LOG = LoggerFactory.getLogger(INDISocketConnection.class);
    }
}

