/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.chiller;

import java.time.Duration;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

public class Chiller
extends Ascii {
    private static final int DEFAULT_PORT = 9760;
    private static final int TIMEOUT = 200;
    private static final int TIMEOUT_SET = 1000;
    private static final double SETPOINT_TOLERANCE = 0.1;
    private static final double SETFLOW_TOLERANCE = 0.1;
    private static final int MAX_SETUP_PARAM = 77;
    private static final String Lbl = "Chiller ";
    private final Duration intervalCheckSet = Duration.ofMillis(10L);
    private int telnetPort = 9760;
    private int timeout = 200;
    private boolean debug = false;
    private boolean first = true;
    private Query[] qval = Query.values();

    public void open(String host, int port) throws DriverException {
        super.open(DriverConstants.ConnType.NET, host, port);
        this.setTimeout(this.timeout);
        this.setTerminator(Ascii.Terminator.CRLF);
        try {
            this.write("SI");
            this.write("DP2");
            this.write("DS");
            this.setParameter(1, "2");
            this.setParameter(16, "0");
            this.setParameter(39, "0");
            this.setParameter(47, "0");
            this.setParameter(35, "5");
            this.first = false;
        }
        catch (DriverException e) {
            this.closeSilent();
            throw e;
        }
    }

    public void open(String host) throws DriverException {
        this.open(host, 9760);
    }

    public void setDebug(boolean on_off) {
        this.debug = on_off;
    }

    public String listQueries() {
        Object table = "List of all queries for Chiller \n";
        for (int i = 0; i < this.qval.length; ++i) {
            table = (String)table + String.format("\n   %-15s  (%-5s)     %s", new Object[]{this.qval[i], this.qval[i].getCommand(), this.qval[i].getDescription()});
        }
        table = (String)table + "\n";
        return table;
    }

    public String listStatusBits() {
        StatusRegister[] stat = StatusRegister.values();
        Object table = "List of status bits \n";
        for (int i = 0; i < stat.length; ++i) {
            table = (String)table + String.format("\n   %-10s   %s", new Object[]{stat[i], stat[i].getDescr()});
        }
        return table;
    }

    public String listNamedParameters() {
        FParam[] pars;
        Object table = "List of named Chiller setup parameters \n";
        for (FParam par : pars = FParam.values()) {
            table = (String)table + String.format("\n   %-15s  (F%02d)     %s", new Object[]{par, par.getNumber(), par.getDescription()});
        }
        table = (String)table + "\n";
        return table;
    }

    public synchronized String queryChiller(Query query) throws DriverException {
        Object reply = this.read(query.getCommand());
        int expect = query.getExpectedLines();
        if (expect > 1) {
            for (int nlines = 1; nlines < expect; ++nlines) {
                reply = (String)reply + "\n" + this.read();
            }
        }
        return reply;
    }

    public double getTemperature(Query query) throws DriverException {
        if (!query.getIsTemp()) {
            throw new IllegalArgumentException("Quantity is not a temperature");
        }
        String response = this.queryChiller(query);
        String substr = response.substring(response.lastIndexOf(32) + 1);
        double value = Double.parseDouble(substr);
        return value;
    }

    public double getFlow(Query query) throws DriverException {
        if (query != Query.FLOW_RATE && query != Query.FLOW_SETPT) {
            throw new IllegalArgumentException("Arg must be a flow quantity");
        }
        String response = this.queryChiller(query);
        String substr = response.substring(response.lastIndexOf(32) + 1);
        double value = Double.parseDouble(substr);
        return value;
    }

    public double getPressure(Query query) throws DriverException {
        if (query != Query.PRESSURE_IN && query != Query.PRESSURE_OUT && query != Query.PRESSURE_TANK && query != Query.TANK_P_SET) {
            throw new IllegalArgumentException("Arg must be pressure quantity");
        }
        String response = this.queryChiller(query);
        String substr = response.substring(response.lastIndexOf(32) + 1);
        double value = Double.parseDouble(substr);
        return value;
    }

    public double getFill(Query query) throws DriverException {
        if (query != Query.TANK_PERCENT) {
            throw new IllegalArgumentException("Arg must be fill quantity");
        }
        String response = this.queryChiller(query);
        String substr = response.substring(response.lastIndexOf(32) + 1);
        double value = Integer.parseInt(substr);
        return value;
    }

    public double[] getHeatCool() throws DriverException {
        String[] resp = this.queryChiller(Query.HEAT_COOL).split("%");
        double[] percentages = new double[2];
        for (int i = 0; i < 2; ++i) {
            String substr = resp[i].substring(resp[i].lastIndexOf("=") + 1);
            percentages[i] = Double.parseDouble(substr);
        }
        return percentages;
    }

    public double getLifetime(Life life) throws DriverException {
        String substr;
        if (life == Life.CURR_VALVE) {
            String response = this.queryChiller(Query.VALVE_COUNT);
            substr = response.substring(response.lastIndexOf(32) + 1);
        } else {
            String[] lifetime = this.queryChiller(Query.LIFETIME).split("\n");
            String line = lifetime[life.ordinal()];
            substr = line.substring(line.lastIndexOf(32) + 1);
        }
        return Integer.parseInt(substr);
    }

    public String decodeEvtReg() throws DriverException {
        String resp = this.queryEvtReg();
        String substr = resp.substring(resp.length() - 2, resp.length());
        int register = Integer.parseUnsignedInt(substr, 16);
        return resp + "  " + EventRegister.decode(register);
    }

    public int getStatusReg() throws DriverException {
        String resp = this.queryChiller(Query.STATE_BITS);
        String substr = resp.substring(resp.length() - 2, resp.length());
        return Integer.parseUnsignedInt(substr, 16);
    }

    public String decodeStatusReg() throws DriverException {
        return StatusRegister.decode(this.getStatusReg());
    }

    public ErrorWords getErrorWords() throws DriverException {
        String errors = this.queryChiller(Query.ERROR_BITS);
        int idx1 = errors.indexOf(32);
        int idx2 = errors.indexOf(32, idx1 + 1);
        int idx3 = errors.indexOf(32, idx2 + 1);
        int idx4 = errors.indexOf(32, idx3 + 1);
        int err1 = Integer.parseInt(errors.substring(idx1 + 1, idx2));
        int err2 = Integer.parseInt(errors.substring(idx2 + 1, idx3));
        int warn1 = Integer.parseInt(errors.substring(idx3 + 1, idx4));
        int warn2 = Integer.parseInt(errors.substring(idx4 + 1));
        return new ErrorWords(err1, err2, warn1, warn2);
    }

    private synchronized String queryEvtReg() throws DriverException {
        String reply = this.read("REA");
        return reply;
    }

    public synchronized String readParameter(int index) throws DriverException {
        if (index >= 0 && index <= 77) {
            String command = "QFA " + index;
            String reply = this.read(command);
            String[] lines = reply.split("/n");
            if (lines.length != 1) {
                throw new DriverException("Expected 1 line in reply, received " + lines.length);
            }
            return reply;
        }
        throw new IllegalArgumentException("Index must be in range 0 to 77");
    }

    public String readNamedParameter(FParam param) throws DriverException {
        return this.readParameter(param.getNumber());
    }

    void setParameter(int index, String value) throws DriverException {
        if (index >= 0 && index <= 77) {
            int point = value.lastIndexOf(46);
            String command = "SPA " + index + " " + (point > -1 && value.length() - point > 2 ? value.substring(0, point + 2) : value);
            this.write(command);
            return;
        }
        throw new IllegalArgumentException("Index must be in range 0 to 77");
    }

    String setAndReadParameter(int index, String value) throws DriverException {
        this.setParameter(index, value);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Interrupt between se and read", ex);
        }
        return this.readParameter(index);
    }

    public void setParamCommand(FParam param, double value) throws DriverException {
        if (value < param.getMin() || value > param.getMax()) {
            throw new IllegalArgumentException(String.format("Parameter %s must be between %f and %f", new Object[]{param, param.getMin(), param.getMax()}));
        }
        double testp = value / param.getTolerance();
        double testd = Math.round(testp);
        if (Math.abs(testd - testp) >= 1.0E-7) {
            throw new IllegalArgumentException(String.format("Precision of value must not be finer than %.2f", param.getTolerance()));
        }
        this.setParameter(param.getNumber(), Double.toString(value));
        long start = System.currentTimeMillis();
        long dt = 0L;
        while (dt < 1000L) {
            if (this.debug) {
                System.out.println("In wait loop, dt = " + dt);
            }
            try {
                Thread.sleep(this.intervalCheckSet.toMillis());
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Unexpected interrupt while waiting in Chiller.setParamCommand", ex);
            }
            String str = this.readNamedParameter(param);
            String substr = str.substring(str.lastIndexOf(32) + 1);
            double val = Double.parseDouble(substr);
            if (this.debug) {
                System.out.println("param " + param.getNumber() + "  val read = " + val + "  set value = " + value);
            }
            dt = System.currentTimeMillis() - start;
            if (!(Math.abs(val - value) < param.getTolerance())) continue;
            if (this.debug) {
                System.out.println("End of loop, dt = " + dt);
            }
            return;
        }
        throw new DriverTimeoutException("timeout, dt = " + dt + ", while waiting for parameter setting");
    }

    public void setTemperature(double value) throws DriverException {
        String cmndString = "GT " + Double.toString(value);
        this.write(cmndString);
        this.checkSetPoint(value);
    }

    public void setTemperatureWithRamp(double value, double ramp) throws DriverException {
        String cmndString = "RR " + Double.toString(value) + " " + Double.toString(ramp);
        this.write(cmndString);
        this.checkSetPoint(value);
    }

    private void checkSetPoint(double value) throws DriverException {
        long start = System.currentTimeMillis();
        long dt = 0L;
        while (dt < 1000L) {
            try {
                Thread.sleep(this.intervalCheckSet.toMillis());
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Unexpected interrupt while waiting in Chiller.setParamCommand", ex);
            }
            double setpt = this.getTemperature(Query.SET_POINT);
            if (Math.abs(setpt - value) < 0.1) {
                return;
            }
            dt = System.currentTimeMillis() - start;
        }
        throw new DriverTimeoutException("timeout while waiting for temperature setpoimt");
    }

    public void quitControl() throws DriverException {
        this.write("QU");
    }

    public void setFlow(double value) throws DriverException {
        String cmndString = "PSP " + String.format("%.1f", value);
        this.write(cmndString);
        long start = System.currentTimeMillis();
        long dt = 0L;
        while (dt < 1000L) {
            try {
                Thread.sleep(this.intervalCheckSet.toMillis());
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Unexpected interrupt while waiting in Chiller.setParamCommand", ex);
            }
            double setpt = this.getFlow(Query.FLOW_SETPT);
            if (Math.abs(setpt - value) < 0.1) {
                return;
            }
            dt = System.currentTimeMillis() - start;
        }
        throw new DriverTimeoutException("timeout while waiting for flow setpoimt");
    }

    public void startPurge() throws DriverException {
        this.write("PO");
    }

    public void stopPurge() throws DriverException {
        this.write("PF");
    }

    public void writeDUT(double temperature) throws DriverException {
        String cmnd = "SDT " + String.format("%.1f", temperature);
        this.write(cmnd);
    }

    public void clearErrors() throws DriverException {
        this.write("CLE");
    }

    public void clearGuiErrorScreen() throws DriverException {
        this.write("CES");
    }

    public void lockGui(boolean lock) throws DriverException {
        String cmnd = lock ? "FLO" : "FLF";
        this.write(cmnd);
    }

    public void saveParams() throws DriverException {
        this.write("UP");
    }

    public void loadParams() throws DriverException {
        this.write("RUP");
    }

    public void sendDirectCommand(String command, String ... args) throws DriverException {
        if (this.debug) {
            boolean notQuery = true;
            for (int i = 0; i < this.qval.length; ++i) {
                String test = this.qval[i].getCommand();
                int idx = test.indexOf(32);
                if (idx > 0) {
                    test = test.substring(0, idx);
                }
                if (!command.equals(test)) continue;
                notQuery = false;
                break;
            }
            if (command.equals("QFA") || command.equals("TE")) {
                notQuery = false;
            }
            if (!notQuery) {
                throw new DriverException("not allowed for query commands");
            }
        } else {
            throw new DriverException("allowed only in Debug mode");
        }
        this.write(Chiller.makeCommandString(command, args));
    }

    protected static String makeCommandString(String command, String ... args) {
        StringBuilder cmnd = new StringBuilder(command);
        for (String arg : args) {
            cmnd.append(' ').append(arg);
        }
        return cmnd.toString();
    }

    public static enum Query {
        FLOW_RATE("CHF", "Flow Rate (GPM or LPM)", 1, false),
        CASCADE_SETPT("CSP", "Cascade setpoint in DUT mode", 1, true),
        IDENTITY("*IDN?", "Controller Identity", 1, false),
        LOOP_COUNT("LCT", "Loop Count (Program Mode)", 1, false),
        T_PROBE2("PT 2", "Temperature Probe 2 (type F35)", 1, true),
        LAT_CMND("QC", "Last Command String", 1, false),
        ERR_BITS_OLD("QCE", "Error1, Error2, Warning1", 1, false),
        DIAG_INFO("QDI", "Diagnostics Info", 2, false),
        ERROR_BITS("QEW", "Error1, Error2, Warn1, Warn2", 1, false),
        TANK_P_SET("QFA 73", "Tank pressure setpoint", 1, false),
        LIFETIME("QLP", "Life Time Parameters", 4, false),
        REMOTE_MODE("QM", "1 = Immediate, 2 = Program", 1, false),
        SERIAL_NO("QN", "Controller Serial Number", 1, false),
        PGM_STATE("QPG", "Remote Program Running State", 1, false),
        HEAT_COOL("QPL", "Heat and Cool Percents of Max", 1, false),
        TEMP_RANGE("QR", "Controller Temperature Range", 1, false),
        SET_POINT("QS", "Probe Number and Set Point", 1, true),
        DYNAMIC_SET("QSC", "Probe No. and Control Set Point", 1, true),
        SYS_INFO("QSI", "System Information", 7, false),
        FIRMWARE("QV", "Firmware Version", 1, false),
        VALVE_COUNT("QVC", "Current valve-activation count", 1, false),
        WARN2("QWT", "Warning2 (bits)", 1, false),
        FLOW_RATE_D1("RCF", "Flow Rate to 1-decimal", 1, false),
        STATUS("RCS", "Chiller Status (hex)", 1, false),
        INPUT_BITS1("RID 1", "5V Digital Inputs (binary)", 1, false),
        INPUT_BITS2("RID 2", "24V Digital Inputs (binary)", 1, false),
        PRESSURE_IN("RIP", "Input Pressure", 1, false),
        OUTPUT_BITS1("ROD 1", "5V Digital Outputs (binary)", 1, false),
        OUTPUT_BITS2("ROD 2", "24V Digital Outputs (binary)", 1, false),
        PRESSURE_OUT("ROP", "Output Pressure", 1, false),
        PID_PARAM("RP", "PID Constants (F0, F10 to F12)", 1, false),
        FLOW_SETPT("RPS", "Pressure or Flow Setpoint", 1, false),
        STATE_BITS("RSA", "Chiller State Bits (hex)", 1, false),
        GPIB_TIMEOUT("RTM", "GPIB timeout (F44)", 1, false),
        PRESSURE_TANK("RTP", "Tank Pressure", 1, false),
        TANK_PERCENT("TLP", "Tank fill percentage", 1, false),
        TEMPERATURE("TP 1", "Coolant Output Temperature", 1, true),
        T_CONDENSER("TP 5", "Temperature CondensorOut", 1, true),
        T_TXV_BULB("TP 6", "Temperture TXV_Bulb", 1, true),
        T_STAGE2EVAP("TP 7", "Temperature Stage2Evap", 1, true);

        private String command;
        private String description;
        private int expectedLines;
        private boolean isTemp;

        private Query(String command, String description, int expectedLines, boolean isTemp) {
            this.command = command;
            this.description = description;
            this.expectedLines = expectedLines;
            this.isTemp = isTemp;
        }

        public String getCommand() {
            return this.command;
        }

        public String getDescription() {
            return this.description;
        }

        public int getExpectedLines() {
            return this.expectedLines;
        }

        public boolean getIsTemp() {
            return this.isTemp;
        }
    }

    public static enum StatusRegister {
        ERROR(1, "Error(s) present "),
        WARNING(2, "Warning(s) present "),
        PGM_FULL(4, "Program Buffer over 0.75 full "),
        T_CONTROL(8, "RunState: Controlling T "),
        AT_SETPT(16, "At Temperature SetPoint "),
        SRQ_SET(32, "SRQ Set "),
        CMPRS_ON(64, "Compressors on "),
        UNUSED_7(128, "Unused Bit7 ");

        private int mask;
        private String descr;

        private StatusRegister(int mask, String descr) {
            this.mask = mask;
            this.descr = descr;
        }

        public int getMask() {
            return this.mask;
        }

        public String getDescr() {
            return this.descr;
        }

        public static String decode(int register) {
            String decoded = "StatusRegister = 0x" + Integer.toHexString(register);
            StatusRegister[] stat = StatusRegister.values();
            int nbits = stat.length;
            for (int i = 0; i < nbits; ++i) {
                String st = (register & stat[i].mask) != 0 ? "Yes" : "No ";
                decoded = decoded + "   " + stat[i] + " " + st;
            }
            return decoded;
        }
    }

    public static enum FParam {
        PID_KP(0, 1.0, 1.0, 64.0, "", "PID proportional coeff"),
        COLD_PERIOD(2, 1.0, 1.0, 32.0, "s", "Cold valve period (s)"),
        CLR_KI_SETPT(5, 1.0, 0.0, 1.0, "", "If 1, clear Ki at setpoint"),
        PID_KI(10, 1.0, 0.0, 3200.0, "", "PID integral coeff"),
        PID_KD(11, 1.0, 0.0, 3200.0, "", "PID differential coeff"),
        PID_GAINFAC(12, 1.0, -99.0, 99.0, "", "PID cool (<0)/heat (>0) factor"),
        HEAT_CAPACITY(15, 1.0, 1.0, 100.0, "", "Heat capacity, % of max"),
        DUT_TMIN(27, 0.1, -70.0, 30.0, "\u00b0C", "DUT lower temp limit"),
        DUT_TMAX(28, 0.1, -70.0, 30.0, "\u00b0C", "DUT upper temp limit"),
        DUT_DT_LO(29, 0.1, 1.0, 300.0, "\u00b0C", "DUT lower DeltaT limit"),
        DUT_DT_HI(30, 0.1, 1.0, 300.0, "\u00b0C", "DUT upper DeltaT limit"),
        SETPT_TOL(31, 0.1, 0.1, 10.0, "\u00b0C", "SetPoint tolerance (deg-C)"),
        SETPT_SETTLE(32, 1.0, 0.0, 59.0, "s", "Min SetPoint stable time (s)"),
        THERMSL_MASS(34, 1.0, 1.0, 1000.0, "", "Thermal mass (DUT damping)"),
        REFRIG_OFF(36, 1.0, 5.0, 10.0, "min", "Refrig-off timer (min)"),
        RAMP_DEFAULT(37, 0.1, 0.0, 500.0, "\u00b0C/min", "Default ramp rate (deg/min)"),
        FLOWMETER_LO(38, 0.1, 0.0, 99.0, "gal/min", "Low-flow-meter alarm thresh"),
        T_CTRL_MODE(40, 1.0, 0.0, 1.0, "", "T-control Normal (0)/DUT (1)"),
        FLOW_ERR_MASK(58, 1.0, 1.0, 180.0, "s", "Flow-switch error mask time (s)"),
        DUT_KP(59, 0.1, 0.1, 64.0, "", "DUT proportional coeff"),
        DUT_KI(60, 0.1, 0.0, 64.0, "", "DUT integral coeff"),
        COOL_CAPACITY(64, 1.0, 1.0, 100.0, "", "Cool capacity, % of max"),
        HEAT_PERIOD(66, 1.0, 1.0, 10.0, "s", "Period for heat application"),
        BUBBLEV_TIME(72, 1.0, 1.0, 10.0, "min", "Bubble valve open duration"),
        TANK_SETPOINT(73, 1.0, 0.0, 50.0, "psig", "Tank pressure setpoint"),
        PURGE_TIME(77, 1.0, 1.0, 10.0, "min", "Time purge lasts after start");

        private int number;
        private double tol;
        private double min;
        private double max;
        private String units;
        private String descr;

        private FParam(int number, double tol, double min, double max, String units, String descr) {
            this.number = number;
            this.tol = tol;
            this.min = min;
            this.max = max;
            this.units = units;
            this.descr = descr;
        }

        public int getNumber() {
            return this.number;
        }

        public double getTolerance() {
            return this.tol;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public String getUnits() {
            return this.units;
        }

        public String getDescription() {
            return this.descr;
        }
    }

    public static enum Life {
        CONTROL("Controller Hours"),
        COMPRESS("Compressor One Hours"),
        PUMP("Pump Hours"),
        VALVE("Valve Activation Count"),
        CURR_VALVE("Current Valve Activation Count");

        private String descr;

        private Life(String descr) {
            this.descr = descr;
        }

        public String getDescription() {
            return this.descr;
        }
    }

    public static enum EventRegister {
        BAD_ARG(1, "Bad_Argument "),
        PGM_FULL(2, "PgmBuffer_0.75Full "),
        BAD_CMND(4, "UnrecognizedCmnd "),
        DWELLTIME(8, "DwellTime_Done "),
        SETPOINT(16, "SetPoint_Reached "),
        CMND_OVFL(32, "CmndBufferOverrun  "),
        UNUSED_6(64, "Unused_Bit6 "),
        UNUSED_7(128, "Unused_Bit7 ");

        private int mask;
        private String descr;

        private EventRegister(int mask, String descr) {
            this.mask = mask;
            this.descr = descr;
        }

        public static String decode(int register) {
            Object decoded = "EventRegister:  ";
            EventRegister[] bits = EventRegister.values();
            int nbits = bits.length;
            for (int i = 0; i < nbits; ++i) {
                if ((register & bits[i].mask) == 0) continue;
                decoded = (String)decoded + bits[i].toString() + " ";
            }
            return decoded;
        }
    }

    public static class ErrorWords {
        private int err1;
        private int err2;
        private int warn1;
        private int warn2;

        public ErrorWords(int err1, int err2, int warn1, int warn2) {
            this.err1 = err1;
            this.err2 = err2;
            this.warn1 = warn1;
            this.warn2 = warn2;
        }

        public int getError1() {
            return this.err1;
        }

        public int getError2() {
            return this.err2;
        }

        public int getWarning1() {
            return this.warn1;
        }

        public int getWarning2() {
            return this.warn2;
        }

        public String toString() {
            String err = "Error1 = 0x" + Integer.toHexString(this.err1) + "  Error2 = 0x" + Integer.toHexString(this.err2) + "  Warning1 = 0x" + Integer.toHexString(this.warn1) + "  Warning2 = 0x" + Integer.toHexString(this.warn2);
            return err;
        }

        public boolean equals(Object y) {
            ErrorWords x = (ErrorWords)y;
            boolean eq = this.err1 == x.getError1() && this.err2 == x.getError2() && this.warn1 == x.getWarning1() && this.warn2 == x.getWarning2();
            return eq;
        }
    }
}

