/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.subsystem.teststand.PhotoDiodeDevice;
import org.lsst.ccs.subsystem.teststand.UniblitzShutter;
import org.lsst.ccs.subsystem.teststand.data.TestStandAgentProperties;

public class TS8Bench
extends Subsystem
implements HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    Map<String, PhotoDiodeDevice> photoDiodeMap = new HashMap<String, PhotoDiodeDevice>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    UniblitzShutter shutter;
    @LookupName
    private String name;
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getPackage().getName());

    public TS8Bench() {
        super("ccfcs", AgentInfo.AgentType.WORKER);
    }

    public void postInit() {
        ((AgentPropertiesService)this.getAgentService(AgentPropertiesService.class)).setAgentProperty(TestStandAgentProperties.TESTSTAND_TYPE_AGENT_PROPERTY, TS8Bench.class.getCanonicalName());
    }

    @Command(type=Command.CommandType.ACTION, name="openShutter", description="open TS8 shutter")
    public void openShutter() throws DriverException {
        if (this.shutter == null) {
            this.log.severe("Shutter not configured");
            return;
        }
        this.shutter.setShutter(true);
    }

    @Command(type=Command.CommandType.ACTION, name="closeShutters", description="close TS8 shutter")
    public void closeShutter() throws DriverException {
        if (this.shutter == null) {
            this.log.severe("Shutter not configured");
            return;
        }
        this.shutter.setShutter(false);
    }
}

