/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.location;

import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.utilities.location.Location;

public class SensorLocation
implements Serializable,
Comparable<SensorLocation> {
    private static final Pattern SENSOR_PATTERN = Pattern.compile("R(\\d\\d)S(.)([012])");
    private static final long serialVersionUID = 1L;
    final Location rebLocation;
    final int sensor;

    public SensorLocation(byte bay, byte board, int sensor) {
        this(new Location(bay, board), sensor);
    }

    public SensorLocation(Location rebLocation, int sensor) {
        int nCCDs;
        int n = nCCDs = rebLocation.type() == Location.LocationType.SCIENCE ? 3 : 2;
        if (sensor >= nCCDs) {
            throw new IllegalArgumentException("Invalid sensor # " + sensor + " for " + rebLocation);
        }
        this.rebLocation = rebLocation;
        this.sensor = sensor;
    }

    public Location getRebLocation() {
        return this.rebLocation;
    }

    public int getSensor() {
        return this.sensor;
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + Objects.hashCode(this.rebLocation);
        hash = 83 * hash + this.sensor;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SensorLocation other = (SensorLocation)obj;
        if (this.sensor != other.sensor) {
            return false;
        }
        return Objects.equals(this.rebLocation, other.rebLocation);
    }

    public static SensorLocation of(String string) {
        Matcher matcher = SENSOR_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid sensor location: " + string);
        }
        String reb = "R" + matcher.group(1) + "/Reb" + matcher.group(2);
        Location rebLocation = Location.of(reb);
        int sensor = Integer.parseInt(matcher.group(3));
        return new SensorLocation(rebLocation, sensor);
    }

    public String toString() {
        return this.rebLocation.getRaftName() + this.rebLocation.getSensorName(this.sensor);
    }

    public String toString(String rebSensorSeparator) {
        return this.rebLocation.getRaftName() + rebSensorSeparator + this.rebLocation.getSensorName(this.sensor);
    }

    @Override
    public int compareTo(SensorLocation other) {
        int result = this.rebLocation.compareTo(other.rebLocation);
        if (result == 0) {
            result = this.sensor - other.sensor;
        }
        return result;
    }
}

