/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j;

import java.io.Serializable;
import java.util.Formatter;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class INDISexagesimalFormatter
implements Serializable {
    private static final long serialVersionUID = -3904216502728630808L;
    private String format;
    private int length;
    private int fractionLength;
    private static final int FL3 = 3;
    private static final int FL5 = 5;
    private static final int FL6 = 6;
    private static final int FL8 = 8;
    private static final int FL9 = 9;
    private static final double MINUTES_PER_HOUR = 60.0;
    private static final double SECONDS_PER_HOUR = 3600.0;
    private static final double SECONDS_PER_MINUTE = 60.0;
    private static final double ZERO_NEG = -0.0;

    public INDISexagesimalFormatter(String format) {
        this.format = format;
        this.checkFormat();
    }

    public final String getFormat() {
        return this.format;
    }

    private void checkFormat() {
        if (!this.format.startsWith("%")) {
            throw new IllegalArgumentException("Number format not starting with %");
        }
        if (!this.format.endsWith("m")) {
            throw new IllegalArgumentException("Sexagesimal format not recognized (not ending m)");
        }
        String remaining = this.format.substring(1, this.format.length() - 1);
        int dotPos = remaining.indexOf(".");
        if (dotPos == -1) {
            throw new IllegalArgumentException("Sexagesimal format not correct (no dot)");
        }
        String l = remaining.substring(0, dotPos);
        String frLength = remaining.substring(dotPos + 1);
        try {
            this.length = Integer.parseInt(l);
            this.fractionLength = Integer.parseInt(frLength);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Illegal sexagesimal length or fraction length");
        }
        if (this.fractionLength != 3 && this.fractionLength != 5 && this.fractionLength != 6 && this.fractionLength != 8 && this.fractionLength != 9) {
            throw new IllegalArgumentException("Illegal sexagesimal fraction length");
        }
    }

    @Deprecated
    public final double parseSexagesimal2(String number) {
        String newNumber = number.replace(' ', ':');
        if ((newNumber = newNumber.replace(';', ':')).indexOf(":") == -1) {
            try {
                double n = Double.parseDouble(newNumber);
                return n;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Sexagesimal number format not correct (not even single number)");
            }
        }
        StringTokenizer st = new StringTokenizer(newNumber, ":", false);
        double degrees = 0.0;
        double minutes = 0.0;
        double seconds = 0.0;
        try {
            String aux = st.nextToken().trim();
            if (aux.length() > 0) {
                degrees = Double.parseDouble(aux);
            }
            if ((aux = st.nextToken().trim()).length() > 0) {
                minutes = Double.parseDouble(aux);
            }
            if (this.fractionLength > 5 && (aux = st.nextToken().trim()).length() > 0) {
                seconds = Double.parseDouble(aux);
            }
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("Sexagesimal number format not correct");
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Sexagesimal number component not correct");
        }
        double res = degrees;
        res = degrees > 0.0 ? (res += minutes / 60.0 + seconds / 3600.0) : (res -= minutes / 60.0 + seconds / 3600.0);
        return res;
    }

    public final double parseSexagesimal(String number) {
        String newNumber = number.trim();
        if (newNumber.isEmpty()) {
            throw new IllegalArgumentException("Empty number");
        }
        newNumber = newNumber.replace(' ', ':');
        int charCount = (newNumber = newNumber.replace(';', ':')).length() - newNumber.replaceAll(":", "").length();
        if (charCount > 2) {
            throw new IllegalArgumentException("Too many components for the sexagesimal formatter");
        }
        double degrees = 0.0;
        double minutes = 0.0;
        double seconds = 0.0;
        StringTokenizer st = new StringTokenizer(newNumber, ":", false);
        String d = st.nextToken().trim();
        try {
            degrees = Double.parseDouble(d);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Number format incorrect");
        }
        if (st.hasMoreTokens()) {
            String m = st.nextToken().trim();
            try {
                minutes = Double.parseDouble(m);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Minutes format incorrect");
            }
            if (minutes < 0.0) {
                throw new IllegalArgumentException("Minutes cannot be negative");
            }
            if (st.hasMoreTokens()) {
                String s = st.nextToken().trim();
                try {
                    seconds = Double.parseDouble(s);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Seconds format incorrect");
                }
                if (seconds < 0.0) {
                    throw new IllegalArgumentException("Seconds cannot be negative");
                }
            }
        }
        double res = degrees;
        res = Double.valueOf(degrees).compareTo(-0.0) > 0 ? (res += minutes / 60.0 + seconds / 3600.0) : (res -= minutes / 60.0 + seconds / 3600.0);
        return res;
    }

    public final String format(Double number) {
        double minutes;
        int sign = 1;
        if (number < 0.0) {
            sign = -1;
        }
        double newNumber = Math.abs(number);
        String fractionalPart = ":";
        int integerPart = (int)Math.floor(newNumber);
        double fractional = Math.abs(newNumber - (double)integerPart);
        if (this.fractionLength < 6) {
            minutes = fractional * 60.0;
            String form = "%02.0f";
            if (this.fractionLength == 5) {
                form = "%04.1f";
            }
            Formatter formatter = new Formatter(Locale.US);
            Object[] objectArray = new Object[]{minutes};
            String newMinutes = formatter.format(form, objectArray).toString();
            if (Double.parseDouble(newMinutes) >= 60.0) {
                minutes = 0.0;
                ++integerPart;
            }
            formatter = new Formatter(Locale.US);
            fractionalPart = fractionalPart + formatter.format(form, minutes);
        } else {
            minutes = Math.floor(fractional * 60.0);
            double rest = fractional - minutes / 60.0;
            double seconds = rest * 3600.0;
            String form = "%02.0f";
            if (this.fractionLength == 8) {
                form = "%04.1f";
            } else if (this.fractionLength == 9) {
                form = "%05.2f";
            }
            Formatter formatter = new Formatter(Locale.US);
            String newSeconds = formatter.format(form, seconds).toString();
            if (Double.parseDouble(newSeconds) >= 60.0) {
                seconds = 0.0;
                minutes += 1.0;
            }
            formatter = new Formatter(Locale.US);
            Object[] objectArray = new Object[]{minutes};
            String newMinutes = formatter.format("%02.0f", objectArray).toString();
            if (Double.parseDouble(newMinutes) >= 60.0) {
                minutes = 0.0;
                ++integerPart;
            }
            formatter = new Formatter(Locale.US);
            fractionalPart = fractionalPart + formatter.format("%02.0f:" + form, minutes, seconds);
        }
        String res = integerPart + fractionalPart;
        if (sign < 0) {
            res = "-" + res;
        }
        res = this.padLeft(res, this.length);
        return res;
    }

    private String padLeft(String s, int n) {
        if (s.length() >= n) {
            return s;
        }
        int nSpaces = n - s.length();
        if (nSpaces <= 0) {
            return s;
        }
        StringBuilder spacesBuffer = new StringBuilder(nSpaces);
        for (int i = 0; i < nSpaces; ++i) {
            spacesBuffer.append(" ");
        }
        String spaces = spacesBuffer.toString();
        return spaces + s;
    }
}

