import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.subsystem.power.MainPower
import org.lsst.ccs.subsystem.power.SimPowerDevice
import org.lsst.ccs.subsystem.power.PowerDeviceGroup
import org.lsst.ccs.subsystem.power.PowerControl
import org.lsst.ccs.monitor.Channel

CCSBuilder builder = ["power-sim"]

builder.main (MainPower) {

    def pwr = "Power"

    "$pwr" (SimPowerDevice, loads:[10, 20, 100, 500]) {

        "$pwr" (PowerDeviceGroup)

        "6V"  (PowerControl, description:"6V power supply", hwChan:0)

        "9V"  (PowerControl, description:"9V power supply", hwChan:3)

        "24V" (PowerControl, description:"24V power supply", hwChan:2)

        "40V" (PowerControl, description:"40V power supply", hwChan:1)
    }

    "${pwr}/6V_V" (Channel, description: "6V supply voltage", units: "Volts",
                   devcName: pwr,  hwChan:0, type: "VOLTAGE")
                          
    "${pwr}/6V_I" (Channel, description: "6V supply current", units: "Amps",
                   devcName: pwr,  hwChan:0, type: "CURRENT")

    "${pwr}/9V_V" (Channel, description: "9V supply voltage", units: "Volts",
                   devcName: pwr,  hwChan:3, type: "VOLTAGE")
                          
    "${pwr}/9V_I" (Channel, description: "9V supply current", units: "Amps",
                   devcName: pwr,  hwChan:3, type: "CURRENT")

    "${pwr}/24V_V" (Channel, description: "24V supply voltage", units: "Volts",
                    devcName: pwr,  hwChan:2, type: "VOLTAGE")
                          
    "${pwr}/24V_I" (Channel, description: "24V supply current", units: "Amps",
                    devcName: pwr,  hwChan:2, type: "CURRENT")

    "${pwr}/40V_V" (Channel, description: "40V supply voltage", units: "Volts",
                    devcName: pwr,  hwChan:1, type: "VOLTAGE")
                          
    "${pwr}/40V_I" (Channel, description: "40V supply current", units: "Amps",
                    devcName: pwr,  hwChan:1, type: "CURRENT")

}
