/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.DataException;
import org.astrogrid.samp.JsonReader;
import org.astrogrid.samp.JsonWriter;
import org.astrogrid.samp.Metadata;

public class SampUtils {
    public static final String LOCALHOST_PROP = "jsamp.localhost";
    private static final Logger logger_ = Logger.getLogger(SampUtils.class.getName());
    private static String sampVersion_;
    private static String softwareVersion_;
    private static File lockFile_;
    private static final String NEWLINE;

    private SampUtils() {
    }

    public static String encodeInt(int i) {
        return Integer.toString(i);
    }

    public static int decodeInt(String s) {
        return Integer.parseInt(s);
    }

    public static String encodeLong(long i) {
        return Long.toString(i);
    }

    public static long decodeLong(String s) {
        return Long.parseLong(s);
    }

    public static String encodeFloat(double d) {
        if (Double.isInfinite(d)) {
            throw new IllegalArgumentException("Infinite value not permitted");
        }
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("NaN not permitted");
        }
        return Double.toString(d);
    }

    public static double decodeFloat(String s) {
        return Double.parseDouble(s);
    }

    public static String encodeBoolean(boolean b) {
        return SampUtils.encodeInt(b ? 1 : 0);
    }

    public static boolean decodeBoolean(String s) {
        try {
            return SampUtils.decodeInt(s) != 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static void checkObject(Object obj) {
        if (obj instanceof Map) {
            SampUtils.checkMap((Map)obj);
        } else if (obj instanceof List) {
            SampUtils.checkList((List)obj);
        } else if (obj instanceof String) {
            SampUtils.checkString((String)obj);
        } else {
            if (obj == null) {
                throw new DataException("Bad SAMP object: contains a null");
            }
            throw new DataException("Bad SAMP object: contains a " + obj.getClass().getName());
        }
    }

    public static void checkMap(Map map) {
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            if (key instanceof String) {
                SampUtils.checkString((String)key);
                SampUtils.checkObject(entry.getValue());
                continue;
            }
            if (key == null) {
                throw new DataException("Map key null");
            }
            throw new DataException("Map key not a string (" + key.getClass().getName() + ")");
        }
    }

    public static void checkList(List list) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            SampUtils.checkObject(it.next());
        }
    }

    public static void checkString(String string) {
        int leng = string.length();
        for (int i = 0; i < leng; ++i) {
            char c = string.charAt(i);
            if (SampUtils.isStringChar(c)) continue;
            throw new DataException("Bad SAMP string; contains character 0x" + Integer.toHexString(c));
        }
    }

    public static boolean isStringChar(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': {
                return true;
            }
        }
        return c >= ' ' && c <= '\u007f';
    }

    public static void checkUrl(String url) {
        if (url != null) {
            try {
                new URL(url);
            }
            catch (MalformedURLException e) {
                throw new DataException("Bad URL " + url, e);
            }
        }
    }

    public static String toString(Client client) {
        String name;
        Metadata meta = client.getMetadata();
        if (meta != null && (name = meta.getName()) != null && name.trim().length() > 0) {
            return name;
        }
        return client.getId();
    }

    public static String formatObject(Object obj, int indent) {
        SampUtils.checkObject(obj);
        return new JsonWriter(indent, true).toJson(obj);
    }

    public static Object parseValue(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        try {
            Object obj = SampUtils.fromJson(str);
            SampUtils.checkObject(obj);
            return obj;
        }
        catch (RuntimeException e) {
            logger_.config("String not JSON (" + e + ")");
            String sval = str;
            SampUtils.checkObject(sval);
            return sval;
        }
    }

    public static String getLocalhost() {
        String defaultHost = "127.0.0.1";
        String hostname = System.getProperty(LOCALHOST_PROP, System.getProperty("samp.localhost", ""));
        if (hostname.length() == 0) {
            hostname = "127.0.0.1";
        } else if ("[hostname]".equals(hostname)) {
            try {
                hostname = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                logger_.log(Level.WARNING, "Local host determination failed - fall back to 127.0.0.1", e);
                hostname = "127.0.0.1";
            }
        } else if ("[hostnumber]".equals(hostname)) {
            try {
                hostname = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                logger_.log(Level.WARNING, "Local host determination failed - fall back to 127.0.0.1", e);
                hostname = "127.0.0.1";
            }
        }
        logger_.config("Local host is " + hostname);
        return hostname;
    }

    public static int getUnusedPort(int startPort) throws IOException {
        return SampUtils.findAnyPort();
    }

    public static URL fileToUrl(File file) {
        try {
            return new URL("file", "localhost", file.toURI().toURL().getPath());
        }
        catch (MalformedURLException e) {
            throw new AssertionError();
        }
    }

    public static String uriDecode(String text) {
        try {
            return URLDecoder.decode(SampUtils.replaceChar(text, '+', "%2B"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 unsupported??");
        }
    }

    public static String uriEncode(String text) {
        try {
            return SampUtils.replaceChar(URLEncoder.encode(text, "UTF-8"), '+', "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 unsupported??");
        }
    }

    public static File urlToFile(URL url) {
        if (url.getProtocol().equals("file") && url.getRef() == null && url.getQuery() == null) {
            String path = SampUtils.uriDecode(url.getPath());
            String filename = File.separatorChar == '/' ? path : path.replace('/', File.separatorChar);
            return new File(filename);
        }
        return null;
    }

    public static Object fromJson(String str) {
        return new JsonReader().read(str);
    }

    public static String toJson(Object item, boolean multiline) {
        SampUtils.checkObject(item);
        return new JsonWriter(multiline ? 2 : -1, true).toJson(item);
    }

    public static String getSampVersion() {
        if (sampVersion_ == null) {
            sampVersion_ = SampUtils.readResource("samp.version");
        }
        return sampVersion_;
    }

    public static String getSoftwareVersion() {
        if (softwareVersion_ == null) {
            softwareVersion_ = SampUtils.readResource("jsamp.version");
        }
        return softwareVersion_;
    }

    private static String readResource(String rname) {
        URL url = SampUtils.class.getResource(rname);
        if (url == null) {
            logger_.warning("No such resource " + rname);
            return "??";
        }
        try {
            int c;
            InputStream in = url.openStream();
            StringBuffer sbuf = new StringBuffer();
            while ((c = in.read()) >= 0) {
                sbuf.append((char)c);
            }
            in.close();
            return sbuf.toString().trim();
        }
        catch (IOException e) {
            logger_.warning("Failed to read resource " + url);
            return "??";
        }
    }

    private static String getLineSeparator() {
        try {
            return System.getProperty("line.separator", "\n");
        }
        catch (SecurityException e) {
            return "\n";
        }
    }

    private static String replaceChar(String in, char oldChar, String newTxt) {
        int len = in.length();
        StringBuffer sbuf = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char c = in.charAt(i);
            if (c == oldChar) {
                sbuf.append(newTxt);
                continue;
            }
            sbuf.append(c);
        }
        return sbuf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int findAnyPort() throws IOException {
        ServerSocket socket = new ServerSocket(0);
        try {
            int n = socket.getLocalPort();
            return n;
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static int scanForPort(int startPort, int nTry) throws IOException {
        for (int iPort = startPort; iPort < startPort + nTry; ++iPort) {
            try {
                Socket trySocket = new Socket("localhost", iPort);
                if (trySocket.isClosed()) continue;
                trySocket.shutdownOutput();
                trySocket.shutdownInput();
                trySocket.close();
                continue;
            }
            catch (ConnectException e) {
                return iPort;
            }
        }
        throw new IOException("Can't locate an unused port in range " + startPort + " ... " + (startPort + nTry));
    }

    static {
        NEWLINE = SampUtils.getLineSeparator();
    }
}

