/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.config.BulkValidationException;
import org.lsst.ccs.config.ConfigurationBulkChangeHandler;
import org.lsst.ccs.drivers.reb.BoardDacs;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.monitor.Control;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.rafts.config.DACS;
import org.lsst.ccs.subsystem.rafts.data.RaftException;

public class DacControl
extends Control
implements ConfigurationBulkChangeHandler {
    public static final String SCLK_LOW_P = "sclkLowP";
    public static final String SCLK_HIGH_P = "sclkHighP";
    public static final String PCLK_LOW_P = "pclkLowP";
    public static final String PCLK_HIGH_P = "pclkHighP";
    public static final String RG_LOW_P = "rgLowP";
    public static final String RG_HIGH_P = "rgHighP";
    public static final String SCLK_LOW = "sclkLow";
    public static final String SCLK_LOW_SH = "sclkLowSh";
    public static final String SCLK_HIGH = "sclkHigh";
    public static final String SCLK_HIGH_SH = "sclkHighSh";
    public static final String PCLK_LOW = "pclkLow";
    public static final String PCLK_LOW_SH = "pclkLowSh";
    public static final String PCLK_HIGH = "pclkHigh";
    public static final String PCLK_HIGH_SH = "pclkHighSh";
    public static final String RG_LOW = "rgLow";
    public static final String RG_LOW_SH = "rgLowSh";
    public static final String RG_HIGH = "rgHigh";
    public static final String RG_HIGH_SH = "rgHighSh";
    public static final String CS_GATE = "csGate";
    private static final int SCLK_LOW_CH = 1;
    private static final int SCLK_LOW_SH_CH = 2;
    private static final int SCLK_HIGH_CH = 4;
    private static final int SCLK_HIGH_SH_CH = 8;
    private static final int PCLK_LOW_CH = 16;
    private static final int PCLK_LOW_SH_CH = 32;
    private static final int PCLK_HIGH_CH = 64;
    private static final int PCLK_HIGH_SH_CH = 128;
    private static final int RG_LOW_CH = 256;
    private static final int RG_LOW_SH_CH = 512;
    private static final int RG_HIGH_CH = 1024;
    private static final int RG_HIGH_SH_CH = 2048;
    private static final int CS_GATE_CH = 4096;
    private static final String[] checkList = new String[]{"sclkLow", "sclkHigh", "pclkLow", "pclkHigh", "rgLow", "rgHigh"};
    private static final double DAC_TOLERANCE = 0.4;
    private static final int DEFAULT_LOAD_WAIT = 160;
    private static final int DEFAULT_CLEAR_WAIT = 50;
    private static final int SLOW_ADCS_DELTA = 6;
    private static final int SLOW_ADCS_SAMPLE_DELAY = 34;
    private static final double TEST_VOLTS = 0.5;
    private static final double ZERO_ERROR = 0.2;
    private static final double VALUE_ERROR = 0.2;
    private static final double CHANGE_ERROR = 0.1;
    private static final double CLK_SHORTS_LIMIT = 0.002;
    private static final Map<Integer, Integer> seqLineMap = new HashMap<Integer, Integer>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService sce;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    private REBDevice rebDevc;
    @LookupPath
    String dacPath;
    @ConfigurationParameter(category="Rafts", range="-6.5..-3.0", description="Serial clock low", units="volts")
    private volatile double sclkLowP;
    @ConfigurationParameter(category="Rafts", range="3.0..7.0", description="Serial clock high", units="volts")
    private volatile double sclkHighP;
    @ConfigurationParameter(category="Rafts", range="-9.0..-4.0", description="Parallel clock low", units="volts")
    private volatile double pclkLowP;
    @ConfigurationParameter(category="Rafts", range="1.0..6.0", description="Parallel clock high", units="volts")
    private volatile double pclkHighP;
    @ConfigurationParameter(category="Rafts", range="-5.0..0.0", description="Reset gate low", units="volts")
    private volatile double rgLowP;
    @ConfigurationParameter(category="Rafts", range="5.0..10.0", description="Reset gate high", units="volts")
    private volatile double rgHighP;
    @ConfigurationParameter(category="RaftsLimits", description="Serial clock low min", units="volts")
    private volatile double sclkLowMin;
    @ConfigurationParameter(category="RaftsLimits", description="Serial clock low max", units="volts")
    private volatile double sclkLowMax;
    @ConfigurationParameter(category="RaftsLimits", description="Serial clock high min", units="volts")
    private volatile double sclkHighMin;
    @ConfigurationParameter(category="RaftsLimits", description="Serial clock high max", units="volts")
    private volatile double sclkHighMax;
    @ConfigurationParameter(category="RaftsLimits", description="Parallel clock low min", units="volts")
    private volatile double pclkLowMin;
    @ConfigurationParameter(category="RaftsLimits", description="Parallel clock low max", units="volts")
    private volatile double pclkLowMax;
    @ConfigurationParameter(category="RaftsLimits", description="Parallel clock high min", units="volts")
    private volatile double pclkHighMin;
    @ConfigurationParameter(category="RaftsLimits", description="Parallel clock high max", units="volts")
    private volatile double pclkHighMax;
    @ConfigurationParameter(category="RaftsLimits", description="Reset gate low min", units="volts")
    private volatile double rgLowMin;
    @ConfigurationParameter(category="RaftsLimits", description="Reset gate low max", units="volts")
    private volatile double rgLowMax;
    @ConfigurationParameter(category="RaftsLimits", description="Reset gate high min", units="volts")
    private volatile double rgHighMin;
    @ConfigurationParameter(category="RaftsLimits", description="Reset gate high max", units="volts")
    private volatile double rgHighMax;
    @ConfigurationParameter(category="Rafts", description="Serial clock low", units="DAC counts")
    private volatile int sclkLow;
    @ConfigurationParameter(category="Rafts", description="Serial clock low shifted", units="DAC counts")
    private volatile int sclkLowSh;
    @ConfigurationParameter(category="Rafts", description="Serial clock high", units="DAC counts")
    private volatile int sclkHigh;
    @ConfigurationParameter(category="Rafts", description="Serial clock high shifted", units="DAC counts")
    private volatile int sclkHighSh;
    @ConfigurationParameter(category="Rafts", description="Parallel clock low", units="DAC counts")
    private volatile int pclkLow;
    @ConfigurationParameter(category="Rafts", description="Parallel clock low shifted", units="DAC counts")
    private volatile int pclkLowSh;
    @ConfigurationParameter(category="Rafts", description="Parallel clock high", units="DAC counts")
    private volatile int pclkHigh;
    @ConfigurationParameter(category="Rafts", description="Parallel clock high shifted", units="DAC counts")
    private volatile int pclkHighSh;
    @ConfigurationParameter(category="Rafts", description="Reset gate low", units="DAC counts")
    private volatile int rgLow;
    @ConfigurationParameter(category="Rafts", description="Reset gate low shifted", units="DAC counts")
    private volatile int rgLowSh;
    @ConfigurationParameter(category="Rafts", description="Reset gate high", units="DAC counts")
    private volatile int rgHigh;
    @ConfigurationParameter(category="Rafts", description="Reset gate high shifted", units="DAC counts")
    private volatile int rgHighSh;
    @ConfigurationParameter(category="Rafts", description="Current source", units="DAC counts", maxLength=3)
    private final int[] csGate = new int[3];
    @ConfigurationParameter(category="RaftsPower", range="0.4..1.0", description="Shorts Test Voltage for SClkL", units="Volts")
    private volatile double sclkLowTestV;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for 0V w/SClkL test", units="Volts")
    private volatile double sclkLowZeroErr;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for SClkL TestV", units="Volts")
    private volatile double sclkLowValueErr;
    @ConfigurationParameter(category="RaftsPower", range="0.4..1.0", description="Shorts Test Voltage for SClkU", units="Volts")
    private volatile double sclkHighTestV;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for 0V w/SClkU test", units="Volts")
    private volatile double sclkHighZeroErr;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for SClkU TestV", units="Volts")
    private volatile double sclkHighValueErr;
    @ConfigurationParameter(category="RaftsPower", range="0.4..1.0", description="Shorts Test Voltage for PClkL", units="Volts")
    private volatile double pclkLowTestV;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for 0V w/PClkL test", units="Volts")
    private volatile double pclkLowZeroErr;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for PClkL TestV", units="Volts")
    private volatile double pclkLowValueErr;
    @ConfigurationParameter(category="RaftsPower", range="0.4..1.0", description="Shorts Test Voltage for PClkU", units="Volts")
    private volatile double pclkHighTestV;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for 0V w/PClkU test", units="Volts")
    private volatile double pclkHighZeroErr;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for PClkU TestV", units="Volts")
    private volatile double pclkHighValueErr;
    @ConfigurationParameter(category="RaftsPower", range="0.4..1.0", description="Shorts Test Voltage for RGL", units="Volts")
    private volatile double rgLowTestV;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for 0V w/RGL test", units="Volts")
    private volatile double rgLowZeroErr;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for RGL TestV", units="Volts")
    private volatile double rgLowValueErr;
    @ConfigurationParameter(category="RaftsPower", range="0.4..1.0", description="Shorts Test Voltage for RGU", units="Volts")
    private volatile double rgHighTestV;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for 0V w/RGU test", units="Volts")
    private volatile double rgHighZeroErr;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for RGU TestV", units="Volts")
    private volatile double rgHighValueErr;
    @ConfigurationParameter(category="RaftsPower", range="0.00..0.70", description="Serial low tolerance", units="volts")
    private volatile double sclkLowTol;
    @ConfigurationParameter(category="RaftsPower", range="0.90..1.10", description="Serial low calib", units="none")
    private volatile double sclkLowCal;
    @ConfigurationParameter(category="RaftsPower", range="0.00..0.70", description="Serial high tolerance", units="volts")
    private volatile double sclkHighTol;
    @ConfigurationParameter(category="RaftsPower", range="0.90..1.15", description="Serial high calib", units="none")
    private volatile double sclkHighCal;
    @ConfigurationParameter(category="RaftsPower", range="0.00..0.70", description="Parallel low tolerance", units="volts")
    private volatile double pclkLowTol;
    @ConfigurationParameter(category="RaftsPower", range="0.90..1.10", description="Parallel low calib", units="none")
    private volatile double pclkLowCal;
    @ConfigurationParameter(category="RaftsPower", range="0.00..0.70", description="Parallel high tolerance", units="volts")
    private volatile double pclkHighTol;
    @ConfigurationParameter(category="RaftsPower", range="0.90..1.10", description="Parallel high calib", units="none")
    private volatile double pclkHighCal;
    @ConfigurationParameter(category="RaftsPower", range="0.00..0.70", description="Reset low tolerance", units="volts")
    private volatile double rgLowTol;
    @ConfigurationParameter(category="RaftsPower", range="0.90..1.10", description="Reset low calib", units="none")
    private volatile double rgLowCal;
    @ConfigurationParameter(category="RaftsPower", range="0.00..0.70", description="Reset high tolerance", units="volts")
    private volatile double rgHighTol;
    @ConfigurationParameter(category="RaftsPower", range="0.90..1.10", description="Reset high calib", units="none")
    private volatile double rgHighCal;
    @ConfigurationParameter(category="RaftsPower", range="0.100..0.120", description="Max ClkHI value", units="Amps")
    private volatile double clkhIMax;
    @ConfigurationParameter(category="RaftsPower", range="0.050..0.065", description="Max ClkLI value", units="Amps")
    private volatile double clklIMax;
    private boolean raw = false;
    private static final Logger LOG;
    private boolean cfgValid;
    private boolean isCurrent;
    private boolean isCorner;
    private int hwVersion;
    private BoardDacs dac;
    private int changed = 0;
    private final Map<String, Double> lowLimitMap = new HashMap<String, Double>();
    private final Map<String, Double> highLimitMap = new HashMap<String, Double>();
    private double railShiftConvH;
    private double railConvH;
    private double railShiftConvL;
    private double railConvL;
    private int adcType;

    public DacControl() {
        for (String pName : checkList) {
            this.lowLimitMap.put(pName, 0.0);
            this.highLimitMap.put(pName, 0.0);
        }
    }

    protected void configure(Monitor mon, Device devc) {
        super.configure(mon, devc);
        this.dac = this.rebDevc.getBoardDacs();
    }

    public boolean checkConfig() {
        this.hwVersion = DacControl.getHwVersion(this.dac);
        this.isCurrent = this.hwVersion >= 1;
        boolean bl = this.isCorner = this.hwVersion == 1 || this.hwVersion == 3;
        if (!this.raw) {
            double shiftGainH = this.hwVersion == 1 ? 2.0 : 2.4899999999999998;
            double shiftGainL = this.hwVersion == 2 ? 2.4677898909811695 : shiftGainH;
            double fudge = this.hwVersion == 1 ? 1.0 : 1.04;
            this.railShiftConvH = fudge * 819.0 / shiftGainH;
            this.railConvH = fudge * 819.0 / (1.0 + shiftGainH);
            this.railShiftConvL = fudge * 819.0 / shiftGainL;
            this.railConvL = fudge * 819.0 / (1.0 + shiftGainL);
        } else {
            this.cfgValid = true;
        }
        this.adcType = this.isCorner ? 6 : 4;
        this.changed = 0;
        return true;
    }

    public boolean isRaw() {
        return this.raw;
    }

    public static int getHwVersion(BoardDacs dac) {
        int version = dac.getVersion();
        version = version == 0 || version == 1 ? 0 : (version == 2 || version == 4 || version == 5 ? 1 : (version == 3 || version == 6 ? 2 : (version == 7 || version == 8 ? 3 : -1)));
        return version;
    }

    @Deprecated
    public int getHwVersion() {
        return this.hwVersion;
    }

    public void validateBulkChange(Map<String, Object> params) throws IllegalArgumentException {
        String errMsg = null;
        if (!this.raw) {
            for (String pName : checkList) {
                double max;
                double value = (Double)params.get(pName + "P");
                if (value > (max = ((Double)params.get(pName + "Max")).doubleValue())) {
                    errMsg = String.format("%s: %sP (%5.5g) is above high limit (%5.5g)", this.getName(), pName, value, max);
                    break;
                }
                double min = (Double)params.get(pName + "Min");
                if (!(value < min)) continue;
                errMsg = String.format("%s: %sP (%5.5g) is below low limit (%5.5g)", this.getName(), pName, value, min);
                break;
            }
        }
        if (errMsg != null) {
            LOG.log(Level.SEVERE, "Configuration failure: {0}", errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        this.cfgValid = true;
    }

    public void setParameterBulk(Map<String, Object> params) throws IllegalArgumentException {
        StringBuilder changedString = new StringBuilder();
        Pattern changedPattern = Pattern.compile("(pclk|sclk|rg)(Low|High)(P|Cal|Tol)");
        if (!this.raw) {
            int matchCount = 0;
            for (String param : params.keySet()) {
                Matcher m = changedPattern.matcher(param);
                if (!m.matches()) continue;
                if (param.startsWith(SCLK_LOW)) {
                    this.changed |= 1;
                } else if (param.startsWith(SCLK_HIGH)) {
                    this.changed |= 4;
                } else if (param.startsWith(PCLK_LOW)) {
                    this.changed |= 0x10;
                } else if (param.startsWith(PCLK_HIGH)) {
                    this.changed |= 0x40;
                } else if (param.startsWith(RG_LOW)) {
                    this.changed |= 0x100;
                } else if (param.startsWith(RG_HIGH)) {
                    this.changed |= 0x400;
                } else {
                    LOG.log(Level.WARNING, "Programmer error: Unexpected parameter change match: " + param);
                }
                changedString.append(" " + param);
                ++matchCount;
            }
            if (matchCount > 0) {
                this.rebDevc.setUpdateCCDsPowerState();
            }
            LOG.log(Level.INFO, this.dacPath + ": " + matchCount + " parameters changed:" + changedString);
            LOG.log(Level.FINE, String.format("%s: changed = 0x%x", this.dacPath, this.changed));
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get the changed variable value")
    public String getChanged() {
        return String.format("0x%x", this.changed);
    }

    @ConfigurationParameterChanger
    public void setPclkLowP(double value) {
        this.pclkLowP = value;
        this.changed |= 0x10;
    }

    public double getPclkLowP() {
        return this.pclkLowP;
    }

    @ConfigurationParameterChanger
    public void setPclkLowMax(double value) {
        this.pclkLowMax = value;
        this.highLimitMap.put(PCLK_LOW, value);
    }

    @ConfigurationParameterChanger
    public void setPclkLowMin(double value) {
        this.pclkLowMin = value;
        this.lowLimitMap.put(PCLK_LOW, value);
    }

    @ConfigurationParameterChanger
    public void setPclkLow(int value) {
        this.pclkLow = value;
        this.changed |= 0x10;
    }

    public int getPclkLow() {
        return this.pclkLow;
    }

    @ConfigurationParameterChanger
    public void setPclkLowSh(int value) {
        this.pclkLowSh = value;
        this.changed |= 0x20;
    }

    public int getPclkLowSh() {
        return this.pclkLowSh;
    }

    @ConfigurationParameterChanger
    public void setPclkHighP(double value) {
        this.pclkHighP = value;
        this.changed |= 0x40;
    }

    public double getPclkHighP() {
        return this.pclkHighP;
    }

    @ConfigurationParameterChanger
    public void setPclkHighMax(double value) {
        this.pclkHighMax = value;
        this.highLimitMap.put(PCLK_HIGH, value);
    }

    @ConfigurationParameterChanger
    public void setPclkHighMin(double value) {
        this.pclkHighMin = value;
        this.lowLimitMap.put(PCLK_HIGH, value);
    }

    @ConfigurationParameterChanger
    public void setPclkHigh(int value) {
        this.pclkHigh = value;
        this.changed |= 0x40;
    }

    public int getPclkHigh() {
        return this.pclkHigh;
    }

    @ConfigurationParameterChanger
    public void setPclkHighSh(int value) {
        this.pclkHighSh = value;
        this.changed |= 0x80;
    }

    public int getPclkHighSh() {
        return this.pclkHighSh;
    }

    @ConfigurationParameterChanger
    public void setSclkLowP(double value) {
        this.sclkLowP = value;
        this.changed |= 1;
    }

    public double getSclkLowP() {
        return this.sclkLowP;
    }

    @ConfigurationParameterChanger
    public void setSclkLowMax(double value) {
        this.sclkLowMax = value;
        this.highLimitMap.put(SCLK_LOW, value);
    }

    @ConfigurationParameterChanger
    public void setSclkLowMin(double value) {
        this.sclkLowMin = value;
        this.lowLimitMap.put(SCLK_LOW, value);
    }

    @ConfigurationParameterChanger
    public void setSclkLow(int value) {
        this.sclkLow = value;
        this.changed |= 1;
    }

    public int getSclkLow() {
        return this.sclkLow;
    }

    @ConfigurationParameterChanger
    public void setSclkLowSh(int value) {
        this.sclkLowSh = value;
        this.changed |= 2;
    }

    public int getSclkLowSh() {
        return this.sclkLowSh;
    }

    @ConfigurationParameterChanger
    public void setSclkHighP(double value) {
        this.sclkHighP = value;
        this.changed |= 4;
    }

    public double getSclkHighP() {
        return this.sclkHighP;
    }

    @ConfigurationParameterChanger
    public void setSclkHighMax(double value) {
        this.sclkHighMax = value;
        this.highLimitMap.put(SCLK_HIGH, value);
    }

    @ConfigurationParameterChanger
    public void setSclkHighMin(double value) {
        this.sclkHighMin = value;
        this.lowLimitMap.put(SCLK_HIGH, value);
    }

    @ConfigurationParameterChanger
    public void setSclkHigh(int value) {
        this.sclkHigh = value;
        this.changed |= 4;
    }

    public int getSclkHigh() {
        return this.sclkHigh;
    }

    @ConfigurationParameterChanger
    public void setSclkHighSh(int value) {
        this.sclkHighSh = value;
        this.changed |= 8;
    }

    public int getSclkHighSh() {
        return this.sclkHighSh;
    }

    @ConfigurationParameterChanger
    public void setRgLowP(double value) {
        this.rgLowP = value;
        this.changed |= 0x100;
    }

    public double getRgLowP() {
        return this.rgLowP;
    }

    @ConfigurationParameterChanger
    public void setRgLowMax(double value) {
        this.rgLowMax = value;
        this.highLimitMap.put(RG_LOW, value);
    }

    @ConfigurationParameterChanger
    public void setRgLowMin(double value) {
        this.rgLowMin = value;
        this.lowLimitMap.put(RG_LOW, value);
    }

    @ConfigurationParameterChanger
    public void setRgLow(int value) {
        this.rgLow = value;
        this.changed |= 0x100;
    }

    public int getRgLow() {
        return this.rgLow;
    }

    @ConfigurationParameterChanger
    public void setRgLowSh(int value) {
        this.rgLowSh = value;
        this.changed |= 0x200;
    }

    public int getRgLowSh() {
        return this.rgLowSh;
    }

    @ConfigurationParameterChanger
    public void setRgHighP(double value) {
        this.rgHighP = value;
        this.changed |= 0x400;
    }

    public double getRgHighP() {
        return this.rgHighP;
    }

    @ConfigurationParameterChanger
    public void setRgHighMax(double value) {
        this.rgHighMax = value;
        this.highLimitMap.put(RG_HIGH, value);
    }

    @ConfigurationParameterChanger
    public void setRgHighMin(double value) {
        this.rgHighMin = value;
        this.lowLimitMap.put(RG_HIGH, value);
    }

    @ConfigurationParameterChanger
    public void setRgHigh(int value) {
        this.rgHigh = value;
        this.changed |= 0x400;
    }

    public int getRgHigh() {
        return this.rgHigh;
    }

    @ConfigurationParameterChanger
    public void setRgHighSh(int value) {
        this.rgHighSh = value;
        this.changed |= 0x800;
    }

    public int getRgHighSh() {
        return this.rgHighSh;
    }

    @ConfigurationParameterChanger
    public void setCsGate(int[] value) {
        System.arraycopy(value, 0, this.csGate, 0, this.csGate.length);
        this.changed |= 0x1000;
    }

    public int[] getCsGate() {
        return this.csGate;
    }

    void setConfig(DACS dacs) throws RaftException {
        String name = this.getName();
        if (!this.raw) {
            double[] values = dacs.getPValues();
            this.sce.submitChange(name, RG_HIGH_P, (Object)values[5]);
            this.sce.submitChange(name, RG_LOW_P, (Object)values[4]);
            this.sce.submitChange(name, PCLK_HIGH_P, (Object)values[3]);
            this.sce.submitChange(name, PCLK_LOW_P, (Object)values[2]);
            this.sce.submitChange(name, SCLK_HIGH_P, (Object)values[1]);
            this.sce.submitChange(name, SCLK_LOW_P, (Object)values[0]);
        } else {
            int[] values = dacs.getValues();
            this.sce.submitChange(name, RG_HIGH, (Object)values[5]);
            this.sce.submitChange(name, RG_LOW, (Object)values[4]);
            this.sce.submitChange(name, PCLK_HIGH, (Object)values[3]);
            this.sce.submitChange(name, PCLK_LOW, (Object)values[2]);
            this.sce.submitChange(name, SCLK_HIGH, (Object)values[1]);
            this.sce.submitChange(name, SCLK_LOW, (Object)values[0]);
            if (this.isCurrent) {
                this.sce.submitChange(name, RG_LOW_SH, (Object)values[10]);
                this.sce.submitChange(name, PCLK_LOW_SH, (Object)values[8]);
                this.sce.submitChange(name, SCLK_LOW_SH, (Object)values[6]);
                if (this.isCorner) {
                    this.sce.submitChange(name, RG_HIGH_SH, (Object)values[11]);
                    this.sce.submitChange(name, PCLK_HIGH_SH, (Object)values[9]);
                    this.sce.submitChange(name, SCLK_HIGH_SH, (Object)values[7]);
                }
            } else {
                this.sce.submitChange(name, CS_GATE, (Object)new int[]{values[12], values[13], values[14]});
            }
        }
        try {
            this.sce.commitBulkChange();
        }
        catch (BulkValidationException e) {
            this.sce.dropSubmittedChangesForComponent(name);
            throw new RaftException("Bulk configuration validation failed");
        }
    }

    void getConfig(DACS dacs) {
        if (!this.raw) {
            double[] values = dacs.getPValues();
            values[5] = this.rgHighP;
            values[4] = this.rgLowP;
            values[3] = this.pclkHighP;
            values[2] = this.pclkLowP;
            values[1] = this.sclkHighP;
            values[0] = this.sclkLowP;
        } else {
            int[] values = dacs.getValues();
            values[5] = this.rgHigh;
            values[4] = this.rgLow;
            values[3] = this.pclkHigh;
            values[2] = this.pclkLow;
            values[1] = this.sclkHigh;
            values[0] = this.sclkLow;
            if (this.isCurrent) {
                values[10] = this.rgLowSh;
                values[8] = this.pclkLowSh;
                values[6] = this.sclkLowSh;
                if (this.isCorner) {
                    values[11] = this.rgHighSh;
                    values[9] = this.pclkHighSh;
                    values[7] = this.sclkHighSh;
                }
            } else {
                values[12] = this.csGate[0];
                values[13] = this.csGate[1];
                values[14] = this.csGate[2];
            }
        }
    }

    public int loadConfig(boolean check, List<REBDevice.AdcData> dataList) throws RaftException {
        return this.loadConfig(160, check, false, dataList);
    }

    public int loadConfig(int wait, boolean check, boolean powerOn, List<REBDevice.AdcData> dataList) throws RaftException {
        if (!this.cfgValid) {
            throw new RaftException("DAC load error: invalid configuration");
        }
        if (!this.rebDevc.isSerialNumValid()) {
            throw new RaftException("DAC load error: invalid REB serial number");
        }
        int count = 0;
        this.rebDevc.readAllAdcs(dataList);
        count += this.loadSclkLow(wait, check, powerOn, dataList);
        count += this.loadSclkHigh(wait, check, powerOn, dataList);
        count += this.loadPclkLow(wait, check, powerOn, dataList);
        count += this.loadPclkHigh(wait, check, powerOn, dataList);
        count += this.loadRgLow(wait, check, powerOn, dataList);
        count += this.loadRgHigh(wait, check, powerOn, dataList);
        if (!this.isCurrent) {
            this.setDac(17, this.csGate[0]);
            this.setDac(19, this.csGate[1]);
            this.setDac(20, this.csGate[2]);
            this.loadDac(0);
            count += 3;
        }
        this.rebDevc.readAllAdcs(dataList);
        this.changed = 0;
        return count;
    }

    public int loadChanged(boolean check, List<REBDevice.AdcData> dataList) throws RaftException {
        return this.loadChanged(160, check, dataList);
    }

    public int loadChanged(int wait, boolean check, List<REBDevice.AdcData> dataList) throws RaftException {
        if (!this.cfgValid) {
            throw new RaftException("DAC load error: invalid configuration");
        }
        if (!this.rebDevc.isSerialNumValid()) {
            throw new RaftException("DAC load error: invalid REB serial number");
        }
        int count = 0;
        this.rebDevc.readAllAdcs(dataList);
        if ((this.changed & 1) != 0) {
            count += this.loadSclkLow(wait, check, false, dataList);
        }
        if ((this.changed & 4) != 0) {
            count += this.loadSclkHigh(wait, check, false, dataList);
        }
        if ((this.changed & 0x10) != 0) {
            count += this.loadPclkLow(wait, check, false, dataList);
        }
        if ((this.changed & 0x40) != 0) {
            count += this.loadPclkHigh(wait, check, false, dataList);
        }
        if ((this.changed & 0x100) != 0) {
            count += this.loadRgLow(wait, check, false, dataList);
        }
        if ((this.changed & 0x400) != 0) {
            count += this.loadRgHigh(wait, check, false, dataList);
        }
        if (!this.isCurrent && (this.changed & 0x1000) != 0) {
            this.setDac(17, this.csGate[0]);
            this.setDac(19, this.csGate[1]);
            this.setDac(20, this.csGate[2]);
            this.loadDac(0);
            count += 3;
            this.rebDevc.readAllAdcs(dataList);
        }
        this.changed = 0;
        return count;
    }

    public void clear(int wait, List<REBDevice.AdcData> dataList) throws RaftException {
        this.clearRgLow(0);
        this.clearRgHigh(wait, dataList);
        this.clearPclkLow(0);
        this.clearPclkHigh(wait, dataList);
        this.clearSclkLow(0);
        this.clearSclkHigh(wait, dataList);
        if (!this.isCurrent) {
            this.setDac(17, 0);
            this.setDac(19, 0);
            this.setDac(20, 0);
            this.loadDac(0);
        }
        this.changed = -1;
    }

    public int getClockDacsPowerState(double[] slowAdcs, List<String> tmsgList, double uSeqOffset) {
        int expectedCnt = 6;
        int offCnt = 0;
        int onCnt = 0;
        int lowCnt = 0;
        int dltaCnt = 0;
        int changes = 0;
        double maxDelta = this.rebDevc.getMaxDelta();
        lowCnt = 0;
        double value = slowAdcs[2];
        double delta = this.sclkLowP - value;
        if (Math.abs(value) < this.sclkLowZeroErr) {
            ++offCnt;
            ++lowCnt;
            tmsgList.add(String.format("%s %s value %.2f is in OFF range", this.dacPath, REBDevice.getAdcName(2), value));
        }
        if (Math.abs(delta) < this.sclkLowTol) {
            ++onCnt;
            ++lowCnt;
            changes |= this.changed & 1;
            tmsgList.add(String.format("%s %s value %.2f is in ON range", this.dacPath, REBDevice.getAdcName(2), value));
        } else if (Math.abs(delta) < maxDelta) {
            ++onCnt;
            ++lowCnt;
            ++dltaCnt;
            changes |= 1;
            tmsgList.add(String.format("%s %s value %.2f is in DELTA range", this.dacPath, REBDevice.getAdcName(2), value));
        }
        if (lowCnt == 0) {
            tmsgList.add(String.format("%s %s value %.2f is NOT in OFF or ON allowed range", this.dacPath, REBDevice.getAdcName(2), value));
        }
        if (lowCnt == 2) {
            tmsgList.add(String.format("%s %s value %.2f is in both OFF and ON allowed range", this.dacPath, REBDevice.getAdcName(2), value));
        }
        value = slowAdcs[3];
        delta = this.sclkHighP - value;
        if (Math.abs(value) < this.sclkHighZeroErr + uSeqOffset) {
            ++offCnt;
            tmsgList.add(String.format("%s %s value %.2f is in OFF range", this.dacPath, REBDevice.getAdcName(3), value));
        } else if (Math.abs(delta) < this.sclkHighTol) {
            ++onCnt;
            changes |= this.changed & 4;
            tmsgList.add(String.format("%s %s value %.2f is in ON range", this.dacPath, REBDevice.getAdcName(3), value));
        } else if (Math.abs(delta) < maxDelta) {
            ++onCnt;
            ++dltaCnt;
            changes |= 4;
            tmsgList.add(String.format("%s %s value %.2f is in DELTA range", this.dacPath, REBDevice.getAdcName(3), value));
        } else {
            tmsgList.add(String.format("%s %s value %.2f is NOT in OFF or ON allowed range", this.dacPath, REBDevice.getAdcName(3), value));
        }
        lowCnt = 0;
        value = slowAdcs[0];
        delta = this.pclkLowP - value;
        if (Math.abs(value) < this.pclkLowZeroErr) {
            ++offCnt;
            ++lowCnt;
            tmsgList.add(String.format("%s %s value %.2f is in OFF range", this.dacPath, REBDevice.getAdcName(0), value));
        }
        if (Math.abs(delta) < this.pclkLowTol) {
            ++onCnt;
            ++lowCnt;
            changes |= this.changed & 0x10;
            tmsgList.add(String.format("%s %s value %.2f is in ON range", this.dacPath, REBDevice.getAdcName(0), value));
        } else if (Math.abs(delta) < maxDelta) {
            ++onCnt;
            ++dltaCnt;
            ++lowCnt;
            changes |= 0x10;
            tmsgList.add(String.format("%s %s value %.2f is in DELTA range", this.dacPath, REBDevice.getAdcName(0), value));
        }
        if (lowCnt == 0) {
            tmsgList.add(String.format("%s %s value %.2f is NOT in OFF or ON allowed range", this.dacPath, REBDevice.getAdcName(0), value));
        }
        if (lowCnt == 2) {
            tmsgList.add(String.format("%s %s value %.2f is in both OFF and ON allowed range", this.dacPath, REBDevice.getAdcName(0), value));
        }
        lowCnt = 0;
        value = slowAdcs[1];
        delta = this.pclkHighP - value;
        if (Math.abs(value) < this.pclkHighZeroErr + uSeqOffset) {
            ++offCnt;
            ++lowCnt;
            tmsgList.add(String.format("%s %s value %.2f is in OFF range", this.dacPath, REBDevice.getAdcName(1), value));
        }
        if (Math.abs(delta) < this.pclkHighTol) {
            ++onCnt;
            ++lowCnt;
            changes |= this.changed & 0x40;
            tmsgList.add(String.format("%s %s value %.2f is in ON range", this.dacPath, REBDevice.getAdcName(1), value));
        } else if (Math.abs(delta) < maxDelta) {
            ++onCnt;
            ++dltaCnt;
            ++lowCnt;
            changes |= 0x40;
            tmsgList.add(String.format("%s %s value %.2f is in DELTA range", this.dacPath, REBDevice.getAdcName(1), value));
        }
        if (lowCnt == 0) {
            tmsgList.add(String.format("%s %s value %.2f is NOT in OFF or ON allowed range", this.dacPath, REBDevice.getAdcName(1), value));
        }
        if (lowCnt == 2) {
            tmsgList.add(String.format("%s %s value %.2f is in both OFF and ON allowed range", this.dacPath, REBDevice.getAdcName(1), value));
        }
        lowCnt = 0;
        value = slowAdcs[4];
        delta = this.rgLowP - value;
        if (Math.abs(value) < this.rgLowZeroErr) {
            ++offCnt;
            ++lowCnt;
            tmsgList.add(String.format("%s %s value %.2f is in OFF range", this.dacPath, REBDevice.getAdcName(4), value));
        }
        if (Math.abs(delta) < this.rgLowTol) {
            ++onCnt;
            ++lowCnt;
            changes |= this.changed & 0x100;
            tmsgList.add(String.format("%s %s value %.2f is in ON range", this.dacPath, REBDevice.getAdcName(4), value));
        } else if (Math.abs(delta) < maxDelta) {
            ++onCnt;
            ++lowCnt;
            ++dltaCnt;
            changes |= 0x100;
            tmsgList.add(String.format("%s %s value %.2f is in DELTA range", this.dacPath, REBDevice.getAdcName(4), value));
        }
        if (lowCnt == 0) {
            tmsgList.add(String.format("%s %s value %.2f is NOT in OFF or ON allowed range", this.dacPath, REBDevice.getAdcName(4), value));
        }
        if (lowCnt == 2) {
            tmsgList.add(String.format("%s %s value %.2f is in both OFF and ON allowed range", this.dacPath, REBDevice.getAdcName(4), value));
        }
        value = slowAdcs[5];
        delta = this.rgHighP - value;
        if (Math.abs(value) < this.rgHighZeroErr + uSeqOffset) {
            ++offCnt;
            tmsgList.add(String.format("%s %s value %.2f is in OFF range", this.dacPath, REBDevice.getAdcName(5), value));
        } else if (Math.abs(delta) < this.rgHighTol) {
            ++onCnt;
            changes |= this.changed & 0x400;
            tmsgList.add(String.format("%s %s value %.2f is in ON range", this.dacPath, REBDevice.getAdcName(5), value));
        } else if (Math.abs(delta) < maxDelta) {
            ++onCnt;
            ++dltaCnt;
            changes |= 0x400;
            tmsgList.add(String.format("%s %s value %.2f is in DELTA range", this.dacPath, REBDevice.getAdcName(5), value));
        } else {
            tmsgList.add(String.format("%s %s value %.2f is NOT in OFF or ON allowed range", this.dacPath, REBDevice.getAdcName(5), value));
        }
        tmsgList.add(String.format("%s: getClockDacsPowerState() found %d ON, %d OFF of %d", this.dacPath, onCnt, offCnt, expectedCnt));
        if (offCnt == expectedCnt) {
            this.changed = -1;
            return 0;
        }
        if (onCnt == expectedCnt && dltaCnt == 0) {
            this.changed = changes;
            return 1;
        }
        if (onCnt == expectedCnt && dltaCnt > 0) {
            this.changed = changes;
            return 1 + dltaCnt;
        }
        return -1;
    }

    public int setClockDacsCalibration(double[] slowAdcs, List<String> tmsgList, boolean action) {
        double conv;
        int retval = 0;
        double maxDelta = this.rebDevc.getMaxDelta();
        double minTol = this.rebDevc.getMinTol();
        String formatStr0 = "%-8.8s %-8.8s %6.2f %6.2f  %6.3f --> %-6.3f  %8.3f --> %-8.3f  %5d --> %5d  %6.2f --> %-6.2f";
        String formatStr1 = "%-8.8s %-8.8s %6.2f %6.2f  %6.3f --> ERROR Delta larger than %5.3f max";
        double sclkLowCalNew = this.sclkLowCal;
        double sclkLowTolNew = this.sclkLowTol;
        double value = slowAdcs[2];
        double delta = this.sclkLowP - value;
        double d = conv = this.sclkLowP >= 0.0 ? this.railConvL : this.railShiftConvL;
        if (Math.signum(this.sclkLowP) == Math.signum(value) && Math.abs(delta) < maxDelta) {
            sclkLowCalNew = this.sclkLowCal * this.sclkLowP / value;
            sclkLowTolNew = Math.abs(delta) / 4.0 > minTol ? Math.abs(delta) / 4.0 : minTol;
            tmsgList.add(String.format(formatStr0, this.dacPath, REBDevice.getAdcName(2), this.sclkLowP, slowAdcs[2], this.sclkLowCal, sclkLowCalNew, this.sclkLowTol, sclkLowTolNew, (int)(conv * this.sclkLowCal * this.sclkLowP), (int)(conv * sclkLowCalNew * this.sclkLowP), conv * this.sclkLowCal, conv * sclkLowCalNew));
        } else {
            ++retval;
            tmsgList.add(String.format(formatStr1, this.dacPath, REBDevice.getAdcName(2), this.sclkLowP, slowAdcs[2], this.sclkLowCal, maxDelta));
        }
        double sclkHighCalNew = this.sclkHighCal;
        double sclkHighTolNew = this.sclkHighTol;
        value = slowAdcs[3];
        delta = this.sclkHighP - value;
        double d2 = conv = this.sclkHighP >= 0.0 ? this.railConvH : this.railShiftConvH;
        if (Math.signum(this.sclkHighP) == Math.signum(value) && Math.abs(delta) < maxDelta) {
            sclkHighCalNew = this.sclkHighCal * Math.abs(this.sclkHighP / slowAdcs[3]);
            sclkHighTolNew = Math.abs(delta) / 4.0 > minTol ? Math.abs(delta) / 4.0 : minTol;
            tmsgList.add(String.format(formatStr0, this.dacPath, REBDevice.getAdcName(3), this.sclkHighP, slowAdcs[3], this.sclkHighCal, sclkHighCalNew, this.sclkHighTol, sclkHighTolNew, (int)(conv * this.sclkHighCal * this.sclkHighP), (int)(conv * sclkHighCalNew * this.sclkHighP), conv * this.sclkHighCal, conv * sclkHighCalNew));
        } else {
            ++retval;
            tmsgList.add(String.format(formatStr1, this.dacPath, REBDevice.getAdcName(3), this.sclkHighP, slowAdcs[3], this.sclkHighCal, maxDelta));
        }
        double pclkLowCalNew = this.pclkLowCal;
        double pclkLowTolNew = this.pclkLowTol;
        value = slowAdcs[0];
        delta = this.pclkLowP - value;
        double d3 = conv = this.pclkLowP >= 0.0 ? this.railConvL : this.railShiftConvL;
        if (Math.signum(this.pclkLowP) == Math.signum(value) && Math.abs(delta) < maxDelta) {
            pclkLowCalNew = this.pclkLowCal * Math.abs(this.pclkLowP / slowAdcs[0]);
            pclkLowTolNew = Math.abs(delta) / 4.0 > minTol ? Math.abs(delta) / 4.0 : minTol;
            tmsgList.add(String.format(formatStr0, this.dacPath, REBDevice.getAdcName(0), this.pclkLowP, slowAdcs[0], this.pclkLowCal, pclkLowCalNew, this.pclkLowTol, pclkLowTolNew, (int)(conv * this.pclkLowCal * this.pclkLowP), (int)(conv * pclkLowCalNew * this.pclkLowP), conv * this.pclkLowCal, conv * pclkLowCalNew));
        } else {
            ++retval;
            tmsgList.add(String.format(formatStr1, this.dacPath, REBDevice.getAdcName(0), this.pclkLowP, slowAdcs[0], this.pclkLowCal, maxDelta));
        }
        double pclkHighCalNew = this.pclkHighCal;
        double pclkHighTolNew = this.pclkHighTol;
        value = slowAdcs[1];
        delta = this.pclkHighP - value;
        double d4 = conv = this.pclkHighP >= 0.0 ? this.railConvH : this.railShiftConvH;
        if (Math.signum(this.pclkHighP) == Math.signum(value) && Math.abs(delta) < maxDelta) {
            pclkHighCalNew = this.pclkHighCal * Math.abs(this.pclkHighP / slowAdcs[1]);
            pclkHighTolNew = Math.abs(delta) / 4.0 > minTol ? Math.abs(delta) / 4.0 : minTol;
            tmsgList.add(String.format(formatStr0, this.dacPath, REBDevice.getAdcName(1), this.pclkHighP, slowAdcs[1], this.pclkHighCal, pclkHighCalNew, this.pclkHighTol, pclkHighTolNew, (int)(conv * this.pclkHighCal * this.pclkHighP), (int)(conv * pclkHighCalNew * this.pclkHighP), conv * this.pclkHighCal, conv * pclkHighCalNew));
        } else {
            ++retval;
            tmsgList.add(String.format(formatStr1, this.dacPath, REBDevice.getAdcName(1), this.pclkHighP, slowAdcs[1], this.pclkHighCal, maxDelta));
        }
        double rgLowCalNew = this.rgLowCal;
        double rgLowTolNew = this.rgLowTol;
        value = slowAdcs[4];
        delta = this.rgLowP - value;
        double d5 = conv = this.rgLowP >= 0.0 ? this.railConvL : this.railShiftConvL;
        if (Math.signum(this.rgLowP) == Math.signum(value) && Math.abs(delta) < maxDelta) {
            rgLowCalNew = this.rgLowCal * Math.abs(this.rgLowP / slowAdcs[4]);
            rgLowTolNew = Math.abs(delta) / 4.0 > minTol ? Math.abs(delta) / 4.0 : minTol;
            tmsgList.add(String.format(formatStr0, this.dacPath, REBDevice.getAdcName(4), this.rgLowP, slowAdcs[4], this.rgLowCal, rgLowCalNew, this.rgLowTol, rgLowTolNew, (int)(conv * this.rgLowCal * this.rgLowP), (int)(conv * rgLowCalNew * this.rgLowP), conv * this.rgLowCal, conv * rgLowCalNew));
        } else {
            ++retval;
            tmsgList.add(String.format(formatStr1, this.dacPath, REBDevice.getAdcName(4), this.rgLowP, slowAdcs[4], this.rgLowCal, maxDelta));
        }
        double rgHighCalNew = this.rgHighCal;
        double rgHighTolNew = this.rgHighTol;
        value = slowAdcs[5];
        delta = this.rgHighP - value;
        double d6 = conv = this.rgHighP >= 0.0 ? this.railConvH : this.railShiftConvH;
        if (Math.signum(this.rgHighP) == Math.signum(value) && Math.abs(delta) < maxDelta) {
            rgHighCalNew = this.rgHighCal * Math.abs(this.rgHighP / slowAdcs[5]);
            rgHighTolNew = Math.abs(delta) / 4.0 > minTol ? Math.abs(delta) / 4.0 : minTol;
            tmsgList.add(String.format(formatStr0, this.dacPath, REBDevice.getAdcName(5), this.rgHighP, slowAdcs[5], this.rgHighCal, rgHighCalNew, this.rgHighTol, rgHighTolNew, (int)(conv * this.rgHighCal * this.rgHighP), (int)(conv * rgHighCalNew * this.rgHighP), conv * this.rgHighCal, conv * rgHighCalNew));
        } else {
            ++retval;
            tmsgList.add(String.format(formatStr1, this.dacPath, REBDevice.getAdcName(5), this.rgHighP, slowAdcs[5], this.rgHighCal, maxDelta));
        }
        if (action && retval == 0) {
            this.sce.submitChange(this.dacPath, "sclkLowCal", (Object)sclkLowCalNew);
            this.sce.submitChange(this.dacPath, "sclkLowTol", (Object)sclkLowTolNew);
            this.sce.submitChange(this.dacPath, "sclkHighCal", (Object)sclkHighCalNew);
            this.sce.submitChange(this.dacPath, "sclkHighTol", (Object)sclkHighTolNew);
            this.sce.submitChange(this.dacPath, "pclkLowCal", (Object)pclkLowCalNew);
            this.sce.submitChange(this.dacPath, "pclkLowTol", (Object)pclkLowTolNew);
            this.sce.submitChange(this.dacPath, "pclkHighCal", (Object)pclkHighCalNew);
            this.sce.submitChange(this.dacPath, "pclkHighTol", (Object)pclkHighTolNew);
            this.sce.submitChange(this.dacPath, "rgLowCal", (Object)rgLowCalNew);
            this.sce.submitChange(this.dacPath, "rgLowTol", (Object)rgLowTolNew);
            this.sce.submitChange(this.dacPath, "rgHighCal", (Object)rgHighCalNew);
            this.sce.submitChange(this.dacPath, "rgHighTol", (Object)rgHighTolNew);
        }
        return retval;
    }

    public int checkClockStepLimits(double[] slowAdcs, List<String> tmsgList) {
        int retval = 0;
        double maxStep = this.rebDevc.getMaxStep();
        String formatStr1 = "%-8.8s %-8.8s %6.2f --> %-6.2f: %s";
        double delta = this.sclkLowP - slowAdcs[2];
        boolean isOk = Math.abs(delta) < maxStep;
        retval += isOk ? 0 : 1;
        tmsgList.add(String.format(formatStr1, this.dacPath, REBDevice.getAdcName(2), slowAdcs[2], this.sclkLowP, isOk ? "OK" : "STEPTOOLARGE"));
        delta = this.sclkHighP - slowAdcs[3];
        isOk = Math.abs(delta) < maxStep;
        retval += isOk ? 0 : 1;
        tmsgList.add(String.format(formatStr1, this.dacPath, REBDevice.getAdcName(3), slowAdcs[3], this.sclkHighP, isOk ? "OK" : "STEPTOOLARGE"));
        delta = this.pclkLowP - slowAdcs[0];
        isOk = Math.abs(delta) < maxStep;
        retval += isOk ? 0 : 1;
        tmsgList.add(String.format(formatStr1, this.dacPath, REBDevice.getAdcName(0), slowAdcs[0], this.pclkLowP, isOk ? "OK" : "STEPTOOLARGE"));
        delta = this.pclkHighP - slowAdcs[1];
        isOk = Math.abs(delta) < maxStep;
        retval += isOk ? 0 : 1;
        tmsgList.add(String.format(formatStr1, this.dacPath, REBDevice.getAdcName(1), slowAdcs[1], this.pclkHighP, isOk ? "OK" : "STEPTOOLARGE"));
        delta = this.rgLowP - slowAdcs[4];
        isOk = Math.abs(delta) < maxStep;
        retval += isOk ? 0 : 1;
        tmsgList.add(String.format(formatStr1, this.dacPath, REBDevice.getAdcName(4), slowAdcs[4], this.rgLowP, isOk ? "OK" : "STEPTOOLARGE"));
        delta = this.rgHighP - slowAdcs[5];
        isOk = Math.abs(delta) < maxStep;
        tmsgList.add(String.format(formatStr1, this.dacPath, REBDevice.getAdcName(5), slowAdcs[5], this.rgHighP, isOk ? "OK" : "STEPTOOLARGE"));
        return retval += isOk ? 0 : 1;
    }

    public boolean testShorts(List<REBDevice.AdcData> dataList, List<String> tmsgList) throws RaftException {
        boolean failed = this.testShorts(2, 0, 3, 2, this.sclkHighTestV, this.sclkHighValueErr, this.sclkHighZeroErr, this.sclkLowTestV, this.sclkLowValueErr, this.sclkLowZeroErr, dataList, tmsgList);
        failed |= this.testShorts(10, 8, 1, 0, this.pclkHighTestV, this.pclkHighValueErr, this.pclkHighZeroErr, this.pclkLowTestV, this.pclkLowValueErr, this.pclkLowZeroErr, dataList, tmsgList);
        return failed |= this.testShorts(6, 4, 5, 4, this.rgHighTestV, this.rgHighValueErr, this.rgHighZeroErr, this.rgLowTestV, this.rgLowValueErr, this.rgLowZeroErr, dataList, tmsgList);
    }

    private boolean testShorts(int dacUp, int dacLo, int adcUp, int adcLo, double adcUpTestV, double adcUpValueErr, double adcUpZeroErr, double adcLoTestV, double adcLoValueErr, double adcLoZeroErr, List<REBDevice.AdcData> dataList, List<String> tmsgList) throws RaftException {
        this.rebDevc.readSlowAdcs(dataList);
        double[] origPower = this.rebDevc.readPowerAdcs(dataList);
        long tstamp = this.rebDevc.getTime();
        LOG.log(Level.FINE, String.format("%d initial reading done", tstamp));
        this.setDac(dacUp, 0);
        this.setDac(dacLo, 0);
        this.loadDac(50);
        this.rebDevc.readAllAdcs(dataList);
        tstamp = this.rebDevc.getTime();
        LOG.log(Level.FINE, String.format("%d set both rails to 0", tstamp));
        LOG.log(Level.FINE, String.format("%d %s,%s set to 0.0 with %d ms wait", tstamp, REBDevice.getAdcName(adcLo), REBDevice.getAdcName(adcUp), 50));
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        tstamp = this.rebDevc.getTime();
        LOG.log(Level.FINE, String.format("%d settled for %d ms", tstamp, 50));
        double[] lowerPower = this.rebDevc.readPowerAdcs(dataList);
        double[] lowerAdcs = this.rebDevc.readSlowAdcs(dataList);
        tstamp = this.rebDevc.getTime();
        LOG.log(Level.FINE, String.format("%d recorded lower values", tstamp));
        this.setDac(dacUp, (int)(this.railConvH * adcUpTestV));
        this.setDac(dacLo, (int)(this.railConvL * adcLoTestV));
        this.loadDac(160, dataList);
        tstamp = this.rebDevc.getTime();
        LOG.log(Level.FINE, String.format("%d %s set to %.2f with %d ms wait", tstamp, REBDevice.getAdcName(adcLo), adcLoTestV, 160));
        LOG.log(Level.FINE, String.format("%d %s set to %.2f with %d ms wait", tstamp, REBDevice.getAdcName(adcUp), adcUpTestV, 160));
        double[] upperPower = this.rebDevc.readPowerAdcs(dataList);
        double[] upperAdcs = this.rebDevc.readSlowAdcs(dataList);
        tstamp = this.rebDevc.getTime();
        LOG.log(Level.FINE, String.format("%d recorded at test voltage", tstamp));
        this.setDac(dacUp, 0);
        this.setDac(dacLo, 0);
        this.loadDac(50, dataList);
        tstamp = this.rebDevc.getTime();
        LOG.log(Level.FINE, String.format("%d set both rails to 0", tstamp));
        LOG.log(Level.FINE, String.format("%d %s clock rails set to 0.0 with %d ms wait", tstamp, REBDevice.getAdcName(adcLo), 50));
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.rebDevc.readAllAdcs(dataList);
        tstamp = this.rebDevc.getTime();
        LOG.log(Level.FINE, String.format("%d final reading", tstamp));
        return this.checkValues(adcUp, adcLo, adcUpTestV, adcUpValueErr, adcUpZeroErr, adcLoTestV, adcLoValueErr, adcLoZeroErr, lowerAdcs, upperAdcs, origPower, lowerPower, upperPower, tmsgList);
    }

    private boolean checkValues(int adcUp, int adcLo, double adcUpTestV, double adcUpValueErr, double adcUpZeroErr, double adcLoTestV, double adcLoValueErr, double adcLoZeroErr, double[] baseAdcs, double[] measAdcs, double[] origPower, double[] basePower, double[] measPower, List<String> tmsgList) {
        boolean failed = false;
        for (int ad = 0; ad < baseAdcs.length; ++ad) {
            double basevalue = baseAdcs[ad];
            double measvalue = measAdcs[ad];
            if (ad == adcUp) {
                if (Math.abs(basevalue) > adcUpZeroErr) {
                    tmsgList.add(String.format("%s %s baseline value (%.2f) is out of bounds (%.2f)", this.dacPath, REBDevice.getAdcName(ad), basevalue, adcUpZeroErr));
                    failed = true;
                }
                if (!(Math.abs(measvalue - adcUpTestV) > adcUpValueErr)) continue;
                tmsgList.add(String.format("%s %s measured value (%.2f) is out of bounds (%.2f +/- %.2f)", this.dacPath, REBDevice.getAdcName(ad), measvalue, adcUpTestV, adcUpValueErr));
                failed = true;
                continue;
            }
            if (ad == adcLo) {
                if (Math.abs(basevalue) > adcLoZeroErr) {
                    tmsgList.add(String.format("%s %s baseline value (%.2f) is out of bounds (%.2f)", this.dacPath, REBDevice.getAdcName(ad), basevalue, adcLoZeroErr));
                    failed = true;
                }
                if (!(Math.abs(measvalue - adcLoTestV) > adcLoValueErr)) continue;
                tmsgList.add(String.format("%s %s measured value (%.2f) is out of bounds (%.2f +/- %.2f)", this.dacPath, REBDevice.getAdcName(ad), measvalue, adcLoTestV, adcLoValueErr));
                failed = true;
                continue;
            }
            if (!(Math.abs(measvalue - basevalue) > adcLoZeroErr)) continue;
            tmsgList.add(String.format("%s %s change of (%.2f) is out of bounds (+/- %.2f)", this.dacPath, REBDevice.getAdcName(ad), measvalue - basevalue, 0.1));
            failed = true;
        }
        if (basePower[5] > origPower[5] + 0.002) {
            tmsgList.add(String.format("%s ClkHi base current increased excessively from %.2f mA to %.2f mA while testing %s", this.dacPath, 1000.0 * origPower[5], 1000.0 * basePower[5], REBDevice.getAdcName(adcUp)));
            failed = true;
        }
        if (measPower[5] > basePower[5] + 0.002) {
            tmsgList.add(String.format("%s ClkHi meas current increased excessively from %.2f mA to %.2f mA while testing %s", this.dacPath, 1000.0 * basePower[5], 1000.0 * measPower[5], REBDevice.getAdcName(adcUp)));
            failed = true;
        }
        if (basePower[9] > origPower[9] + 0.002) {
            tmsgList.add(String.format("%s ClkLo base current increased excessively from %.2f mA to %.2f mA while testing %s", this.dacPath, 1000.0 * origPower[9], 1000.0 * basePower[9], REBDevice.getAdcName(adcLo)));
            failed = true;
        }
        if (measPower[9] > basePower[9] + 0.002) {
            tmsgList.add(String.format("%s ClkLo meas current increased excessively from %.2f mA to %.2f mA while testing %s", this.dacPath, 1000.0 * basePower[9], 1000.0 * measPower[9], REBDevice.getAdcName(adcLo)));
            failed = true;
        }
        return failed;
    }

    private int loadPclkLow(int wait, boolean check, boolean powerOn, List<REBDevice.AdcData> dataList) throws RaftException {
        int count = 1;
        if (!this.raw) {
            this.setDac(8, this.pclkLowP >= 0.0 ? (int)(this.railConvL * this.pclkLowCal * this.pclkLowP) : 0);
            this.setDac(9, this.pclkLowP <= 0.0 ? (int)(-this.railShiftConvL * this.pclkLowCal * this.pclkLowP) : 0);
            ++count;
            this.loadDac(wait, dataList);
            try {
                this.checkAdc(0, dataList, check, this.pclkLowP, this.pclkLowTol);
            }
            catch (RaftException e) {
                if (powerOn) {
                    this.clearPclkLow(0);
                }
                throw e;
            }
        } else {
            this.setDac(8, this.pclkLow);
            if (this.isCurrent) {
                this.setDac(9, this.pclkLowSh);
                ++count;
            }
            this.loadDac(wait);
        }
        return count;
    }

    private int loadPclkHigh(int wait, boolean check, boolean powerOn, List<REBDevice.AdcData> dataList) throws RaftException {
        int count = 1;
        if (!this.raw) {
            if (!this.isCorner) {
                this.setDac(10, this.pclkHighP >= 0.0 ? (int)(this.railConvH * this.pclkHighCal * this.pclkHighP) : 0);
                this.loadDac(wait, dataList);
            }
            try {
                this.checkAdc(1, dataList, check, this.pclkHighP, this.pclkHighTol);
            }
            catch (RaftException e) {
                if (powerOn) {
                    this.clearPclkHigh(0);
                }
                throw e;
            }
        } else {
            this.setDac(10, this.pclkHigh);
            if (this.isCorner) {
                this.setDac(11, this.pclkHighSh);
                ++count;
            }
            this.loadDac(wait);
        }
        return count;
    }

    private int loadSclkLow(int wait, boolean check, boolean powerOn, List<REBDevice.AdcData> dataList) throws RaftException {
        int count = 1;
        if (!this.raw) {
            this.setDac(0, this.sclkLowP >= 0.0 ? (int)(this.railConvL * this.sclkLowCal * this.sclkLowP) : 0);
            this.setDac(1, this.sclkLowP <= 0.0 ? (int)(-this.railShiftConvL * this.sclkLowCal * this.sclkLowP) : 0);
            ++count;
            this.loadDac(wait, dataList);
            try {
                this.checkAdc(2, dataList, check, this.sclkLowP, this.sclkLowTol);
            }
            catch (RaftException e) {
                if (powerOn) {
                    this.clearSclkLow(0);
                }
                throw e;
            }
        } else {
            this.setDac(0, this.sclkLow);
            if (this.isCurrent) {
                this.setDac(1, this.sclkLowSh);
                ++count;
            }
            this.loadDac(wait);
        }
        return count;
    }

    private int loadSclkHigh(int wait, boolean check, boolean powerOn, List<REBDevice.AdcData> dataList) throws RaftException {
        int count = 1;
        if (!this.raw) {
            this.setDac(2, this.sclkHighP >= 0.0 ? (int)(this.railConvH * this.sclkHighCal * this.sclkHighP) : 0);
            if (this.isCorner) {
                this.setDac(3, this.sclkHighP <= 0.0 ? (int)(-this.railShiftConvH * this.sclkHighCal * this.sclkHighP) : 0);
                ++count;
            }
            this.loadDac(wait, dataList);
            try {
                this.checkAdc(3, dataList, check, this.sclkHighP, this.sclkHighTol);
            }
            catch (RaftException e) {
                if (powerOn) {
                    this.clearSclkHigh(0);
                }
                throw e;
            }
        } else {
            this.setDac(2, this.sclkHigh);
            if (this.isCorner) {
                this.setDac(3, this.sclkHighSh);
                ++count;
            }
            this.loadDac(wait);
        }
        return count;
    }

    private int loadRgLow(int wait, boolean check, boolean powerOn, List<REBDevice.AdcData> dataList) throws RaftException {
        int count = 1;
        if (!this.raw) {
            this.setDac(4, this.rgLowP >= 0.0 ? (int)(this.railConvL * this.rgLowCal * this.rgLowP) : 0);
            this.setDac(5, this.rgLowP <= 0.0 ? (int)(-this.railShiftConvL * this.rgLowCal * this.rgLowP) : 0);
            ++count;
            this.loadDac(wait, dataList);
            try {
                this.checkAdc(4, dataList, check, this.rgLowP, this.rgLowTol);
            }
            catch (RaftException e) {
                if (powerOn) {
                    this.clearRgLow(0);
                }
                throw e;
            }
        } else {
            this.setDac(4, this.rgLow);
            if (this.isCurrent) {
                this.setDac(5, this.rgLowSh);
                ++count;
            }
            this.loadDac(wait);
        }
        return count;
    }

    private int loadRgHigh(int wait, boolean check, boolean powerOn, List<REBDevice.AdcData> dataList) throws RaftException {
        int count = 1;
        if (!this.raw) {
            this.setDac(6, this.rgHighP >= 0.0 ? (int)(this.railConvH * this.rgHighCal * this.rgHighP) : 0);
            if (this.isCorner) {
                this.setDac(7, this.rgHighP <= 0.0 ? (int)(-this.railShiftConvH * this.rgHighCal * this.rgHighP) : 0);
                ++count;
            }
            this.loadDac(wait, dataList);
            try {
                this.checkAdc(5, dataList, check, this.rgHighP, this.rgHighTol);
            }
            catch (Exception e) {
                if (powerOn) {
                    this.clearRgHigh(0);
                }
                throw e;
            }
        } else {
            this.setDac(6, this.rgHigh);
            if (this.isCorner) {
                this.setDac(7, this.rgHighSh);
                ++count;
            }
            this.loadDac(wait);
        }
        return count;
    }

    private void checkAdc(int adc, List<REBDevice.AdcData> dataList, boolean check, double setPoint, double adcTol) throws RaftException {
        StringBuilder exString = new StringBuilder();
        boolean failed = false;
        if (!check && dataList == null) {
            return;
        }
        double[] adcValues = this.rebDevc.readSlowAdcs(dataList);
        double[] curPower = this.rebDevc.readPowerAdcs(dataList);
        if (Math.abs(adcValues[adc] - setPoint) > adcTol) {
            exString.append(String.format("\n%s %s out of range: setpt=%.2f, reading: %.2f, tol: %.2f", this.dacPath, REBDevice.getAdcName(adc), setPoint, adcValues[adc], adcTol));
            failed = true;
        }
        if (curPower[5] > this.clkhIMax) {
            exString.append(String.format("\n%s %s caused overcurrent on ClkHI: measured %.3f, limit: %.3f", this.dacPath, REBDevice.getAdcName(adc), curPower[5], this.clkhIMax));
            failed = true;
        }
        if (curPower[9] > this.clklIMax) {
            exString.append(String.format("\n%s %s caused overcurrent on ClkLI: measured %.3f, limit: %.3f", this.dacPath, REBDevice.getAdcName(adc), curPower[9], this.clklIMax));
            failed = true;
        }
        if (failed) {
            LOG.log(Level.SEVERE, exString.toString());
            if (check) {
                throw new RaftException(exString.toString());
            }
        }
    }

    private static boolean isValueOkay(double read, double set) {
        return Math.abs(read - set) <= 0.4;
    }

    private void clearPclkLow(int wait) throws RaftException {
        this.setDac(8, 0);
        if (this.isCurrent) {
            this.setDac(9, 0);
        }
        this.loadDac(wait);
    }

    private void clearPclkHigh(int wait) throws RaftException {
        this.setDac(10, 0);
        if (this.isCorner) {
            this.setDac(11, 0);
        }
        this.loadDac(wait);
    }

    private void clearPclkHigh(int wait, List<REBDevice.AdcData> dataList) throws RaftException {
        this.setDac(10, 0);
        if (this.isCorner) {
            this.setDac(11, 0);
        }
        this.loadDac(wait, dataList);
    }

    private void clearSclkLow(int wait) throws RaftException {
        this.setDac(0, 0);
        if (this.isCurrent) {
            this.setDac(1, 0);
        }
        this.loadDac(wait);
    }

    private void clearSclkHigh(int wait) throws RaftException {
        this.setDac(2, 0);
        if (this.isCorner) {
            this.setDac(3, 0);
        }
        this.loadDac(wait);
    }

    private void clearSclkHigh(int wait, List<REBDevice.AdcData> dataList) throws RaftException {
        this.setDac(2, 0);
        if (this.isCorner) {
            this.setDac(3, 0);
        }
        this.loadDac(wait, dataList);
    }

    private void clearRgLow(int wait) throws RaftException {
        this.setDac(4, 0);
        if (this.isCurrent) {
            this.setDac(5, 0);
        }
        this.loadDac(wait);
    }

    private void clearRgHigh(int wait) throws RaftException {
        this.setDac(6, 0);
        if (this.isCorner) {
            this.setDac(7, 0);
        }
        this.loadDac(wait);
    }

    private void clearRgHigh(int wait, List<REBDevice.AdcData> dataList) throws RaftException {
        this.setDac(6, 0);
        if (this.isCorner) {
            this.setDac(7, 0);
        }
        this.loadDac(wait, dataList);
    }

    private void setDac(int chan, int value) throws RaftException {
        try {
            this.dac.set(chan, Math.max(0, Math.min(value, 4095)));
        }
        catch (REBException e) {
            throw new RaftException(e.getMessage());
        }
    }

    private void loadDac(int wait) throws RaftException {
        try {
            this.dac.loadGlobal();
        }
        catch (REBException e) {
            throw new RaftException(e.getMessage());
        }
        try {
            Thread.sleep(wait);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void loadDac(int wait, List<REBDevice.AdcData> dataList) throws RaftException {
        int delay = wait;
        try {
            this.dac.loadGlobal();
        }
        catch (REBException e) {
            throw new RaftException(e.getMessage());
        }
        if (delay > 12) {
            try {
                Thread.sleep(6L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.rebDevc.readSlowAdcs(dataList);
            delay -= 12;
        }
        while (delay > 40) {
            try {
                Thread.sleep(34L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.rebDevc.readSlowAdcs(dataList);
            delay -= 40;
        }
        if (delay > 0) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static {
        seqLineMap.put(0, 3840);
        seqLineMap.put(1, 0);
        seqLineMap.put(2, 112);
        seqLineMap.put(3, 0);
        seqLineMap.put(4, 128);
        seqLineMap.put(5, 0);
        LOG = Logger.getLogger(DacControl.class.getName());
    }
}

