/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.CarouselClamp;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarousel;

public class SimuCarouselSocket
extends CarouselSocket {
    private static final Logger FCSLOG = Logger.getLogger(SimuCarouselSocket.class.getName());

    public SimuCarouselSocket(int id, CarouselClamp clampXminus, CarouselClamp clampXplus) {
        super(id, clampXminus, clampXplus);
    }

    @Override
    public void updateFilterID() {
        if (this.isEmpty()) {
            this.filterID = 0;
        } else if (this.autochanger.isAtStandby() && this.autochanger.isHoldingFilter()) {
            this.filterID = this.autochanger.getFilterID();
        }
        FCSLOG.finer(() -> this.name + " filter ID = " + this.carousel.getSocketAtStandby().getFilterID());
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Change the filterID on socket")
    public void simulateFilterID(int filterID) {
        this.filterID = filterID;
        boolean atStandby = this.isAtStandby();
        if (filterID == 0) {
            ((SimuCarousel)this.carousel).simulateSocketEmpty(atStandby, this.getId());
        } else {
            ((SimuCarousel)this.carousel).simulateSocketHoldingFilter(atStandby, this.getId());
        }
        FCSLOG.info(this.name + " filter ID = " + filterID);
        this.publishData();
    }
}

