/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.lsst.ccs.Agent;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridge;
import org.lsst.ccs.subsystem.ocsbridge.OCSCommandExecutor;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.event.SoftwareVersionsEvent;

class SoftwareVersionsGenerator {
    private final Agent agent;
    private final OCSBridge ocsBridge;

    SoftwareVersionsGenerator(OCSBridge ocsBridge, Agent agent) {
        this.ocsBridge = ocsBridge;
        this.agent = agent;
    }

    void run(boolean fullVersions) {
        String cscVersion = this.agent.getAgentInfo().getAgentProperty("version.agent");
        String subsystemVersions = "";
        if (fullVersions) {
            this.agent.getMessagingAccess().getAgentPresenceManager().waitForFirstContact(20L, TimeUnit.SECONDS);
            List connectedAgents = this.agent.getMessagingAccess().getAgentPresenceManager().listConnectedAgents();
            subsystemVersions = connectedAgents.stream().filter(a -> a.isAgentWorkerOrService()).filter(a -> !a.equals((Object)this.agent.getAgentInfo())).map(a -> a.getName() + "=" + a.getAgentProperty("version.agent")).collect(Collectors.joining(","));
        }
        OCSCommandExecutor oce = this.ocsBridge.getOcsCommandExecutor();
        SoftwareVersionsEvent sve = new SoftwareVersionsEvent(oce.getSALVersion(), oce.getXMLVersion(), cscVersion, subsystemVersions);
        this.ocsBridge.getOcsCommandExecutor().sendEvent((CameraEvent)sve);
    }
}

