/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.imagenaming.Controller;
import org.lsst.ccs.imagenaming.Source;
import org.lsst.ccs.imagenaming.service.ImageNameService;
import org.lsst.ccs.subsystem.focalplane.data.ImageMetaDataEvent;
import org.lsst.ccs.subsystem.imagehandling.data.AdditionalFile;
import org.lsst.ccs.subsystem.imagehandling.data.MeasuredShutterTime;
import org.lsst.ccs.subsystem.ocsbridge.AdditionalFileToLFAEvent;
import org.lsst.ccs.subsystem.ocsbridge.AsynchronousEventHandler;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.CCSExecutor;
import org.lsst.ccs.subsystem.ocsbridge.ConfigurationSender;
import org.lsst.ccs.subsystem.ocsbridge.MCMLayer;
import org.lsst.ccs.subsystem.ocsbridge.MotionLockUnlockEventHandler;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridgeConfig;
import org.lsst.ccs.subsystem.ocsbridge.OCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.S3FileUploaderAndDeleter;
import org.lsst.ccs.subsystem.ocsbridge.SALHeartbeatGenerator;
import org.lsst.ccs.subsystem.ocsbridge.TelemetrySender;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSAdditionalFileEvent;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSAvailableFiltersEvent;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSConfigurationAppliedEvent;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSConfigurationsAvailableEvent;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSImageNameEvent;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSSetFilterEvent;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSSimulationEvent;
import org.lsst.ccs.subsystem.ocsbridge.events.EventListener;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCM;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMDirectLayer;
import org.lsst.ccs.subsystem.ocsbridge.states.RaftsState;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.DelimitedStringSplitJoin;
import org.lsst.ccs.subsystem.ocsbridge.util.OCSCommandConverter;
import org.lsst.ccs.subsystem.ocsbridge.util.OCSStateChangeToEventConverter;
import org.lsst.ccs.subsystem.ocsbridge.util.OCSStateEventConverter;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.subsystem.ocsbridge.util.SummaryInfoConverter;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;
import org.lsst.sal.SALException;
import org.lsst.sal.atcamera.event.ImageReadoutParametersEvent;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.CameraStateChangeEvent;
import org.lsst.sal.camera.command.DisableCommand;
import org.lsst.sal.camera.command.EnableCommand;
import org.lsst.sal.camera.command.EnterControlCommand;
import org.lsst.sal.camera.command.ExitControlCommand;
import org.lsst.sal.camera.command.InitGuidersCommand;
import org.lsst.sal.camera.command.SetFilterCommand;
import org.lsst.sal.camera.command.StandbyCommand;
import org.lsst.sal.camera.command.StartCommand;
import org.lsst.sal.camera.command.StartImageCommand;
import org.lsst.sal.camera.command.TakeImagesCommand;
import org.lsst.sal.camera.event.AlertRaisedEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.ConfigurationAppliedEvent;
import org.lsst.sal.camera.event.ConfigurationsAvailableEvent;
import org.lsst.sal.camera.event.EndSetFilterEvent;
import org.lsst.sal.camera.event.ErrorCodeEvent;
import org.lsst.sal.camera.event.ImageReadoutParametersEvent;
import org.lsst.sal.camera.event.LargeFileObjectAvailableEvent;
import org.lsst.sal.camera.event.SimulationModeEvent;
import org.lsst.sal.camera.event.StartSetFilterEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;
import org.lsst.sal.camera.states.OfflineDetailedStateEvent;
import org.lsst.sal.camera.states.SummaryStateEvent;

public class OCSBridge {
    private static final Logger LOG = Logger.getLogger(OCSBridge.class.getName());
    static final DelimitedStringSplitJoin DELIMITED_STRING_SPLIT_JOIN = new DelimitedStringSplitJoin();
    private final CCS ccs;
    private final State lse209State;
    private final State offlineState;
    private OCSCommandExecutor ocsCommandExecutor;
    private CCSCommandExecutor ccsCommandExecutor;
    private final MCMLayer mcm;
    private final OCSBridgeConfig config;
    private final State commandState;
    private final OCSCommandConverter ocsCcsCommandConverter = new OCSCommandConverter();
    private final OCSStateEventConverter ocsCcsStateEventConverter = new OCSStateEventConverter();
    private final OCSStateChangeToEventConverter ocsStateChangeToEventConverter = new OCSStateChangeToEventConverter();
    private final TelemetrySender telemetrySender;
    private final ConfigurationSender configurationSender;
    private StringBuilder roiBuilder = new StringBuilder();
    private final AsynchronousEventHandler eventHandler;
    private final S3FileUploaderAndDeleter s3FileUploader;
    private MotionLockUnlockEventHandler motionLockUnlockEventHandler;

    OCSBridge(final OCSBridgeConfig config, CCS ccs, MCMLayer mcm) {
        this.config = config;
        this.ccs = ccs;
        this.mcm = mcm;
        this.eventHandler = new AsynchronousEventHandler(config, ccs);
        CCSTimeStamp now = CCSTimeStamp.currentTime();
        this.lse209State = new State<SummaryStateEvent.SummaryState>(SummaryStateEvent.SummaryState.OFFLINE);
        ccs.getAggregateStatus().add(now, this.lse209State);
        this.offlineState = new State<OfflineDetailedStateEvent.OfflineState>(OfflineDetailedStateEvent.OfflineState.OFFLINE_PUBLISH_ONLY);
        ccs.getAggregateStatus().add(now, this.offlineState);
        this.commandState = new State<CCSCommandStateEvent.CCSCommandState>(CCSCommandStateEvent.CCSCommandState.IDLE);
        ccs.getAggregateStatus().add(now, this.commandState);
        this.ocsCommandExecutor = new OCSCommandExecutor(this);
        this.ccsCommandExecutor = new CCSCommandExecutor();
        this.telemetrySender = TelemetrySender.create(config.getDevice(), this.ocsCommandExecutor, ccs.getScheduler());
        this.configurationSender = ConfigurationSender.create(config.getDevice(), this.ocsCommandExecutor);
        this.s3FileUploader = new S3FileUploaderAndDeleter(config);
        SALHeartbeatGenerator shg = new SALHeartbeatGenerator(this);
        shg.start();
        mcm.addStateChangeListener((when, state, oldState, cause) -> {
            LOG.log(Level.INFO, "MCM {0} State changed from {1} to {2}", new Object[]{state.getClass().getName(), oldState, state});
            try {
                CameraEvent converted;
                if (state instanceof OperationalState && state == OperationalState.ENGINEERING_FAULT && ccs.getAggregateStatus().anyState(new Enum[]{SummaryStateEvent.SummaryState.ENABLED, SummaryStateEvent.SummaryState.DISABLED})) {
                    LOG.log(Level.WARNING, "Switching to FAULT state");
                    this.lse209State.setState(SummaryStateEvent.SummaryState.FAULT, cause);
                    StringBuilder sb = new StringBuilder("MCM has entered fault state");
                    if (cause == null) {
                        sb.append(" for unspecified reason");
                    } else {
                        sb.append(". Cause: ").append(cause);
                    }
                    ErrorCodeEvent ece = new ErrorCodeEvent(1099, sb.toString(), "");
                    this.ocsCommandExecutor.sendEvent((CameraEvent)ece);
                    try {
                        mcm.unlock();
                    }
                    catch (ExecutionException x) {
                        LOG.log(Level.WARNING, "Unable to release MCM lock", x);
                    }
                }
                if ((oldState == RaftsState.CLEARING || oldState == RaftsState.QUIESCENT) && state == RaftsState.INTEGRATING) {
                    LOG.log(Level.INFO, "Detected state transition {0} -> {1}. Getting new image handler.", new Object[]{oldState, state});
                    this.eventHandler.getNewImageHandler(Duration.ofSeconds(2L)).thenAccept(imageHandler -> imageHandler.startIntegration());
                }
                if (oldState == RaftsState.INTEGRATING && state == RaftsState.READING_OUT) {
                    this.eventHandler.getCurrent().startReadout(when);
                }
                if (oldState == RaftsState.READING_OUT) {
                    this.eventHandler.getCurrent().endReadout(when);
                }
                if ((converted = this.ocsStateChangeToEventConverter.convert(when, oldState, state)) != null) {
                    this.ocsCommandExecutor.sendEvent(converted);
                }
            }
            catch (Exception x) {
                LOG.log(Level.SEVERE, "Error during state change", x);
            }
        });
        mcm.addEventListener(event -> {
            if (event instanceof CCSAvailableFiltersEvent) {
                DelimitedStringSplitJoin ccsDelimiter = new DelimitedStringSplitJoin(',', '\\');
                CCSAvailableFiltersEvent ccsEvent = (CCSAvailableFiltersEvent)event;
                AvailableFiltersEvent salEvent = new AvailableFiltersEvent(ccsDelimiter.join(ccsEvent.getAvailableFilters()), ccsDelimiter.join(ccsEvent.getAvailableFilterTypes()), ccsEvent.getMaxChangeAngle(), ccsEvent.getMaxFastChangeAngle(), ccsEvent.getMaxSlowChangeTime(), ccsEvent.getMaxFastChangeTime());
                this.ocsCommandExecutor.sendEvent((CameraEvent)salEvent);
            } else if (event instanceof CCSImageNameEvent) {
                CCSImageNameEvent cCSImageNameEvent = (CCSImageNameEvent)event;
                LOG.log(Level.INFO, "CCSImageNameEvent event {0}", event);
                this.eventHandler.create(cCSImageNameEvent, this.ocsCommandExecutor);
            } else if (event instanceof CCSSetFilterEvent) {
                CCSSetFilterEvent setFilter = (CCSSetFilterEvent)event;
                if (setFilter.isStart()) {
                    this.ocsCommandExecutor.sendEvent((CameraEvent)new StartSetFilterEvent(setFilter.getFilterName(), setFilter.getFilterType()));
                } else {
                    this.ocsCommandExecutor.sendEvent((CameraEvent)new EndSetFilterEvent(setFilter.getFilterName(), setFilter.getFilterType(), setFilter.getSlot(), setFilter.getPosition()));
                }
            } else if (event instanceof CCSConfigurationAppliedEvent) {
                CCSConfigurationAppliedEvent ccsEvent = (CCSConfigurationAppliedEvent)event;
                String otherEvents = this.configurationSender.getConfigurationEvents();
                this.ocsCommandExecutor.sendEvent((CameraEvent)new ConfigurationAppliedEvent(ccsEvent.getSettings(), this.makeSemverCompliant(ccsEvent.getVersion()), ccsEvent.getUrl(), ccsEvent.getSchema(), otherEvents));
            } else if (event instanceof CCSConfigurationsAvailableEvent) {
                CCSConfigurationsAvailableEvent ccsEvent = (CCSConfigurationsAvailableEvent)event;
                this.ocsCommandExecutor.sendEvent((CameraEvent)new ConfigurationsAvailableEvent(ccsEvent.getConfigurationsAvailable(), this.makeSemverCompliant(ccsEvent.getVersion()), ccsEvent.getUrl(), ccsEvent.getSchema()));
            } else if (event instanceof CCSSimulationEvent) {
                CCSSimulationEvent ccsEvent = (CCSSimulationEvent)event;
                this.ocsCommandExecutor.sendEvent((CameraEvent)new SimulationModeEvent(ccsEvent.getSimulationMode()));
            } else if (event instanceof CCSAdditionalFileEvent) {
                CCSAdditionalFileEvent cCSAdditionalFileEvent = (CCSAdditionalFileEvent)event;
                AdditionalFile additionalFile = cCSAdditionalFileEvent.getAdditionalFile();
                LOG.log(Level.INFO, "Received additional file {0}", additionalFile.getFileName());
                try {
                    String minioArchiveURL = this.s3FileUploader.writeToS3(additionalFile);
                    LOG.log(Level.INFO, "Wrote LFA file to {0}", minioArchiveURL);
                    AdditionalFileToLFAEvent jflfa = new AdditionalFileToLFAEvent(additionalFile, minioArchiveURL);
                    LargeFileObjectAvailableEvent lfa = jflfa.getlfaEvent();
                    this.ocsCommandExecutor.sendEvent((CameraEvent)lfa);
                }
                catch (IOException x) {
                    LOG.log(Level.SEVERE, "Unable to send s3 file", x);
                }
            }
        });
        mcm.addStatusMessageListener(new EventListener<StatusMessage>(){

            @Override
            public void eventFired(StatusMessage msg) {
                if (msg instanceof StatusConfigurationInfo) {
                    StatusConfigurationInfo sci = (StatusConfigurationInfo)msg;
                    AgentInfo originAgentInfo = msg.getOriginAgentInfo();
                    ConfigurationInfo info = sci.getConfigurationInfo();
                    if (originAgentInfo != null && "FOCAL_PLANE".equals(originAgentInfo.getAgentProperty("agentCategory"))) {
                        SummaryInfoConverter converter = new SummaryInfoConverter(config.getDevice());
                        OCSBridge.this.ocsCommandExecutor.sendEvent(converter.convert(info));
                    }
                    OCSBridge.this.configurationSender.send(sci);
                } else if (msg instanceof StatusSubsystemData) {
                    StatusSubsystemData ssd = (StatusSubsystemData)msg;
                    AgentInfo originAgentInfo = msg.getOriginAgentInfo();
                    String subsystemName = originAgentInfo == null ? "unknown" : originAgentInfo.getName();
                    LOG.log(Level.FINE, "Received from {0} {1}", new Object[]{subsystemName, ssd.getDataKey()});
                    LOG.log(Level.FINE, "Data {0}", new Object[]{ssd.getSubsystemData().getValue().toString()});
                    Serializable serializable = ssd.getSubsystemData().getValue();
                    if (serializable instanceof org.lsst.ccs.subsystem.focalplane.data.ImageReadoutParametersEvent) {
                        org.lsst.ccs.subsystem.focalplane.data.ImageReadoutParametersEvent data = (org.lsst.ccs.subsystem.focalplane.data.ImageReadoutParametersEvent)serializable;
                        ccdNames = new ArrayList();
                        ArrayList<ImageReadoutParametersEvent.CcdType> ccdTypes = new ArrayList<ImageReadoutParametersEvent.CcdType>();
                        ArrayList<Integer> overCols = new ArrayList<Integer>();
                        ArrayList<Integer> overRows = new ArrayList<Integer>();
                        ArrayList<Integer> postCols = new ArrayList<Integer>();
                        ArrayList<Integer> postRows = new ArrayList<Integer>();
                        ArrayList<Integer> preCols = new ArrayList<Integer>();
                        ArrayList<Integer> preRows = new ArrayList<Integer>();
                        ArrayList<Integer> readCols = new ArrayList<Integer>();
                        ArrayList<Integer> readCols2 = new ArrayList<Integer>();
                        ArrayList<Integer> readRows = new ArrayList<Integer>();
                        ArrayList<Integer> underCols = new ArrayList<Integer>();
                        int index = 0;
                        for (Location location : data.getLocations()) {
                            int nSensors = location.type().getCCDCount();
                            for (int i2 = 0; i2 < nSensors; ++i2) {
                                ccdNames.add(location.getRaftName() + (config.getDevice() == Camera.AUXTEL ? "S00" : location.getSensorName(i2)));
                                ccdTypes.add(ImageReadoutParametersEvent.CcdType.valueOf((String)data.getCcdType()[index].toUpperCase()));
                                overCols.add(data.getOverCols()[index]);
                                overRows.add(data.getOverRows()[index]);
                                postCols.add(data.getPostCols()[index]);
                                postRows.add(data.getPostRows()[index]);
                                preCols.add(data.getPreCols()[index]);
                                preRows.add(data.getPreRows()[index]);
                                readCols.add(data.getReadCols()[index]);
                                readCols2.add(data.getReadCols2()[index]);
                                readRows.add(data.getReadRows()[index]);
                                underCols.add(data.getUnderCols()[index]);
                            }
                            ++index;
                        }
                        Object irpe = config.getDevice() == Camera.AUXTEL ? ImageReadoutParametersEvent.builder().imageName(data.getImageName().toString()).ccdLocation(DELIMITED_STRING_SPLIT_JOIN.join((Iterable<? extends CharSequence>)((Object)ccdNames))).raftBay(ccdNames.stream().map(name -> name.substring(0, 3)).collect(DELIMITED_STRING_SPLIT_JOIN.joining())).ccdSlot(ccdNames.stream().map(name -> name.substring(3, 6)).collect(DELIMITED_STRING_SPLIT_JOIN.joining())).ccdType(ImageReadoutParametersEvent.CcdType.ITL).overRows(((Integer)overRows.get(0)).intValue()).overCols(((Integer)overCols.get(0)).intValue()).readRows(((Integer)readRows.get(0)).intValue()).readCols(((Integer)readCols.get(0)).intValue()).readCols2(((Integer)readCols2.get(0)).intValue()).preCols(((Integer)preCols.get(0)).intValue()).preRows(((Integer)preRows.get(0)).intValue()).postCols(((Integer)postCols.get(0)).intValue()).underCols(((Integer)underCols.get(0)).intValue()).daqFolder(data.getDaqFolder()).daqAnnotation(data.getAnnotation()).build() : org.lsst.sal.camera.event.ImageReadoutParametersEvent.builder().imageName(data.getImageName().toString()).ccdLocation(DELIMITED_STRING_SPLIT_JOIN.join((Iterable<? extends CharSequence>)((Object)ccdNames))).raftBay(ccdNames.stream().map(name -> name.substring(0, 3)).collect(DELIMITED_STRING_SPLIT_JOIN.joining())).ccdSlot(ccdNames.stream().map(name -> name.substring(3, 6)).collect(DELIMITED_STRING_SPLIT_JOIN.joining())).ccdType((ImageReadoutParametersEvent.CcdType[])ccdTypes.stream().toArray(ImageReadoutParametersEvent.CcdType[]::new)).overRows(overRows.stream().mapToInt(i -> i).toArray()).overCols(overCols.stream().mapToInt(i -> i).toArray()).readRows(readRows.stream().mapToInt(i -> i).toArray()).readCols(readCols.stream().mapToInt(i -> i).toArray()).readCols2(readCols2.stream().mapToInt(i -> i).toArray()).preCols(preCols.stream().mapToInt(i -> i).toArray()).preRows(preRows.stream().mapToInt(i -> i).toArray()).postCols(postCols.stream().mapToInt(i -> i).toArray()).underCols(underCols.stream().mapToInt(i -> i).toArray()).daqFolder(data.getDaqFolder()).daqAnnotation(data.getAnnotation()).build();
                        OCSBridge.this.ocsCommandExecutor.sendEvent((CameraEvent)irpe);
                    } else {
                        ccdNames = ssd.getSubsystemData().getValue();
                        if (ccdNames instanceof ImageMetaDataEvent) {
                            ImageMetaDataEvent data = (ImageMetaDataEvent)ccdNames;
                            OCSBridge.this.eventHandler.getHandlerForImage(data.getImageName()).imageMetaDataArrived(data);
                        } else {
                            ccdNames = ssd.getSubsystemData().getValue();
                            if (ccdNames instanceof AdditionalFile) {
                                AdditionalFile additionalFile = (AdditionalFile)ccdNames;
                                LOG.log(Level.INFO, "Received additional file {0}", additionalFile.getFileName());
                                try {
                                    String writtenMinioURL = OCSBridge.this.s3FileUploader.writeToS3(additionalFile);
                                    LOG.log(Level.INFO, "Wrote LFA file to {0}", writtenMinioURL);
                                    AdditionalFileToLFAEvent jflfa = new AdditionalFileToLFAEvent(additionalFile, writtenMinioURL);
                                    LargeFileObjectAvailableEvent lfa = jflfa.getlfaEvent();
                                    OCSBridge.this.ocsCommandExecutor.sendEvent((CameraEvent)lfa);
                                }
                                catch (IOException x) {
                                    LOG.log(Level.SEVERE, "Unable to send s3 file", x);
                                }
                            } else {
                                serializable = ssd.getSubsystemData().getValue();
                                if (serializable instanceof MeasuredShutterTime) {
                                    MeasuredShutterTime measuredShutterTime = (MeasuredShutterTime)serializable;
                                    LOG.log(Level.INFO, "MeasuredShutterTime event {0}", measuredShutterTime);
                                    OCSBridge.this.eventHandler.getHandlerForImage(measuredShutterTime.getImageName()).shutterTimeArrived(measuredShutterTime);
                                } else if (ssd.getSubsystemData().getValue() instanceof List) {
                                    OCSBridge.this.telemetrySender.send(ssd);
                                } else {
                                    LOG.log(Level.FINE, "Got unhandled telemetry from {0} of type ", new Object[]{subsystemName, ssd.getClass().getSimpleName()});
                                }
                            }
                        }
                    }
                }
            }
        });
        ccs.addStateChangeListener((when, currentState, oldState, cause) -> {
            CameraStateChangeEvent converted = this.ocsCcsStateEventConverter.convert(when, currentState);
            if (converted == null) {
                LOG.log(Level.FINE, "Enum {0} of class {1} could not be converted to equivalent OCS state", new Object[]{currentState, currentState.getClass()});
            } else {
                this.ocsCommandExecutor.sendEvent((CameraEvent)converted);
            }
        });
    }

    State<CCSCommandStateEvent.CCSCommandState> getCommandState() {
        return this.commandState;
    }

    public OCSBridgeConfig getConfig() {
        return this.config;
    }

    void addSubsystem(AgentInfo ai, DataProviderDictionary dict) {
        this.telemetrySender.getConverter().addSubsystem(ai, dict);
        this.configurationSender.getConverter().addSubsystem(ai, dict);
    }

    void removeSubsystem(String subsystemName) {
        this.telemetrySender.getConverter().removeSubsystem(subsystemName);
        this.configurationSender.getConverter().removeSubsystem(subsystemName);
    }

    void setMotionLockUnlockEventHandler(MotionLockUnlockEventHandler motionLockUnlockEventHandler) {
        this.motionLockUnlockEventHandler = motionLockUnlockEventHandler;
    }

    void setOCSCommandExecutor(OCSCommandExecutor ocs) {
        this.ocsCommandExecutor = ocs;
        this.telemetrySender.setSender(ocs);
        this.configurationSender.setSender(ocs);
        CCSTimeStamp now = CCSTimeStamp.currentTime();
        this.ccs.getAggregateStatus().getStates().stream().map(s -> this.ocsCcsStateEventConverter.convert(now, (Enum)s.getState())).filter(Objects::nonNull).forEach(converted -> this.ocsCommandExecutor.sendEvent((CameraEvent)converted));
    }

    public OCSCommandExecutor getOcsCommandExecutor() {
        return this.ocsCommandExecutor;
    }

    void setCCSCommandExecutor(CCSCommandExecutor ccs) {
        this.ccsCommandExecutor = ccs;
    }

    static OCSBridge createOCSBridge(MCMConfig mcmConfig) {
        OCSBridgeConfig ocsConfig = OCSBridgeConfig.createDefaultConfig(mcmConfig.getCameraType());
        ImageNameService ins = ImageNameService.testInstance((String)"jdbc:h2:mem:test;MODE=MYSQL", (Controller)Controller.OCS, (Source)Source.MainCamera, (String)"UTC", (Duration)Duration.ofHours(12L), (Instant)Instant.parse("2022-01-01T00:00:00.00Z"));
        return OCSBridge.createOCSBridge(ocsConfig, mcmConfig, ins);
    }

    static OCSBridge createOCSBridge(Camera camera) {
        OCSBridgeConfig ocsConfig = OCSBridgeConfig.createDefaultConfig(camera);
        MCMConfig mcmConfig = new MCMConfig(camera);
        ImageNameService ins = ImageNameService.testInstance((String)"jdbc:h2:mem:test;MODE=MYSQL", (Controller)Controller.OCS, (Source)(camera == Camera.AUXTEL ? Source.AuxTel : Source.MainCamera), (String)"UTC", (Duration)Duration.ofHours(12L), (Instant)Instant.parse("2022-01-01T00:00:00.00Z"));
        return OCSBridge.createOCSBridge(ocsConfig, mcmConfig, ins);
    }

    static OCSBridge createOCSBridge(OCSBridgeConfig config, MCMConfig mcmConfig, ImageNameService imageNamingService) {
        CCS ccs = new CCS();
        MCMDirectLayer mcm = new MCMDirectLayer(new MCM(ccs, mcmConfig, imageNamingService));
        return new OCSBridge(config, ccs, mcm);
    }

    State getLse209State() {
        return this.lse209State;
    }

    State getOfflineState() {
        return this.offlineState;
    }

    private String makeSemverCompliant(int version) {
        return version + ".0.0";
    }

    void execute(CameraCommand cmd) {
        if (cmd instanceof DisableCommand) {
            DisableCommand disableCommand = (DisableCommand)cmd;
            this.execute(disableCommand);
        } else if (cmd instanceof EnableCommand) {
            EnableCommand enableCommand = (EnableCommand)cmd;
            this.execute(enableCommand);
        } else if (cmd instanceof ExitControlCommand) {
            ExitControlCommand exitControlCommand = (ExitControlCommand)cmd;
            this.execute(exitControlCommand);
        } else if (cmd instanceof EnterControlCommand) {
            EnterControlCommand enterControlCommand = (EnterControlCommand)cmd;
            this.execute(enterControlCommand);
        } else if (cmd instanceof TakeImagesCommand) {
            TakeImagesCommand takeImagesCommand = (TakeImagesCommand)cmd;
            this.execute(takeImagesCommand);
        } else if (cmd instanceof StartCommand) {
            StartCommand startCommand = (StartCommand)cmd;
            this.execute(startCommand);
        } else if (cmd instanceof StartImageCommand) {
            StartImageCommand startImageCommand = (StartImageCommand)cmd;
            this.execute(startImageCommand);
        } else if (cmd instanceof InitGuidersCommand) {
            InitGuidersCommand initGuidersCommand = (InitGuidersCommand)cmd;
            this.execute(initGuidersCommand);
        } else if (cmd instanceof StandbyCommand) {
            StandbyCommand standbyCommand = (StandbyCommand)cmd;
            this.execute(standbyCommand);
        } else if (cmd instanceof SetFilterCommand) {
            SetFilterCommand setFilterCommand = (SetFilterCommand)cmd;
            this.execute(setFilterCommand);
        } else {
            ForwardToMCMExecutor fcm = new ForwardToMCMExecutor(cmd);
            this.ocsCommandExecutor.executeCommand(fcm);
        }
    }

    void execute(InitGuidersCommand command) {
        String roiSpec = command.getRoiSpec();
        LOG.log(Level.INFO, "Got ROISpec {0}", roiSpec);
        if (roiSpec.endsWith("-")) {
            this.roiBuilder.append(roiSpec.substring(0, roiSpec.length() - 1));
            NoOpExecutor noop = new NoOpExecutor();
            this.ocsCommandExecutor.executeCommand(noop);
        } else if (roiSpec.length() > 0) {
            this.roiBuilder.append(roiSpec);
            command = new InitGuidersCommand(this.roiBuilder.toString());
            InitGuidersExecutor initGuiders = new InitGuidersExecutor(command);
            this.roiBuilder.setLength(0);
            this.ocsCommandExecutor.executeCommand(initGuiders);
        } else {
            InitGuidersExecutor initGuiders = new InitGuidersExecutor(command);
            this.ocsCommandExecutor.executeCommand(initGuiders);
        }
    }

    void execute(SetFilterCommand command) {
        SetFilterExecutor setFilter = new SetFilterExecutor(command);
        this.ocsCommandExecutor.executeCommand(setFilter);
    }

    void execute(TakeImagesCommand command) {
        TakeImagesExecutor takeImages = new TakeImagesExecutor(command);
        this.ocsCommandExecutor.executeCommand(takeImages);
    }

    void execute(StartImageCommand command) {
        StartImageExecutor startImage = new StartImageExecutor(command);
        this.ocsCommandExecutor.executeCommand(startImage);
    }

    void execute(EnterControlCommand command) {
        EnterControlExecutor takeControl = new EnterControlExecutor(command);
        this.ocsCommandExecutor.executeCommand(takeControl);
    }

    void execute(ExitControlCommand command) {
        ExitExecutor exit = new ExitExecutor(command);
        this.ocsCommandExecutor.executeCommand(exit);
    }

    void execute(StartCommand command) {
        StartExecutor start = new StartExecutor(command);
        this.ocsCommandExecutor.executeCommand(start);
    }

    void execute(StandbyCommand command) {
        StandbyExecutor standby = new StandbyExecutor(command);
        this.ocsCommandExecutor.executeCommand(standby);
    }

    void execute(EnableCommand command) {
        EnableExecutor enable = new EnableExecutor(command);
        this.ocsCommandExecutor.executeCommand(enable);
    }

    void execute(DisableCommand command) {
        DisableExecutor disable = new DisableExecutor(command);
        this.ocsCommandExecutor.executeCommand(disable);
    }

    void execute(CCSCommand command) throws Exception {
        if (command instanceof CCSCommand.CCSSetAvailableCommand) {
            CCSCommand.CCSSetAvailableCommand cCSSetAvailableCommand = (CCSCommand.CCSSetAvailableCommand)command;
            this.execute(cCSSetAvailableCommand);
        } else if (command instanceof CCSCommand.CCSRevokeAvailableCommand) {
            CCSCommand.CCSRevokeAvailableCommand cCSRevokeAvailableCommand = (CCSCommand.CCSRevokeAvailableCommand)command;
            this.execute(cCSRevokeAvailableCommand);
        } else if (command instanceof CCSCommand.CCSSimulateFaultCommand) {
            CCSCommand.CCSSimulateFaultCommand cCSSimulateFaultCommand = (CCSCommand.CCSSimulateFaultCommand)command;
            this.execute(cCSSimulateFaultCommand);
        } else if (command instanceof CCSCommand.CCSClearFaultCommand) {
            CCSCommand.CCSClearFaultCommand cCSClearFaultCommand = (CCSCommand.CCSClearFaultCommand)command;
            this.execute(cCSClearFaultCommand);
        } else if (command instanceof CCSCommand.CCSLockMotionCommand) {
            CCSCommand.CCSLockMotionCommand lockMotionCommand = (CCSCommand.CCSLockMotionCommand)command;
            this.execute(lockMotionCommand);
        } else if (command instanceof CCSCommand.CCSUnlockMotionCommand) {
            CCSCommand.CCSUnlockMotionCommand unlockMotionCommand = (CCSCommand.CCSUnlockMotionCommand)command;
            this.execute(unlockMotionCommand);
        } else if (command instanceof CCSCommand.CCSCreateTestAlertCommand) {
            CCSCommand.CCSCreateTestAlertCommand createTestAlert = (CCSCommand.CCSCreateTestAlertCommand)command;
            this.execute(createTestAlert);
        } else {
            throw new RuntimeException("Unknown command type: " + command);
        }
    }

    void execute(CCSCommand.CCSSetAvailableCommand command) throws Exception {
        SetAvailableExecutor setAvailable = new SetAvailableExecutor(command);
        this.ccsCommandExecutor.executeCommand(new CCSCommand.CCSCommandResponse<Void>(setAvailable));
    }

    void execute(CCSCommand.CCSRevokeAvailableCommand command) throws Exception {
        RevokeAvailableExecutor revokeAvailable = new RevokeAvailableExecutor(command);
        this.ccsCommandExecutor.executeCommand(new CCSCommand.CCSCommandResponse<Void>(revokeAvailable));
    }

    void execute(CCSCommand.CCSSimulateFaultCommand command) throws Exception {
        SimulateFaultExecutor simulateFault = new SimulateFaultExecutor(command);
        this.ccsCommandExecutor.executeCommand(new CCSCommand.CCSCommandResponse<Void>(simulateFault));
    }

    void execute(CCSCommand.CCSClearFaultCommand command) throws Exception {
        ClearFaultExecutor clearFault = new ClearFaultExecutor(command);
        this.ccsCommandExecutor.executeCommand(new CCSCommand.CCSCommandResponse<Void>(clearFault));
    }

    void execute(CCSCommand.CCSLockMotionCommand command) throws Exception {
        LockMotionExecutor lockMotion = new LockMotionExecutor(command);
        this.ccsCommandExecutor.executeCommand(new CCSCommand.CCSCommandResponse<Void>(lockMotion));
    }

    void execute(CCSCommand.CCSUnlockMotionCommand command) throws Exception {
        UnlockMotionExecutor unlockMotion = new UnlockMotionExecutor(command);
        this.ccsCommandExecutor.executeCommand(new CCSCommand.CCSCommandResponse<Void>(unlockMotion));
    }

    void execute(CCSCommand.CCSCreateTestAlertCommand command) throws Exception {
        CreateTestAlertExecutor createTestAlert = new CreateTestAlertExecutor(command);
        this.ccsCommandExecutor.executeCommand(new CCSCommand.CCSCommandResponse<Void>(createTestAlert));
    }

    public Future<Void> waitForState(Enum state) {
        return this.ccs.waitForStatus(state);
    }

    CCS getCCS() {
        return this.ccs;
    }

    class ForwardToMCMExecutor
    extends OCSCommandExecutor.OCSExecutor {
        private CCSCommand.CCSCommandResponse response;
        private final SummaryStateEvent.SummaryState initialState;
        private final CameraCommand command;
        private CCSCommand ccsCommand;

        ForwardToMCMExecutor(CameraCommand command) {
            this(command, SummaryStateEvent.SummaryState.ENABLED);
        }

        ForwardToMCMExecutor(CameraCommand command, SummaryStateEvent.SummaryState initialState) {
            super(command);
            this.command = command;
            this.initialState = initialState;
        }

        @Override
        Duration testPreconditions() throws OCSCommandExecutor.PreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(this.initialState)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in: " + OCSBridge.this.lse209State);
            }
            try {
                this.ccsCommand = OCSBridge.this.ocsCcsCommandConverter.convert(this.command);
                CCSCommand.CCSAckOrNack can = this.forwardCommand();
                if (can.isNack()) {
                    throw new OCSCommandExecutor.PreconditionsNotMet("Command rejected: " + can.getReason());
                }
                return can.getDuration();
            }
            catch (OCSCommandConverter.CommandConversionException x) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command rejected: " + x.getMessage());
            }
        }

        protected CCSCommand.CCSAckOrNack forwardCommand() {
            this.response = OCSBridge.this.mcm.execute(this.ccsCommand);
            return this.response.waitForAckOrNack();
        }

        @Override
        void execute() throws Exception {
            this.response.waitForCompletion();
        }
    }

    class NoOpExecutor
    extends OCSCommandExecutor.OCSExecutor {
        public NoOpExecutor() {
            super(null);
        }

        @Override
        Duration testPreconditions() throws OCSCommandExecutor.PreconditionsNotMet {
            return Duration.ZERO;
        }

        @Override
        void execute() throws Exception {
        }
    }

    class InitGuidersExecutor
    extends ForwardToMCMExecutor {
        public InitGuidersExecutor(InitGuidersCommand command) {
            super((CameraCommand)command);
        }
    }

    class SetFilterExecutor
    extends ForwardToMCMExecutor {
        private boolean wasLocked;

        public SetFilterExecutor(SetFilterCommand command) {
            super((CameraCommand)command);
        }

        @Override
        protected CCSCommand.CCSAckOrNack forwardCommand() {
            CCSCommand.CCSAckOrNack ackOrNack;
            if (OCSBridge.this.motionLockUnlockEventHandler != null) {
                this.wasLocked = OCSBridge.this.motionLockUnlockEventHandler.isLocked();
                try {
                    if (!this.wasLocked) {
                        OCSBridge.this.motionLockUnlockEventHandler.lock();
                    }
                }
                catch (TimeoutException | SALException x) {
                    LOG.log(Level.SEVERE, "Failed to get motion lock during setFilter command", x);
                    return new CCSCommand.CCSAckOrNack(x.getMessage());
                }
            }
            if ((ackOrNack = super.forwardCommand()).isNack()) {
                try {
                    this.unlockIfWasLocked();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return ackOrNack;
        }

        @Override
        void execute() throws Exception {
            try {
                super.execute();
            }
            finally {
                this.unlockIfWasLocked();
            }
        }

        private void unlockIfWasLocked() throws TimeoutException, SALException {
            if (OCSBridge.this.motionLockUnlockEventHandler != null && !this.wasLocked) {
                try {
                    OCSBridge.this.motionLockUnlockEventHandler.unlock();
                }
                catch (TimeoutException | SALException x) {
                    LOG.log(Level.SEVERE, "Failed to free motion lock after setFilter command", x);
                    throw x;
                }
            }
        }
    }

    class TakeImagesExecutor
    extends ForwardToMCMExecutor {
        public TakeImagesExecutor(TakeImagesCommand command) {
            super((CameraCommand)command);
        }

        @Override
        protected CCSCommand.CCSAckOrNack forwardCommand() {
            return super.forwardCommand();
        }
    }

    class StartImageExecutor
    extends ForwardToMCMExecutor {
        public StartImageExecutor(StartImageCommand command) {
            super((CameraCommand)command);
        }

        @Override
        protected CCSCommand.CCSAckOrNack forwardCommand() {
            return super.forwardCommand();
        }
    }

    class EnterControlExecutor
    extends OCSCommandExecutor.OCSExecutor {
        public EnterControlExecutor(EnterControlCommand command) {
            super((CameraCommand)command);
        }

        @Override
        Duration testPreconditions() throws OCSCommandExecutor.PreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.SummaryState.OFFLINE)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            if (!OCSBridge.this.offlineState.isInState(OfflineDetailedStateEvent.OfflineState.OFFLINE_AVAILABLE)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in " + OCSBridge.this.offlineState);
            }
            return Duration.ZERO;
        }

        @Override
        void execute() throws Exception {
            OCSBridge.this.mcm.lock();
            CCSCommand.CCSCommandResponse response = OCSBridge.this.mcm.execute(new CCSCommand.CCSStandbyCommand());
            CCSCommand.CCSAckOrNack ackOrNack = response.waitForAckOrNack();
            if (ackOrNack.isNack()) {
                throw new RuntimeException("Standby command rejected: " + ackOrNack.getReason());
            }
            response.waitForCompletion();
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.STANDBY);
        }
    }

    class ExitExecutor
    extends OCSCommandExecutor.OCSExecutor {
        public ExitExecutor(ExitControlCommand command) {
            super((CameraCommand)command);
        }

        @Override
        Duration testPreconditions() throws OCSCommandExecutor.PreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.SummaryState.STANDBY)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            return Duration.ZERO;
        }

        @Override
        void execute() throws Exception {
            OCSBridge.this.mcm.unlock();
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.OFFLINE);
            OCSBridge.this.offlineState.setState(OfflineDetailedStateEvent.OfflineState.OFFLINE_PUBLISH_ONLY);
        }
    }

    class StartExecutor
    extends ForwardToMCMExecutor {
        public StartExecutor(StartCommand command) {
            super((CameraCommand)command, SummaryStateEvent.SummaryState.STANDBY);
        }

        @Override
        void execute() throws Exception {
            super.execute();
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.DISABLED);
        }
    }

    class StandbyExecutor
    extends ForwardToMCMExecutor {
        public StandbyExecutor(StandbyCommand command) {
            super((CameraCommand)command, SummaryStateEvent.SummaryState.DISABLED);
        }

        @Override
        void execute() throws Exception {
            super.execute();
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.STANDBY);
        }
    }

    class EnableExecutor
    extends OCSCommandExecutor.OCSExecutor {
        public EnableExecutor(EnableCommand command) {
            super((CameraCommand)command);
        }

        @Override
        Duration testPreconditions() throws OCSCommandExecutor.PreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.SummaryState.DISABLED)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            return Duration.ZERO;
        }

        @Override
        void execute() throws Exception {
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.ENABLED);
        }
    }

    class DisableExecutor
    extends OCSCommandExecutor.OCSExecutor {
        public DisableExecutor(DisableCommand command) {
            super((CameraCommand)command);
        }

        @Override
        Duration testPreconditions() throws OCSCommandExecutor.PreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.SummaryState.ENABLED)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            return Duration.ZERO;
        }

        @Override
        void execute() throws Exception {
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.DISABLED);
        }
    }

    class SetAvailableExecutor
    extends CCSExecutor {
        private SetAvailableExecutor(CCSCommand.CCSSetAvailableCommand command) {
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.SummaryState.OFFLINE)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            if (!OCSBridge.this.offlineState.isInState(OfflineDetailedStateEvent.OfflineState.OFFLINE_PUBLISH_ONLY)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Command not accepted in " + OCSBridge.this.offlineState);
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() throws Exception {
            OCSBridge.this.offlineState.setState(OfflineDetailedStateEvent.OfflineState.OFFLINE_AVAILABLE);
        }
    }

    class RevokeAvailableExecutor
    extends CCSExecutor {
        private RevokeAvailableExecutor(CCSCommand.CCSRevokeAvailableCommand command) {
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.SummaryState.OFFLINE)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            if (!OCSBridge.this.offlineState.isInState(OfflineDetailedStateEvent.OfflineState.OFFLINE_AVAILABLE)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Command not accepted in " + OCSBridge.this.offlineState);
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() throws Exception {
            OCSBridge.this.offlineState.setState(OfflineDetailedStateEvent.OfflineState.OFFLINE_PUBLISH_ONLY);
        }
    }

    class SimulateFaultExecutor
    extends CCSExecutor {
        private SimulateFaultExecutor(CCSCommand.CCSSimulateFaultCommand command) {
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            return Duration.ZERO;
        }

        @Override
        protected void execute() throws Exception {
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.FAULT, "Executed CCSSimulateFaultCommand");
        }
    }

    class ClearFaultExecutor
    extends CCSExecutor {
        private ClearFaultExecutor(CCSCommand.CCSClearFaultCommand command) {
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.SummaryState.FAULT)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() throws Exception {
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.OFFLINE);
            OCSBridge.this.offlineState.setState(OfflineDetailedStateEvent.OfflineState.OFFLINE_PUBLISH_ONLY);
        }
    }

    class LockMotionExecutor
    extends CCSExecutor {
        private LockMotionExecutor(CCSCommand.CCSLockMotionCommand command) {
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (OCSBridge.this.motionLockUnlockEventHandler == null) {
                throw new CCSCommand.CCSPreconditionsNotMet("MotionLockUnlockEventHandler not registered");
            }
            return Duration.ofSeconds(15L);
        }

        @Override
        protected void execute() throws Exception {
            OCSBridge.this.motionLockUnlockEventHandler.lock();
        }
    }

    class UnlockMotionExecutor
    extends CCSExecutor {
        private UnlockMotionExecutor(CCSCommand.CCSUnlockMotionCommand command) {
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (OCSBridge.this.motionLockUnlockEventHandler == null) {
                throw new CCSCommand.CCSPreconditionsNotMet("MotionLockUnlockEventHandler not registered");
            }
            return Duration.ofSeconds(15L);
        }

        @Override
        protected void execute() throws Exception {
            OCSBridge.this.motionLockUnlockEventHandler.unlock();
        }
    }

    class CreateTestAlertExecutor
    extends CCSExecutor {
        private final String message;
        private final String level;
        private final boolean isCleared;

        private CreateTestAlertExecutor(CCSCommand.CCSCreateTestAlertCommand command) {
            this.message = command.getMessage();
            this.level = command.getLevel();
            this.isCleared = command.isCleared();
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            return Duration.ZERO;
        }

        @Override
        protected void execute() throws Exception {
            AlertRaisedEvent are = AlertRaisedEvent.builder().additionalInfo("AdditionalInfo").alertId("TestAlert").cause("cause").currentSeverity(AlertRaisedEvent.CurrentSeverity.valueOf((String)this.level)).description(this.message).highestSeverity(AlertRaisedEvent.CurrentSeverity.CRITICAL.ordinal()).isCleared(this.isCleared).origin("lsstcam").timestampAlertStatusChanged(CCSTimeStamp.currentTime().getTAIDouble()).build();
            OCSBridge.this.ocsCommandExecutor.sendEvent((CameraEvent)are);
        }
    }
}

