/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.plc;

import java.nio.ByteBuffer;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.shutter.common.Axis;
import org.lsst.ccs.subsystem.shutter.plc.MsgToPLC;

public class ChangeAxisEnablePLC
extends MsgToPLC {
    private ChangeAxisEnable msg;

    public ChangeAxisEnablePLC(ChangeAxisEnable msg) {
        this.msg = msg;
    }

    public ChangeAxisEnablePLC(ByteBuffer data) {
        super(data);
        String name = Axis.fromAxisNum(data.getInt()).getName();
        boolean enable = data.get() != 0;
        this.msg = new ChangeAxisEnable(name, enable);
    }

    @Override
    public void encode(ByteBuffer data) {
        super.encode(data);
        data.putInt(Axis.fromName(this.msg.getAxisName()).getPLCAxisNum());
        data.put((byte)(this.msg.isEnabled() ? 1 : 0));
    }

    @Override
    public String toString() {
        return "ChangeAxisEnablePLC{" + super.toString() + " axis=" + this.msg.getAxisName() + ", enabled=" + this.msg.isEnabled() + "}";
    }
}

