/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand.limits;

import java.util.List;
import org.lsst.ccs.subsystem.teststand.limits.LimitAlgorithm;
import org.lsst.ccs.subsystem.teststand.limits.LimitsInterface;

class ProportionalLimitAlgorithm
extends LimitAlgorithm {
    private double initialAlarmLowFactor;
    private double initialWarnLowFactor;
    private double initialWarnHighFactor;
    private double initialAlarmHighFactor;
    private double targetAlarmLowFactor;
    private double targetWarnLowFactor;
    private double targetWarnHighFactor;
    private double targetAlarmHighFactor;

    ProportionalLimitAlgorithm() {
    }

    @Override
    public void init(List<Double> parameters, double initialValue, LimitsInterface initialLimits, double targetValue, LimitsInterface targetLimits) {
        super.init(parameters, initialValue, initialLimits, targetValue, targetLimits);
        this.initialAlarmLowFactor = Math.abs(initialLimits.getAlarmLow() / initialValue);
        this.initialWarnLowFactor = Math.abs(initialLimits.getWarnLow() / initialValue);
        this.initialWarnHighFactor = Math.abs(initialLimits.getWarnHigh() / initialValue);
        this.initialAlarmHighFactor = Math.abs(initialLimits.getAlarmHigh() / initialValue);
        if (this.initialAlarmLowFactor <= 0.0 || this.initialAlarmLowFactor > this.initialWarnLowFactor || this.initialAlarmHighFactor < this.initialWarnHighFactor) {
            throw new IllegalArgumentException("Proportional limit algorith values are invalid [" + this.initialAlarmLowFactor + "," + this.initialWarnLowFactor + "," + this.initialWarnHighFactor + "," + this.initialAlarmHighFactor + "]");
        }
        this.targetAlarmLowFactor = Math.abs(targetLimits.getAlarmLow() / targetValue);
        this.targetWarnLowFactor = Math.abs(targetLimits.getWarnLow() / targetValue);
        this.targetWarnHighFactor = Math.abs(targetLimits.getWarnHigh() / targetValue);
        this.targetAlarmHighFactor = Math.abs(targetLimits.getAlarmHigh() / targetValue);
        if (this.targetAlarmLowFactor <= 0.0 || this.targetAlarmLowFactor > this.targetWarnLowFactor || this.targetAlarmHighFactor < this.targetWarnHighFactor) {
            throw new IllegalArgumentException("Proportional limit algorith values are invalid");
        }
    }

    @Override
    public void adjust(double currentValue, LimitsInterface limits) {
        double alpha = Math.abs((currentValue - this.getTargetValue()) / (this.getInitialValue() - this.getTargetValue()));
        double alarmLowFactor = alpha * this.initialAlarmLowFactor + (1.0 - alpha) * this.targetAlarmLowFactor;
        double warnLowFactor = alpha * this.initialWarnLowFactor + (1.0 - alpha) * this.targetWarnLowFactor;
        double warnHighFactor = alpha * this.initialWarnHighFactor + (1.0 - alpha) * this.targetWarnHighFactor;
        double alarmHighFactor = alpha * this.initialAlarmHighFactor + (1.0 - alpha) * this.targetAlarmHighFactor;
        limits.setLimits(currentValue * alarmLowFactor, currentValue * warnLowFactor, currentValue * warnHighFactor, currentValue * alarmHighFactor);
    }
}

