/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.canopenjni;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.canopenjni.CanOpenInterface;
import org.lsst.ccs.drivers.canopenjni.CanopenSlave;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.canopenjni.SDOException;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.utilities.logging.Logger;

public class CanopenMaster {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.drivers.canopenjni");
    private final Map<Integer, CanopenSlave> slaves = new HashMap<Integer, CanopenSlave>();
    private final CanOpenInterface coi;

    public CanopenMaster(CanOpenInterface coi) {
        this.coi = coi;
    }

    public synchronized void addSlave(CanopenSlave slave) throws DriverException {
        this.slaves.put(slave.getNodeId(), slave);
        for (int cobId : slave.getCobIds()) {
            this.coi.addReceivedPDO(cobId);
        }
    }

    @Command
    public void sync() throws DriverException {
        PDOData rd = this.coi.sync();
        for (Map.Entry<Integer, Long> e : rd.pdos.entrySet()) {
            this.slaves.get(e.getKey() & 0x7F).updateWithPDO(e.getKey(), e.getValue());
        }
    }

    @Command
    public synchronized String info(int nodeID) throws DriverException {
        return this.coi.info(nodeID);
    }

    @Command
    public void wsdo(int nodeId, int index, int subindex, int size, int data) throws DriverException {
        this.coi.wsdo(nodeId, index, subindex, size, data);
    }

    @Command
    public long rsdo(int nodeId, int index, int subindex) throws SDOException, DriverException {
        return this.coi.rsdo(nodeId, index, subindex);
    }
}

