/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.yaskawa;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.modbus.Modbus;

public class A1000 {
    public static final int STATUS_RUNNING = 1;
    public static final int STATUS_ZERO_SPEED = 2;
    public static final int STATUS_REVERSE = 4;
    public static final int STATUS_FAULT_RESET = 8;
    public static final int STATUS_SPEED_AGREE = 16;
    public static final int STATUS_READY = 32;
    public static final int STATUS_ALARM = 64;
    public static final int STATUS_FAULT = 128;
    private static final short REG_COMMAND_MF_IN = 1;
    private static final short CMND_STOP = 0;
    private static final short CMND_FORWARD = 1;
    private static final short CMND_FR_REVERSE = 2;
    private static final short CMND_OD_REVERSE = 3;
    private static final short CMND_RESET_FAULT = 8;
    private static final short REG_FREQ_REFC = 2;
    private static final short REG_VOLTAGE_GAIN = 3;
    private static final short REG_TORQUE_REFC = 4;
    private static final short REG_TORQUE_COMP = 5;
    private static final short REG_PID_TARGET = 6;
    private static final short REG_ANAL_OUT_FM = 7;
    private static final short REG_ANAL_OUT_AM = 8;
    private static final short REG_DIGITAL_OUT = 9;
    private static final short REG_PULSE_OUT = 10;
    private static final short REG_CTRL_SLCTN = 15;
    private static final short REG_ANAL_MONITOR_1 = 27;
    private static final short REG_ANAL_MONITOR_2 = 28;
    private static final short REG_DIG_OUT_OPTN = 29;
    private static final short REG_DRIVE_STATUS_1 = 32;
    private static final short REG_FAULT_1 = 33;
    private static final short REG_LINK_STATUS = 34;
    private static final short REG_FREQ_REF_IN = 35;
    private static final short REG_OUTPUT_FRQ = 36;
    private static final short REG_VOLTAGE_REF = 37;
    private static final short REG_OUTPUT_CUR = 38;
    private static final short REG_OUTPUT_PWR = 39;
    private static final short REG_TORQUE_REF_IN = 40;
    private static final short REG_FAULT_2 = 41;
    private static final short REG_ALARM_1 = 42;
    private static final short REG_INPUT_TRM = 43;
    private static final short REG_DRIVE_STATUS_2 = 44;
    private static final short REG_OUTPUT_TRM = 45;
    private static final short REG_FREQ_REF_BIAS = 47;
    private static final short REG_DC_BUS_VOLTAGE = 49;
    private static final short REG_TORQUE_REF_IN2 = 50;
    private static final short REG_PRODUCT_CODE_1 = 52;
    private static final short REG_PRODUCT_CODE_2 = 53;
    private static final short REG_COMM_ERROR = 61;
    private static final short REG_OUT_FREQ_RPM = 62;
    private static final short REG_OUT_FREQ_PCT = 63;
    private static final short REG_FREQ_REFC_IN = 64;
    private static final short REG_OUTPUT_FREQ = 65;
    private static final short REG_OUTPUT_CURR = 66;
    private static final short REG_CTRL_METHOD_IN = 67;
    private static final short REG_MOTOR_SPEED = 68;
    private static final short REG_VOLTAGE_REFC = 69;
    private static final short REG_BUS_VOLTAGE = 70;
    private static final short REG_OUTPUT_POWER = 71;
    private static final short REG_INPUT_TERM = 73;
    private static final short REG_OUTPUT_TERM = 74;
    private static final short REG_DRIVE_STATUS = 75;
    private static final short REG_OPERATION_TIME = 76;
    private static final short REG_RUN_CMND_COUNT = 117;
    private static final short REG_FAN_OPRN_TIME = 103;
    private static final short REG_FAN_LIFE_PCT = 126;
    private static final short REG_CAP_LIFE_PCT = 124;
    private static final short REG_SCBR_LIFE_PCT = 2006;
    private static final short REG_IGBT_LIFE_PCT = 2007;
    private static final short REG_HEATSINK_TEMP = 104;
    private static final short REG_LED_CHECK = 94;
    private static final short REG_KWH_LOWER = 92;
    private static final short REG_KWH_UPPER = 93;
    private static final short REG_PEAK_HOLD_CURR = 1999;
    private static final short REG_PEAK_HOLD_FREQ = 2000;
    private static final short REG_OVERLOAD_EST = 2008;
    private static final short REG_OPER_TIME_SET = 1291;
    private static final short REG_OPER_TIME_TYPE = 1292;
    private static final short REG_FAN_OP_TIME_SET = 1294;
    private static final short REG_CAP_LT_PCT_SET = 1309;
    private static final short REG_SCBR_LT_PCT_SET = 1315;
    private static final short REG_IGBT_LT_PCT_SET = 1317;
    private static final short REG_ALARM_CODE = 127;
    private static final short REG_CURR_FAULT = 128;
    private static final short REG_PREV_FAULT = 129;
    private static final short REG_ACC_OP_TIME_HI = 152;
    private static final short REG_ACC_OP_TIME_LO = 153;
    private static final short REG_FAN_OP_TIME_HI = 154;
    private static final short REG_FAN_OP_TIME_LO = 155;
    private static final short REG_RATED_CURRENT = 171;
    private static final short REG_MOTOR_SPD_RPM = 172;
    private static final short REG_MOTOR_SPD_PCT = 173;
    private static final short REG_FREQ_REF_S_RPM = 181;
    private static final short REG_FREQ_REF_S_PCT = 182;
    private static final short REG_FREQ_REF_RPM = 183;
    private static final short REG_FREQ_REF_PCT = 184;
    private static final short REG_OP_ERROR_CODE = 191;
    private static final short REG_FAULT_3 = 192;
    private static final short REG_FAULT_4 = 193;
    private static final short REG_FAULT_5 = 194;
    private static final short REG_FAULT_6 = 195;
    private static final short REG_FAULT_7 = 196;
    private static final short REG_FAULT_8 = 197;
    private static final short REG_FAULT_9 = 198;
    private static final short NUM_FAULT_REGS = 7;
    private static final short REG_ALARM_2 = 200;
    private static final short REG_ALARM_3 = 201;
    private static final short REG_ALARM_4 = 202;
    private static final short REG_ALARM_5 = 203;
    private static final short REG_ALARM_6 = 204;
    private static final short NUM_ALARM_REGS = 5;
    private static final short REG_CPF_1 = 208;
    private static final short REG_CPF_2 = 209;
    private static final short REG_CPF_3 = 210;
    private static final short REG_LANGUAGE = 256;
    private static final short LANG_ENGLISH = 0;
    private static final short LANG_JAPANESE = 1;
    private static final short LANG_GERMAN = 2;
    private static final short LANG_FRENCH = 3;
    private static final short LANG_ITALIAN = 4;
    private static final short LANG_SPANISH = 5;
    private static final short LANG_PORTUGUESE = 6;
    private static final short LANG_CHINESE = 7;
    private static final short LANG_CZECH = 8;
    private static final short LANG_RUSSIAN = 9;
    private static final short LANG_TURKISH = 10;
    private static final short LANG_POLISH = 11;
    private static final short LANG_GREEK = 12;
    private static final short REG_ACCESS_LEVEL = 257;
    private static final short ACC_LEVEL_OPR_ONLY = 0;
    private static final short ACC_LEVEL_USR_PARM = 1;
    private static final short ACC_LEVEL_FULL = 2;
    private static final short REG_CTRL_MODE = 258;
    private static final short CTRL_MODE_VF = 0;
    private static final short CTRL_MODE_VF_PG = 1;
    private static final short CTRL_MODE_OLV = 2;
    private static final short CTRL_MODE_CLV = 3;
    private static final short CTRL_MODE_OLV_PM = 5;
    private static final short CTRL_MODE_AOLV_PM = 6;
    private static final short CTRL_MODE_CLV_PM = 7;
    private static final short REG_INIT_PARAMS = 259;
    private static final short INIT_NONE = 0;
    private static final short INIT_USER = 4368;
    private static final short INIT_2WIRE = 8736;
    private static final short INIT_3WIRE = 13104;
    private static final short INIT_OPE04_RESET = 21840;
    private static final short REG_PW_ENTRY = 260;
    private static final short REG_PW_SETTING = 261;
    private static final short REG_FREQ_REF_SRC = 384;
    private static final short FREQ_REF_OPERATOR = 0;
    private static final short FREQ_REF_ANALOG = 1;
    private static final short FREQ_REF_MODBUS = 2;
    private static final short FREQ_REF_OPTN_PCB = 3;
    private static final short FREQ_REF_PULSE = 4;
    private static final short REG_RUN_CMND_SRC = 385;
    private static final short RUN_CMND_OPERATOR = 0;
    private static final short RUN_CMND_DIGITAL = 1;
    private static final short RUN_CMND_MODBUS = 2;
    private static final short RUN_CMND_OPTN_PCB = 3;
    private static final short REG_STOP_METHOD = 386;
    private static final short STOP_METH_RAMP = 0;
    private static final short STOP_METH_COAST = 1;
    private static final short STOP_METH_INJECT = 2;
    private static final short STOP_METH_COAST_TM = 3;
    private static final short REG_REV_PERMIT = 387;
    private static final short REV_ENABLED = 0;
    private static final short REV_DISABLED = 1;
    private static final short REG_DIG_INPUT_CONF = 389;
    private static final short DIG_CONF_DISABLED = 0;
    private static final short DIG_CONF_ENABLED = 1;
    private static final short REG_RUN_CMND_CYCLE = 390;
    private static final short RUN_CYCLE_ENABLED = 0;
    private static final short RUN_CYCLE_DISABLED = 1;
    private static final short REG_RUN_CMND_PROG = 391;
    private static final short PROG_MODE_ONLY = 0;
    private static final short RUN_PROG_OKAY = 1;
    private static final short RUN_MODE_ONLY = 2;
    private static final short REG_FREQ_REF_MAX = 649;
    private static final short REG_FREQ_REF_MIN = 650;
    private static final short REG_INPUT_VOLTAGE = 768;
    private static final short REG_VF_SELECTION = 770;
    private static final short VF_50HZ = 0;
    private static final short VF_60HZ_SAT = 1;
    private static final short VF_50HZ_SAT = 2;
    private static final short VF_72HZ = 3;
    private static final short VF_50HZ_VT1 = 4;
    private static final short VF_50HZ_VT2 = 5;
    private static final short VF_60HZ_VT1 = 6;
    private static final short VF_60HZ_VT2 = 7;
    private static final short VF_50HZ_HST1 = 8;
    private static final short VF_50HZ_HST2 = 9;
    private static final short VF_60HZ_HST1 = 10;
    private static final short VF_60HZ_HST2 = 11;
    private static final short VF_90HZ = 12;
    private static final short VF_120HZ = 13;
    private static final short VF_180HZ = 14;
    private static final short VF_CUSTOM = 15;
    private static final short REG_NODE_ADDRESS = 1061;
    private static final short REG_BAUD_RATE = 1062;
    private static final short BAUD_RATE_1200 = 0;
    private static final short BAUD_RATE_2400 = 1;
    private static final short BAUD_RATE_4800 = 2;
    private static final short BAUD_RATE_9600 = 3;
    private static final short BAUD_RATE_19200 = 4;
    private static final short BAUD_RATE_38400 = 5;
    private static final short BAUD_RATE_57600 = 6;
    private static final short BAUD_RATE_76800 = 7;
    private static final short BAUD_RATE_115200 = 8;
    private static final short REG_COMM_PARITY = 1063;
    private static final short PARITY_NONE = 0;
    private static final short PARITY_EVEN = 1;
    private static final short PARITY_ODD = 2;
    private static final short REG_ERROR_ACTION = 1064;
    private static final short ERROR_RAMP_STOP = 0;
    private static final short ERROR_COAST_STOP = 1;
    private static final short ERROR_FAST_STOP = 2;
    private static final short ERROR_ALARM_ONLY = 3;
    private static final short REG_COMM_FAULT_DET = 1065;
    private static final short FAULT_DETC_OFF = 0;
    private static final short FAULT_DETC_ON = 1;
    private static final short REG_XMIT_WAIT_TIME = 1066;
    private static final short REG_RTS_CONTROL = 1067;
    private static final short RTS_ALWAYS_ON = 0;
    private static final short RTS_ONLY_ON_SEND = 1;
    private static final short REG_ERROR_DET_TIME = 1077;
    private static final short REG_VOLTAGE_UNITS = 1078;
    private static final short VOLT_UNITS_TENTHS = 0;
    private static final short VOLT_UNITS_ONES = 1;
    private static final short REG_ENTER_FUNC = 1084;
    private static final short ENTER_REQUIRED = 0;
    private static final short ENTER_NOT_REQUIRED = 1;
    private static final short REG_RUN_CMND_TYPE = 1085;
    private static final short RUN_CMND_FWD_REV = 0;
    private static final short RUN_CMND_OPER_DIRN = 1;
    private static final short REG_DRIVE_MODEL = 1288;
    private static final short MODEL_4A0002 = 146;
    private static final short MODEL_4A0004 = 147;
    private static final short MODEL_4A0005 = 148;
    private static final short MODEL_4A0007 = 149;
    private static final short MODEL_4A0009 = 150;
    private static final short REG_ENTER_EEPROM = 2304;
    private static final short REG_ENTER_RAM = 2320;
    private static final short REG_ = 0;
    private static final short z = 0;
    public static final int ALARM_NONE = 0;
    public static final int ALARM_UNDERVOLTAGE = 1;
    public static final int ALARM_OVERVOLTAGE = 2;
    public static final int ALARM_HEATSINK_OVERHEAT = 3;
    public static final int ALARM_DRIVE_OVERHEAT = 4;
    public static final int ALARM_OVERTORQUE_1 = 5;
    public static final int ALARM_OVERTORQUE_2 = 6;
    public static final int ALARM_RUN_INPUT_ERROR = 7;
    public static final int ALARM_DRIVE_BASEBLOCK = 8;
    public static final int ALARM_EXTERNAL_FAULT_3 = 9;
    public static final int ALARM_EXTERNAL_FAULT_4 = 10;
    public static final int ALARM_EXTERNAL_FAULT_5 = 11;
    public static final int ALARM_EXTERNAL_FAULT_6 = 12;
    public static final int ALARM_EXTERNAL_FAULT_7 = 13;
    public static final int ALARM_EXTERNAL_FAULT_8 = 14;
    public static final int ALARM_COOLING_FAN = 15;
    public static final int ALARM_OVERSPEED = 16;
    public static final int ALARM_EXCESS_SPEED_DEVN = 17;
    public static final int ALARM_PG_DISCONNECTED = 18;
    public static final int ALARM_MODBUS_COMM_ERR = 20;
    public static final int ALARM_OPTION_COMM_ERR = 21;
    public static final int ALARM_SERIAL_COMM_ERR = 22;
    public static final int ALARM_MOTOR_OVERLOAD = 23;
    public static final int ALARM_DRIVE_OVERLOAD = 24;
    public static final int ALARM_OPTION_CARD_FAULT = 26;
    public static final int ALARM_SWITCH_DURING_RUN = 27;
    public static final int ALARM_SERIAL_TRANS_ERR = 29;
    public static final int ALARM_UNDERTORQUE_1 = 30;
    public static final int ALARM_UNDERTORQUE_2 = 31;
    public static final int ALARM_MODBUS_TEST_FAULT = 32;
    public static final int ALARM_MOTOR_OVERHEAT = 34;
    public static final int ALARM_PID_FEEDBACK_LOSS = 39;
    public static final int ALARM_PID_EXC_FEEDBACK = 40;
    public static final int ALARM_DRIVE_DISABLED = 42;
    public static final int ALARM_PG_DISCONNECTEDX = 43;
    public static final int ALARM_SI_T3_WATCHDOG = 49;
    public static final int ALARM_SI_T3_ADDR_SETTING = 50;
    public static final int ALARM_SI_T3_CYCLE_SETTING = 51;
    public static final int ALARM_HIGH_CURRENT = 52;
    public static final int ALARM_FAN_MAINT_TIME = 53;
    public static final int ALARM_CAP_MAINT_TIME = 54;
    public static final int ALARM_SI_S_EEPROM_ERROR = 56;
    public static final int ALARM_EXTERNAL_FAULT_1 = 57;
    public static final int ALARM_EXTERNAL_FAULT_2 = 58;
    public static final int ALARM_SAFE_DISABLE_INPUT = 59;
    public static final int ALARM_SAFE_DISABLE_INPUTX = 60;
    public static final int ALARM_MECH_WEAKENING_1 = 61;
    public static final int ALARM_MECH_WEAKENING_2 = 62;
    public static final int ALARM_PLC_1 = 63;
    public static final int ALARM_PLC_2 = 64;
    public static final int ALARM_VOLTAGE_DETC_FAULT = 65;
    public static final int ALARM_IGBT_MAINT_TIME_90 = 66;
    public static final int ALARM_SCBR_MAINT_TIME = 67;
    public static final int ALARM_IGBT_MAINT_TIME_50 = 68;
    public static final int ALARM_MOTOR_OVERHEAT_NTC = 72;
    public static final int ALARM_DRIVE_WORKS_EZ = 73;
    public static final int ALARM_THERMISTOR_DISC = 77;
    private static final Map<Integer, String> alarmDesc = new HashMap<Integer, String>();
    public static final int FAULT_NONE = 0;
    public static final int FAULT_BLOWN_FUSE = 1;
    public static final int FAULT_UNDERVOLTAGE = 2;
    public static final int FAULT_CPS_UNDERVOLTAGE = 3;
    public static final int FAULT_SOFT_CHARGE_CIRCUIT = 4;
    public static final int FAULT_GROUND_FAULT = 6;
    public static final int FAULT_OVERCURRENT = 7;
    public static final int FAULT_OVERVOLTAGE = 8;
    public static final int FAULT_HEATSINK_OVERHEAT = 9;
    public static final int FAULT_HEATSINK_OVERHEAT1 = 10;
    public static final int FAULT_MOTOR_OVERLOAD = 11;
    public static final int FAULT_DRIVE_OVERLOAD = 12;
    public static final int FAULT_OVERTORQUE_1 = 13;
    public static final int FAULT_OVERTORQUE_2 = 14;
    public static final int FAULT_DYN_BRAKING_TRANS = 15;
    public static final int FAULT_BRAKING_RESISTOR = 16;
    public static final int FAULT_EXTERNAL_FAULT_3 = 17;
    public static final int FAULT_EXTERNAL_FAULT_4 = 18;
    public static final int FAULT_EXTERNAL_FAULT_5 = 19;
    public static final int FAULT_EXTERNAL_FAULT_6 = 20;
    public static final int FAULT_EXTERNAL_FAULT_7 = 21;
    public static final int FAULT_EXTERNAL_FAULT_8 = 22;
    public static final int FAULT_COOLING_FAN_FAIL = 23;
    public static final int FAULT_OVERSPEED = 24;
    public static final int FAULT_EXCESS_SPEED_DEVN = 25;
    public static final int FAULT_PG_DISCONNECT = 26;
    public static final int FAULT_INPUT_PHASE_LOSS = 27;
    public static final int FAULT_OUTPUT_PHASE_LOSS = 28;
    public static final int FAULT_MOTOR_OVERHEAT_PTC1 = 29;
    public static final int FAULT_DIGITAL_OPER_CONN = 30;
    public static final int FAULT_EEPROM_WRITE_ERROR = 31;
    public static final int FAULT_MOTOR_OVERHEAT_PTC2 = 32;
    public static final int FAULT_MODBUS_COMM_ERROR = 33;
    public static final int FAULT_OPTION_COMM_ERROR = 34;
    public static final int FAULT_CONTROL = 37;
    public static final int FAULT_ZERO_SERVO = 38;
    public static final int FAULT_OPTION_EXTERNAL = 39;
    public static final int FAULT_PID_FEEDBACK_LOSS = 40;
    public static final int FAULT_UNDERTORQUE_1 = 41;
    public static final int FAULT_UNDERTORQUE_2 = 42;
    public static final int FAULT_HARDWARE = 48;
    public static final int FAULT_OUTPUT_CURR_IMBAL = 54;
    public static final int FAULT_PG_HARDWARE = 56;
    public static final int FAULT_EXCESS_SS_RESTARTS = 59;
    public static final int FAULT_EXC_PID_FEEDBACK = 65;
    public static final int FAULT_EXTERNAL_FAULT_1 = 66;
    public static final int FAULT_EXTERNAL_FAULT_2 = 67;
    public static final int FAULT_MECH_WEAKENING_1 = 68;
    public static final int FAULT_MECH_WEAKENING_2 = 69;
    public static final int FAULT_CURRENT_OFFSET = 70;
    public static final int FAULT_PLC_ERROR_1 = 71;
    public static final int FAULT_PLC_ERROR_2 = 72;
    public static final int FAULT_DRIVEWORKS_EZ = 73;
    public static final int FAULT_OUTPUT_VOLT_DETC = 77;
    public static final int FAULT_MOTOR_OVERHEAT_NTC = 80;
    public static final int FAULT_NODE_SETUP = 82;
    public static final int FAULT_THERMISTOR_DISC = 83;
    public static final int FAULT_CURR_UNBALANCE = 96;
    public static final int FAULT_PS_UNDERVOLTAGE = 97;
    public static final int FAULT_MC_FAN_POWER_FAIL = 98;
    public static final int FAULT_THERMAL_CONVERTER = 99;
    public static final int FAULT_ABNORMAL_FAN_DIODE = 100;
    public static final int FAULT_ABNORMAL_FAN_PANEL = 101;
    public static final int FAULT_AD_CONV_ERROR_1 = 131;
    public static final int FAULT_PWM_FEEDBACK = 132;
    public static final int FAULT_EEPROM_DATA_ERROR = 135;
    public static final int FAULT_TERM_BOARD_CONN_ERR = 136;
    public static final int FAULT_EEPROM_SERIAL_COMM = 137;
    public static final int FAULT_RAM_FAULT = 140;
    public static final int FAULT_FLASH_MEM_EXCPTN = 141;
    public static final int FAULT_WATCHDOG_EXCPTN = 142;
    public static final int FAULT_CONTROL_CIRCUIT_1 = 143;
    public static final int FAULT_CLOCK_FAULT = 145;
    public static final int FAULT_TIMING_FAULT = 146;
    public static final int FAULT_CONTROL_CIRCUIT_2 = 147;
    public static final int FAULT_CONTROL_CIRCUIT_3 = 148;
    public static final int FAULT_HW_FAULT_POWERUP = 149;
    public static final int FAULT_HW_FAULT_COMM_START = 150;
    public static final int FAULT_AD_CONV_FAULT = 151;
    public static final int FAULT_PWM_FEEDBACK_FAULT = 152;
    public static final int FAULT_DRIVE_SIGNAL_FAULT = 153;
    public static final int FAULT_ASIC_BB_CIRC_ERROR = 155;
    public static final int FAULT_ASIC_PWM_SET_ERROR = 156;
    public static final int FAULT_ASIC_PWM_PATT_ERROR = 157;
    public static final int FAULT_ASIC_ONDELAY_ERROR = 158;
    public static final int FAULT_ASIC_BBON_ERROR = 159;
    public static final int FAULT_ASIC_CODE_ERROR = 160;
    public static final int FAULT_ASIC_STARTUP_ERROR = 161;
    public static final int FAULT_WATCHDOG_ERROR = 162;
    public static final int FAULT_ASIC_POWER_ERROR = 163;
    public static final int FAULT_EXT_AD_CONV_ERROR = 164;
    public static final int FAULT_CONTROL_CIRC_ERR_1 = 169;
    public static final int FAULT_CONTROL_CIRC_ERR_2 = 170;
    public static final int FAULT_CONTROL_CIRC_ERR_3 = 171;
    public static final int FAULT_CONTROL_CIRC_ERR_4 = 172;
    public static final int FAULT_CONTROL_CIRC_ERR_5 = 173;
    public static final int FAULT_CONTROL_CIRC_ERR_6 = 174;
    public static final int FAULT_OPTION_COMPAT_ERR_A = 257;
    public static final int FAULT_OPTION_CONN_ERR_A = 258;
    public static final int FAULT_DUPL_OPTION_ERR_A = 259;
    public static final int FAULT_AD_CONV_ERROR_A = 262;
    public static final int FAULT_OPTION_RESP_ERR_A = 263;
    public static final int FAULT_OPTION_RAM_FAULT_A = 273;
    public static final int FAULT_OPTION_OPMODE_FAULT_A = 274;
    public static final int FAULT_DRIVE_RCV_CRC_ERR_A = 275;
    public static final int FAULT_DRIVE_RCV_FRAME_ERR_A = 276;
    public static final int FAULT_DRIVE_RCV_ABORT_ERR_A = 277;
    public static final int FAULT_OPTION_RCV_CRC_ERR_A = 278;
    public static final int FAULT_OPTION_RCV_FRAME_ERR_A = 279;
    public static final int FAULT_OPTION_RCV_ABORT_ERR_A = 280;
    public static final int FAULT_COMM_ID_ERR_A = 305;
    public static final int FAULT_MODEL_CODE_ERR_A = 306;
    public static final int FAULT_CHECKSUM_ERR_A = 307;
    public static final int FAULT_OPTION_TIMEOUT_A = 308;
    public static final int FAULT_MODBUS_TIMEOUT_A = 309;
    public static final int FAULT_DRIVE_TIMEOUT1_A = 310;
    public static final int FAULT_CI_CHECK_ERR_A = 311;
    public static final int FAULT_DRIVE_TIMEOUT2_A = 312;
    public static final int FAULT_CTRL_COMMMAND_ERR_A = 313;
    public static final int FAULT_DRIVE_TIMEOUT3_A = 314;
    public static final int FAULT_CTRL_RESP_ERR1_A = 315;
    public static final int FAULT_DRIVE_TIMEOUT4_A = 316;
    public static final int FAULT_CTRL_RESP_ERR2_A = 317;
    public static final int FAULT_CTRL_RESP_ERR3_A = 318;
    public static final int FAULT_OPTION_CONN_ERR_B = 513;
    public static final int FAULT_DUPL_OPTION_ERR_B = 514;
    public static final int FAULT_AD_CONV_ERR_B = 517;
    public static final int FAULT_OPTION_RESP_ERR_B = 518;
    public static final int FAULT_OPTION_RAM_FAULT_B = 528;
    public static final int FAULT_OPTION_OPMODE_FAULT_B = 529;
    public static final int FAULT_DRIVE_RCV_CRC_ERR_B = 530;
    public static final int FAULT_DRIVE_RCV_FRAME_ERR_B = 531;
    public static final int FAULT_DRIVE_RCV_ABORT_ERR_B = 532;
    public static final int FAULT_OPTION_RCV_CRC_ERR_B = 533;
    public static final int FAULT_OPTION_RCV_FRAME_ERR_B = 534;
    public static final int FAULT_OPTION_RCV_ABORT_ERR_B = 535;
    public static final int FAULT_COMM_ID_ERROR_B = 561;
    public static final int FAULT_MODEL_CODE_ERR_B = 562;
    public static final int FAULT_CHECKSUM_ERR_B = 563;
    public static final int FAULT_OPTION_TIMEOUT_B = 564;
    public static final int FAULT_MODBUS_TIMEOUT_B = 565;
    public static final int FAULT_DRIVE_TIMEOUT1_B = 566;
    public static final int FAULT_CI_CHECK_ERROR_B = 567;
    public static final int FAULT_DRIVE_TIMEOUT2_B = 568;
    public static final int FAULT_CTRL_COMMMAND_ERR_B = 569;
    public static final int FAULT_DRIVE_TIMEOUT3_B = 570;
    public static final int FAULT_CTRL_RESP_ERR1_B = 571;
    public static final int FAULT_DRIVE_TIMEOUT4_B = 572;
    public static final int FAULT_CTRL_RESP_ERR2_B = 573;
    public static final int FAULT_CTRL_RESP_ERR3_B = 574;
    public static final int FAULT_OPTION_COMPAT_ERR_C = 768;
    public static final int FAULT_OPTION_CONN_ERR_C = 769;
    public static final int FAULT_DUPL_OPTION_ERR_C = 770;
    public static final int FAULT_AD_CONV_ERR_C = 773;
    public static final int FAULT_OPTION_RESP_ERR_C = 774;
    private static final Map<Integer, String> faultDesc;
    private static final Map<Language, Short> languageEnumMap;
    private static final Map<Short, Language> languageValueMap;
    private static final Map<AccessLevel, Short> accessLevelEnumMap;
    private static final Map<Short, AccessLevel> accessLevelValueMap;
    private static final Map<ControlMode, Short> controlModeEnumMap;
    private static final Map<Short, ControlMode> controlModeValueMap;
    private static final Map<FreqRefSrc, Short> freqRefSrcEnumMap;
    private static final Map<Short, FreqRefSrc> freqRefSrcValueMap;
    private static final Map<RunCmndSrc, Short> runCmndSrcEnumMap;
    private static final Map<Short, RunCmndSrc> runCmndSrcValueMap;
    private static final Map<StopMethod, Short> stopMethodEnumMap;
    private static final Map<Short, StopMethod> stopMethodValueMap;
    private static final Map<RunProg, Short> runProgEnumMap;
    private static final Map<Short, RunProg> runProgValueMap;
    private static final Map<BaudRate, Short> baudRateEnumMap;
    private static final Map<Short, BaudRate> baudRateValueMap;
    private static final Map<Parity, Short> parityEnumMap;
    private static final Map<Short, Parity> parityValueMap;
    private static final Map<ErrorAction, Short> errorActionEnumMap;
    private static final Map<Short, ErrorAction> errorActionValueMap;
    private static final Map<VoltageUnits, Short> voltageUnitsEnumMap;
    private static final Map<Short, VoltageUnits> voltageUnitsValueMap;
    private static final Map<VfSelection, Short> vfSelectionEnumMap;
    private static final Map<Short, VfSelection> vfSelectionValueMap;
    private static final Map<Short, String> modelNameMap;
    private static final Map<Short, Double> ratedCurrentMap;
    private static final int BAUD_RATE = 115200;
    private static final int DEVC_ADDR = 31;
    private static final short ZERO = 0;
    private static final short ONE = 1;
    private static final short TWO = 2;
    private static final int EXCP_BIT_COUNT = 3;
    private static final int EXCP_SET_DATA = 33;
    private static final int EXCP_WRITE_MODE = 34;
    private static final int EXCP_BUS_UNDERVOLT = 35;
    private static final int EXCP_WRITE_PARAM = 36;
    private static final int EXCP_WRITE_EEPROM = 37;
    private static final Map<Integer, String> excpMap;
    private static final double VOLT_UNITS = 0.1;
    private static final double FREQ_UNITS = 0.01;
    private static final double FREQ_LIMIT_UNITS = 0.1;
    private final Modbus mbus;
    private short devcAddr;
    private double ratedCurrent;
    private VoltageUnits voltageUnits = VoltageUnits.TENTHS;
    private boolean runCmndFwdRev = true;

    public A1000() {
        this.mbus = new Modbus();
        this.mbus.setOptions(Ascii.Option.NO_NET);
        this.mbus.setDefaultBaud(115200);
        this.mbus.setAddressMode(true);
        this.mbus.setExceptionMap(excpMap);
    }

    public void open(String device, int address, int baudRate, int dataChar) throws DriverException {
        this.mbus.open(Modbus.ConnType.SERIAL, device, baudRate, dataChar);
        this.devcAddr = address != 0 ? (int)address : 31;
        try {
            this.ratedCurrent = this.getRatedCurrent();
        }
        catch (DriverException e) {
            this.mbus.closeSilent();
            throw e;
        }
    }

    public void open(String device, int address, int baudRate) throws DriverException {
        this.open(device, address, baudRate, 0);
    }

    public void open(String device, int address) throws DriverException {
        this.open(device, address, 115200);
    }

    public void open(String device) throws DriverException {
        this.open(device, 31);
    }

    public void close() throws DriverException {
        this.mbus.close();
    }

    public short[] readRegisters(short addr, short count) throws DriverException {
        return this.mbus.readRegisters(this.devcAddr, addr, count);
    }

    public int readRegister(short addr) throws DriverException {
        return this.mbus.readRegisters(this.devcAddr, addr, (short)1)[0];
    }

    public void writeRegister(short addr, short value) throws DriverException {
        this.mbus.writeRegisters(this.devcAddr, addr, new short[]{value});
    }

    public void writeRegisters(short addr, short[] value) throws DriverException {
        this.mbus.writeRegisters(this.devcAddr, addr, value);
    }

    public void enterParameters() throws DriverException {
        this.writeRegister((short)2320, (short)0);
    }

    public void saveParameters() throws DriverException {
        this.writeRegister((short)2304, (short)0);
    }

    public void setNodeAddress(int address) throws DriverException {
        this.writeRegister((short)1061, (short)address);
    }

    public int getNodeAddress() throws DriverException {
        return this.readRegister((short)1061);
    }

    public void setBaudRate(BaudRate rate) throws DriverException {
        this.writeRegister((short)1062, baudRateEnumMap.get((Object)rate));
    }

    public BaudRate getBaudRate() throws DriverException {
        return baudRateValueMap.get((short)this.readRegister((short)1062));
    }

    public void setParity(Parity parity) throws DriverException {
        this.writeRegister((short)1063, parityEnumMap.get((Object)parity));
    }

    public Parity getParity() throws DriverException {
        return parityValueMap.get((short)this.readRegister((short)1063));
    }

    public String getModelName() throws DriverException {
        return modelNameMap.get((short)this.readRegister((short)1288));
    }

    public double getRatedCurrent() throws DriverException {
        return ratedCurrentMap.get((short)this.readRegister((short)1288));
    }

    public void setLocalControl() throws DriverException {
        this.setRunCmndSrc(RunCmndSrc.DIGITAL);
        this.setFreqRefSrc(FreqRefSrc.ANALOG);
        this.enterParameters();
    }

    public void setRemoteControl() throws DriverException {
        this.setRunCmndSrc(RunCmndSrc.MODBUS);
        this.setFreqRefSrc(FreqRefSrc.MODBUS);
        this.enterParameters();
    }

    public void setAccessLevel(AccessLevel level) throws DriverException {
        this.writeRegister((short)257, accessLevelEnumMap.get((Object)level));
    }

    public AccessLevel getAccessLevel() throws DriverException {
        return accessLevelValueMap.get((short)this.readRegister((short)257));
    }

    public void setControlMode(ControlMode mode) throws DriverException {
        this.writeRegister((short)258, controlModeEnumMap.get((Object)mode));
    }

    public ControlMode getControlMode() throws DriverException {
        return controlModeValueMap.get((short)this.readRegister((short)258));
    }

    public void setFreqRefSrc(FreqRefSrc src) throws DriverException {
        this.writeRegister((short)384, freqRefSrcEnumMap.get((Object)src));
    }

    public FreqRefSrc getFreqRefSrc() throws DriverException {
        return freqRefSrcValueMap.get((short)this.readRegister((short)384));
    }

    public void setRunCmndSrc(RunCmndSrc src) throws DriverException {
        this.writeRegister((short)385, runCmndSrcEnumMap.get((Object)src));
    }

    public RunCmndSrc getRunCmndSrc() throws DriverException {
        return runCmndSrcValueMap.get((short)this.readRegister((short)385));
    }

    public void setStopMethod(StopMethod method) throws DriverException {
        this.writeRegister((short)386, stopMethodEnumMap.get((Object)method));
    }

    public StopMethod getStopMethod() throws DriverException {
        return stopMethodValueMap.get((short)this.readRegister((short)386));
    }

    public void setRunProg(RunProg runProg) throws DriverException {
        this.writeRegister((short)391, runProgEnumMap.get((Object)runProg));
    }

    public RunProg getRunProg() throws DriverException {
        return runProgValueMap.get((short)this.readRegister((short)391));
    }

    public void setErrorAction(ErrorAction action) throws DriverException {
        this.writeRegister((short)1064, errorActionEnumMap.get((Object)action));
    }

    public ErrorAction getErrorAction() throws DriverException {
        return errorActionValueMap.get((short)this.readRegister((short)1064));
    }

    public void setReversePermitted(boolean permit) throws DriverException {
        this.writeRegister((short)387, permit ? (short)0 : 1);
    }

    public boolean isReversePermitted() throws DriverException {
        return this.readRegister((short)387) == 0;
    }

    public void setFaultDetected(boolean detect) throws DriverException {
        this.writeRegister((short)1065, detect ? (short)1 : 0);
    }

    public boolean isFaultDetected() throws DriverException {
        return this.readRegister((short)1065) == 1;
    }

    public void setEnterRequired(boolean require) throws DriverException {
        this.writeRegister((short)1084, require ? (short)0 : 1);
    }

    public boolean isEnterRequired() throws DriverException {
        return this.readRegister((short)1084) == 0;
    }

    public void setRunCmndFwdRev(boolean fwdRev) throws DriverException {
        this.writeRegister((short)1085, fwdRev ? (short)0 : 1);
        this.runCmndFwdRev = fwdRev;
    }

    public boolean isRunCmndFwdRev() throws DriverException {
        return this.readRegister((short)1085) == 0;
    }

    public void setVoltageUnits(VoltageUnits units) throws DriverException {
        this.writeRegister((short)1078, voltageUnitsEnumMap.get((Object)units));
        this.voltageUnits = units;
    }

    public VoltageUnits getVoltageUnits() throws DriverException {
        return voltageUnitsValueMap.get((short)this.readRegister((short)1078));
    }

    public void setInputVoltage(double voltage) throws DriverException {
        this.writeRegister((short)768, (short)voltage);
    }

    public double getInputVoltage() throws DriverException {
        return this.readRegister((short)768);
    }

    public void setVfSelection(VfSelection level) throws DriverException {
        this.writeRegister((short)770, vfSelectionEnumMap.get((Object)level));
    }

    public VfSelection getVfSelection() throws DriverException {
        return vfSelectionValueMap.get((short)this.readRegister((short)770));
    }

    public void setMaxFrequency(double freqPct) throws DriverException {
        this.writeRegister((short)649, (short)(freqPct / 0.1));
    }

    public double getMaxFrequency() throws DriverException {
        return 0.1 * (double)this.readRegister((short)649);
    }

    public void setMinFrequency(double freqPct) throws DriverException {
        this.writeRegister((short)650, (short)(freqPct / 0.1));
    }

    public double getMinFrequency() throws DriverException {
        return 0.1 * (double)this.readRegister((short)650);
    }

    public void setFrequency(double freq) throws DriverException {
        this.writeRegister((short)2, (short)(freq / 0.01));
    }

    public double getFrequency() throws DriverException {
        return 0.01 * (double)this.readRegister((short)2);
    }

    public double getFrequencyApp() throws DriverException {
        return 0.01 * (double)this.readRegister((short)64);
    }

    public double readFrequency() throws DriverException {
        return 0.01 * (double)this.readRegister((short)65);
    }

    public double readVoltage() throws DriverException {
        return 0.1 * (double)this.readRegister((short)69);
    }

    public double readCurrent() throws DriverException {
        return this.ratedCurrent / 8192.0 * (double)this.readRegister((short)66);
    }

    public double readBusVoltage() throws DriverException {
        return this.readRegister((short)70);
    }

    public double readTemperature() throws DriverException {
        return this.readRegister((short)104);
    }

    public int getOperationTime() throws DriverException {
        return this.readRegister((short)76);
    }

    public void setOperationTime(int time) throws DriverException {
        this.writeRegister((short)1291, (short)(time / 10));
    }

    public void setOpTimeActive(boolean isActvTime) throws DriverException {
        this.writeRegister((short)1292, isActvTime ? (short)1 : 0);
    }

    public boolean isOpTimeActive() throws DriverException {
        return this.readRegister((short)1292) != 0;
    }

    public int getFanOperationTime() throws DriverException {
        return this.readRegister((short)103);
    }

    public void setFanOperationTime(int time) throws DriverException {
        this.writeRegister((short)1294, (short)(time / 10));
    }

    public int getRunCount() throws DriverException {
        return this.readRegister((short)117);
    }

    public double getOutputKwh() throws DriverException {
        short[] values = this.readRegisters((short)92, (short)2);
        return 0.1 * (double)values[0] + 100.0 * (double)values[1];
    }

    public double getFanLifetimeUsed() throws DriverException {
        return (double)this.readRegister((short)126) / 100.0;
    }

    public double getCapLifetimeUsed() throws DriverException {
        return (double)this.readRegister((short)124) / 100.0;
    }

    public void setCapLifetimeUsed(double fract) throws DriverException {
        this.writeRegister((short)1309, (short)(100.0 * fract));
    }

    public double getScbrLifetimeUsed() throws DriverException {
        return (double)this.readRegister((short)2006) / 100.0;
    }

    public void setScbrLifetimeUsed(double fract) throws DriverException {
        this.writeRegister((short)1315, (short)(100.0 * fract));
    }

    public double getIgbtLifetimeUsed() throws DriverException {
        return (double)this.readRegister((short)2007) / 100.0;
    }

    public void setIgbtLifetimeUsed(double fract) throws DriverException {
        this.writeRegister((short)1317, (short)(100.0 * fract));
    }

    public void flashLeds() throws DriverException {
        this.readRegister((short)94);
    }

    public int getDriveStatus() throws DriverException {
        return this.readRegister((short)75) & 0xFF;
    }

    public void runForward() throws DriverException {
        this.writeRegister((short)1, (short)1);
    }

    public void runReverse() throws DriverException {
        this.writeRegister((short)1, this.runCmndFwdRev ? (short)2 : 3);
    }

    public void stop() throws DriverException {
        this.writeRegister((short)1, (short)0);
    }

    public int getAlarmCode() throws DriverException {
        return this.readRegister((short)127);
    }

    public Set<Integer> getAlarmCodes() throws DriverException {
        HashSet<Integer> alarmSet = new HashSet<Integer>();
        short[] alarmBits = this.readRegisters((short)200, (short)5);
        for (int j = 0; j < 5; ++j) {
            short bits = alarmBits[j];
            for (int k = 0; bits != 0 && k < 16; bits = (short)(bits >>> 1), ++k) {
                if ((bits & 1) == 0) continue;
                alarmSet.add(16 * j + k + 1);
            }
        }
        return alarmSet;
    }

    public String getAlarmDesc() throws DriverException {
        int code = this.getAlarmCode();
        return code == 0 ? null : A1000.getAlarmDesc(code);
    }

    public static String getAlarmDesc(int code) {
        String text = alarmDesc.get(code);
        if (text == null) {
            text = String.format("Undefined alarm code: 0x%04x", code);
        }
        return text;
    }

    public static Set<Integer> getAllAvailableAlarmCodes() {
        return alarmDesc.keySet();
    }

    public int getCurrFaultCode() throws DriverException {
        return this.readRegister((short)128);
    }

    public int getPrevFaultCode() throws DriverException {
        return this.readRegister((short)129);
    }

    public String getCurrFaultDesc() throws DriverException {
        int code = this.getCurrFaultCode();
        return code == 0 ? null : A1000.getFaultDesc(code);
    }

    public String getPrevFaultDesc() throws DriverException {
        int code = this.getPrevFaultCode();
        return code == 0 ? null : A1000.getFaultDesc(code);
    }

    public static String getFaultDesc(int code) {
        String text = faultDesc.get(code);
        if (text == null) {
            text = String.format("Undefined fault code: 0x%04x", code);
        }
        return text;
    }

    public static Set<Integer> getAllAvailableFaultCodes() {
        return faultDesc.keySet();
    }

    public void resetFault() throws DriverException {
        this.writeRegister((short)1, (short)8);
    }

    static {
        alarmDesc.put(1, "Undervoltage (Uv)");
        alarmDesc.put(2, "Overvoltage (ov)");
        alarmDesc.put(3, "Heatsink overheat (oH)");
        alarmDesc.put(4, "Drive overheat (oH2)");
        alarmDesc.put(5, "Overtorque 1 (oL3)");
        alarmDesc.put(6, "Overtorque 2 (oL4)");
        alarmDesc.put(7, "Run commands input error (EF)");
        alarmDesc.put(8, "Drive baseblock (bb)");
        alarmDesc.put(9, "External fault 3, input terminal S3 (EF3)");
        alarmDesc.put(10, "External fault 4, input terminal S4 (EF4)");
        alarmDesc.put(11, "External fault 5, input terminal S5 (EF5)");
        alarmDesc.put(12, "External fault 6, input terminal S6 (EF6)");
        alarmDesc.put(13, "External fault 7, input terminal S7 (EF7)");
        alarmDesc.put(14, "External fault 8, input terminal S8 (EF8)");
        alarmDesc.put(15, "Cooling fan error (FAN)");
        alarmDesc.put(16, "Overspeed (oS)");
        alarmDesc.put(17, "Excessive speed deviation (dEv");
        alarmDesc.put(18, "PG disconnected (PGo)");
        alarmDesc.put(20, "Modbus communication error (cE)");
        alarmDesc.put(21, "Option communication error (bUS)");
        alarmDesc.put(22, "Serial communication transmission error (CALL)");
        alarmDesc.put(23, "Motor overload (oL1)");
        alarmDesc.put(24, "Drive overload (oL2)");
        alarmDesc.put(26, "Option card external fault (EF0)");
        alarmDesc.put(27, "Motor command switch input during run (rUN)");
        alarmDesc.put(29, "Serial communication transmission error (CALL)");
        alarmDesc.put(30, "Undertorque detection 1 (UL3)");
        alarmDesc.put(31, "Undertorque detection 2 (UL4)");
        alarmDesc.put(32, "Modbus test mode fault (SE)");
        alarmDesc.put(34, "Motor overheat (oH3)");
        alarmDesc.put(39, "PID feedback loss (FbL)");
        alarmDesc.put(40, "Excessive PID feedback (FbH)");
        alarmDesc.put(42, "Drive disabled (dnE)");
        alarmDesc.put(43, "PG disconnected (PGo)");
        alarmDesc.put(49, "S!-T3 watchdog error (E5)");
        alarmDesc.put(50, "S!-T3 station address setting error (AEr)");
        alarmDesc.put(51, "SI-T3 comm. cycle setting error (CyC)");
        alarmDesc.put(52, "High current (HCA)");
        alarmDesc.put(53, "Cooling fan maintenance time (LT-1)");
        alarmDesc.put(54, "Capacitor maintenance time (LT-2)");
        alarmDesc.put(56, "SI-S EEPROM error (EEP)");
        alarmDesc.put(57, "External fault 1, input terminal S1 (EF1)");
        alarmDesc.put(58, "External fault 2, input terminal S2 (EF2)");
        alarmDesc.put(59, "Safe disable input (HbbF)");
        alarmDesc.put(60, "Safe disable input (Hbb)");
        alarmDesc.put(61, "Mechanical weakening detection 1 (oL5)");
        alarmDesc.put(62, "Mechanical weakening detection 2 (UL5)");
        alarmDesc.put(63, "PLC alarm (PA1)");
        alarmDesc.put(64, "PLC alarm (PA2)");
        alarmDesc.put(65, "Output voltage detection fault (voF)");
        alarmDesc.put(66, "IGBT maintenance time (90%) (TrPC)");
        alarmDesc.put(67, "Soft charge bypass relay maint. time (LT-3)");
        alarmDesc.put(68, "IGBT maintenance time (50%) (LT-4)");
        alarmDesc.put(72, "Motor overheat (NTC input) (oH5)");
        alarmDesc.put(73, "DriveWorks EZ alarm (dWAL)");
        alarmDesc.put(77, "Thermistor disconnect (THo)");
        faultDesc = new HashMap<Integer, String>();
        faultDesc.put(1, "Blown fuse (PUF)");
        faultDesc.put(2, "Undervoltage (Uv1)");
        faultDesc.put(3, "Control p[ower supply undervoltage (Uv2)");
        faultDesc.put(4, "Soft charge circuit fault (Uv3)");
        faultDesc.put(6, "Ground fault (GF)");
        faultDesc.put(7, "Overcurrent (oC)");
        faultDesc.put(8, "Overvoltage (ov)");
        faultDesc.put(9, "Heatsink overheat (oH)");
        faultDesc.put(10, "Heatsink overheat (oH1)");
        faultDesc.put(11, "Motor overload (oL1)");
        faultDesc.put(12, "Drive overload (oL2)");
        faultDesc.put(13, "Overtorque 1 (oL3)");
        faultDesc.put(14, "Overtorque 2 (oL4)");
        faultDesc.put(15, "Dynamic braking transistor (rr)");
        faultDesc.put(16, "Braking resistor (rH)");
        faultDesc.put(17, "External fault at input terminal S3 (EF3)");
        faultDesc.put(18, "External fault at input terminal S4 (EF4)");
        faultDesc.put(19, "External fault at input terminal S5 (EF5)");
        faultDesc.put(20, "External fault at input terminal S6 (EF6)");
        faultDesc.put(21, "External fault at input terminal S7 (EF7)");
        faultDesc.put(22, "External fault at input terminal S8 (EF8)");
        faultDesc.put(23, "Drive cooling fan failure (FAn)");
        faultDesc.put(24, "Overspeed (oS)");
        faultDesc.put(25, "Excessive speed deviation (dEv)");
        faultDesc.put(26, "PG disconnect (PGo)");
        faultDesc.put(27, "Input phase loss (PF)");
        faultDesc.put(28, "Output phase loss (LF)");
        faultDesc.put(29, "Motor overheat (PTC input) (oH3)");
        faultDesc.put(30, "Digital operator connection (oPr)");
        faultDesc.put(31, "EEPROM write error (Err)");
        faultDesc.put(32, "Motor overheat (PTC input) (oH4)");
        faultDesc.put(33, "Modbus commuication error (CE)");
        faultDesc.put(34, "Option communication error (bUS)");
        faultDesc.put(37, "Control fault (CF)");
        faultDesc.put(38, "Zero-server fault (SvE)");
        faultDesc.put(39, "Option external fault (EF0)");
        faultDesc.put(40, "PID feedback loss (FbL)");
        faultDesc.put(41, "Undertorque 1 (UL3)");
        faultDesc.put(42, "Undertorque 2 (UL4)");
        faultDesc.put(48, "Hardware fault (including oFx)");
        faultDesc.put(54, "Output current imbalance (LF2)");
        faultDesc.put(56, "PG hardware fault (PGoH)");
        faultDesc.put(59, "Too many speed search restarts (SEr)");
        faultDesc.put(65, "Excessive PID feedback (FbH)");
        faultDesc.put(66, "External fault at input terminal S1 (EF1)");
        faultDesc.put(67, "External fault at input terminal S2 (EF2)");
        faultDesc.put(68, "Mechanical weakening 1 (oL5)");
        faultDesc.put(69, "Mechanical weakening 2 (UL5)");
        faultDesc.put(70, "Current offset fault (CoF)");
        faultDesc.put(71, "PLC error 1 (PE1)");
        faultDesc.put(72, "PLC error 2 (PE2)");
        faultDesc.put(73, "DriveWorks EZ fault (dWFL)");
        faultDesc.put(77, "Output voltage detection fault (voF)");
        faultDesc.put(80, "Motor overheat (NTC inout) (oH5)");
        faultDesc.put(82, "Node setup fault (nSE)");
        faultDesc.put(83, "Thermistor disconnect (THo)");
        faultDesc.put(96, "Current unbalance (UnbC)");
        faultDesc.put(97, "Power supply module undervoltage (Uv4)");
        faultDesc.put(98, "MC fan power failure (Uv5)");
        faultDesc.put(99, "Thermal converter fault (oH6)");
        faultDesc.put(100, "Abnormal fan diode module (dFAn)");
        faultDesc.put(101, "Abnormal fan panel (EFAn)");
        faultDesc.put(131, "A/D conversion fault (CPF02)");
        faultDesc.put(132, "PWM feedback fault (CPF03)");
        faultDesc.put(135, "EEPROM data error (CPF06)");
        faultDesc.put(136, "Terminal board connection error (CPF07)");
        faultDesc.put(137, "EEPROM serial communication fault (CPF08)");
        faultDesc.put(140, "RAM fault (CPF11)");
        faultDesc.put(141, "Flash memory exception (CPF12)");
        faultDesc.put(142, "Watchdog exception (CPF13)");
        faultDesc.put(143, "Control circuit fault (CPF14)");
        faultDesc.put(145, "Clock fault (CPF16)");
        faultDesc.put(146, "Timing fault (CPF17)");
        faultDesc.put(147, "Control circuit fault (CPF18)");
        faultDesc.put(148, "Control circuit fault (CPF19)");
        faultDesc.put(149, "Hardware fault at power-up (CPF20)");
        faultDesc.put(150, "Hardware fault at communication startup (CPF21)");
        faultDesc.put(151, "A/D conversion fault (CPF22)");
        faultDesc.put(152, "PWM feedback fault (CPF23)");
        faultDesc.put(153, "Drive unit signal fault (CPF24)");
        faultDesc.put(155, "ASIC BB circuit error (CPF26)");
        faultDesc.put(156, "ASIC PWM setting register error (CPF27)");
        faultDesc.put(157, "ASIC PWM pattern error (CPF28)");
        faultDesc.put(158, "ASIC on-delay error (CPF29)");
        faultDesc.put(159, "ASIC BBON error (CPF30)");
        faultDesc.put(160, "ASIC code error (CPF31)");
        faultDesc.put(161, "ASIC startup error (CPF32)");
        faultDesc.put(162, "Watchdog error (CPF33)");
        faultDesc.put(163, "ASIC power clock error (CPF34)");
        faultDesc.put(164, "External A/D conversion error (CPF35)");
        faultDesc.put(169, "Control circuit error (CPF40)");
        faultDesc.put(170, "Control circuit error (CPF41)");
        faultDesc.put(171, "Control circuit error (CPF42)");
        faultDesc.put(172, "Control circuit error (CPF43)");
        faultDesc.put(173, "Control circuit error (CPF44)");
        faultDesc.put(174, "Control circuit error (CPF45)");
        faultDesc.put(257, "Option compatibility error (oFA00)");
        faultDesc.put(258, "Option not properly connected (oFA01)");
        faultDesc.put(259, "Option of same type already connected (oFA02)");
        faultDesc.put(262, "A/D conversion error (oFA05)");
        faultDesc.put(263, "Option response error (oFA06)");
        faultDesc.put(273, "Option RAM fault (oFA10)");
        faultDesc.put(274, "Option operation mode fault (SLMOD) (oFA11)");
        faultDesc.put(275, "Drive receive CRC error (oFA12)");
        faultDesc.put(276, "Drive reveive frsme error (oFA13)");
        faultDesc.put(277, "Drive receive abort error (oFA14)");
        faultDesc.put(278, "Option receive CRC error (oFA15)");
        faultDesc.put(279, "Option receive frame error (oFA16)");
        faultDesc.put(280, "Option receive abort error (oFA17)");
        faultDesc.put(305, "Communication ID error (oFA30)");
        faultDesc.put(306, "Model code error (oFA31)");
        faultDesc.put(307, "Checksum error (oFA32)");
        faultDesc.put(308, "Option response timeout (oFA33)");
        faultDesc.put(309, "Modbus timeout (oFA34)");
        faultDesc.put(310, "Drive response timeout (oFA35)");
        faultDesc.put(311, "CI check error (oFA36)");
        faultDesc.put(312, "Drive response timeout (oFA37)");
        faultDesc.put(313, "Control command selection error (oFA38)");
        faultDesc.put(314, "Drive response timeout (oFA39)");
        faultDesc.put(315, "Control response selection 1 error (oFA40)");
        faultDesc.put(316, "Drive response timeout (oFA41)");
        faultDesc.put(317, "Control rsponse election 2 error (oFA42)");
        faultDesc.put(318, "Control response selection error (oFA43)");
        faultDesc.put(513, "Option not properly connected (oFb01)");
        faultDesc.put(514, "Option of same type already connected (oFb02)");
        faultDesc.put(517, "A/D conversion error (oFb05)");
        faultDesc.put(518, "Option response error (oFb06)");
        faultDesc.put(528, "Option RAM fault (oFb10)");
        faultDesc.put(529, "Option operation mode fault (SLMOD) (oFb11)");
        faultDesc.put(530, "Drive receive CRC error (oFb12)");
        faultDesc.put(531, "Drive reveive frsme error (oFb13)");
        faultDesc.put(532, "Drive receive abort error (oFb14)");
        faultDesc.put(533, "Option receive CRC error (oFb15)");
        faultDesc.put(534, "Option receive frame error (oFb16)");
        faultDesc.put(535, "Option receive abort error (oFb17)");
        faultDesc.put(561, "Communication ID error (oFb30)");
        faultDesc.put(562, "Model code error (oFb31)");
        faultDesc.put(563, "Checksum error (oFb32)");
        faultDesc.put(564, "Option response timeout (oFb33)");
        faultDesc.put(565, "Modbus timeout (oFb34)");
        faultDesc.put(566, "Drive response timeout (oFb35)");
        faultDesc.put(567, "CI check error (oFb36)");
        faultDesc.put(568, "Drive response timeout (oFb35)");
        faultDesc.put(569, "Control command selection error (oFb38)");
        faultDesc.put(570, "Drive response timeout (oFb39)");
        faultDesc.put(571, "Control response selection 1 error (oFb40)");
        faultDesc.put(572, "Drive response timeout (oFb41)");
        faultDesc.put(573, "Control response election 2 error (oFb42)");
        faultDesc.put(574, "Control response selection error (oFb43)");
        faultDesc.put(768, "Option compatibility error (oFC00)");
        faultDesc.put(769, "Option not properly connected (oFC01)");
        faultDesc.put(770, "Option of same type already connected (oFC02)");
        faultDesc.put(773, "A/D conversion error (oFC05)");
        faultDesc.put(774, "Option response error (oFC06)");
        languageEnumMap = new HashMap<Language, Short>();
        languageValueMap = new HashMap<Short, Language>();
        languageEnumMap.put(Language.ENGLISH, (short)0);
        for (Map.Entry<Language, Short> entry : languageEnumMap.entrySet()) {
            languageValueMap.put(entry.getValue(), entry.getKey());
        }
        accessLevelEnumMap = new HashMap<AccessLevel, Short>();
        accessLevelValueMap = new HashMap<Short, AccessLevel>();
        accessLevelEnumMap.put(AccessLevel.OPR_ONLY, (short)0);
        accessLevelEnumMap.put(AccessLevel.USR_PARM, (short)1);
        accessLevelEnumMap.put(AccessLevel.FULL, (short)2);
        for (Map.Entry<Enum, Short> entry : accessLevelEnumMap.entrySet()) {
            accessLevelValueMap.put(entry.getValue(), (AccessLevel)entry.getKey());
        }
        controlModeEnumMap = new HashMap<ControlMode, Short>();
        controlModeValueMap = new HashMap<Short, ControlMode>();
        controlModeEnumMap.put(ControlMode.VF, (short)0);
        controlModeEnumMap.put(ControlMode.VF_PG, (short)1);
        controlModeEnumMap.put(ControlMode.OLV, (short)2);
        controlModeEnumMap.put(ControlMode.CLV, (short)3);
        controlModeEnumMap.put(ControlMode.CLV_PM, (short)7);
        controlModeEnumMap.put(ControlMode.OLV_PM, (short)5);
        controlModeEnumMap.put(ControlMode.AOLV_PM, (short)6);
        for (Map.Entry<Enum, Short> entry : controlModeEnumMap.entrySet()) {
            controlModeValueMap.put(entry.getValue(), (ControlMode)entry.getKey());
        }
        freqRefSrcEnumMap = new HashMap<FreqRefSrc, Short>();
        freqRefSrcValueMap = new HashMap<Short, FreqRefSrc>();
        freqRefSrcEnumMap.put(FreqRefSrc.OPERATOR, (short)0);
        freqRefSrcEnumMap.put(FreqRefSrc.ANALOG, (short)1);
        freqRefSrcEnumMap.put(FreqRefSrc.MODBUS, (short)2);
        freqRefSrcEnumMap.put(FreqRefSrc.OPTN_PCB, (short)3);
        freqRefSrcEnumMap.put(FreqRefSrc.PULSE, (short)4);
        for (Map.Entry<Enum, Short> entry : freqRefSrcEnumMap.entrySet()) {
            freqRefSrcValueMap.put(entry.getValue(), (FreqRefSrc)entry.getKey());
        }
        runCmndSrcEnumMap = new HashMap<RunCmndSrc, Short>();
        runCmndSrcValueMap = new HashMap<Short, RunCmndSrc>();
        runCmndSrcEnumMap.put(RunCmndSrc.OPERATOR, (short)0);
        runCmndSrcEnumMap.put(RunCmndSrc.DIGITAL, (short)1);
        runCmndSrcEnumMap.put(RunCmndSrc.MODBUS, (short)2);
        runCmndSrcEnumMap.put(RunCmndSrc.OPTN_PCB, (short)3);
        for (Map.Entry<Enum, Short> entry : runCmndSrcEnumMap.entrySet()) {
            runCmndSrcValueMap.put(entry.getValue(), (RunCmndSrc)entry.getKey());
        }
        stopMethodEnumMap = new HashMap<StopMethod, Short>();
        stopMethodValueMap = new HashMap<Short, StopMethod>();
        stopMethodEnumMap.put(StopMethod.COAST, (short)1);
        stopMethodEnumMap.put(StopMethod.COAST_TMR, (short)3);
        stopMethodEnumMap.put(StopMethod.INJECT, (short)2);
        stopMethodEnumMap.put(StopMethod.RAMP, (short)0);
        for (Map.Entry<Enum, Short> entry : stopMethodEnumMap.entrySet()) {
            stopMethodValueMap.put(entry.getValue(), (StopMethod)entry.getKey());
        }
        runProgEnumMap = new HashMap<RunProg, Short>();
        runProgValueMap = new HashMap<Short, RunProg>();
        runProgEnumMap.put(RunProg.PROG_ONLY, (short)0);
        runProgEnumMap.put(RunProg.RUN_PROG, (short)1);
        runProgEnumMap.put(RunProg.RUN_ONLY, (short)2);
        for (Map.Entry<Enum, Short> entry : runProgEnumMap.entrySet()) {
            runProgValueMap.put(entry.getValue(), (RunProg)entry.getKey());
        }
        baudRateEnumMap = new HashMap<BaudRate, Short>();
        baudRateValueMap = new HashMap<Short, BaudRate>();
        baudRateEnumMap.put(BaudRate.B1200, (short)0);
        baudRateEnumMap.put(BaudRate.B2400, (short)1);
        baudRateEnumMap.put(BaudRate.B4800, (short)2);
        baudRateEnumMap.put(BaudRate.B9600, (short)3);
        baudRateEnumMap.put(BaudRate.B19200, (short)4);
        baudRateEnumMap.put(BaudRate.B38400, (short)5);
        baudRateEnumMap.put(BaudRate.B57600, (short)6);
        baudRateEnumMap.put(BaudRate.B76800, (short)7);
        baudRateEnumMap.put(BaudRate.B115200, (short)8);
        for (Map.Entry<Enum, Short> entry : baudRateEnumMap.entrySet()) {
            baudRateValueMap.put(entry.getValue(), (BaudRate)entry.getKey());
        }
        parityEnumMap = new HashMap<Parity, Short>();
        parityValueMap = new HashMap<Short, Parity>();
        parityEnumMap.put(Parity.EVEN, (short)1);
        parityEnumMap.put(Parity.ODD, (short)2);
        parityEnumMap.put(Parity.NONE, (short)0);
        for (Map.Entry<Enum, Short> entry : parityEnumMap.entrySet()) {
            parityValueMap.put(entry.getValue(), (Parity)entry.getKey());
        }
        errorActionEnumMap = new HashMap<ErrorAction, Short>();
        errorActionValueMap = new HashMap<Short, ErrorAction>();
        errorActionEnumMap.put(ErrorAction.RAMP_STOP, (short)0);
        errorActionEnumMap.put(ErrorAction.COAST_STOP, (short)1);
        errorActionEnumMap.put(ErrorAction.FAST_STOP, (short)2);
        errorActionEnumMap.put(ErrorAction.ALARM_ONLY, (short)3);
        for (Map.Entry<Enum, Short> entry : errorActionEnumMap.entrySet()) {
            errorActionValueMap.put(entry.getValue(), (ErrorAction)entry.getKey());
        }
        voltageUnitsEnumMap = new HashMap<VoltageUnits, Short>();
        voltageUnitsValueMap = new HashMap<Short, VoltageUnits>();
        voltageUnitsEnumMap.put(VoltageUnits.ONES, (short)1);
        voltageUnitsEnumMap.put(VoltageUnits.TENTHS, (short)0);
        for (Map.Entry<Enum, Short> entry : voltageUnitsEnumMap.entrySet()) {
            voltageUnitsValueMap.put(entry.getValue(), (VoltageUnits)entry.getKey());
        }
        vfSelectionEnumMap = new HashMap<VfSelection, Short>();
        vfSelectionValueMap = new HashMap<Short, VfSelection>();
        vfSelectionEnumMap.put(VfSelection.HZ50, (short)0);
        vfSelectionEnumMap.put(VfSelection.HZ60_SAT, (short)1);
        vfSelectionEnumMap.put(VfSelection.HZ50_SAT, (short)2);
        vfSelectionEnumMap.put(VfSelection.HZ72, (short)3);
        vfSelectionEnumMap.put(VfSelection.HZ50_VT1, (short)4);
        vfSelectionEnumMap.put(VfSelection.HZ50_VT2, (short)5);
        vfSelectionEnumMap.put(VfSelection.HZ60_VT1, (short)6);
        vfSelectionEnumMap.put(VfSelection.HZ60_VT2, (short)7);
        vfSelectionEnumMap.put(VfSelection.HZ50_HST1, (short)8);
        vfSelectionEnumMap.put(VfSelection.HZ50_HST2, (short)9);
        vfSelectionEnumMap.put(VfSelection.HZ60_HST1, (short)10);
        vfSelectionEnumMap.put(VfSelection.HZ60_HST2, (short)11);
        vfSelectionEnumMap.put(VfSelection.HZ90, (short)12);
        vfSelectionEnumMap.put(VfSelection.HZ120, (short)13);
        vfSelectionEnumMap.put(VfSelection.HZ180, (short)14);
        vfSelectionEnumMap.put(VfSelection.CUSTOM, (short)15);
        for (Map.Entry<Enum, Short> entry : vfSelectionEnumMap.entrySet()) {
            vfSelectionValueMap.put(entry.getValue(), (VfSelection)entry.getKey());
        }
        modelNameMap = new HashMap<Short, String>();
        modelNameMap.put((short)146, "4A0002");
        modelNameMap.put((short)147, "4A0004");
        modelNameMap.put((short)148, "4A0005");
        modelNameMap.put((short)149, "4A0007");
        modelNameMap.put((short)150, "4A0009");
        ratedCurrentMap = new HashMap<Short, Double>();
        ratedCurrentMap.put((short)146, 2.1);
        ratedCurrentMap.put((short)147, 4.1);
        ratedCurrentMap.put((short)148, 5.4);
        ratedCurrentMap.put((short)149, 6.9);
        ratedCurrentMap.put((short)150, 8.8);
        excpMap = new HashMap<Integer, String>();
        excpMap.put(3, "bit count error");
        excpMap.put(33, "illegal data value");
        excpMap.put(34, "illegal write operation");
        excpMap.put(35, "illegal write while in undervoltage");
        excpMap.put(36, "illegal write while processing parameters");
        excpMap.put(37, "illegal write to EEPROM");
    }

    public static enum VfSelection {
        HZ50,
        HZ60_SAT,
        HZ50_SAT,
        HZ72,
        HZ50_VT1,
        HZ50_VT2,
        HZ60_VT1,
        HZ60_VT2,
        HZ50_HST1,
        HZ50_HST2,
        HZ60_HST1,
        HZ60_HST2,
        HZ90,
        HZ120,
        HZ180,
        CUSTOM;

    }

    public static enum VoltageUnits {
        ONES,
        TENTHS;

    }

    public static enum ErrorAction {
        RAMP_STOP,
        COAST_STOP,
        FAST_STOP,
        ALARM_ONLY;

    }

    public static enum Parity {
        EVEN,
        ODD,
        NONE;

    }

    public static enum BaudRate {
        B1200,
        B2400,
        B4800,
        B9600,
        B19200,
        B38400,
        B57600,
        B76800,
        B115200;

    }

    public static enum RunProg {
        PROG_ONLY,
        RUN_PROG,
        RUN_ONLY;

    }

    public static enum StopMethod {
        COAST,
        COAST_TMR,
        INJECT,
        RAMP;

    }

    public static enum RunCmndSrc {
        OPERATOR,
        DIGITAL,
        MODBUS,
        OPTN_PCB;

    }

    public static enum FreqRefSrc {
        OPERATOR,
        ANALOG,
        MODBUS,
        OPTN_PCB,
        PULSE;

    }

    public static enum ControlMode {
        VF,
        VF_PG,
        OLV,
        CLV,
        CLV_PM,
        OLV_PM,
        AOLV_PM;

    }

    public static enum AccessLevel {
        OPR_ONLY,
        USR_PARM,
        FULL;

    }

    public static enum Language {
        ENGLISH;

    }
}

