/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.Serializable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.imagehandling.data.JsonFile;
import org.lsst.ccs.subsystem.imagehandling.data.MeasuredShutterTime;
import org.lsst.ccs.subsystem.ocsbridge.events.ShutterMotionProfileFitResult;
import org.lsst.ccs.subsystem.ocsbridge.sim.ControlledSubsystem;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterInterface;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterMotionProfileFitter;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterMotionProfileSender;
import org.lsst.ccs.subsystem.ocsbridge.states.ShutterState;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.status.MotionDone;
import org.lsst.ccs.utilities.scheduler.Scheduler;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

class MainCameraShutterSubsystemLayer
extends ControlledSubsystem
implements ShutterInterface {
    private static final Logger LOG = Logger.getLogger(MainCameraShutterSubsystemLayer.class.getName());
    private static final Map<Enum<PhysicalState>, Enum<ShutterState>> CAMERA_SHUTTER_TO_SHUTTER_STATE = new HashMap<Enum<PhysicalState>, Enum<ShutterState>>();
    private volatile CountDownLatch motionDoneCountDown;
    private volatile ImageName currentImageName;
    static final String MOTOR_ENCODER_PATH = "shutter/motorEncoder/";
    static final String HALL_SENSOR_PATH = "shutter/hallSensor/";
    static final String MOTION_PROFILE_FIT_RESULT = "/motionProfileFitResult";
    private final Subsystem theMCM;
    private volatile CompletableFuture<Double> openMotionFuture = null;

    MainCameraShutterSubsystemLayer(Subsystem mcm, CCS ccs, MCMConfig config) {
        super(mcm, config.getShutterSubsystemName(), ccs, config);
        this.theMCM = mcm;
    }

    public double getShutterOpenTime(CCSTimeStamp t1, CCSTimeStamp t2) {
        return t1.getTAIDouble() - t2.getTAIDouble();
    }

    @Override
    public void expose(ImageName imageName, Duration exposeTime) throws ExecutionException {
        try {
            this.motionDoneCountDown = new CountDownLatch(2);
            this.currentImageName = imageName;
            this.commandSender.sendCommand("takeExposure", (double)exposeTime.toMillis() / 1000.0);
            boolean success = this.motionDoneCountDown.await(exposeTime.toMillis() + 2000L, TimeUnit.MILLISECONDS);
            if (!success) {
                throw new TimeoutException("Timed out waiting for shutter exposure to complete");
            }
        }
        catch (InterruptedException | TimeoutException x) {
            throw new ExecutionException("Error during expose", x);
        }
    }

    @Override
    public void open(ImageName imageName) throws ExecutionException {
        this.commandSender.sendCommand("openShutter", new Object[0]);
    }

    @Override
    public void close() throws ExecutionException {
        this.commandSender.sendCommand("closeShutter", new Object[0]);
    }

    @Override
    public void prepare() {
    }

    @Override
    protected void onStateChange(StatusStateChangeNotification statusChange) {
        CCSTimeStamp when = statusChange.getStateTransitionTimestamp();
        StateBundle newStates = statusChange.getNewState();
        StateBundle oldStates = statusChange.getOldState();
        StateBundle changedStates = newStates.diffState(oldStates);
        String cause = statusChange.getCause();
        changedStates.getComponentStateBundle("statemachine").getDecodedStates().entrySet().stream().map(changedState -> (Enum)changedState.getValue()).forEachOrdered(value -> this.translateCameraShutterStateToShutterState(when, (Enum)value, cause));
    }

    @Override
    protected void onEvent(StatusMessage msg) {
        if (msg.getObject() instanceof KeyValueData && "MotionDone".equals(((KeyValueData)msg.getObject()).getKey()) && this.motionDoneCountDown != null) {
            LOG.log(Level.INFO, "Got Motion Done {0} ", msg);
            int currentCount = (int)this.motionDoneCountDown.getCount();
            if (currentCount > 0) {
                this.motionDoneCountDown.countDown();
                MotionDone motionDone = (MotionDone)((KeyValueData)msg.getObject()).getValue();
                boolean isOpen = currentCount == 2;
                CompletableFuture<Double> scheduleMotionFuture = this.scheduleMotionDoneFit(this.currentImageName, isOpen, motionDone);
                if (isOpen) {
                    this.openMotionFuture = scheduleMotionFuture;
                } else {
                    ImageName imageName = this.currentImageName;
                    this.openMotionFuture.thenAcceptBoth(scheduleMotionFuture, (openTime, closeTime) -> {
                        MeasuredShutterTime cst = new MeasuredShutterTime(imageName, closeTime - openTime);
                        this.sendEvent("CCSMeasuredShutterTime", (Serializable)cst);
                    });
                }
            }
        }
    }

    private void translateCameraShutterStateToShutterState(CCSTimeStamp when, Enum value, String cause) {
        Enum<ShutterState> converted = CAMERA_SHUTTER_TO_SHUTTER_STATE.get(value);
        if (converted != null) {
            LOG.log(Level.INFO, "Got shutter state {0} ", value);
            this.ccs.getAggregateStatus().add(when, new State<Enum<ShutterState>>(converted, cause));
        }
    }

    @Override
    public void setImageSequence(boolean imageSequence) {
    }

    private CompletableFuture<Double> scheduleMotionDoneFit(ImageName imageName, boolean isOpen, MotionDone motionDone) {
        Scheduler scheduler = this.theMCM.getScheduler();
        CompletableFuture<ShutterMotionProfileFitter> futureFit = ShutterMotionProfileFitter.fit((Executor)scheduler, motionDone);
        return futureFit.thenApply(fitResult -> {
            ShutterMotionProfileSender motionProfileSender = new ShutterMotionProfileSender(imageName, motionDone, isOpen, (ShutterMotionProfileFitter)fitResult);
            JsonFile jsonProfile = motionProfileSender.getJsonFile();
            this.sendEvent("additionalFile", (Serializable)jsonProfile);
            String pathPrefix = motionDone.side().toString() + "/" + (isOpen ? "open" : "close") + MOTION_PROFILE_FIT_RESULT;
            ShutterMotionProfileFitResult encoderFitResult = motionProfileSender.getEncoderFitResult();
            String encoderPath = MOTOR_ENCODER_PATH + pathPrefix;
            this.sendEvent(encoderPath, encoderFitResult);
            ShutterMotionProfileFitResult hallSensorFitResult = motionProfileSender.getHallSensorFitResult();
            String hallSensorPath = HALL_SENSOR_PATH + pathPrefix;
            this.sendEvent(hallSensorPath, hallSensorFitResult);
            double timeAtMidPoint = motionProfileSender.getStartTime().getTAIDouble() + motionProfileSender.getMidPointTimeFromHallSensor() + hallSensorFitResult.getModelStartTime();
            return timeAtMidPoint;
        });
    }

    static {
        CAMERA_SHUTTER_TO_SHUTTER_STATE.put((Enum<PhysicalState>)PhysicalState.OPENED, ShutterState.OPEN);
        CAMERA_SHUTTER_TO_SHUTTER_STATE.put((Enum<PhysicalState>)PhysicalState.OPENING, ShutterState.OPENING);
        CAMERA_SHUTTER_TO_SHUTTER_STATE.put((Enum<PhysicalState>)PhysicalState.CLOSED, ShutterState.CLOSED);
        CAMERA_SHUTTER_TO_SHUTTER_STATE.put((Enum<PhysicalState>)PhysicalState.CLOSING, ShutterState.CLOSING);
    }
}

