/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j.client;

import java.util.ArrayList;
import org.indilib.i4j.INDIException;
import org.indilib.i4j.client.INDIElementListener;
import org.indilib.i4j.client.INDIProperty;
import org.indilib.i4j.client.INDIValueException;
import org.indilib.i4j.protocol.DefElement;
import org.indilib.i4j.protocol.OneElement;

public abstract class INDIElement {
    private INDIProperty<?> property;
    private String name;
    private String label;
    private ArrayList<INDIElementListener> listeners;

    protected INDIElement(DefElement<?> xml, INDIProperty<?> property) {
        this.property = property;
        this.name = xml.getName();
        if (this.name.length() == 0) {
            throw new IllegalArgumentException("No name for Element");
        }
        this.label = xml.getLabel();
        if (this.label.length() == 0) {
            this.label = this.name;
        }
        this.listeners = new ArrayList();
    }

    public void addINDIElementListener(INDIElementListener listener) {
        this.listeners.add(listener);
    }

    public void removeINDIElementListener(INDIElementListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyListeners() {
        for (INDIElementListener l : new ArrayList<INDIElementListener>(this.listeners)) {
            l.elementChanged(this);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public INDIProperty<?> getProperty() {
        return this.property;
    }

    public abstract Object getValue();

    public abstract String getValueAsString();

    protected abstract void setValue(OneElement<?> var1);

    public abstract Object getDesiredValue();

    public abstract void setDesiredValue(Object var1) throws INDIValueException;

    public abstract boolean isChanged();

    public abstract INDIElementListener getDefaultUIComponent() throws INDIException;

    public abstract boolean checkCorrectValue(Object var1) throws INDIValueException;

    protected abstract OneElement<?> getXMLOneElementNewValue();

    public abstract String getNameAndValueAsString();
}

