/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.subsystem.refrig.CompLimits;

public class ColdCompLimits
extends CompLimits {
    @ConfigurationParameter(category="CompLimits", isFinal=true, units="second", description="Time delay before excess discharge pressure causes compressor shutoff")
    private volatile int discPressDelayTime;
    @ConfigurationParameter(category="CompLimits", isFinal=true, units="Celsius", description="Liquid temperature limit causing immediate compressor shutoff")
    private volatile double liquidTempImmedLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true, units="Celsius", description="Liquid temperature limit causing delayed compressor shutoff")
    private volatile double liquidTempDelayLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true, units="second", description="Time delay before excess liquid temperature causes compressor shutoff")
    private volatile int liquidTempDelayTime;

    @ConfigurationParameterChanger
    public void setLiquidTempImmedLimit(double value) {
        this.liquidTempImmedLimit = value;
        this.limitData[7].immedLimit = value;
    }

    @ConfigurationParameterChanger
    public void setLiquidTempDelayLimit(double value) {
        this.liquidTempDelayLimit = value;
        this.limitData[7].delayLimit = value;
    }

    @ConfigurationParameterChanger
    public void setLiquidTempDelayTime(int value) {
        this.liquidTempDelayTime = value;
        this.limitData[7].delayTime = 1000 * value;
    }

    @ConfigurationParameterChanger
    public void setDiscPressDelayTime(int value) {
        this.discPressDelayTime = value;
        this.limitData[0].delayTime = 1000 * value;
    }
}

