/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.usb;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.usb.UsbConfigurationDescriptor;
import org.lsst.ccs.drivers.usb.UsbDevice;
import org.lsst.ccs.drivers.usb.UsbInterface;

public class UsbConfiguration {
    private final UsbConfigurationDescriptor desc;
    private final List<List<UsbInterface>> ifcs;
    private final UsbDevice devc;

    UsbConfiguration(UsbConfigurationDescriptor desc, List<List<UsbInterface>> ifcs, UsbDevice devc) {
        this.desc = desc;
        this.ifcs = ifcs;
        this.devc = devc;
    }

    public UsbConfigurationDescriptor getDescriptor() {
        return this.desc;
    }

    public String getString() {
        return this.devc.getString(this.desc.iConfiguration());
    }

    public boolean containsInterface(int iface) {
        for (List<UsbInterface> ifc : this.ifcs) {
            if (iface != ifc.get(0).getDescriptor().bInterfaceNumber()) continue;
            return true;
        }
        return false;
    }

    public UsbDevice getDevice() {
        return this.devc;
    }

    public UsbInterface getInterface(int iface) {
        for (List<UsbInterface> ifcl : this.ifcs) {
            UsbInterface ifc = ifcl.get(0);
            if (iface != ifc.getDescriptor().bInterfaceNumber()) continue;
            return ifc;
        }
        return null;
    }

    public List<UsbInterface> getInterfaces() {
        ArrayList<UsbInterface> ifca = new ArrayList<UsbInterface>();
        for (List<UsbInterface> ifcl : this.ifcs) {
            ifca.add(ifcl.get(0));
        }
        return ifca;
    }

    public boolean isActive() throws DriverException {
        return this.desc.bConfigurationValue() == this.devc.getActiveConfigurationNumber();
    }
}

