/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.mtmount.event;

import org.lsst.sal.SALEvent;

public class TargetEvent
extends SALEvent {
    private final double elevation;
    private final double elevationVelocity;
    private final double azimuth;
    private final double azimuthVelocity;
    private final double taiTime;
    private final int trackId;
    private final String tracksys;
    private final String radesys;

    public TargetEvent(double elevation, double elevationVelocity, double azimuth, double azimuthVelocity, double taiTime, int trackId, String tracksys, String radesys) {
        this.elevation = elevation;
        this.elevationVelocity = elevationVelocity;
        this.azimuth = azimuth;
        this.azimuthVelocity = azimuthVelocity;
        this.taiTime = taiTime;
        this.trackId = trackId;
        this.tracksys = tracksys;
        this.radesys = radesys;
    }

    public double getElevation() {
        return this.elevation;
    }

    public double getElevationVelocity() {
        return this.elevationVelocity;
    }

    public double getAzimuth() {
        return this.azimuth;
    }

    public double getAzimuthVelocity() {
        return this.azimuthVelocity;
    }

    public double getTaiTime() {
        return this.taiTime;
    }

    public int getTrackId() {
        return this.trackId;
    }

    public String getTracksys() {
        return this.tracksys;
    }

    public String getRadesys() {
        return this.radesys;
    }

    public String toString() {
        return "TargetEvent{elevation=" + this.elevation + ", elevationVelocity=" + this.elevationVelocity + ", azimuth=" + this.azimuth + ", azimuthVelocity=" + this.azimuthVelocity + ", taiTime=" + this.taiTime + ", trackId=" + this.trackId + ", tracksys=" + this.tracksys + ", radesys=" + this.radesys + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private double elevation;
        private double elevationVelocity;
        private double azimuth;
        private double azimuthVelocity;
        private double taiTime;
        private int trackId;
        private String tracksys;
        private String radesys;

        private Builder() {
        }

        public Builder elevation(double elevation) {
            this.elevation = elevation;
            return this;
        }

        public Builder elevationVelocity(double elevationVelocity) {
            this.elevationVelocity = elevationVelocity;
            return this;
        }

        public Builder azimuth(double azimuth) {
            this.azimuth = azimuth;
            return this;
        }

        public Builder azimuthVelocity(double azimuthVelocity) {
            this.azimuthVelocity = azimuthVelocity;
            return this;
        }

        public Builder taiTime(double taiTime) {
            this.taiTime = taiTime;
            return this;
        }

        public Builder trackId(int trackId) {
            this.trackId = trackId;
            return this;
        }

        public Builder tracksys(String tracksys) {
            this.tracksys = tracksys;
            return this;
        }

        public Builder radesys(String radesys) {
            this.radesys = radesys;
            return this;
        }

        public TargetEvent build() {
            return new TargetEvent(this.elevation, this.elevationVelocity, this.azimuth, this.azimuthVelocity, this.taiTime, this.trackId, this.tracksys, this.radesys);
        }
    }
}

