/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.netbotz;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.lsst.ccs.drivers.commons.DriverException;

public class NetbotzDriver {
    private double Humidity;
    private double Temperature;
    private double Dew;
    private double PartCnt;
    private String envirofile = "/home/homer/bnlenviro.dat";
    private File nblog = null;
    private BufferedReader in = null;
    String line = null;
    boolean isConnected = false;
    long prevTime = 0L;

    public void open(String envirofile) throws DriverException {
        this.envirofile = envirofile;
        this.nblog = new File(this.envirofile);
        if (!this.nblog.exists()) {
            System.out.println("Environment data file is inaccessible!");
            throw new DriverException();
        }
        try {
            this.in = new BufferedReader(new FileReader(this.nblog));
            this.isConnected = true;
        }
        catch (IOException b) {
            System.out.println("Unable to start BufferedReader connection to NetBotz data file" + b);
            this.isConnected = false;
        }
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException ex) {
            System.out.println("NetbotzDriver: Attempt to close stream failed!" + ex);
        }
    }

    public double getHumidity() {
        return this.Humidity;
    }

    public double getTemperature() {
        return this.Temperature;
    }

    public double getDew() {
        return this.Dew;
    }

    public double getPartCnt() {
        return this.PartCnt;
    }

    public String toString() {
        return "Humidity=" + this.Humidity + ", Temperature=" + this.Temperature + ", Dew=" + this.Dew + ", PartCnt=" + this.PartCnt;
    }

    public void GetEnviro() throws IOException {
        long now;
        if (this.isConnected && (now = System.currentTimeMillis()) - this.prevTime > 5000L) {
            this.prevTime = now;
            try {
                while (this.in.ready()) {
                    this.line = this.in.readLine();
                }
                String[] svals = this.line.split(",");
                if (svals.length > 4) {
                    this.Humidity = Double.valueOf(svals[5].split(" ")[3]);
                    this.Temperature = Double.valueOf(svals[6].split(" ")[3]);
                    this.Dew = Double.valueOf(svals[4].split(" ")[3]);
                    this.PartCnt = Double.max(Double.valueOf(svals[2].split(" ")[3]), Double.valueOf(svals[3].split(" ")[3]));
                } else {
                    System.out.println("Environment data currently unavailable.");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void GetEnviro(Double Humidity, Double Temperature, Double Dew, Double PartCnt) throws IOException {
        try {
            this.GetEnviro();
            Humidity = this.Humidity;
            Temperature = this.Temperature;
            Dew = this.Dew;
            PartCnt = this.PartCnt;
        }
        catch (IOException e) {
            System.out.println("Error retrieving NetBotz readings =  " + e);
        }
    }
}

