/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling.imagedb;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.framework.HasLifecycle;

public class ImageDatabaseService
implements HasLifecycle {
    private static final Logger LOG = Logger.getLogger(ImageDatabaseService.class.getName());
    @ConfigurationParameter(isFinal=true, units="unitless", description="Image Database URL")
    private volatile String dbURL;
    @ConfigurationParameter(isFinal=true, units="unitless", description="true/false Image Database enable flag")
    private volatile boolean enabled = true;
    private Connection conn;

    public static ImageDatabaseService testInstance(String dbURL) {
        ImageDatabaseService idbs = new ImageDatabaseService();
        idbs.dbURL = dbURL;
        return idbs;
    }

    public void shutdown() {
        this.closeConnection();
    }

    synchronized Connection openConnection() throws SQLException {
        if (this.enabled && (this.conn == null || this.conn.isClosed())) {
            this.conn = DriverManager.getConnection(this.dbURL);
            this.conn.setAutoCommit(false);
            this.conn.setTransactionIsolation(8);
        }
        return this.conn;
    }

    synchronized void closeConnection() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException ex) {
                LOG.log(Level.SEVERE, "Error closing image database", ex);
            }
            this.conn = null;
        }
    }
}

