/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertListener;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.actions.RefrigAction;
import org.lsst.ccs.subsystem.refrig.Compressor;
import org.lsst.ccs.subsystem.refrig.CryoCompressor;

public class RefrigActionManager
implements HasLifecycle,
AlertListener {
    private static final Logger LOG = Logger.getLogger(RefrigActionManager.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService propertiesService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, CryoCompressor> cryoComps = new HashMap<String, CryoCompressor>();
    private final Map<String, Set<String>>[] active = new Map[RefrigAction.Action.values().length];

    public RefrigActionManager() {
        for (int j = 0; j < this.active.length; ++j) {
            this.active[j] = new HashMap<String, Set<String>>();
        }
    }

    public void build() {
        this.active[RefrigAction.Action.CRYO_PLATE_TOO_COLD.ordinal()].put("", new ConcurrentSkipListSet());
        for (String name : this.cryoComps.keySet()) {
            this.active[RefrigAction.Action.CRYO_CIRCUIT_TOO_COLD.ordinal()].put(name, new ConcurrentSkipListSet());
        }
        this.active[RefrigAction.Action.VACUUM_INSUFFICIENT.ordinal()].put("", new ConcurrentSkipListSet());
    }

    public void init() {
        this.propertiesService.setAgentProperty(RefrigAction.getManagerName(), "");
        this.alertService.startStatusAlertListening(info -> info.hasAgentProperty(RefrigAction.getClientName()));
    }

    public void start() {
        this.alertService.addListener((AlertListener)this);
    }

    public void shutdown() {
        this.alertService.removeListener((AlertListener)this);
    }

    public void onAlert(AlertEvent event) {
        String origin = event.getSource();
        switch (event.getType()) {
            case AGENT_CONNECTION: {
                LOG.log(Level.INFO, "Connected to agent {0}, a source of alerts with payload {1}", new Object[]{origin, RefrigAction.getName()});
                for (RaisedAlertHistory alertHistory : event.getSummary().getAllRaisedAlertHistories()) {
                    this.processAlert(origin, alertHistory.getLatestAlert(), alertHistory.getLatestAlertState());
                }
                break;
            }
            case AGENT_DISCONNECTION: {
                LOG.log(Level.INFO, "Disconnected from agent {0}, a source of alerts with payload {1}", new Object[]{origin, RefrigAction.getName()});
                for (RefrigAction.Action action : RefrigAction.Action.values()) {
                    for (Map.Entry<String, Set<String>> entry : this.active[action.ordinal()].entrySet()) {
                        if (!entry.getValue().remove(origin) || !entry.getValue().isEmpty()) continue;
                        this.performAction(action, entry.getKey(), false);
                    }
                }
                break;
            }
            case ALERT_RAISED: {
                this.processAlert(origin, event.getAlert(), event.getLevel());
            }
        }
    }

    private synchronized void processAlert(String origin, Alert alert, AlertState state) {
        RefrigAction action = RefrigAction.getData((Alert)alert);
        if (action != null) {
            boolean on;
            LOG.log(Level.INFO, "Received {0} level alert from {1}: action = ({2}, {3})", new Object[]{state, origin, action.action, action.compName});
            Set<String> orgSet = this.active[action.action.ordinal()].get(action.compName);
            if (orgSet == null) {
                return;
            }
            boolean bl = on = state == AlertState.ALARM;
            if (on) {
                orgSet.add(origin);
            } else {
                orgSet.remove(origin);
                if (!orgSet.isEmpty()) {
                    return;
                }
            }
            this.performAction(action.action, action.compName, on);
        }
    }

    private void performAction(RefrigAction.Action action, String compName, boolean on) {
        switch (action) {
            case CRYO_CIRCUIT_TOO_COLD: {
                if (!on && !this.active[RefrigAction.Action.CRYO_PLATE_TOO_COLD.ordinal()].get("").isEmpty()) break;
                this.cryoComps.get(compName).setPlateTempLow(on);
                break;
            }
            case CRYO_PLATE_TOO_COLD: {
                for (String string : this.cryoComps.keySet()) {
                    if (!on && !this.active[RefrigAction.Action.CRYO_CIRCUIT_TOO_COLD.ordinal()].get(string).isEmpty()) continue;
                    this.cryoComps.get(string).setPlateTempLow(on);
                }
                break;
            }
            case VACUUM_INSUFFICIENT: {
                for (Compressor compressor : this.cryoComps.values()) {
                    compressor.setVacuumBad(on);
                }
                break;
            }
        }
    }
}

