/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.model;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitEntityNameSource;
import org.hibernate.boot.model.naming.ImplicitForeignKeyNameSource;
import org.hibernate.boot.model.naming.ImplicitIndexNameSource;
import org.hibernate.boot.model.naming.ImplicitJoinColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitJoinTableNameSource;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyJpaCompliantImpl;
import org.hibernate.boot.model.naming.ImplicitUniqueKeyNameSource;

public class CCSNamingStrategy
extends ImplicitNamingStrategyJpaCompliantImpl {
    private static final long serialVersionUID = 3751202026782556556L;
    private static final String CCS_PREFIX = "ccs_";
    private List<String> uniqueNames = new ArrayList<String>();

    public Identifier determinePrimaryTableName(ImplicitEntityNameSource source) {
        Object tableName = source.getEntityNaming().getJpaEntityName();
        tableName = Character.toLowerCase(((String)tableName).charAt(0)) + ((String)tableName).substring(1);
        return this.checkIdentifier(new Identifier(CCS_PREFIX + (String)tableName, false));
    }

    public Identifier determineForeignKeyName(ImplicitForeignKeyNameSource source) {
        return this.checkIdentifier(new Identifier(CCS_PREFIX + CCSNamingStrategy.shortName(source.getTableName().getText()) + "_" + CCSNamingStrategy.shortColumnsIdentifier(source.getColumnNames()) + "_" + CCSNamingStrategy.shortName(source.getReferencedTableName().getText()) + "_fk", false), false);
    }

    public Identifier determineUniqueKeyName(ImplicitUniqueKeyNameSource source) {
        return this.checkIdentifier(new Identifier(CCS_PREFIX + CCSNamingStrategy.shortName(source.getTableName().getText()) + "_" + CCSNamingStrategy.shortColumnsIdentifier(source.getColumnNames()) + "_u", false));
    }

    public Identifier determineIndexName(ImplicitIndexNameSource source) {
        return this.checkIdentifier(new Identifier(CCS_PREFIX + CCSNamingStrategy.shortName(source.getTableName().getText()) + "_" + CCSNamingStrategy.shortColumnsIdentifier(source.getColumnNames()) + "_i", false), false);
    }

    public Identifier determineJoinTableName(ImplicitJoinTableNameSource source) {
        return this.checkIdentifier(new Identifier(CCS_PREFIX + CCSNamingStrategy.shortName(source.getOwningPhysicalTableName()) + "_" + CCSNamingStrategy.shortName(source.getNonOwningPhysicalTableName()) + "_b", false), false);
    }

    public Identifier determineJoinColumnName(ImplicitJoinColumnNameSource source) {
        Object columnName = super.determineJoinColumnName(source).getText();
        if (((String)columnName).endsWith("_id")) {
            columnName = ((String)columnName).substring(0, ((String)columnName).length() - 3) + "Id";
        }
        columnName = Character.toLowerCase(((String)columnName).charAt(0)) + ((String)columnName).substring(1);
        return new Identifier((String)columnName, false);
    }

    private static String shortColumnsIdentifier(List<Identifier> cols) {
        Object result = "";
        for (Identifier col : cols) {
            if (!((String)result).isEmpty()) {
                result = (String)result + "_";
            }
            result = (String)result + CCSNamingStrategy.shortName(col.getText());
        }
        return result;
    }

    protected static String shortName(String tableName) {
        Object result = "";
        tableName = tableName.replace(CCS_PREFIX, "");
        boolean add = false;
        int nChars = 1;
        int nCharsFirstWord = 7;
        boolean firstWord = true;
        int counter = 0;
        for (int i = 0; i < tableName.length(); ++i) {
            char c = tableName.charAt(i);
            if (i == 0) {
                result = (String)result + Character.toLowerCase(c);
                add = true;
            } else if (Character.isUpperCase(c)) {
                firstWord = false;
                result = (String)result + c;
                counter = 0;
                add = true;
            } else if (add) {
                result = (String)result + c;
                ++counter;
            }
            if ((!firstWord || counter != nCharsFirstWord) && (firstWord || counter != nChars)) continue;
            add = false;
            counter = 0;
        }
        if (((String)result).endsWith("_b")) {
            result = ((String)result).replace("_b", "");
        }
        return result;
    }

    private Identifier checkIdentifier(Identifier id) {
        return this.checkIdentifier(id, true);
    }

    private Identifier checkIdentifier(Identifier id, boolean checkUnique) {
        if (!this.uniqueNames.contains(id.getText())) {
            this.uniqueNames.add(id.getText());
        } else if (checkUnique) {
            throw new RuntimeException("ERROR: generated name " + id.getText() + " already exists.");
        }
        if (id.getText().length() > 64) {
            throw new RuntimeException("ERROR: name exceeds maximum length of 64 chars " + id.getText());
        }
        return id;
    }
}

