/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import java.time.Duration;
import java.util.Objects;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAllFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.DisableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.HomeAxis;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.shutter.common.Axis;
import org.lsst.ccs.subsystem.shutter.plc.CalibDone;
import org.lsst.ccs.subsystem.shutter.plc.Calibrate;
import org.lsst.ccs.subsystem.shutter.plc.ChangeBrakeState;
import org.lsst.ccs.subsystem.shutter.plc.Error;
import org.lsst.ccs.subsystem.shutter.plc.Ignored;
import org.lsst.ccs.subsystem.shutter.plc.MotionDonePLC;
import org.lsst.ccs.subsystem.shutter.statemachine.Channel;
import org.lsst.ccs.subsystem.shutter.statemachine.Context;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.PromptReply;
import org.lsst.ccs.subsystem.shutter.statemachine.State;

abstract class SimpleState<C extends Context<?>>
implements State<C> {
    private final C context;

    protected SimpleState(C context) {
        Objects.requireNonNull(context, "A state's context can't be null.");
        this.context = context;
    }

    @Override
    public final C getContext() {
        return this.context;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void brakePowerChange(Channel<EventReply> chan, boolean isPowerOn) throws InterruptedException {
        chan.write(new PromptReply("The brake power-change event should have been handled by the top level."));
    }

    @Override
    public void brakePowerLoss(Channel<EventReply> chan) throws InterruptedException {
        chan.write(PromptReply.ACCEPTED);
    }

    @Override
    public void contactLost(Channel<EventReply> chan, String msg) throws InterruptedException {
        chan.write(new PromptReply(this.rejectionMsg()));
    }

    @Override
    public void plcIsEnabled(Channel<EventReply> chan) throws InterruptedException {
        chan.write(PromptReply.ACCEPTED);
    }

    @Override
    public void plcIsDisabled(Channel<EventReply> chan) throws InterruptedException {
        chan.write(PromptReply.ACCEPTED);
    }

    @Override
    public void resync(Channel<EventReply> chan) throws InterruptedException {
        chan.write(new PromptReply(this.rejectionMsg()));
    }

    @Override
    public void syncTimeout(Channel<EventReply> chan) throws InterruptedException {
        chan.write(new PromptReply(this.rejectionMsg()));
    }

    @Override
    public void enable(Channel<EventReply> chan) throws InterruptedException {
        chan.write(new PromptReply(this.rejectionMsg()));
    }

    @Override
    public void disable(Channel<EventReply> chan) throws InterruptedException {
        chan.write(new PromptReply(this.rejectionMsg()));
    }

    @Override
    public void motionDone(Channel<EventReply> chan, MotionDonePLC profileData) throws InterruptedException {
        chan.write(new PromptReply(this.rejectionMsg()));
    }

    @Override
    public void toggleSafetyCheck(Channel<EventReply> chan) throws InterruptedException {
        chan.write(new PromptReply(this.rejectionMsg()));
    }

    @Override
    public void calibrate(Channel<EventReply> chan, Calibrate calibParams) throws InterruptedException {
        chan.write(new PromptReply(this.rejectionMsg()));
    }

    @Override
    public void calibDone(Channel<EventReply> chan, CalibDone calibResults) throws InterruptedException {
        chan.write(new PromptReply(this.rejectionMsg()));
    }

    @Override
    public void error(Channel<EventReply> chan, Error err) throws InterruptedException {
        chan.write(new PromptReply(this.rejectionMsg()));
    }

    @Override
    public void reset(Channel<EventReply> chan) throws InterruptedException {
        chan.write(new PromptReply(this.rejectionMsg()));
    }

    @Override
    public void takeExposure(Channel<EventReply> chan, Duration exposureTime) throws InterruptedException {
        chan.write(new PromptReply(this.rejectionMsg()));
    }

    @Override
    public void openShutter(Channel<EventReply> chan) throws InterruptedException {
        chan.write(new PromptReply(this.rejectionMsg()));
    }

    @Override
    public void timer(Channel<EventReply> chan) throws InterruptedException {
        chan.write(new PromptReply(this.rejectionMsg()));
    }

    @Override
    public void closeShutter(Channel<EventReply> chan) throws InterruptedException {
        chan.write(new PromptReply(this.rejectionMsg()));
    }

    @Override
    public void ignored(Channel<EventReply> chan, Ignored.Reason reason) throws InterruptedException {
        chan.write(new PromptReply(this.rejectionMsg()));
    }

    @Override
    public void homeAxis(Channel<EventReply> chan, HomeAxis req) throws InterruptedException {
        chan.write(new PromptReply(this.rejectionMsg()));
    }

    @Override
    public void gotoProd(Channel<EventReply> chan) throws InterruptedException {
        chan.write(new PromptReply("Can't go to Prod from CCS state " + this.getName() + "."));
    }

    @Override
    public void gotoCenter(Channel<EventReply> chan) throws InterruptedException {
        chan.write(new PromptReply(this.rejectionMsg()));
    }

    @Override
    public void moveAxisAbsolute(Channel<EventReply> chan, MoveAxisAbsolute req) throws InterruptedException {
        chan.write(new PromptReply(this.rejectionMsg()));
    }

    @Override
    public void moveAxisRelative(Channel<EventReply> chan, MoveAxisRelative req) throws InterruptedException {
        chan.write(new PromptReply(this.rejectionMsg()));
    }

    @Override
    public void clearAllFaults(Channel<EventReply> chan, ClearAllFaults req) throws InterruptedException {
        chan.write(new PromptReply(this.rejectionMsg()));
    }

    @Override
    public void changeAxisEnable(Channel<EventReply> chan, ChangeAxisEnable req) throws InterruptedException {
        chan.write(new PromptReply(this.rejectionMsg()));
    }

    @Override
    public void clearAxisFaults(Channel<EventReply> chan, ClearAxisFaults req) throws InterruptedException {
        chan.write(new PromptReply(this.rejectionMsg()));
    }

    @Override
    public void changeBrakeState(Channel<EventReply> chan, Axis ax, ChangeBrakeState.State newState) throws InterruptedException {
        chan.write(new PromptReply(this.rejectionMsg()));
    }

    @Override
    public void enableAllAxes(Channel<EventReply> chan, EnableAllAxes req) throws InterruptedException {
        chan.write(new PromptReply(this.rejectionMsg()));
    }

    @Override
    public void disableAllAxes(Channel<EventReply> chan, DisableAllAxes req) throws InterruptedException {
        chan.write(new PromptReply(this.rejectionMsg()));
    }

    protected final String rejectionMsg() {
        return String.format("Event %s() is invalid for CCS state %s.", new Exception().getStackTrace()[1].getMethodName(), this.getName());
    }
}

