/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.util.function.Supplier;
import java.util.logging.Level;
import org.lsst.ccs.bus.data.RunMode;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.subsystem.power.PowerSupplyConfiguration;
import org.lsst.ccs.subsystem.power.RebPowerSupplyNode;
import org.lsst.ccs.subsystem.power.constants.RebPsEnum;
import org.lsst.ccs.subsystem.power.data.PowerException;
import org.lsst.ccs.subsystem.power.states.RebPowerState;

public class CornerRaftRebPowerSupplyNode
extends RebPowerSupplyNode {
    @ConfigurationParameter(range="1300..4095", units="volts", description="Delta voltage between Parallel High and Low")
    volatile int dphi = 4095;

    public CornerRaftRebPowerSupplyNode(PowerSupplyConfiguration powerSupplyConfiguration, int channel) {
        super(powerSupplyConfiguration, channel);
    }

    @Override
    public void build() {
        super.build();
        if (RunMode.isSimulation()) {
            this.powerSupplyDevice.setSimulatedPsType(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ConfigurationParameterChanger(propertyName="dphi")
    public void setDphi(int dphi) {
        this.dphi = dphi;
        Object object = this.agentStateService.getStateLock();
        synchronized (object) {
            if (this.agentStateService.isComponentInState(this.rebPath, (Enum)RebPowerState.ON)) {
                this.writeDphiConfigurationValueToDac();
            }
        }
    }

    void writeDphiConfigurationValueToDac() {
        try {
            this.powerSupplyDevice.setDphiDac(this.channel, this.dphi);
            LOG.log(Level.INFO, "{0} set dphi DAC value of {1}", new Object[]{this.rebPath, this.dphi});
        }
        catch (PowerException ex) {
            LOG.log(Level.WARNING, "Could not set the HVBias DAC value", ex);
            throw new RuntimeException(ex);
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Turns on the dphi bias to the configuration value", autoAck=false)
    public void dphiOn() throws PowerException {
        this.agent.helper().precondition(this.agentStateService.isComponentInState(this.rebPath, (Enum)RebPowerState.ON), "The Reb main power must be ON.", new Supplier[0]).enterFaultOnException(true).action(() -> this.powerSupplyDevice.setPowerOn(this.channel, RebPsEnum.DPHI.getNumber(), true));
    }

    @Command(type=Command.CommandType.ACTION, description="Turns off the dphi bias")
    public void dphiOff() throws PowerException {
        this.powerSupplyDevice.setPowerOn(this.channel, RebPsEnum.DPHI.getNumber(), false);
    }

    @Command(type=Command.CommandType.ACTION, description="Read the Dphi DAC value")
    public double readDphiDac() throws PowerException {
        return this.powerSupplyDevice.getDacs(false)[this.channel];
    }
}

