/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystem.focalplane.CCSEmulatedPlayList;
import org.lsst.ccs.subsystem.focalplane.CCSImageList;
import org.lsst.ccs.subsystem.focalplane.CCSPlayList;
import org.lsst.ccs.subsystem.focalplane.CCSSimulatedPlayList;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneSubsystem;
import org.lsst.ccs.subsystem.focalplane.SequencerConfig;
import org.lsst.ccs.subsystem.focalplane.states.FocalPlaneState;

public class PlaylistCommands {
    private final FocalPlaneSubsystem subsys;
    private final SequencerConfig config;
    private static final String PLIST_SUFFIX = ".plist";
    private static final Logger LOG = Logger.getLogger(PlaylistCommands.class.getName());

    PlaylistCommands(FocalPlaneSubsystem subsys, SequencerConfig config) {
        this.subsys = subsys;
        this.config = config;
    }

    @Command(type=Command.CommandType.ACTION, description="Start a playlist", level=0, autoAck=false)
    public void play(String playListFileName, @Argument(defaultValue="false") boolean repeat) throws IOException {
        Path playListPath = this.getPlaylistBaseDir(playListFileName);
        this.subsys.helper().enterFaultOnException(false).precondition(new Enum[]{FocalPlaneState.QUIESCENT, FocalPlaneState.NEEDS_CLEAR}).precondition(!this.config.isRealDAQ(), "play command only evailable with emulated or simulated DAQ", new Supplier[0]).precondition(Files.exists(playListPath, new LinkOption[0]), "play list backing file does not exist", new Supplier[0]).action(() -> {
            CCSImageList imageList = CCSImageList.open(playListPath);
            CCSPlayList cpl = this.config.hasSimulatedDAQ() ? new CCSSimulatedPlayList(imageList, repeat, this.subsys, this.config) : new CCSEmulatedPlayList(imageList, repeat, this.config.getStore());
            cpl.validate();
            this.config.setCurrentPlaylist(cpl);
            LOG.log(Level.INFO, "Playlist set {0}", cpl);
        });
    }

    @Command(type=Command.CommandType.ACTION, description="Define a playlist", level=0, autoAck=false)
    public void definePlaylist(String playListFileName, String daqFolder, String ... imageNames) {
        this.subsys.helper().enterFaultOnException(false).precondition(new Enum[]{FocalPlaneState.QUIESCENT, FocalPlaneState.NEEDS_CLEAR}).precondition(!this.config.isRealDAQ(), "playlists only evailable with emulated or simulated DAQ", new Supplier[0]).action(() -> {
            Path playListPath = this.getPlaylistBaseDir(playListFileName);
            if (Files.deleteIfExists(playListPath)) {
                // empty if block
            }
            CCSImageList imageList = CCSImageList.create(playListPath, this.config.hasSimulatedDAQ() ? this.config.getSimulatedDataFolder() : "DAQ", daqFolder);
            for (String imageName : imageNames) {
                imageList.add(imageName);
            }
            imageList.save();
            return null;
        });
    }

    @Command(type=Command.CommandType.QUERY, description="Show contents of a playlist", level=0, autoAck=false)
    public String showPlaylist(String playListFileName) throws IOException {
        Path playListPath = this.getPlaylistBaseDir(playListFileName);
        return (String)this.subsys.helper().enterFaultOnException(false).precondition(new Enum[]{FocalPlaneState.QUIESCENT, FocalPlaneState.NEEDS_CLEAR}).precondition(!this.config.isRealDAQ(), "playlists only evailable with emulated or simulated DAQ", new Supplier[0]).precondition(Files.exists(playListPath, new LinkOption[0]), "play list backing file does not exist", new Supplier[0]).action(() -> {
            CCSImageList imageList = CCSImageList.open(playListPath);
            List<String> images = imageList.getImages();
            return images.stream().collect(Collectors.joining("\n"));
        });
    }

    @Command(type=Command.CommandType.QUERY, description="Show status of the current playlist", level=0, autoAck=false)
    public String showCurrentPlaylist() throws IOException {
        return (String)this.subsys.helper().enterFaultOnException(false).precondition(new Enum[]{FocalPlaneState.QUIESCENT, FocalPlaneState.NEEDS_CLEAR}).precondition(!this.config.isRealDAQ(), "playlists only evailable with emulated or simulated DAQ", new Supplier[0]).precondition(this.config.getCurrentPlaylist() != null, "no playlist currently active", new Supplier[0]).action(() -> this.config.getCurrentPlaylist().toString());
    }

    @Command(type=Command.CommandType.QUERY, description="Show status of the current playlist", level=0, autoAck=false)
    public String listPlaylists() throws IOException {
        return (String)this.subsys.helper().enterFaultOnException(false).precondition(new Enum[]{FocalPlaneState.QUIESCENT, FocalPlaneState.NEEDS_CLEAR}).precondition(!this.config.isRealDAQ(), "playlists only evailable with emulated or simulated DAQ", new Supplier[0]).action(() -> {
            List playlists = Files.list(this.config.getPlaylistBaseDir()).filter(p -> p.getFileName().toString().endsWith(PLIST_SUFFIX)).collect(Collectors.toList());
            ArrayList<String> results = new ArrayList<String>();
            for (Path path : playlists) {
                CCSImageList playList = CCSImageList.open(path);
                results.add(String.format("%s: size=%d", playList.getName(), playList.size()));
            }
            Collections.sort(results);
            return results.stream().collect(Collectors.joining("\n"));
        });
    }

    private Path getPlaylistBaseDir(String playlistFileName) throws IOException {
        if (!((String)playlistFileName).endsWith(PLIST_SUFFIX)) {
            playlistFileName = (String)playlistFileName + PLIST_SUFFIX;
        }
        return this.config.getPlaylistBaseDir().resolve((String)playlistFileName);
    }
}

