/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.time.Duration;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.sal.SAL;
import org.lsst.sal.SALCommand;
import org.lsst.sal.SALCommandResponse;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.mtmount.SALMain;
import org.lsst.sal.mtrotator.command.LockMotionCommand;
import org.lsst.sal.mtrotator.command.UnlockMotionCommand;

public class LockUnlockUtils {
    private static final Logger LOG = Logger.getLogger(LockUnlockUtils.class.getName());
    private final SAL<SALCommand, SALEvent, SALTelemetry> mtrotator = org.lsst.sal.mtrotator.SALMain.create();
    private final SAL<SALCommand, SALEvent, SALTelemetry> mtmount = SALMain.create();

    LockUnlockUtils() {
    }

    public void execute(SAL<SALCommand, SALEvent, SALTelemetry> mgr, SALCommand cmd) {
        try {
            LOG.log(Level.INFO, "Sending {0}", cmd);
            SALCommandResponse response = mgr.issueCommand(cmd);
            Duration estimatedTime = response.waitForAck(Duration.ofSeconds(10L));
            if (estimatedTime != Duration.ZERO) {
                LOG.log(Level.INFO, "Expected command duration {0}", estimatedTime);
            }
            int rc = response.waitForCompletion(estimatedTime.plus(Duration.ofSeconds(10L)));
            LOG.log(Level.INFO, "Command complete ack={0}", rc);
        }
        catch (SALCommandResponse.CommandFailedException ex) {
            LOG.log(Level.SEVERE, "Command failed: errorCode={1}, ack={2}, message={0}", new Object[]{ex.getMessage(), ex.getErrorCode(), ex.getAck()});
        }
        catch (TimeoutException ex) {
            LOG.log(Level.WARNING, "Timeout while waiting for ack from: {0}", cmd);
        }
        catch (SALException ex) {
            LOG.log(Level.SEVERE, "Exception executing SAL command: {0}", ex.getMessage());
        }
    }

    public static void main(String[] args) throws InterruptedException {
        LockUnlockUtils luu = new LockUnlockUtils();
        luu.lockUnlock();
    }

    private void lockUnlock() throws InterruptedException {
        LOG.log(Level.INFO, "Sending lock to mtrotator");
        this.execute(this.mtrotator, (SALCommand)new LockMotionCommand());
        Thread.sleep(5000L);
        LOG.log(Level.INFO, "Sending unlock to mtrotator");
        this.execute(this.mtrotator, (SALCommand)new UnlockMotionCommand());
        Thread.sleep(5000L);
        LOG.log(Level.INFO, "Sending lock to mtmount");
        this.execute(this.mtmount, (SALCommand)new org.lsst.sal.mtmount.command.LockMotionCommand());
        Thread.sleep(5000L);
        LOG.log(Level.INFO, "Sending unlock to mtmount");
        this.execute(this.mtmount, (SALCommand)new org.lsst.sal.mtmount.command.UnlockMotionCommand());
        Thread.sleep(5000L);
    }
}

