/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import java.util.logging.Logger;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.common.SoftwareState;
import org.lsst.ccs.subsystem.shutter.plc.MotionDonePLC;
import org.lsst.ccs.subsystem.shutter.statemachine.Channel;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.Logging;
import org.lsst.ccs.subsystem.shutter.statemachine.Prod;
import org.lsst.ccs.subsystem.shutter.statemachine.PromptReply;
import org.lsst.ccs.subsystem.shutter.statemachine.SimpleState;

class Closing
extends SimpleState<Prod> {
    private static final Logger LOG = Logger.getLogger(Closing.class.getName());

    public Closing(Prod context) {
        super(context);
    }

    @Override
    public Logger getLogger() {
        return LOG;
    }

    @Override
    public void entry() {
        Logging.logEntry(this);
        ((Prod)this.getContext()).getActions().setSoftwareState(SoftwareState.CLOSING);
        ((Prod)this.getContext()).getActions().setPhysicalState(PhysicalState.CLOSING);
    }

    @Override
    public void brakePowerLoss(Channel<EventReply> chan) throws InterruptedException {
        Logging.logEvent(this);
        chan.write(PromptReply.ACCEPTED);
        ((Prod)this.getContext()).getActions().signalAReset();
    }

    @Override
    public void motionDone(Channel<EventReply> chan, MotionDonePLC profileData) throws InterruptedException {
        Logging.logEntry(this);
        chan.write(PromptReply.ACCEPTED);
        Prod ctx = (Prod)this.getContext();
        ctx.makeTransition(ctx.getClosedState(), () -> ctx.getActions().sendProfile(profileData));
    }
}

