/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Sanitizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppInfoParser {
    private static final Logger log = LoggerFactory.getLogger(AppInfoParser.class);
    private static final String VERSION;
    private static final String COMMIT_ID;
    protected static final String DEFAULT_VALUE = "unknown";

    public static String getVersion() {
        return VERSION;
    }

    public static String getCommitId() {
        return COMMIT_ID;
    }

    public static synchronized void registerAppInfo(String prefix, String id, Metrics metrics, long nowMs) {
        try {
            ObjectName name = new ObjectName(prefix + ":type=app-info,id=" + Sanitizer.jmxSanitize(id));
            AppInfo mBean = new AppInfo(nowMs);
            ManagementFactory.getPlatformMBeanServer().registerMBean(mBean, name);
            AppInfoParser.registerMetrics(metrics, mBean);
        }
        catch (JMException e) {
            log.warn("Error registering AppInfo mbean", (Throwable)e);
        }
    }

    public static synchronized void unregisterAppInfo(String prefix, String id, Metrics metrics) {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName name = new ObjectName(prefix + ":type=app-info,id=" + Sanitizer.jmxSanitize(id));
            if (server.isRegistered(name)) {
                server.unregisterMBean(name);
            }
            AppInfoParser.unregisterMetrics(metrics);
        }
        catch (JMException e) {
            log.warn("Error unregistering AppInfo mbean", (Throwable)e);
        }
    }

    private static MetricName metricName(Metrics metrics, String name) {
        return metrics.metricName(name, "app-info", "Metric indicating " + name);
    }

    private static void registerMetrics(Metrics metrics, AppInfo appInfo) {
        if (metrics != null) {
            metrics.addMetric(AppInfoParser.metricName(metrics, "version"), new ImmutableValue<String>(appInfo.getVersion()));
            metrics.addMetric(AppInfoParser.metricName(metrics, "commit-id"), new ImmutableValue<String>(appInfo.getCommitId()));
            metrics.addMetric(AppInfoParser.metricName(metrics, "start-time-ms"), new ImmutableValue<Long>(appInfo.getStartTimeMs()));
        }
    }

    private static void unregisterMetrics(Metrics metrics) {
        if (metrics != null) {
            metrics.removeMetric(AppInfoParser.metricName(metrics, "version"));
            metrics.removeMetric(AppInfoParser.metricName(metrics, "commit-id"));
            metrics.removeMetric(AppInfoParser.metricName(metrics, "start-time-ms"));
        }
    }

    static {
        Properties props = new Properties();
        try (InputStream resourceStream = AppInfoParser.class.getResourceAsStream("/kafka/kafka-version.properties");){
            props.load(resourceStream);
        }
        catch (Exception e) {
            log.warn("Error while loading kafka-version.properties: {}", (Object)e.getMessage());
        }
        VERSION = props.getProperty("version", DEFAULT_VALUE).trim();
        COMMIT_ID = props.getProperty("commitId", DEFAULT_VALUE).trim();
    }

    static class ImmutableValue<T>
    implements Gauge<T> {
        private final T value;

        public ImmutableValue(T value) {
            this.value = value;
        }

        @Override
        public T value(MetricConfig config, long now) {
            return this.value;
        }
    }

    public static class AppInfo
    implements AppInfoMBean {
        private final Long startTimeMs;

        public AppInfo(long startTimeMs) {
            this.startTimeMs = startTimeMs;
            log.info("Kafka version: {}", (Object)AppInfoParser.getVersion());
            log.info("Kafka commitId: {}", (Object)AppInfoParser.getCommitId());
            log.info("Kafka startTimeMs: {}", (Object)startTimeMs);
        }

        @Override
        public String getVersion() {
            return AppInfoParser.getVersion();
        }

        @Override
        public String getCommitId() {
            return AppInfoParser.getCommitId();
        }

        @Override
        public Long getStartTimeMs() {
            return this.startTimeMs;
        }
    }

    public static interface AppInfoMBean {
        public String getVersion();

        public String getCommitId();

        public Long getStartTimeMs();
    }
}

