/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j.client;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.indilib.i4j.INDIDateFormat;
import org.indilib.i4j.INDIProtocolParser;
import org.indilib.i4j.INDIProtocolReader;
import org.indilib.i4j.client.INDIDevice;
import org.indilib.i4j.client.INDIDeviceListener;
import org.indilib.i4j.client.INDIElement;
import org.indilib.i4j.client.INDIProperty;
import org.indilib.i4j.client.INDIServerConnectionListener;
import org.indilib.i4j.protocol.DefVector;
import org.indilib.i4j.protocol.DelProperty;
import org.indilib.i4j.protocol.GetProperties;
import org.indilib.i4j.protocol.INDIProtocol;
import org.indilib.i4j.protocol.Message;
import org.indilib.i4j.protocol.SetVector;
import org.indilib.i4j.protocol.api.INDIConnection;
import org.indilib.i4j.protocol.api.INDIInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class INDIServerConnection
implements INDIProtocolParser {
    private static final Logger LOG = LoggerFactory.getLogger(INDIServerConnection.class);
    private final URL indiUrl;
    private INDIConnection connection = null;
    private INDIProtocolReader reader = null;
    private final Map<String, INDIDevice> devices = new LinkedHashMap<String, INDIDevice>();
    private List<INDIServerConnectionListener> listeners = new ArrayList<INDIServerConnectionListener>();

    public INDIServerConnection(String name, String host, int port) {
        this(host, port);
    }

    public INDIServerConnection(String host, int port) {
        try {
            this.indiUrl = new URL("indi", host, port, "/");
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("illegal indi url", e);
        }
    }

    public INDIServerConnection(String uri) {
        this(INDIServerConnection.openConnection(uri));
    }

    private static INDIConnection openConnection(String uri) {
        try {
            return (INDIConnection)new URL(uri).openConnection();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("the specified uri is not a legal indi url", e);
        }
    }

    public INDIServerConnection(INDIConnection connection) {
        this.indiUrl = connection.getURL();
        this.connection = connection;
    }

    public INDIDevice waitForDevice(String deviceName) {
        return this.waitForDevice(deviceName, Integer.MAX_VALUE);
    }

    public INDIDevice waitForDevice(String deviceName, int maxWait) {
        INDIDevice d = null;
        long startTime = new Date().getTime();
        boolean timeElapsed = false;
        while (d == null && !timeElapsed) {
            long endTime;
            d = this.getDevice(deviceName);
            if (d == null) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    LOG.warn("sleep interrupted", (Throwable)e);
                }
            }
            if (((endTime = new Date().getTime()) - startTime) / 1000L <= (long)maxWait) continue;
            timeElapsed = true;
        }
        return d;
    }

    public void connect() throws IOException {
        if (this.connection == null) {
            this.connection = (INDIConnection)this.indiUrl.openConnection();
        }
        if (this.reader == null) {
            this.reader = new INDIProtocolReader((INDIProtocolParser)this, "client reader " + this.connection.getURL());
            this.reader.start();
        }
    }

    public void disconnect() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException e) {
                LOG.error("error durill connection close", (Throwable)e);
            }
            this.devices.clear();
            this.notifyListenersConnectionLost();
            this.connection = null;
        }
    }

    public boolean isConnected() {
        return this.connection != null;
    }

    public void askForDevices() throws IOException {
        this.sendMessageToServer((INDIProtocol<?>)new GetProperties().setVersion("1.7"));
    }

    public void askForDevices(String device) throws IOException {
        this.sendMessageToServer((INDIProtocol)new GetProperties().setVersion("1.7").setDevice(device));
    }

    public void askForDevices(String device, String propertyName) throws IOException {
        this.sendMessageToServer((INDIProtocol)((GetProperties)new GetProperties().setVersion("1.7").setDevice(device)).setName(propertyName));
    }

    protected void sendMessageToServer(INDIProtocol<?> xmlMessage) throws IOException {
        this.connection.getINDIOutputStream().writeObject(xmlMessage);
    }

    public void finishReader() {
        this.disconnect();
    }

    private void addDevice(INDIDevice device) {
        this.devices.put(device.getName(), device);
        this.notifyListenersNewDevice(device);
    }

    public INDIDevice getDevice(String deviceName) {
        return this.devices.get(deviceName);
    }

    public INDIProperty<?> getProperty(String deviceName, String propertyName) {
        INDIDevice d = this.getDevice(deviceName);
        if (d == null) {
            return null;
        }
        return d.getProperty(propertyName);
    }

    public INDIElement getElement(String deviceName, String propertyName, String elementName) {
        INDIDevice d = this.getDevice(deviceName);
        if (d == null) {
            return null;
        }
        return d.getElement(propertyName, elementName);
    }

    public void processProtokolMessage(INDIProtocol<?> xml) {
        if (xml instanceof DefVector) {
            this.addProperty((DefVector)xml);
        } else if (xml instanceof SetVector) {
            this.updateProperty((SetVector)xml);
        } else if (xml instanceof Message) {
            this.messageReceived((Message)xml);
        } else if (xml instanceof DelProperty) {
            this.deleteProperty((DelProperty)xml);
        }
    }

    private void deleteProperty(DelProperty xml) {
        if (xml.hasDevice()) {
            String deviceName = xml.getDevice();
            INDIDevice d = this.getDevice(deviceName);
            if (d != null) {
                String propertyName = xml.getName();
                if (propertyName != null && !propertyName.isEmpty()) {
                    d.deleteProperty(xml);
                } else {
                    this.deleteDevice(d);
                }
            } else {
                this.deleteAllDevices();
            }
        }
    }

    private void deleteAllDevices() {
        Iterator<INDIDevice> devs = this.devices.values().iterator();
        while (!devs.hasNext()) {
            this.deleteDevice(devs.next());
        }
    }

    private void deleteDevice(INDIDevice device) {
        this.devices.remove(device.getName());
        this.notifyListenersRemoveDevice(device);
    }

    private void messageReceived(Message xml) {
        if (xml.hasDevice()) {
            String deviceName = xml.getDevice();
            INDIDevice d = this.getDevice(deviceName);
            if (d != null) {
                d.messageReceived((INDIProtocol<?>)xml);
            }
        } else if (xml.hasMessage()) {
            Date timestamp = INDIDateFormat.dateFormat().parseTimestamp(xml.getTimestamp());
            this.notifyListenersNewMessage(timestamp, xml.getMessage());
        }
    }

    private void addProperty(DefVector<?> xml) {
        String deviceName = xml.getDevice();
        INDIDevice d = this.getDevice(deviceName);
        if (d == null) {
            d = new INDIDevice(deviceName, this);
            this.addDevice(d);
        }
        d.addProperty(xml);
    }

    private void updateProperty(SetVector<?> el) {
        String deviceName = el.getDevice();
        INDIDevice d = this.getDevice(deviceName);
        if (d != null) {
            d.updateProperty(el);
        }
    }

    public void addINDIServerConnectionListener(INDIServerConnectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeINDIServerConnectionListener(INDIServerConnectionListener listener) {
        this.listeners.remove(listener);
    }

    public void addINDIDeviceListenerToAllDevices(INDIDeviceListener listener) {
        List<INDIDevice> l = this.getDevicesAsList();
        for (int i = 0; i < l.size(); ++i) {
            INDIDevice d = l.get(i);
            d.addINDIDeviceListener(listener);
        }
    }

    public void removeINDIDeviceListenerFromAllDevices(INDIDeviceListener listener) {
        List<INDIDevice> l = this.getDevicesAsList();
        for (int i = 0; i < l.size(); ++i) {
            INDIDevice d = l.get(i);
            d.removeINDIDeviceListener(listener);
        }
    }

    public String[] getDeviceNames() {
        List<INDIDevice> l = this.getDevicesAsList();
        String[] names = new String[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            names[i] = l.get(i).getName();
        }
        return names;
    }

    public List<INDIDevice> getDevicesAsList() {
        return new ArrayList<INDIDevice>(this.devices.values());
    }

    public void addINDIDeviceListener(String deviceName, INDIDeviceListener listener) {
        INDIDevice d = this.getDevice(deviceName);
        if (d == null) {
            return;
        }
        d.addINDIDeviceListener(listener);
    }

    public void removeINDIDeviceListener(String deviceName, INDIDeviceListener listener) {
        INDIDevice d = this.getDevice(deviceName);
        if (d == null) {
            return;
        }
        d.removeINDIDeviceListener(listener);
    }

    private void notifyListenersNewDevice(INDIDevice device) {
        ArrayList<INDIServerConnectionListener> lCopy = new ArrayList<INDIServerConnectionListener>(this.listeners);
        for (int i = 0; i < lCopy.size(); ++i) {
            INDIServerConnectionListener l = lCopy.get(i);
            l.newDevice(this, device);
        }
    }

    private void notifyListenersRemoveDevice(INDIDevice device) {
        ArrayList<INDIServerConnectionListener> lCopy = new ArrayList<INDIServerConnectionListener>(this.listeners);
        for (int i = 0; i < lCopy.size(); ++i) {
            INDIServerConnectionListener l = lCopy.get(i);
            l.removeDevice(this, device);
        }
    }

    private void notifyListenersConnectionLost() {
        ArrayList<INDIServerConnectionListener> lCopy = new ArrayList<INDIServerConnectionListener>(this.listeners);
        for (int i = 0; i < lCopy.size(); ++i) {
            INDIServerConnectionListener l = lCopy.get(i);
            l.connectionLost(this);
        }
    }

    protected void notifyListenersNewMessage(Date timestamp, String message) {
        ArrayList<INDIServerConnectionListener> lCopy = new ArrayList<INDIServerConnectionListener>(this.listeners);
        for (int i = 0; i < lCopy.size(); ++i) {
            INDIServerConnectionListener l = lCopy.get(i);
            l.newMessage(this, timestamp, message);
        }
    }

    public INDIInputStream getInputStream() {
        try {
            return this.connection.getINDIInputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.indiUrl + ")";
    }

    public URL getURL() {
        return this.indiUrl;
    }
}

