/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.monitor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.config.LocalConfigurationDAO;
import org.lsst.ccs.config.SingleCategoryTag;
import org.lsst.ccs.config.SingleCategoryTagData;
import org.lsst.ccs.config.remote.LocalToRemoteMigrationDAO;
import org.lsst.ccs.config.remote.RestFileServerRemoteDAO;
import org.lsst.ccs.utilities.conv.InputConversionEngine;

public class ConvertLimitsCategoryToWarnings {
    public static void main(String[] args) throws Exception {
        String groovyName = null;
        String category = "Limits";
        String tag = "defaultInitial";
        switch (args.length) {
            case 1: {
                groovyName = args[0];
                break;
            }
            case 2: {
                groovyName = args[0];
                tag = args[1];
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal number of arguments. We expect up to two arguments:\nthe first argument must be the groovy file name\nthe second argument (optional) is the tag name (defaultInitial by default)");
            }
        }
        String cacheName = "LimitsCategoryMigration";
        String dao = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.config.remote", "false");
        Object configurationDao = dao.equalsIgnoreCase("true") ? new RestFileServerRemoteDAO(cacheName) : (dao.equalsIgnoreCase("migrate") ? new LocalToRemoteMigrationDAO(cacheName) : new LocalConfigurationDAO());
        SingleCategoryTag singleCatTag = new SingleCategoryTag(groovyName, tag, category);
        SingleCategoryTagData data = configurationDao.loadCategoryTag(singleCatTag);
        Properties conversionProps = new Properties();
        StringBuilder sb = new StringBuilder();
        HashMap<CallSite, Double> limitValues = new HashMap<CallSite, Double>();
        ArrayList<String> componentsWithLimits = new ArrayList<String>();
        for (String key : data.getConfigurationData().keySet()) {
            String comment;
            int keySplit = key.lastIndexOf("/");
            String component = key.substring(0, keySplit);
            String parameter = key.substring(keySplit + 1);
            if (conversionProps.containsKey(component)) {
                component = conversionProps.getProperty(component);
            }
            if ((comment = data.getCommentParameter(key)) != null) {
                sb.append(comment).append("\n");
            }
            String value = (String)data.getConfigurationData().get(key);
            if (parameter.equals("dbandHi")) {
                BigDecimal dbandHi = (BigDecimal)InputConversionEngine.convertArgToType((String)value, BigDecimal.class);
                String limitHiPar = component + "/limitHi";
                String limitHiValue = (String)data.getConfigurationData().get(limitHiPar);
                if (limitHiValue == null) {
                    throw new RuntimeException("Could not find value for " + limitHiPar);
                }
                BigDecimal limitHi = (BigDecimal)InputConversionEngine.convertArgToType((String)limitHiValue, BigDecimal.class);
                BigDecimal warningHi = dbandHi.doubleValue() <= 0.0 ? limitHi : limitHi.subtract(dbandHi);
                parameter = "warnHi";
                value = String.valueOf(warningHi.doubleValue());
                limitValues.put((CallSite)((Object)(component + "/" + parameter)), warningHi.doubleValue());
                limitValues.put((CallSite)((Object)(component + "/limitHi")), limitHi.doubleValue());
                if (!componentsWithLimits.contains(component)) {
                    componentsWithLimits.add(component);
                }
            } else if (parameter.equals("dbandLo")) {
                BigDecimal dbandLo = (BigDecimal)InputConversionEngine.convertArgToType((String)value, BigDecimal.class);
                String limitLoPar = component + "/limitLo";
                String limitLoValue = (String)data.getConfigurationData().get(limitLoPar);
                if (limitLoValue == null) {
                    throw new RuntimeException("Could not find value for " + limitLoPar);
                }
                BigDecimal limitLo = (BigDecimal)InputConversionEngine.convertArgToType((String)limitLoValue, BigDecimal.class);
                BigDecimal warningLo = dbandLo.doubleValue() <= 0.0 ? limitLo : limitLo.add(dbandLo);
                parameter = "warnLo";
                value = String.valueOf(warningLo.doubleValue());
                limitValues.put((CallSite)((Object)(component + "/" + parameter)), warningLo.doubleValue());
                limitValues.put((CallSite)((Object)(component + "/limitLo")), limitLo.doubleValue());
                if (!componentsWithLimits.contains(component)) {
                    componentsWithLimits.add(component);
                }
            }
            sb.append(component).append("/").append(parameter).append("=").append(value).append("\n");
        }
        SingleCategoryTagData convertedData = new SingleCategoryTagData(data.getSingleCategoryTag());
        convertedData.load((InputStream)new ByteArrayInputStream(sb.toString().getBytes()));
        StringBuilder warningConstraint = new StringBuilder("Warning Hi and Lo for the following components do not meet the constraint warnLo < warnHi.\nWe are removing the warning bands by setting their values to the Hi/Lo limits.\n");
        boolean printWarningConstraint = false;
        StringBuilder limitsConstraint = new StringBuilder("Limits Hi and Lo for the following components do not meet the constraint limitLo < limitHi.\nThese problems will have to be fixed by hand.\n");
        boolean printLimitsConstraint = false;
        for (String componentWithLimit : componentsWithLimits) {
            double limitHi = (Double)limitValues.get(componentWithLimit + "/limitHi");
            double warnHi = (Double)limitValues.get(componentWithLimit + "/warnHi");
            double limitLo = (Double)limitValues.get(componentWithLimit + "/limitLo");
            double warnLo = (Double)limitValues.get(componentWithLimit + "/warnLo");
            if (warnHi < warnLo) {
                printWarningConstraint = true;
                warningConstraint.append(componentWithLimit).append(" changed warning Lo from ").append(warnLo).append(" to ").append(limitLo).append(" warnign Hi from ").append(warnHi).append(" to ").append(limitHi).append("\n");
                convertedData.getConfigurationData().put(componentWithLimit + "/warnHi", String.valueOf(limitHi));
                convertedData.getConfigurationData().put(componentWithLimit + "/warnLo", String.valueOf(limitLo));
                continue;
            }
            if (!(limitHi < limitLo)) continue;
            printLimitsConstraint = true;
            limitsConstraint.append(componentWithLimit).append("\n");
        }
        if (printWarningConstraint) {
            System.out.println(warningConstraint.toString());
        }
        if (printLimitsConstraint) {
            System.out.println(limitsConstraint.toString());
        }
        configurationDao.saveCategoryTagData(convertedData);
    }
}

