/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.localdb.statusdb.server.TrendingData;
import org.lsst.ccs.localdb.trendserver.TrendingClientService;
import org.lsst.ccs.localdb.utils.TrendingConnectionUtils;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.DerivedChannel;

public class AccumTimeChannel
extends DerivedChannel {
    private static final int CHECK_INTERVAL = 10000;
    @LookupPath
    private String path;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private TrendingClientService trendingService;
    private Channel channel;
    private static final Logger LOG = Logger.getLogger(AccumTimeChannel.class.getName());
    private final Object syncSavedTime = new Object();
    private String fullName;
    private TrendingConnectionUtils trendingUtils;
    private boolean trendingUtilsError = false;
    private long readTime = 0L;
    private long checkTime = 0L;
    private double accumTime = 0.0;
    private double savedTime = Double.NaN;

    public void init() {
        this.fullName = this.subsys.getName() + "/" + this.path;
        if (this.channel == null) {
            throw new RuntimeException(this.getPath() + " parameter error: channel has not been defined");
        }
        super.init();
    }

    public void start() {
        this.initSavedTime();
        super.start();
    }

    public double evaluateDerivedValue() {
        long currTime = System.currentTimeMillis();
        if (currTime - this.checkTime >= 10000L) {
            this.initSavedTime();
            this.checkTime = currTime;
        }
        if (this.readTime != 0L && this.channel.getValue() > 0.0) {
            this.accumTime += (double)(currTime - this.readTime) / 3600000.0;
        }
        this.readTime = currTime;
        return this.accumTime + this.savedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set the accumulated time")
    public void setAccumTime(@Argument(description="Time period (hour)") double time) {
        Object object = this.syncSavedTime;
        synchronized (object) {
            this.savedTime = time - this.accumTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSavedTime() {
        if (!Double.isNaN(this.savedTime)) {
            return;
        }
        this.trendingUtils = this.trendingService.getBusTrendingConnection();
        if (this.trendingUtils == null) {
            if (!this.trendingUtilsError) {
                LOG.log(Level.SEVERE, "Trending data cannot be accessed");
                this.trendingUtilsError = true;
            }
            return;
        }
        if (this.trendingUtilsError) {
            LOG.log(Level.INFO, "Trending data can now be accessed");
            this.trendingUtilsError = false;
        }
        Object object = this.syncSavedTime;
        synchronized (object) {
            if (Double.isNaN(this.savedTime)) {
                TrendingData data = this.trendingUtils.getLatestData(this.fullName);
                double d = this.savedTime = data == null ? Double.NaN : data.getValue("value");
                if (Double.isNaN(this.savedTime)) {
                    LOG.log(Level.WARNING, "No trending data present for channel {0}", this.fullName);
                    this.savedTime = 0.0;
                } else {
                    LOG.log(Level.INFO, "Got trending data for channel {0}", this.fullName);
                }
            }
        }
    }
}

